/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.netio;

import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.ToIntFunction;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipOutputStream;
import org.ojalgo.netio.ReaderWriterBuilder;
import org.ojalgo.netio.ShardedFile;
import org.ojalgo.type.NumberDefinition;
import org.ojalgo.type.function.AutoConsumer;
import org.ojalgo.type.keyvalue.EntryPair;

public interface ToFileWriter<T>
extends AutoConsumer<T>,
Closeable {
    public static void mkdirs(File dir) {
        if (!(dir.exists() || dir.mkdirs() || dir.exists())) {
            throw new RuntimeException("Failed to create " + dir.getAbsolutePath());
        }
    }

    public static Builder newBuilder(File ... file) {
        return new Builder(file);
    }

    public static Builder newBuilder(ShardedFile shards) {
        return new Builder(shards.shards());
    }

    public static OutputStream output(File file) {
        try {
            ToFileWriter.mkdirs(file.getParentFile());
            String name = file.getName();
            OutputStream retVal = new FileOutputStream(file);
            if (name.endsWith(".gz")) {
                retVal = new GZIPOutputStream(retVal);
            } else if (name.endsWith(".zip")) {
                retVal = new ZipOutputStream(retVal);
            }
            return retVal;
        }
        catch (IOException cause) {
            throw new RuntimeException(cause);
        }
    }

    public static <T extends Serializable> void serializeObjectToFile(T object, File file) {
        try (ObjectOutputStream oos = new ObjectOutputStream(ToFileWriter.output(file));){
            oos.writeObject(object);
        }
        catch (IOException cause) {
            throw new RuntimeException(cause);
        }
    }

    @Override
    default public void close() throws IOException {
        try {
            AutoConsumer.super.close();
        }
        catch (Exception cause) {
            if (cause instanceof IOException) {
                throw (IOException)cause;
            }
            throw new RuntimeException(cause);
        }
    }

    public static final class Builder
    extends ReaderWriterBuilder<Builder> {
        Builder(File[] files) {
            super(files);
        }

        public <T> AutoConsumer<T> build(Function<File, ToFileWriter<T>> factory) {
            return this.build(Object::hashCode, factory);
        }

        public <T> AutoConsumer<T> build(ToIntFunction<T> distributor, Function<File, ? extends AutoConsumer<T>> factory) {
            AutoConsumer<Object> single;
            File[] files = this.getFiles();
            AutoConsumer[] shards = new AutoConsumer[files.length];
            for (int i = 0; i < shards.length; ++i) {
                shards[i] = factory.apply(files[i]);
            }
            int queueCapacity = this.getQueueCapacity();
            int parallelism = this.getParallelism();
            ExecutorService executor = this.getExecutor();
            int numberOfShards = shards.length;
            int numberOfQueues = Math.max(1, Math.min(parallelism, numberOfShards));
            int capacityPerQueue = Math.max(3, queueCapacity / numberOfQueues);
            if (numberOfShards == 1) {
                LinkedBlockingQueue queue = new LinkedBlockingQueue(capacityPerQueue);
                single = AutoConsumer.queued(executor, queue, shards[0]);
            } else if (numberOfQueues == 1) {
                LinkedBlockingQueue queue = new LinkedBlockingQueue(capacityPerQueue);
                AutoConsumer<T> consumer = AutoConsumer.sharded(distributor, shards);
                single = AutoConsumer.queued(executor, queue, consumer);
            } else if (numberOfQueues == numberOfShards) {
                AutoConsumer[] queuedWriters = new AutoConsumer[numberOfQueues];
                for (int q = 0; q < numberOfQueues; ++q) {
                    LinkedBlockingQueue queue = new LinkedBlockingQueue(capacityPerQueue);
                    queuedWriters[q] = AutoConsumer.queued(executor, queue, shards[q]);
                }
                single = AutoConsumer.sharded(distributor, queuedWriters);
            } else {
                int candidateShardsPerQueue = numberOfShards / numberOfQueues;
                while (candidateShardsPerQueue * numberOfQueues < numberOfShards) {
                    ++candidateShardsPerQueue;
                }
                int shardsPerQueue = candidateShardsPerQueue;
                AutoConsumer[] queuedWriters = new AutoConsumer[numberOfQueues];
                ToIntFunction<Object> toQueueDistributor = item -> Math.abs(distributor.applyAsInt(item) % numberOfShards) / shardsPerQueue;
                ToIntFunction<Object> toShardDistributor = item -> Math.abs(distributor.applyAsInt(item) % numberOfShards) % shardsPerQueue;
                for (int q = 0; q < numberOfQueues; ++q) {
                    int offset = q * shardsPerQueue;
                    Object[] shardWriters = new AutoConsumer[shardsPerQueue];
                    Arrays.fill(shardWriters, AutoConsumer.NULL);
                    for (int b = 0; b < shardsPerQueue && offset + b < numberOfShards; ++b) {
                        shardWriters[b] = shards[offset + b];
                    }
                    LinkedBlockingQueue queue = new LinkedBlockingQueue(capacityPerQueue);
                    AutoConsumer<Object> writer = AutoConsumer.sharded(toShardDistributor, shardWriters);
                    queuedWriters[q] = AutoConsumer.queued(executor, queue, writer);
                }
                single = AutoConsumer.sharded(toQueueDistributor, queuedWriters);
            }
            if (this.isStatisticsCollector()) {
                return AutoConsumer.managed(this.getStatisticsCollector(), single);
            }
            return single;
        }

        public <T> AutoConsumer<EntryPair.KeyedPrimitive<T>> buildMapped(Function<File, ToFileWriter<T>> factory) {
            Function<EntryPair.KeyedPrimitive, Object> mapper = Map.Entry::getKey;
            ToIntFunction<EntryPair.KeyedPrimitive> distributor = NumberDefinition::intValue;
            Function<File, AutoConsumer> mappedFactory = file -> AutoConsumer.mapped(mapper, (Consumer)factory.apply((File)file));
            return this.build(distributor, mappedFactory);
        }
    }
}

