/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.type.function;

import java.util.Collection;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.function.Supplier;
import org.ojalgo.type.function.AutoSupplier;

final class QueuedSupplier<T>
implements AutoSupplier<T> {
    private final Future<?>[] myFutures;
    private final BlockingQueue<T> myQueue;
    private final Supplier<T>[] mySuppliers;

    QueuedSupplier(ExecutorService executor, BlockingQueue<T> queue, Supplier<T> ... suppliers) {
        this.myQueue = queue;
        this.mySuppliers = suppliers;
        this.myFutures = new Future[suppliers.length];
        for (int i = 0; i < suppliers.length; ++i) {
            this.myFutures[i] = executor.submit(new Worker<T>(queue, suppliers[i]));
        }
    }

    @Override
    public void close() throws Exception {
        try {
            for (int i = 0; i < this.myFutures.length; ++i) {
                this.myFutures[i].get();
                if (!(this.mySuppliers[i] instanceof AutoCloseable)) continue;
                ((AutoCloseable)((Object)this.mySuppliers[i])).close();
            }
        }
        catch (InterruptedException | ExecutionException cause) {
            throw new RuntimeException(cause);
        }
    }

    @Override
    public int drainTo(Collection<? super T> container, int maxElements) {
        return this.myQueue.drainTo(container, maxElements);
    }

    @Override
    public T read() {
        Object retVal = this.myQueue.poll();
        if (retVal != null) {
            return (T)retVal;
        }
        while (!this.isDone() || this.myQueue.size() > 0) {
            retVal = this.myQueue.poll();
            if (retVal != null) {
                return (T)retVal;
            }
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException cause) {
                throw new RuntimeException(cause);
            }
        }
        return null;
    }

    private boolean isDone() {
        for (Future<?> worker : this.myFutures) {
            if (worker.isDone()) continue;
            return false;
        }
        return true;
    }

    static final class Worker<T>
    implements Runnable {
        private final BlockingQueue<T> myQueue;
        private final Supplier<T> mySupplier;

        Worker(BlockingQueue<T> queue, Supplier<T> reader) {
            this.myQueue = queue;
            this.mySupplier = reader;
        }

        @Override
        public void run() {
            try {
                Object item = null;
                while (true) {
                    T t = this.mySupplier.get();
                    item = t;
                    if (t != null) {
                        this.myQueue.put(item);
                        continue;
                    }
                    break;
                }
            }
            catch (InterruptedException cause) {
                throw new RuntimeException(cause);
            }
        }
    }
}

