/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.math.integrate.lsoda;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.apache.commons.math4.legacy.analysis.solvers.UnivariateSolver;
import org.apache.commons.math4.legacy.exception.DimensionMismatchException;
import org.apache.commons.math4.legacy.exception.MaxCountExceededException;
import org.apache.commons.math4.legacy.exception.NoBracketingException;
import org.apache.commons.math4.legacy.exception.NumberIsTooSmallException;
import org.apache.commons.math4.legacy.ode.FirstOrderDifferentialEquations;
import org.apache.commons.math4.legacy.ode.FirstOrderIntegrator;
import org.apache.commons.math4.legacy.ode.events.EventHandler;
import org.apache.commons.math4.legacy.ode.sampling.StepHandler;
import org.meteoinfo.math.integrate.lsoda.ReturningValues;
import org.meteoinfo.math.integrate.lsoda.SupportingFunctions;
import org.meteoinfo.math.integrate.lsoda.Utility;
import org.meteoinfo.math.integrate.lsoda.exception.EwtException;
import org.meteoinfo.math.integrate.lsoda.exception.ExceedMaxStepsException;
import org.meteoinfo.math.integrate.lsoda.exception.IllegalInputException;
import org.meteoinfo.math.integrate.lsoda.exception.IllegalTException;
import org.meteoinfo.math.integrate.lsoda.exception.InterpolationException;
import org.meteoinfo.math.integrate.lsoda.exception.IstateException;
import org.meteoinfo.math.integrate.lsoda.exception.NeqException;
import org.meteoinfo.math.integrate.lsoda.exception.RepeatedInputException;
import org.meteoinfo.math.integrate.lsoda.exception.TestsFailException;
import org.meteoinfo.math.integrate.lsoda.exception.TooMuchAccuracyException;
import org.meteoinfo.math.integrate.lsoda.tools.Data;

public class LSODA
implements FirstOrderIntegrator {
    public FirstOrderDifferentialEquations ode;
    private final double ETA = 2.220446049250313E-16;
    private double sqrteta;
    private final double[] sm1 = new double[]{0.0, 0.5, 0.575, 0.55, 0.45, 0.35, 0.25, 0.2, 0.15, 0.1, 0.075, 0.05, 0.025};
    private final double[] cm1 = new double[13];
    private final double[] cm2 = new double[6];
    private final int[] mord = new int[]{0, 12, 5};
    private int illin = 0;
    private int init = 0;
    private int meth;
    private int ixpr = 0;
    private int mused;
    private int mxordn;
    private int mxords;
    private int maxord;
    private int nqu;
    private int maxcor;
    private int msbp;
    private int mxncf;
    private int nslast;
    private int irflag;
    private int jstart;
    private int kflag;
    private int ipup;
    private int corflag;
    private int ncf;
    private double[][] yh;
    private int nq;
    private double told;
    private double rh;
    private double del;
    private double delp;
    private double m;
    private int ntrep;
    private double hu;
    private double h;
    private int nhnil;
    private double rmax;
    private double hmxi;
    private double hmin;
    private double hmaxi;
    private double hold;
    private double rc;
    private double ccmax;
    private double crate;
    private double conit;
    private double ratio;
    private double pdh;
    private double rhup;
    private int mxstep;
    private int mxhnil;
    private int ialth;
    private int lmax;
    private int icount;
    private int l;
    private int n;
    private int nslp;
    private int ierpj;
    private int jcur;
    private double el0;
    private int miter;
    private double[] savf;
    private double[] ewt;
    private double[] acor;
    private double[][] wm;
    private double pdnorm;
    private double pdlast;
    private double pdest;
    private int[] ipvt;
    private final double[][] elco = new double[13][14];
    private double[] el = new double[14];
    private final double[][] tesco = new double[13][4];
    public double tn;
    public int istate;
    private int nst;
    private int imxer;
    private int nje;
    private int nfe;
    public double[] y;
    public boolean write = false;
    private Data recorder;
    private double relativeTol;
    private double absoluteTol;
    private ArrayList<Double> tvec;
    private ArrayList<Double[]> yvec;

    public LSODA(double hmin, double hmax, double absoluteTol, double relativeTol, int maxOrderN, int maxOrderS) {
        if (hmin > 0.0) {
            this.hmin = hmin;
        }
        if (hmax > 0.0) {
            this.hmaxi = hmax;
        }
        this.absoluteTol = absoluteTol;
        this.relativeTol = relativeTol;
        this.mxordn = maxOrderN;
        this.mxords = maxOrderS;
    }

    private void calJacobian(double[] y) {
        ++this.nje;
        this.ierpj = 0;
        this.jcur = 1;
        double hl0 = this.h * this.el0;
        if (this.miter != 2) {
            System.err.println("prja: miter!=2");
            throw new RuntimeException();
        }
        double fac = SupportingFunctions.vmnorm(this.n, this.savf, this.ewt);
        double r0 = 1000.0 * Math.abs(this.h) * 2.220446049250313E-16 * (double)this.n * fac;
        if (r0 == 0.0) {
            r0 = 1.0;
        }
        for (int j = 1; j <= this.n; ++j) {
            double yj = y[j];
            double r = Math.max(this.sqrteta * Math.abs(yj), r0 / this.ewt[j]);
            int n = j;
            y[n] = y[n] + r;
            fac = -hl0 / r;
            this.acor = this.FirstOrderSystem(y, this.tn);
            for (int i = 1; i <= this.n; ++i) {
                this.wm[i][j] = (this.acor[i] - this.savf[i]) * fac;
            }
            y[j] = yj;
        }
        this.nfe += this.n;
        this.pdnorm = SupportingFunctions.fnorm(this.n, this.wm, this.ewt) / Math.abs(hl0);
        int i = 1;
        while (i <= this.n) {
            double[] dArray = this.wm[i];
            int n = i++;
            dArray[n] = dArray[n] + 1.0;
        }
        ReturningValues res = Utility.LUDecomposition(this.wm, this.n);
        this.ipvt = res.ipvt;
        this.wm = res.a;
        if (res.info != 0) {
            this.ierpj = 1;
        }
    }

    private void cfode(int meth) {
        double[] pc = new double[13];
        if (meth == 1) {
            this.elco[1][1] = 1.0;
            this.elco[1][2] = 1.0;
            this.tesco[1][1] = 0.0;
            this.tesco[1][2] = 2.0;
            this.tesco[2][1] = 1.0;
            this.tesco[12][3] = 0.0;
            pc[1] = 1.0;
            double rqfac = 1.0;
            for (int q = 2; q <= 12; ++q) {
                double ragq;
                int i;
                double rq1fac = rqfac;
                rqfac /= (double)q;
                int qm1 = q - 1;
                int qp1 = q + 1;
                pc[q] = 0.0;
                for (int i2 = q; i2 >= 2; --i2) {
                    pc[i2] = pc[i2 - 1] + (double)qm1 * pc[i2];
                }
                pc[1] = (double)qm1 * pc[1];
                double pint = pc[1];
                double xpin = pc[1] / 2.0;
                double tsign = 1.0;
                for (i = 2; i <= q; ++i) {
                    tsign = -tsign;
                    pint += tsign * pc[i] / (double)i;
                    xpin += tsign * pc[i] / (double)(i + 1);
                }
                this.elco[q][1] = pint * rq1fac;
                this.elco[q][2] = 1.0;
                for (i = 2; i <= q; ++i) {
                    this.elco[q][i + 1] = rq1fac * pc[i] / (double)i;
                }
                this.tesco[q][2] = ragq = 1.0 / (rqfac * xpin);
                if (q < 12) {
                    this.tesco[qp1][1] = ragq * rqfac / (double)qp1;
                }
                this.tesco[qm1][3] = ragq;
            }
            return;
        }
        pc[1] = 1.0;
        double rq1fac = 1.0;
        for (int q = 1; q <= 5; ++q) {
            int i;
            int qp1 = q + 1;
            pc[qp1] = 0.0;
            for (i = q + 1; i >= 2; --i) {
                pc[i] = pc[i - 1] + (double)q * pc[i];
            }
            pc[1] = pc[1] * (double)q;
            for (i = 1; i <= qp1; ++i) {
                this.elco[q][i] = pc[i] / pc[2];
            }
            this.elco[q][2] = 1.0;
            this.tesco[q][1] = rq1fac;
            this.tesco[q][2] = (double)qp1 / this.elco[q][1];
            this.tesco[q][3] = (double)(q + 2) / this.elco[q][1];
            rq1fac /= (double)q;
        }
    }

    private void scaleH(double rh) {
        rh = Math.min(rh, this.rmax);
        rh /= Math.max(1.0, Math.abs(this.h) * this.hmxi * rh);
        if (this.meth == 1) {
            this.irflag = 0;
            this.pdh = Math.max(Math.abs(this.h) * this.pdlast, 1.0E-6);
            if (rh * this.pdh * 1.0001 >= this.sm1[this.nq]) {
                rh = this.sm1[this.nq] / this.pdh;
                this.irflag = 1;
            }
        }
        double r = 1.0;
        for (int j = 2; j <= this.l; ++j) {
            r *= rh;
            int i = 1;
            while (i <= this.n) {
                double[] dArray = this.yh[j];
                int n = i++;
                dArray[n] = dArray[n] * r;
            }
        }
        this.h *= rh;
        this.rc *= rh;
        this.ialth = this.l;
    }

    public void lsoda(int neq, double[] yp, double t, double tout, int itol, double[] rtol, double[] atol, int itask, int istate, int iopt, int msg, int maxstep, int maxhnil, int maxordn, int maxords, double tmax, double hinit, double hmax, double hmin) {
        double tnext;
        double hmx;
        int iflag;
        int i;
        double atoli;
        int mxstp0 = 1000000;
        int mxhnl0 = 10;
        boolean ihit = false;
        double h0 = 0.0;
        double tcrit = 0.0;
        this.tvec = new ArrayList();
        this.yvec = new ArrayList();
        if (this.write) {
            try {
                this.recorder = new Data("data", "lsoda.csv", neq);
            }
            catch (IOException e) {
                System.err.println("error in creating file");
                return;
            }
        }
        if (istate < 1 || istate > 3) {
            this.terminate();
            throw new IstateException(istate);
        }
        if (itask < 1 || itask > 5) {
            this.terminate();
            throw new IllegalInputException("itask", itask);
        }
        if (this.init == 0 && (istate == 2 || istate == 3)) {
            this.terminate();
            throw new IstateException(istate, this.init);
        }
        if (istate == 1) {
            this.init = 0;
            if (tout == t) {
                ++this.ntrep;
                if (this.ntrep < 5) {
                    return;
                }
                throw new RepeatedInputException();
            }
        }
        if (istate == 1 || istate == 3) {
            this.ntrep = 0;
            if (neq <= 0) {
                this.terminate();
                throw new NeqException(neq);
            }
            if (istate == 3 && neq > this.n) {
                this.terminate();
                throw new NeqException(neq, istate);
            }
            this.n = neq;
            if (itol < 1 || itol > 4) {
                this.terminate();
                throw new IllegalInputException("itol", itol);
            }
            if (iopt < 0 || iopt > 1) {
                this.terminate();
                throw new IllegalInputException("ipot", iopt);
            }
            if (iopt == 0) {
                this.ixpr = 0;
                this.mxstep = mxstp0;
                this.mxhnil = mxhnl0;
                this.hmxi = 0.0;
                this.hmin = 0.0;
                if (istate == 1) {
                    h0 = 0.0;
                    this.mxordn = Math.min(this.mxordn, this.mord[1]);
                    this.mxords = Math.min(this.mxords, this.mord[2]);
                }
            } else {
                this.ixpr = msg;
                if (this.ixpr < 0 || this.ixpr > 1) {
                    this.terminate();
                    throw new IllegalInputException("ixpr", this.ixpr);
                }
                this.mxstep = maxstep;
                if (this.mxstep < 0) {
                    this.terminate();
                    throw new IllegalInputException("mxstep", this.mxstep);
                }
                if (this.mxstep == 0) {
                    this.mxstep = mxstp0;
                }
                this.mxhnil = maxhnil;
                if (this.mxhnil < 0) {
                    this.terminate();
                    throw new IllegalInputException("mxhnil", this.mxhnil);
                }
                if (istate == 1) {
                    h0 = hinit;
                    if (this.mxordn < 0) {
                        this.terminate();
                        throw new IllegalInputException("mxordn", this.mxordn);
                    }
                    if (this.mxordn == 0) {
                        this.mxordn = 100;
                    }
                    this.mxordn = Math.min(this.mxordn, this.mord[1]);
                    if (this.mxords < 0) {
                        this.terminate();
                        throw new IllegalInputException("mxords", this.mxords);
                    }
                    if (this.mxords == 0) {
                        this.mxords = 100;
                    }
                    this.mxords = Math.min(this.mxords, this.mord[2]);
                    if ((tout - t) * h0 < 0.0) {
                        this.terminate();
                        throw new IllegalTException("tout_behind_t", t, tout, h0);
                    }
                }
                if (hmax < 0.0) {
                    this.terminate();
                    throw new IllegalInputException("hmax", hmax);
                }
                this.hmxi = 0.0;
                if (hmax > 0.0) {
                    this.hmxi = 1.0 / hmax;
                }
                this.hmin = hmin;
                if (this.hmin < 0.0) {
                    this.terminate();
                    throw new IllegalInputException("hmin", this.hmin);
                }
            }
        }
        if (istate == 1) {
            this.sqrteta = Math.sqrt(2.220446049250313E-16);
            this.meth = 1;
            int nyh = this.n;
            int lenyh = 1 + Math.max(this.mxordn, this.mxords);
            this.yh = new double[1 + lenyh][1 + nyh];
            this.wm = new double[1 + nyh][1 + nyh];
            this.ewt = new double[1 + nyh];
            this.savf = new double[1 + nyh];
            this.acor = new double[1 + nyh];
            this.ipvt = new int[1 + nyh];
            this.y = new double[1 + neq];
            System.arraycopy(yp, 0, this.y, 1, neq);
        }
        if (istate == 1 || istate == 3) {
            double rtoli = rtol[1];
            atoli = atol[1];
            for (i = 1; i <= this.n; ++i) {
                if (itol >= 3) {
                    rtoli = rtol[i];
                }
                if (itol == 2 || itol == 4) {
                    atoli = atol[i];
                }
                if (rtoli < 0.0) {
                    this.terminate();
                    throw new IllegalInputException("rtol", rtoli);
                }
                if (!(atoli < 0.0)) continue;
                this.terminate();
                throw new IllegalInputException("rtol", atoli);
            }
        }
        if (istate == 3) {
            this.jstart = -1;
        }
        if (istate == 1) {
            double rh;
            this.tn = t;
            this.maxord = this.mxordn;
            if (itask == 4 || itask == 5) {
                tcrit = tmax;
                if ((tcrit - tout) * (tout - t) < 0.0) {
                    this.terminate();
                    throw new IllegalTException("tcrit_behind_tout", t, tout, tcrit);
                }
                if (h0 != 0.0 && (t + h0 - tcrit) * h0 > 0.0) {
                    h0 = tcrit - t;
                }
            }
            this.jstart = 0;
            this.nhnil = 0;
            this.nst = 0;
            this.nje = 0;
            this.nslast = 0;
            this.hu = 0.0;
            this.nqu = 0;
            this.mused = 0;
            this.miter = 0;
            this.ccmax = 0.3;
            this.maxcor = 3;
            this.msbp = 20;
            this.mxncf = 10;
            this.yh[2] = this.FirstOrderSystem(this.y, this.tn);
            this.nfe = 1;
            if (this.n >= 0) {
                System.arraycopy(this.y, 1, this.yh[1], 1, this.n);
            }
            this.nq = 1;
            this.h = 1.0;
            this.ewt = SupportingFunctions.ewset(this.y, itol, rtol, atol, this.n);
            for (i = 1; i <= this.n; ++i) {
                if (this.ewt[i] <= 0.0) {
                    this.terminate();
                    throw new EwtException(i, this.ewt[i]);
                }
                this.ewt[i] = 1.0 / this.ewt[i];
            }
            if (h0 == 0.0) {
                double w0;
                double tdist = Math.abs(tout - t);
                if (tdist < 4.440892098500626E-16 * (w0 = Math.max(Math.abs(t), Math.abs(tout)))) {
                    this.terminate();
                    throw new IllegalTException("tout_close_to_t", t, tout, tcrit);
                }
                double tol = rtol[1];
                if (itol > 2) {
                    for (i = 2; i <= this.n; ++i) {
                        tol = Math.max(tol, rtol[i]);
                    }
                }
                if (tol <= 0.0) {
                    atoli = atol[1];
                    for (i = 1; i <= this.n; ++i) {
                        double ayi;
                        if (itol == 2 || itol == 4) {
                            atoli = atol[i];
                        }
                        if ((ayi = Math.abs(this.y[i])) == 0.0) continue;
                        tol = Math.max(tol, atoli / ayi);
                    }
                }
                tol = Math.max(tol, 2.220446049250313E-14);
                tol = Math.min(tol, 0.001);
                double sum = SupportingFunctions.vmnorm(this.n, this.yh[2], this.ewt);
                sum = 1.0 / (tol * w0 * w0) + tol * sum * sum;
                h0 = 1.0 / Math.sqrt(sum);
                h0 = Math.min(h0, tdist);
                h0 *= (double)(tout - t >= 0.0 ? 1 : -1);
            }
            if ((rh = Math.abs(h0) * this.hmxi) > 1.0) {
                h0 /= rh;
            }
            this.h = h0;
            i = 1;
            while (i <= this.n) {
                double[] dArray = this.yh[2];
                int n = i++;
                dArray[n] = dArray[n] * h0;
            }
        }
        if (istate == 2 || istate == 3) {
            this.nslast = this.nst;
            switch (itask) {
                case 1: {
                    if (!((this.tn - tout) * this.h >= 0.0)) break;
                    this.y = SupportingFunctions.intdy(tout, 0, this.y, this.nq, this.tn, this.hu, 2.220446049250313E-16, this.h, this.yh, this.n);
                    iflag = (int)this.y[0];
                    this.y[0] = 0.0;
                    if (iflag != 0) {
                        this.terminate();
                        throw new InterpolationException(itask, tout);
                    }
                    t = tout;
                    istate = 2;
                    this.illin = 0;
                    return;
                }
                case 2: {
                    break;
                }
                case 3: {
                    double tp = this.tn - this.hu * 1.0000000000000222;
                    if ((tp - tout) * this.h > 0.0) {
                        this.terminate();
                        throw new IllegalTException("tout_behind_tcur_hu", this.tn, tout, itask);
                    }
                    if ((this.tn - tout) * this.h < 0.0) break;
                    this.successReturn(ihit, tcrit, itask);
                    return;
                }
                case 4: {
                    tcrit = tmax;
                    if ((this.tn - tcrit) * this.h > 0.0) {
                        this.terminate();
                        throw new IllegalTException("tcrit_behind_tcur", this.tn, tout, tcrit);
                    }
                    if ((tcrit - tout) * this.h < 0.0) {
                        this.terminate();
                        throw new IllegalTException("tcrit_behind_tout", this.tn, tout, tcrit);
                    }
                    if ((this.tn - tout) * this.h >= 0.0) {
                        this.y = SupportingFunctions.intdy(tout, 0, this.y, this.nq, this.tn, this.hu, 2.220446049250313E-16, this.h, this.yh, this.n);
                        iflag = (int)this.y[0];
                        this.y[0] = 0.0;
                        if (iflag != 0) {
                            this.terminate();
                            throw new InterpolationException(itask, tout);
                        }
                        t = tout;
                        istate = 2;
                        this.illin = 0;
                        return;
                    }
                }
                case 5: {
                    if (itask == 5 && (this.tn - (tcrit = tmax)) * this.h > 0.0) {
                        this.terminate();
                        throw new IllegalTException("tcrit_behind_tcur", this.tn, tout, tcrit);
                    }
                    hmx = Math.abs(this.tn) + Math.abs(this.h);
                    boolean bl = ihit = Math.abs(this.tn - tcrit) <= 2.220446049250313E-14 * hmx;
                    if (ihit) {
                        t = tcrit;
                        this.successReturn(ihit, tcrit, itask);
                        return;
                    }
                    tnext = this.tn + this.h * 0.9999999999999991;
                    if ((tnext - tcrit) * this.h <= 0.0) break;
                    this.h = (tcrit - this.tn) * 0.9999999999999991;
                    if (istate != 2) break;
                    this.jstart = -2;
                }
            }
        }
        this.recording(t, this.y);
        while (true) {
            double tolsf;
            int i2;
            if (istate != 1 || this.nst != 0) {
                if (this.nst - this.nslast >= this.mxstep) {
                    istate = -1;
                    this.terminate2();
                    throw new ExceedMaxStepsException(this.mxstep);
                }
                this.ewt = SupportingFunctions.ewset(this.yh[1], itol, rtol, atol, this.n);
                for (i2 = 1; i2 <= this.n; ++i2) {
                    if (this.ewt[i2] <= 0.0) {
                        istate = -6;
                        this.terminate2();
                        throw new EwtException(i2, this.ewt[i2]);
                    }
                    this.ewt[i2] = 1.0 / this.ewt[i2];
                }
            }
            if ((tolsf = 2.220446049250313E-16 * SupportingFunctions.vmnorm(this.n, this.yh[1], this.ewt)) > 0.01) {
                tolsf *= 200.0;
                if (this.nst == 0) {
                    this.terminate();
                    throw new TooMuchAccuracyException(tolsf);
                }
                istate = -2;
                this.terminate2();
                throw new TooMuchAccuracyException(t, tolsf);
            }
            if (this.tn + this.h == this.tn) {
                ++this.nhnil;
                if (this.nhnil <= this.mxhnil) {
                    System.err.printf("lsoda: warning.. internal t = %g and h = %g are\n         such that in the machine, t+h=t on the next step\n         solver will continue anyway", this.tn, this.h);
                    if (this.nhnil == this.mxhnil) {
                        System.err.printf("lsoda: above warning has been issued %d times,\n         it will be not be issued again for this problem", this.nhnil);
                    }
                }
            }
            this.stoda();
            if (this.kflag == 0) {
                this.init = 1;
                if (this.meth != this.mused) {
                    this.maxord = this.mxordn;
                    if (this.meth == 2) {
                        this.maxord = this.mxords;
                    }
                    this.jstart = -1;
                    if (this.ixpr != 0) {
                        if (this.meth == 2) {
                            System.out.println("lsoda: a switch to the stiff method has occurred");
                        }
                        if (this.meth == 1) {
                            System.out.println("lsoda: a switch to the nonstiff method has occurred");
                        }
                        System.out.printf("         at t = %g, tentative step size h = %g, step nst = %d\n", this.tn, this.h, this.nst);
                    }
                }
                if (itask == 1) {
                    if ((this.tn - tout) * this.h < 0.0) {
                        this.recording(this.tn, this.y);
                        continue;
                    }
                    this.y = SupportingFunctions.intdy(tout, 0, this.y, this.nq, this.tn, this.hu, 2.220446049250313E-16, this.h, this.yh, this.n);
                    iflag = (int)this.y[0];
                    if (iflag != 0) {
                        this.terminate();
                        throw new InterpolationException(itask, tout);
                    }
                    this.y[0] = 0.0;
                    istate = 2;
                    this.illin = 0;
                    this.recording(tout, this.y);
                    return;
                }
                if (itask == 2) {
                    this.successReturn(ihit, tcrit, itask);
                    return;
                }
                if (itask == 3) {
                    if (!((this.tn - tout) * this.h >= 0.0)) continue;
                    this.successReturn(ihit, tcrit, itask);
                    return;
                }
                if (itask == 4) {
                    if ((this.tn - tcrit) * this.h >= 0.0) {
                        this.y = SupportingFunctions.intdy(tout, 0, this.y, this.nq, this.tn, this.hu, 2.220446049250313E-16, this.h, this.yh, this.n);
                        iflag = (int)this.y[0];
                        if (iflag != 0) {
                            this.terminate();
                            throw new InterpolationException(itask, tout);
                        }
                        this.y[0] = 0.0;
                        istate = 2;
                        this.illin = 0;
                        this.recording(tout, this.y);
                        return;
                    }
                    hmx = Math.abs(this.tn) + Math.abs(this.h);
                    boolean bl = ihit = Math.abs(this.tn - tcrit) <= 2.220446049250313E-14 * hmx;
                    if (ihit) {
                        this.successReturn(ihit, tcrit, itask);
                        return;
                    }
                    this.recording(this.tn, this.y);
                    tnext = this.tn + this.h * 1.0000000000000009;
                    if ((tnext - tcrit) * this.h <= 0.0) continue;
                    this.h = (tcrit - this.tn) * 0.9999999999999991;
                    this.jstart = -2;
                    continue;
                }
                if (itask == 5) {
                    hmx = Math.abs(this.tn) + Math.abs(this.h);
                    ihit = Math.abs(this.tn - tcrit) <= 2.220446049250313E-14 * hmx;
                    this.successReturn(ihit, tcrit, itask);
                    return;
                }
            }
            if (this.kflag != -1 && this.kflag != -2) continue;
            double big = 0.0;
            this.imxer = 1;
            for (i2 = 1; i2 <= this.n; ++i2) {
                double size = Math.abs(this.acor[i2]) * this.ewt[i2];
                if (!(big < size)) continue;
                big = size;
                this.imxer = i2;
            }
            this.terminate2();
            if (this.kflag == -1) {
                istate = -4;
                throw new TestsFailException("error_test", this.tn, this.h);
            }
            if (this.kflag == -2) break;
        }
        istate = -5;
        throw new TestsFailException("convergence_test", this.tn, this.h);
    }

    private void terminate() {
        if (this.illin == 5) {
            System.err.println("lsoda: repeated occurrence of illegal input");
            System.err.println("       run aborted.. apparent infinite loop");
        } else {
            ++this.illin;
            this.istate = -3;
        }
    }

    private void terminate2() {
        if (this.n >= 0) {
            System.arraycopy(this.yh[1], 1, this.y, 1, this.n);
        }
        this.illin = 0;
    }

    private void successReturn(boolean ihit, double tcrit, int itask) {
        if (this.n >= 0) {
            System.arraycopy(this.yh[1], 1, this.y, 1, this.n);
        }
        double t = this.tn;
        if ((itask == 4 || itask == 5) && ihit) {
            t = tcrit;
        }
        this.istate = 2;
        this.illin = 0;
        this.recording(t, this.y);
    }

    private void resetCoeff() {
        this.el = this.elco[this.nq];
        this.rc = this.rc * this.el[1] / this.el0;
        this.el0 = this.el[1];
        this.conit = 0.5 / (double)(this.nq + 2);
    }

    private void stoda() {
        int i;
        int orderflag = 0;
        double dsm = 0.0;
        this.kflag = 0;
        this.told = this.tn;
        this.ncf = 0;
        this.ierpj = 0;
        this.jcur = 0;
        this.delp = 0.0;
        if (this.jstart == 0) {
            this.lmax = this.maxord + 1;
            this.nq = 1;
            this.l = 2;
            this.ialth = 2;
            this.rmax = 10000.0;
            this.rc = 0.0;
            this.el0 = 1.0;
            this.crate = 0.7;
            this.hold = this.h;
            this.nslp = 0;
            this.ipup = this.miter;
            this.icount = 20;
            this.irflag = 0;
            this.pdest = 0.0;
            this.pdlast = 0.0;
            this.ratio = 5.0;
            this.cfode(2);
            for (i = 1; i <= 5; ++i) {
                this.cm2[i] = this.tesco[i][2] * this.elco[i][i + 1];
            }
            this.cfode(1);
            for (i = 1; i <= 12; ++i) {
                this.cm1[i] = this.tesco[i][2] * this.elco[i][i + 1];
            }
            this.resetCoeff();
        }
        if (this.jstart == -1) {
            this.ipup = this.miter;
            this.lmax = this.maxord + 1;
            if (this.ialth == 1) {
                this.ialth = 2;
            }
            if (this.meth != this.mused) {
                this.cfode(this.meth);
                this.ialth = this.l;
                this.resetCoeff();
            }
            if (this.h != this.hold) {
                this.rh = this.h / this.hold;
                this.h = this.hold;
                this.scaleH(this.rh);
            }
        }
        if (this.jstart == -2 && this.h != this.hold) {
            this.rh = this.h / this.hold;
            this.h = this.hold;
            this.scaleH(this.rh);
        }
        while (true) {
            int ii;
            int i2;
            int j;
            if (Math.abs(this.rc - 1.0) > this.ccmax) {
                this.ipup = this.miter;
            }
            if (this.nst >= this.nslp + this.msbp) {
                this.ipup = this.miter;
            }
            this.tn += this.h;
            for (j = this.nq; j >= 1; --j) {
                for (i2 = j; i2 <= this.nq; ++i2) {
                    for (ii = 1; ii <= this.n; ++ii) {
                        double[] dArray = this.yh[i2];
                        int n = ii;
                        dArray[n] = dArray[n] + this.yh[i2 + 1][ii];
                    }
                }
            }
            double pnorm = SupportingFunctions.vmnorm(this.n, this.yh[1], this.ewt);
            this.correction(pnorm);
            if (this.corflag != 0) {
                if (this.corflag == 1) {
                    this.rh = Math.max(this.rh, this.hmin / Math.abs(this.h));
                    this.scaleH(this.rh);
                    continue;
                }
                if (this.corflag != 2) continue;
                this.kflag = -2;
                this.hold = this.h;
                this.jstart = 1;
                return;
            }
            this.jcur = 0;
            if (this.m == 0.0) {
                dsm = this.del / this.tesco[this.nq][2];
            }
            if (this.m > 0.0) {
                dsm = SupportingFunctions.vmnorm(this.n, this.acor, this.ewt) / this.tesco[this.nq][2];
            }
            if (dsm <= 1.0) {
                this.kflag = 0;
                ++this.nst;
                this.hu = this.h;
                this.nqu = this.nq;
                this.mused = this.meth;
                for (j = 1; j <= this.l; ++j) {
                    double r = this.el[j];
                    for (i2 = 1; i2 <= this.n; ++i2) {
                        double[] dArray = this.yh[j];
                        int n = i2;
                        dArray[n] = dArray[n] + r * this.acor[i2];
                    }
                }
                --this.icount;
                if (this.icount < 0) {
                    this.methodSwitch(dsm, pnorm);
                    if (this.meth != this.mused) {
                        this.rh = Math.max(this.rh, this.hmin / Math.abs(this.h));
                        this.scaleH(this.rh);
                        this.rmax = 10.0;
                        this.endStoda();
                        break;
                    }
                }
                --this.ialth;
                if (this.ialth == 0) {
                    this.rhup = 0.0;
                    if (this.l != this.lmax) {
                        for (i = 1; i <= this.n; ++i) {
                            this.savf[i] = this.acor[i] - this.yh[this.lmax][i];
                        }
                        double dup = SupportingFunctions.vmnorm(this.n, this.savf, this.ewt) / this.tesco[this.nq][3];
                        double exup = 1.0 / (double)(this.l + 1);
                        this.rhup = 1.0 / (1.4 * Math.pow(dup, exup) + 1.4E-6);
                    }
                    if ((orderflag = this.orderSwitch(dsm)) == 0) {
                        this.endStoda();
                        break;
                    }
                    if (orderflag == 1) {
                        this.rh = Math.max(this.rh, this.hmin / Math.abs(this.h));
                        this.scaleH(this.rh);
                        this.rmax = 10.0;
                        this.endStoda();
                        break;
                    }
                    if (orderflag == 2) {
                        this.resetCoeff();
                        this.rh = Math.max(this.rh, this.hmin / Math.abs(this.h));
                        this.scaleH(this.rh);
                        this.rmax = 10.0;
                        this.endStoda();
                        break;
                    }
                }
                if (this.ialth > 1 || this.l == this.lmax) {
                    this.endStoda();
                    break;
                }
                if (this.n >= 0) {
                    System.arraycopy(this.acor, 1, this.yh[this.lmax], 1, this.n);
                }
                this.endStoda();
                break;
            }
            --this.kflag;
            this.tn = this.told;
            for (j = this.nq; j >= 1; --j) {
                for (i2 = j; i2 <= this.nq; ++i2) {
                    for (ii = 1; ii <= this.n; ++ii) {
                        double[] dArray = this.yh[i2];
                        int n = ii;
                        dArray[n] = dArray[n] - this.yh[i2 + 1][ii];
                    }
                }
            }
            this.rmax = 2.0;
            if (Math.abs(this.h) <= this.hmin * 1.00001) {
                this.kflag = -1;
                this.hold = this.h;
                this.jstart = 1;
                break;
            }
            if (this.kflag > -3) {
                this.rhup = 0.0;
                orderflag = this.orderSwitch(dsm);
                if (orderflag == 1 || orderflag == 0) {
                    if (orderflag == 0) {
                        this.rh = Math.min(this.rh, 0.2);
                    }
                    this.rh = Math.max(this.rh, this.hmin / Math.abs(this.h));
                    this.scaleH(this.rh);
                }
                if (orderflag != 2) continue;
                this.resetCoeff();
                this.rh = Math.max(this.rh, this.hmin / Math.abs(this.h));
                this.scaleH(this.rh);
                continue;
            }
            if (this.kflag == -this.mxncf) {
                this.kflag = -1;
                this.hold = this.h;
                this.jstart = 1;
                break;
            }
            this.rh = 0.1;
            this.rh = Math.max(this.hmin / Math.abs(this.h), this.rh);
            this.h *= this.rh;
            if (this.n >= 0) {
                System.arraycopy(this.yh[1], 1, this.y, 1, this.n);
            }
            this.savf = this.FirstOrderSystem(this.y, this.tn);
            ++this.nfe;
            for (i = 1; i <= this.n; ++i) {
                this.yh[2][i] = this.h * this.savf[i];
            }
            this.ipup = this.miter;
            this.ialth = 5;
            if (this.nq == 1) continue;
            this.nq = 1;
            this.l = 2;
            this.resetCoeff();
        }
    }

    private void correction(double pnorm) {
        this.m = 0.0;
        this.corflag = 0;
        double rate = 0.0;
        this.del = 0.0;
        if (this.n >= 0) {
            System.arraycopy(this.yh[1], 1, this.y, 1, this.n);
        }
        this.savf = this.FirstOrderSystem(this.y, this.tn);
        ++this.nfe;
        while (true) {
            int i;
            if (this.m == 0.0) {
                if (this.ipup > 0) {
                    this.calJacobian(this.y);
                    this.ipup = 0;
                    this.rc = 1.0;
                    this.nslp = this.nst;
                    this.crate = 0.7;
                    if (this.ierpj != 0) {
                        this.corFailure();
                        return;
                    }
                }
                for (i = 1; i <= this.n; ++i) {
                    this.acor[i] = 0.0;
                }
            }
            if (this.miter == 0) {
                for (i = 1; i <= this.n; ++i) {
                    this.savf[i] = this.h * this.savf[i] - this.yh[2][i];
                    this.y[i] = this.savf[i] - this.acor[i];
                }
                this.del = SupportingFunctions.vmnorm(this.n, this.y, this.ewt);
                for (i = 1; i <= this.n; ++i) {
                    this.y[i] = this.yh[1][i] + this.el[1] * this.savf[i];
                    this.acor[i] = this.savf[i];
                }
            } else {
                for (i = 1; i <= this.n; ++i) {
                    this.y[i] = this.h * this.savf[i] - (this.yh[2][i] + this.acor[i]);
                }
                this.y = SupportingFunctions.solsy(this.y, this.wm, this.n, this.ipvt, this.miter);
                this.del = SupportingFunctions.vmnorm(this.n, this.y, this.ewt);
                for (i = 1; i <= this.n; ++i) {
                    int n = i;
                    this.acor[n] = this.acor[n] + this.y[i];
                    this.y[i] = this.yh[1][i] + this.el[1] * this.acor[i];
                }
            }
            if (this.del <= 100.0 * pnorm * 2.220446049250313E-16) break;
            if (this.m != 0.0 || this.meth != 1) {
                double dcon;
                if (this.m != 0.0) {
                    double rm = 1024.0;
                    if (this.del <= 1024.0 * this.delp) {
                        rm = this.del / this.delp;
                    }
                    rate = Math.max(rate, rm);
                    this.crate = Math.max(0.2 * this.crate, rm);
                }
                if ((dcon = this.del * Math.min(1.0, 1.5 * this.crate) / (this.tesco[this.nq][2] * this.conit)) <= 1.0) {
                    this.pdest = Math.max(this.pdest, rate / Math.abs(this.h * this.el[1]));
                    if (this.pdest == 0.0) break;
                    this.pdlast = this.pdest;
                    break;
                }
            }
            this.m += 1.0;
            if (this.m == (double)this.maxcor || this.m >= 2.0 && this.del > 2.0 * this.delp) {
                if (this.miter == 0 || this.jcur == 1) {
                    this.corFailure();
                    return;
                }
                this.ipup = this.miter;
                this.m = 0.0;
                rate = 0.0;
                this.del = 0.0;
                if (this.n >= 0) {
                    System.arraycopy(this.yh[1], 1, this.y, 1, this.n);
                }
            } else {
                this.delp = this.del;
            }
            this.savf = this.FirstOrderSystem(this.y, this.tn);
            ++this.nfe;
        }
    }

    private void methodSwitch(double dsm, double pnorm) {
        double rh2;
        double rh1;
        double dm1;
        double exm1;
        int nqm1;
        if (this.meth == 1) {
            int nqm2;
            double rh22;
            if (this.nq > 5) {
                return;
            }
            if (dsm <= 100.0 * pnorm * 2.220446049250313E-16 || this.pdest == 0.0) {
                if (this.irflag == 0) {
                    return;
                }
                rh22 = 2.0;
                nqm2 = Math.min(this.nq, this.mxords);
            } else {
                double exsm = 1.0 / (double)this.l;
                double rh12 = 1.0 / (1.2 * Math.pow(dsm, exsm) + 1.2E-6);
                double rh1it = 2.0 * rh12;
                this.pdh = this.pdlast * Math.abs(this.h);
                if (this.pdh * rh12 > 1.0E-5) {
                    rh1it = this.sm1[this.nq] / this.pdh;
                }
                rh12 = Math.min(rh12, rh1it);
                if (this.nq > this.mxords) {
                    nqm2 = this.mxords;
                    int lm2 = this.mxords + 1;
                    double exm2 = 1.0 / (double)lm2;
                    int lm2p1 = lm2 + 1;
                    double dm2 = SupportingFunctions.vmnorm(this.n, this.yh[lm2p1], this.ewt) / this.cm2[this.mxords];
                    rh22 = 1.0 / (1.2 * Math.pow(dm2, exm2) + 1.2E-6);
                } else {
                    double dm2 = dsm * (this.cm1[this.nq] / this.cm2[this.nq]);
                    rh22 = 1.0 / (1.2 * Math.pow(dm2, exsm) + 1.2E-6);
                    nqm2 = this.nq;
                }
                if (rh22 < this.ratio * rh12) {
                    return;
                }
            }
            this.rh = rh22;
            this.icount = 20;
            this.meth = 2;
            this.miter = 2;
            this.pdlast = 0.0;
            this.nq = nqm2;
            this.l = this.nq + 1;
            return;
        }
        double exsm = 1.0 / (double)this.l;
        if (this.mxordn < this.nq) {
            nqm1 = this.mxordn;
            int lm1 = this.mxordn + 1;
            exm1 = 1.0 / (double)lm1;
            int lm1p1 = lm1 + 1;
            dm1 = SupportingFunctions.vmnorm(this.n, this.yh[lm1p1], this.ewt) / this.cm1[this.mxordn];
            rh1 = 1.0 / (1.2 * Math.pow(dm1, exm1) + 1.2E-6);
        } else {
            dm1 = dsm * (this.cm2[this.nq] / this.cm1[this.nq]);
            rh1 = 1.0 / (1.2 * Math.pow(dm1, exsm) + 1.2E-6);
            nqm1 = this.nq;
            exm1 = exsm;
        }
        double rh1it = 2.0 * rh1;
        this.pdh = this.pdnorm * Math.abs(this.h);
        if (this.pdh * rh1 > 1.0E-4) {
            rh1it = this.sm1[nqm1] / this.pdh;
        }
        if ((rh1 = Math.min(rh1, rh1it)) * this.ratio < 5.0 * (rh2 = 1.0 / (1.2 * Math.pow(dsm, exsm) + 1.2E-6))) {
            return;
        }
        double alpha = Math.max(0.001, rh1);
        if ((dm1 *= Math.pow(alpha, exm1)) <= 2.220446049250313E-13 * pnorm) {
            return;
        }
        this.rh = rh1;
        this.icount = 20;
        this.meth = 1;
        this.miter = 0;
        this.pdlast = 0.0;
        this.nq = nqm1;
        this.l = this.nq + 1;
    }

    private void endStoda() {
        double r = 1.0 / this.tesco[this.nqu][2];
        int i = 1;
        while (i <= this.n) {
            int n = i++;
            this.acor[n] = this.acor[n] * r;
        }
        this.hold = this.h;
        this.jstart = 1;
    }

    private int orderSwitch(double dsm) {
        int newq;
        int orderflag = 0;
        double exsm = 1.0 / (double)this.l;
        double rhsm = 1.0 / (1.2 * Math.pow(dsm, exsm) + 1.2E-6);
        double rhdn = 0.0;
        if (this.nq != 1) {
            double ddn = SupportingFunctions.vmnorm(this.n, this.yh[this.l], this.ewt) / this.tesco[this.nq][1];
            double exdn = 1.0 / (double)this.nq;
            rhdn = 1.0 / (1.3 * Math.pow(ddn, exdn) + 1.3E-6);
        }
        if (this.meth == 1) {
            this.pdh = Math.max(Math.abs(this.h) * this.pdlast, 1.0E-6);
            if (this.l < this.lmax) {
                this.rhup = Math.min(this.rhup, this.sm1[this.l] / this.pdh);
            }
            rhsm = Math.min(rhsm, this.sm1[this.nq] / this.pdh);
            if (this.nq > 1) {
                rhdn = Math.min(rhdn, this.sm1[this.nq - 1] / this.pdh);
            }
            this.pdest = 0.0;
        }
        if (rhsm >= this.rhup) {
            if (rhsm >= rhdn) {
                newq = this.nq;
                this.rh = rhsm;
            } else {
                newq = this.nq - 1;
                this.rh = rhdn;
                if (this.kflag < 0 && this.rh > 1.0) {
                    this.rh = 1.0;
                }
            }
        } else if (this.rhup <= rhdn) {
            newq = this.nq - 1;
            this.rh = rhdn;
            if (this.kflag < 0 && this.rh > 1.0) {
                this.rh = 1.0;
            }
        } else {
            this.rh = this.rhup;
            if (this.rh >= 1.1) {
                double r = this.el[this.l] / (double)this.l;
                this.nq = this.l;
                this.l = this.nq + 1;
                for (int i = 1; i <= this.n; ++i) {
                    this.yh[this.l][i] = this.acor[i] * r;
                }
                orderflag = 2;
            } else {
                this.ialth = 3;
            }
            return orderflag;
        }
        if (this.meth == 1) {
            if (this.rh * this.pdh * 1.00001 < this.sm1[newq] && this.kflag == 0 && this.rh < 1.1) {
                this.ialth = 3;
                return orderflag;
            }
        } else if (this.kflag == 0 && this.rh < 1.1) {
            this.ialth = 3;
            return orderflag;
        }
        if (this.kflag <= -2) {
            this.rh = Math.min(this.rh, 0.2);
        }
        if (newq == this.nq) {
            orderflag = 1;
            return orderflag;
        }
        this.nq = newq;
        this.l = this.nq + 1;
        orderflag = 2;
        return orderflag;
    }

    private void corFailure() {
        ++this.ncf;
        this.rmax = 2.0;
        this.tn = this.told;
        for (int j = this.nq; j >= 1; --j) {
            for (int i = j; i <= this.nq; ++i) {
                for (int ii = 1; ii <= this.n; ++ii) {
                    double[] dArray = this.yh[i];
                    int n = ii;
                    dArray[n] = dArray[n] - this.yh[i + 1][ii];
                }
            }
        }
        if (Math.abs(this.h) <= this.hmin * 1.00001 || this.ncf == this.mxncf) {
            this.corflag = 2;
            return;
        }
        this.corflag = 1;
        this.rh = 0.25;
        this.ipup = this.miter;
    }

    private void recording(double t, double[] values) {
        this.tvec.add(t);
        this.yvec.add(Utility.transformYVec(values));
        if (this.write) {
            this.recorder.write(t, values);
        }
    }

    public double[] FirstOrderSystem(double[] y, double t) {
        double[] ydot = new double[this.ode.getDimension()];
        this.ode.computeDerivatives(t, Arrays.copyOfRange(y, 1, this.ode.getDimension() + 1), ydot);
        double[] ydot1 = new double[this.ode.getDimension() + 1];
        System.arraycopy(ydot, 0, ydot1, 1, this.ode.getDimension());
        return ydot1;
    }

    public double integrate(FirstOrderDifferentialEquations ode, double t0, double[] y, double tout, double[] result) throws DimensionMismatchException, NumberIsTooSmallException, MaxCountExceededException, NoBracketingException {
        this.ode = ode;
        double[] rtol = new double[]{0.0, this.relativeTol};
        double[] atol = new double[]{0.0, this.absoluteTol};
        this.lsoda(ode.getDimension(), y, t0, tout, 1, rtol, atol, 1, 1, 1, 0, 0, 0, 0, 0, 0.0, 0.0, this.hmaxi, this.hmin);
        System.arraycopy(this.y, 1, result, 0, ode.getDimension());
        return 0.0;
    }

    public String getName() {
        return null;
    }

    public void addStepHandler(StepHandler stepHandler) {
    }

    public Collection<StepHandler> getStepHandlers() {
        return null;
    }

    public void clearStepHandlers() {
    }

    public void addEventHandler(EventHandler eventHandler, double v, double v1, int i) {
    }

    public void addEventHandler(EventHandler eventHandler, double v, double v1, int i, UnivariateSolver univariateSolver) {
    }

    public Collection<EventHandler> getEventHandlers() {
        return null;
    }

    public void clearEventHandlers() {
    }

    public double getCurrentStepStart() {
        return this.tn;
    }

    public double getCurrentSignedStepsize() {
        return this.h;
    }

    public void setMaxEvaluations(int i) {
    }

    public int getMaxEvaluations() {
        return 0;
    }

    public int getEvaluations() {
        return this.nfe;
    }

    public int getJacobianEvaluations() {
        return this.nje;
    }

    public int getStepsTaken() {
        return this.nst;
    }

    public int getMaxComponent() {
        return this.imxer;
    }

    public ArrayList<Double> getTvec() {
        return this.tvec;
    }

    public ArrayList<Double[]> getYvec() {
        return this.yvec;
    }
}

