/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.math.interpolate;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.math4.legacy.analysis.BivariateFunction;
import org.apache.commons.math4.legacy.analysis.UnivariateFunction;
import org.apache.commons.math4.legacy.analysis.interpolation.AkimaSplineInterpolator;
import org.apache.commons.math4.legacy.analysis.interpolation.BicubicInterpolator;
import org.apache.commons.math4.legacy.analysis.interpolation.DividedDifferenceInterpolator;
import org.apache.commons.math4.legacy.analysis.interpolation.LinearInterpolator;
import org.apache.commons.math4.legacy.analysis.interpolation.LoessInterpolator;
import org.apache.commons.math4.legacy.analysis.interpolation.NevilleInterpolator;
import org.apache.commons.math4.legacy.analysis.interpolation.PiecewiseBicubicSplineInterpolator;
import org.apache.commons.math4.legacy.analysis.interpolation.SplineInterpolator;
import org.apache.commons.math4.legacy.analysis.polynomials.PolynomialSplineFunction;
import org.meteoinfo.math.interpolate.InterpolationMethod;
import org.meteoinfo.math.interpolate.KrigingInterpolation1D;
import org.meteoinfo.math.interpolate.KrigingInterpolation2D;
import org.meteoinfo.math.interpolate.RectInterpolator;
import org.meteoinfo.math.interpolate.RectInterpolator3D;
import org.meteoinfo.math.spatial.KDTree;
import org.meteoinfo.ndarray.Array;
import org.meteoinfo.ndarray.DataType;
import org.meteoinfo.ndarray.Index;
import org.meteoinfo.ndarray.IndexIterator;
import org.meteoinfo.ndarray.math.ArrayUtil;

public class InterpUtil {
    public static PolynomialSplineFunction linearInterpFunc(Array x, Array y) {
        double[] xd = (double[])ArrayUtil.copyToNDJavaArray_Double((Array)x);
        double[] yd = (double[])ArrayUtil.copyToNDJavaArray_Double((Array)y);
        LinearInterpolator li = new LinearInterpolator();
        PolynomialSplineFunction psf = li.interpolate(xd, yd);
        return psf;
    }

    public static UnivariateFunction getInterpFunc(Array x, Array y, String kind) {
        SplineInterpolator li;
        double[] xd = (double[])ArrayUtil.copyToNDJavaArray_Double((Array)x);
        double[] yd = (double[])ArrayUtil.copyToNDJavaArray_Double((Array)y);
        switch (kind) {
            case "spline": 
            case "cubic": {
                li = new SplineInterpolator();
                break;
            }
            case "akima": {
                li = new AkimaSplineInterpolator();
                break;
            }
            case "divided": {
                li = new DividedDifferenceInterpolator();
                break;
            }
            case "loess": {
                li = new LoessInterpolator();
                break;
            }
            case "neville": {
                li = new NevilleInterpolator();
                break;
            }
            default: {
                li = new LinearInterpolator();
            }
        }
        UnivariateFunction psf = li.interpolate(xd, yd);
        return psf;
    }

    public static KrigingInterpolation1D getKriging1D(Array x, Array y, double beta) {
        double[] xd = (double[])ArrayUtil.copyToNDJavaArray_Double((Array)x);
        double[] yd = (double[])ArrayUtil.copyToNDJavaArray_Double((Array)y);
        KrigingInterpolation1D krigingInterpolation1D = new KrigingInterpolation1D(xd, yd, beta);
        return krigingInterpolation1D;
    }

    public static BivariateFunction getBiInterpFunc(Array x, Array y, Array z, String kind) {
        PiecewiseBicubicSplineInterpolator li;
        double[] xd = (double[])ArrayUtil.copyToNDJavaArray_Double((Array)x);
        double[] yd = (double[])ArrayUtil.copyToNDJavaArray_Double((Array)y);
        double[][] zd = (double[][])ArrayUtil.copyToNDJavaArray_Double((Array)z);
        switch (kind) {
            case "spline": {
                li = new PiecewiseBicubicSplineInterpolator();
                break;
            }
            default: {
                li = new BicubicInterpolator();
            }
        }
        BivariateFunction func = li.interpolate(xd, yd, zd);
        return func;
    }

    public static KrigingInterpolation2D getKriging2D(Array x, Array y, Array z, double beta) {
        double[] xd = (double[])ArrayUtil.copyToNDJavaArray_Double((Array)x);
        double[] yd = (double[])ArrayUtil.copyToNDJavaArray_Double((Array)y);
        double[] zd = (double[])ArrayUtil.copyToNDJavaArray_Double((Array)z);
        KrigingInterpolation2D krigingInterpolation2D = new KrigingInterpolation2D(xd, yd, zd, beta);
        return krigingInterpolation2D;
    }

    public static Array evaluate(UnivariateFunction func, Array x) {
        Array r = Array.factory((DataType)DataType.DOUBLE, (int[])x.getShape());
        IndexIterator xIter = x.getIndexIterator();
        int i = 0;
        while ((long)i < r.getSize()) {
            r.setDouble(i, func.value(xIter.getDoubleNext()));
            ++i;
        }
        return r;
    }

    public static double evaluate(UnivariateFunction func, Number x) {
        return func.value(x.doubleValue());
    }

    public static double evaluate(KrigingInterpolation1D func, Number x) {
        return func.interpolate(x.doubleValue());
    }

    public static Array evaluate(KrigingInterpolation1D func, Array x) {
        Array r = Array.factory((DataType)DataType.DOUBLE, (int[])x.getShape());
        IndexIterator xIter = x.getIndexIterator();
        int i = 0;
        while ((long)i < r.getSize()) {
            r.setDouble(i, func.interpolate(xIter.getDoubleNext()));
            ++i;
        }
        return r;
    }

    public static Array evaluate(BivariateFunction func, Array x, Array y) {
        Array r = Array.factory((DataType)DataType.DOUBLE, (int[])x.getShape());
        IndexIterator xIter = x.getIndexIterator();
        IndexIterator yIter = y.getIndexIterator();
        int i = 0;
        while ((long)i < r.getSize()) {
            r.setDouble(i, func.value(xIter.getDoubleNext(), yIter.getDoubleNext()));
            ++i;
        }
        return r;
    }

    public static double evaluate(BivariateFunction func, Number x, Number y) {
        return func.value(x.doubleValue(), y.doubleValue());
    }

    public static Array evaluate(KrigingInterpolation2D func, Array x, Array y) {
        Array r = Array.factory((DataType)DataType.DOUBLE, (int[])x.getShape());
        IndexIterator xIter = x.getIndexIterator();
        IndexIterator yIter = y.getIndexIterator();
        int i = 0;
        while ((long)i < r.getSize()) {
            r.setDouble(i, func.interpolate(xIter.getDoubleNext(), yIter.getDoubleNext()));
            ++i;
        }
        return r;
    }

    public static double evaluate(KrigingInterpolation2D func, Number x, Number y) {
        return func.interpolate(x.doubleValue(), y.doubleValue());
    }

    public static Array cressman(List<Number> x_s, List<Number> y_s, Array v_s, List<Number> X, List<Number> Y, List<Number> radList) {
        double val;
        double sum;
        int j;
        double y;
        double x;
        int i;
        v_s = v_s.copyIfView();
        int xNum = X.size();
        int yNum = Y.size();
        int pNum = x_s.size();
        Array r = Array.factory((DataType)DataType.DOUBLE, (int[])new int[]{yNum, xNum});
        int irad = radList.size();
        double xMin = X.get(0).doubleValue();
        double yMin = Y.get(0).doubleValue();
        double xDelt = X.get(1).doubleValue() - X.get(0).doubleValue();
        double yDelt = Y.get(1).doubleValue() - Y.get(0).doubleValue();
        double[][] stationData = new double[pNum][5];
        for (i = 0; i < pNum; ++i) {
            x = x_s.get(i).doubleValue();
            y = y_s.get(i).doubleValue();
            stationData[i][0] = x;
            stationData[i][1] = y;
            stationData[i][2] = v_s.getDouble(i);
            stationData[i][3] = (x - xMin) / xDelt;
            stationData[i][4] = (y - yMin) / yDelt;
        }
        KDTree.Euclidean<double[]> kdTree = new KDTree.Euclidean<double[]>(2);
        for (i = 0; i < pNum; ++i) {
            if (Double.isNaN(stationData[i][2])) continue;
            kdTree.addPoint(new double[]{stationData[i][0], stationData[i][1]}, stationData[i]);
        }
        double HITOP = -9.999E20;
        double HIBOT = 9.999E20;
        double[][] TOP = new double[yNum][xNum];
        double[][] BOT = new double[yNum][xNum];
        for (i = 0; i < yNum; ++i) {
            for (j = 0; j < xNum; ++j) {
                TOP[i][j] = HITOP;
                BOT[i][j] = HIBOT;
            }
        }
        double rad = radList.size() > 0 ? radList.get(0).doubleValue() : 4.0;
        for (i = 0; i < yNum; ++i) {
            y = Y.get(i).doubleValue();
            for (j = 0; j < xNum; ++j) {
                x = X.get(j).doubleValue();
                int stNum = 0;
                sum = 0.0;
                ArrayList neighbours = kdTree.ballSearch(new double[]{x, y}, rad * rad);
                for (double[] station : neighbours) {
                    val = station[2];
                    sum += val;
                    ++stNum;
                    if (TOP[i][j] < val) {
                        TOP[i][j] = val;
                    }
                    if (!(BOT[i][j] > val)) continue;
                    BOT[i][j] = val;
                }
                if (stNum == 0) {
                    r.setDouble(i * xNum + j, Double.NaN);
                    continue;
                }
                r.setDouble(i * xNum + j, sum / (double)stNum);
            }
        }
        for (int p = 0; p < irad; ++p) {
            rad = radList.get(p).doubleValue();
            for (i = 0; i < yNum; ++i) {
                y = Y.get(i).doubleValue();
                for (j = 0; j < xNum; ++j) {
                    if (Double.isNaN(r.getDouble(i * xNum + j))) continue;
                    x = X.get(j).doubleValue();
                    sum = 0.0;
                    double wSum = 0.0;
                    ArrayList neighbours = kdTree.ballSearch(new double[]{x, y}, rad * rad);
                    for (double[] station : neighbours) {
                        double calVal;
                        val = station[2];
                        double sx = station[0];
                        double sy = station[1];
                        double sxi = station[3];
                        double syi = station[4];
                        if (sxi < 0.0 || sxi >= (double)(xNum - 1) || syi < 0.0 || syi >= (double)(yNum - 1)) continue;
                        double dis = Math.sqrt(Math.pow(sx - x, 2.0) + Math.pow(sy - y, 2.0));
                        int i1 = (int)syi;
                        int j1 = (int)sxi;
                        int i2 = i1 + 1;
                        int j2 = j1 + 1;
                        double a = r.getDouble(i1 * xNum + j1);
                        double b = r.getDouble(i1 * xNum + j2);
                        double c = r.getDouble(i2 * xNum + j1);
                        double d = r.getDouble(i2 * xNum + j2);
                        ArrayList<Double> dList = new ArrayList<Double>();
                        if (!Double.isNaN(a)) {
                            dList.add(a);
                        }
                        if (!Double.isNaN(b)) {
                            dList.add(b);
                        }
                        if (!Double.isNaN(c)) {
                            dList.add(c);
                        }
                        if (Double.isNaN(d)) {
                            dList.add(d);
                        }
                        if (dList.isEmpty()) continue;
                        if (dList.size() == 1) {
                            calVal = (Double)dList.get(0);
                        } else if (dList.size() <= 3) {
                            double aSum = 0.0;
                            Iterator iterator = dList.iterator();
                            while (iterator.hasNext()) {
                                double dd = (Double)iterator.next();
                                aSum += dd;
                            }
                            calVal = aSum / (double)dList.size();
                        } else {
                            double x1val = a + (c - a) * (syi - (double)i1);
                            double x2val = b + (d - b) * (syi - (double)i1);
                            calVal = x1val + (x2val - x1val) * (sxi - (double)j1);
                        }
                        double eVal = val - calVal;
                        double w = (rad * rad - dis * dis) / (rad * rad + dis * dis);
                        sum += eVal * w;
                        wSum += w;
                    }
                    if (!(wSum >= 1.0E-6)) continue;
                    double aData = r.getDouble(i * xNum + j) + sum / wSum;
                    r.setDouble(i * xNum + j, Math.max(BOT[i][j], Math.min(TOP[i][j], aData)));
                }
            }
        }
        return r;
    }

    public static Array barnes(List<Number> x_s, List<Number> y_s, Array v_s, List<Number> X, List<Number> Y, List<Number> radList, double kappa, double gamma) {
        double w;
        double sy;
        double sx;
        double val;
        double wSum;
        double sum;
        int j;
        double y;
        double x;
        int i;
        v_s = v_s.copyIfView();
        int xNum = X.size();
        int yNum = Y.size();
        int pNum = x_s.size();
        Array r = Array.factory((DataType)DataType.DOUBLE, (int[])new int[]{yNum, xNum});
        int irad = radList.size();
        double xMin = X.get(0).doubleValue();
        double yMin = Y.get(0).doubleValue();
        double xDelt = X.get(1).doubleValue() - X.get(0).doubleValue();
        double yDelt = Y.get(1).doubleValue() - Y.get(0).doubleValue();
        double[][] stationData = new double[pNum][5];
        for (i = 0; i < pNum; ++i) {
            x = x_s.get(i).doubleValue();
            y = y_s.get(i).doubleValue();
            stationData[i][0] = x;
            stationData[i][1] = y;
            stationData[i][2] = v_s.getDouble(i);
            stationData[i][3] = (x - xMin) / xDelt;
            stationData[i][4] = (y - yMin) / yDelt;
        }
        KDTree.Euclidean<double[]> kdTree = new KDTree.Euclidean<double[]>(2);
        for (i = 0; i < pNum; ++i) {
            if (Double.isNaN(stationData[i][2])) continue;
            kdTree.addPoint(new double[]{stationData[i][0], stationData[i][1]}, stationData[i]);
        }
        double HITOP = -9.999E20;
        double HIBOT = 9.999E20;
        double[][] TOP = new double[yNum][xNum];
        double[][] BOT = new double[yNum][xNum];
        for (i = 0; i < yNum; ++i) {
            for (j = 0; j < xNum; ++j) {
                TOP[i][j] = HITOP;
                BOT[i][j] = HIBOT;
            }
        }
        double rad = radList.size() > 0 ? radList.get(0).doubleValue() : 4.0;
        for (i = 0; i < yNum; ++i) {
            y = Y.get(i).doubleValue();
            for (j = 0; j < xNum; ++j) {
                x = X.get(j).doubleValue();
                int stNum = 0;
                sum = 0.0;
                wSum = 0.0;
                ArrayList neighbours = kdTree.ballSearch(new double[]{x, y}, rad * rad);
                for (double[] station : neighbours) {
                    val = station[2];
                    sx = station[0];
                    sy = station[1];
                    double dis = Math.pow(sx - x, 2.0) + Math.pow(sy - y, 2.0);
                    w = Math.exp(-dis / (4.0 * kappa));
                    wSum += w;
                    sum += w * val;
                    ++stNum;
                    if (TOP[i][j] < val) {
                        TOP[i][j] = val;
                    }
                    if (!(BOT[i][j] > val)) continue;
                    BOT[i][j] = val;
                }
                if (stNum == 0) {
                    r.setDouble(i * xNum + j, Double.NaN);
                    continue;
                }
                r.setDouble(i * xNum + j, sum / (double)stNum);
            }
        }
        for (int p = 0; p < irad; ++p) {
            rad = radList.get(p).doubleValue();
            for (i = 0; i < yNum; ++i) {
                y = Y.get(i).doubleValue();
                for (j = 0; j < xNum; ++j) {
                    if (Double.isNaN(r.getDouble(i * xNum + j))) continue;
                    x = X.get(j).doubleValue();
                    sum = 0.0;
                    wSum = 0.0;
                    ArrayList neighbours = kdTree.ballSearch(new double[]{x, y}, rad * rad);
                    for (double[] station : neighbours) {
                        double calVal;
                        val = station[2];
                        sx = station[0];
                        sy = station[1];
                        double sxi = station[3];
                        double syi = station[4];
                        if (sxi < 0.0 || sxi >= (double)(xNum - 1) || syi < 0.0 || syi >= (double)(yNum - 1)) continue;
                        double dis = Math.pow(sx - x, 2.0) + Math.pow(sy - y, 2.0);
                        int i1 = (int)syi;
                        int j1 = (int)sxi;
                        int i2 = i1 + 1;
                        int j2 = j1 + 1;
                        double a = r.getDouble(i1 * xNum + j1);
                        double b = r.getDouble(i1 * xNum + j2);
                        double c = r.getDouble(i2 * xNum + j1);
                        double d = r.getDouble(i2 * xNum + j2);
                        ArrayList<Double> dList = new ArrayList<Double>();
                        if (!Double.isNaN(a)) {
                            dList.add(a);
                        }
                        if (!Double.isNaN(b)) {
                            dList.add(b);
                        }
                        if (!Double.isNaN(c)) {
                            dList.add(c);
                        }
                        if (Double.isNaN(d)) {
                            dList.add(d);
                        }
                        if (dList.isEmpty()) continue;
                        if (dList.size() == 1) {
                            calVal = (Double)dList.get(0);
                        } else if (dList.size() <= 3) {
                            double aSum = 0.0;
                            Iterator iterator = dList.iterator();
                            while (iterator.hasNext()) {
                                double dd = (Double)iterator.next();
                                aSum += dd;
                            }
                            calVal = aSum / (double)dList.size();
                        } else {
                            double x1val = a + (c - a) * (syi - (double)i1);
                            double x2val = b + (d - b) * (syi - (double)i1);
                            calVal = x1val + (x2val - x1val) * (sxi - (double)j1);
                        }
                        double eVal = val - calVal;
                        w = Math.exp(-dis / (4.0 * kappa * gamma));
                        sum += eVal * w;
                        wSum += w;
                    }
                    if (!(wSum >= 1.0E-6)) continue;
                    double aData = r.getDouble(i * xNum + j) + sum / wSum;
                    r.setDouble(i * xNum + j, Math.max(BOT[i][j], Math.min(TOP[i][j], aData)));
                }
            }
        }
        return r;
    }

    public static double[][] barnes(double[] x_s, double[] y_s, double[] v_s, double[] X, double[] Y, List<Double> radList, double kappa, double gamma) {
        double w;
        double sy;
        double sx;
        double val;
        double wSum;
        double sum;
        int j;
        double y;
        double x;
        int i;
        int xNum = X.length;
        int yNum = Y.length;
        int pNum = x_s.length;
        double[][] r = new double[yNum][xNum];
        int irad = radList.size();
        double xMin = X[0];
        double yMin = Y[0];
        double xDelt = X[1] - X[0];
        double yDelt = Y[1] - Y[0];
        double[][] stationData = new double[pNum][5];
        for (i = 0; i < pNum; ++i) {
            x = x_s[i];
            y = y_s[i];
            stationData[i][0] = x;
            stationData[i][1] = y;
            stationData[i][2] = v_s[i];
            stationData[i][3] = (x - xMin) / xDelt;
            stationData[i][4] = (y - yMin) / yDelt;
        }
        KDTree.Euclidean<double[]> kdTree = new KDTree.Euclidean<double[]>(2);
        for (i = 0; i < pNum; ++i) {
            if (Double.isNaN(stationData[i][2])) continue;
            kdTree.addPoint(new double[]{stationData[i][0], stationData[i][1]}, stationData[i]);
        }
        double HITOP = -9.999E20;
        double HIBOT = 9.999E20;
        double[][] TOP = new double[yNum][xNum];
        double[][] BOT = new double[yNum][xNum];
        for (i = 0; i < yNum; ++i) {
            for (j = 0; j < xNum; ++j) {
                TOP[i][j] = HITOP;
                BOT[i][j] = HIBOT;
            }
        }
        double rad = radList.size() > 0 ? radList.get(0) : 4.0;
        for (i = 0; i < yNum; ++i) {
            y = Y[i];
            for (j = 0; j < xNum; ++j) {
                x = X[j];
                int stNum = 0;
                sum = 0.0;
                wSum = 0.0;
                ArrayList neighbours = kdTree.ballSearch(new double[]{x, y}, rad * rad);
                for (double[] station : neighbours) {
                    val = station[2];
                    sx = station[0];
                    sy = station[1];
                    double dis = Math.pow(sx - x, 2.0) + Math.pow(sy - y, 2.0);
                    w = Math.exp(-dis / (4.0 * kappa));
                    wSum += w;
                    sum += w * val;
                    ++stNum;
                    if (TOP[i][j] < val) {
                        TOP[i][j] = val;
                    }
                    if (!(BOT[i][j] > val)) continue;
                    BOT[i][j] = val;
                }
                r[i][j] = stNum == 0 ? Double.NaN : sum / (double)stNum;
            }
        }
        for (int p = 0; p < irad; ++p) {
            rad = radList.get(p);
            for (i = 0; i < yNum; ++i) {
                y = Y[i];
                for (j = 0; j < xNum; ++j) {
                    if (Double.isNaN(r[i][j])) continue;
                    x = X[j];
                    sum = 0.0;
                    wSum = 0.0;
                    ArrayList neighbours = kdTree.ballSearch(new double[]{x, y}, rad * rad);
                    for (double[] station : neighbours) {
                        double calVal;
                        val = station[2];
                        sx = station[0];
                        sy = station[1];
                        double sxi = station[3];
                        double syi = station[4];
                        if (sxi < 0.0 || sxi >= (double)(xNum - 1) || syi < 0.0 || syi >= (double)(yNum - 1)) continue;
                        double dis = Math.pow(sx - x, 2.0) + Math.pow(sy - y, 2.0);
                        int i1 = (int)syi;
                        int j1 = (int)sxi;
                        int i2 = i1 + 1;
                        int j2 = j1 + 1;
                        double a = r[i1][j1];
                        double b = r[i1][j2];
                        double c = r[i2][j1];
                        double d = r[i2][j2];
                        ArrayList<Double> dList = new ArrayList<Double>();
                        if (!Double.isNaN(a)) {
                            dList.add(a);
                        }
                        if (!Double.isNaN(b)) {
                            dList.add(b);
                        }
                        if (!Double.isNaN(c)) {
                            dList.add(c);
                        }
                        if (Double.isNaN(d)) {
                            dList.add(d);
                        }
                        if (dList.isEmpty()) continue;
                        if (dList.size() == 1) {
                            calVal = (Double)dList.get(0);
                        } else if (dList.size() <= 3) {
                            double aSum = 0.0;
                            Iterator iterator = dList.iterator();
                            while (iterator.hasNext()) {
                                double dd = (Double)iterator.next();
                                aSum += dd;
                            }
                            calVal = aSum / (double)dList.size();
                        } else {
                            double x1val = a + (c - a) * (syi - (double)i1);
                            double x2val = b + (d - b) * (syi - (double)i1);
                            calVal = x1val + (x2val - x1val) * (sxi - (double)j1);
                        }
                        double eVal = val - calVal;
                        w = Math.exp(-dis / (4.0 * kappa * gamma));
                        sum += eVal * w;
                        wSum += w;
                    }
                    if (!(wSum >= 1.0E-6)) continue;
                    double aData = r[i][j] + sum / wSum;
                    r[i][j] = Math.max(BOT[i][j], Math.min(TOP[i][j], aData));
                }
            }
        }
        return r;
    }

    public static Array barnes(List<Number> x_s, List<Number> y_s, Array v_s, List<Number> X, List<Number> Y, double kappa, double gamma) {
        double w;
        double sy;
        double sx;
        double val;
        double wSum;
        double sum;
        int j;
        double y;
        double x;
        int i;
        v_s = v_s.copyIfView();
        int xNum = X.size();
        int yNum = Y.size();
        int pNum = x_s.size();
        Array r = Array.factory((DataType)DataType.DOUBLE, (int[])new int[]{yNum, xNum});
        double xMin = X.get(0).doubleValue();
        double xMax = X.get(xNum - 1).doubleValue();
        double yMin = Y.get(0).doubleValue();
        double yMax = Y.get(yNum - 1).doubleValue();
        double xDelt = X.get(1).doubleValue() - X.get(0).doubleValue();
        double yDelt = Y.get(1).doubleValue() - Y.get(0).doubleValue();
        double[][] stationData = new double[pNum][5];
        for (i = 0; i < pNum; ++i) {
            x = x_s.get(i).doubleValue();
            y = y_s.get(i).doubleValue();
            stationData[i][0] = x;
            stationData[i][1] = y;
            stationData[i][2] = v_s.getDouble(i);
            stationData[i][3] = (x - xMin) / xDelt;
            stationData[i][4] = (y - yMin) / yDelt;
        }
        for (i = 0; i < yNum; ++i) {
            y = Y.get(i).doubleValue();
            for (j = 0; j < xNum; ++j) {
                x = X.get(j).doubleValue();
                sum = 0.0;
                wSum = 0.0;
                for (double[] station : stationData) {
                    val = station[2];
                    sx = station[0];
                    sy = station[1];
                    if (Double.isNaN(val) || sx < xMin || sx > xMax || sy < yMin || sy > yMax) continue;
                    double dis = Math.pow(sx - x, 2.0) + Math.pow(sy - y, 2.0);
                    w = Math.exp(-dis / (4.0 * kappa));
                    wSum += w;
                    sum += w * val;
                }
                r.setDouble(i * xNum + j, sum / wSum);
            }
        }
        for (i = 0; i < yNum; ++i) {
            y = Y.get(i).doubleValue();
            for (j = 0; j < xNum; ++j) {
                x = X.get(j).doubleValue();
                sum = 0.0;
                wSum = 0.0;
                for (double[] station : stationData) {
                    double calVal;
                    val = station[2];
                    sx = station[0];
                    sy = station[1];
                    double sxi = station[3];
                    double syi = station[4];
                    if (Double.isNaN(val) || sx < xMin || sx > xMax || sy < yMin || sy > yMax) continue;
                    int i1 = (int)syi;
                    int j1 = (int)sxi;
                    int i2 = i1 + 1;
                    int j2 = j1 + 1;
                    double a = r.getDouble(i1 * xNum + j1);
                    double b = r.getDouble(i1 * xNum + j2);
                    double c = r.getDouble(i2 * xNum + j1);
                    double d = r.getDouble(i2 * xNum + j2);
                    ArrayList<Double> dList = new ArrayList<Double>();
                    if (!Double.isNaN(a)) {
                        dList.add(a);
                    }
                    if (!Double.isNaN(b)) {
                        dList.add(b);
                    }
                    if (!Double.isNaN(c)) {
                        dList.add(c);
                    }
                    if (Double.isNaN(d)) {
                        dList.add(d);
                    }
                    if (dList.isEmpty()) continue;
                    if (dList.size() == 1) {
                        calVal = (Double)dList.get(0);
                    } else if (dList.size() <= 3) {
                        double aSum = 0.0;
                        Iterator iterator = dList.iterator();
                        while (iterator.hasNext()) {
                            double dd = (Double)iterator.next();
                            aSum += dd;
                        }
                        calVal = aSum / (double)dList.size();
                    } else {
                        double x1val = a + (c - a) * (syi - (double)i1);
                        double x2val = b + (d - b) * (syi - (double)i1);
                        calVal = x1val + (x2val - x1val) * (sxi - (double)j1);
                    }
                    double eVal = val - calVal;
                    double dis = Math.pow(sx - x, 2.0) + Math.pow(sy - y, 2.0);
                    w = Math.exp(-dis / (4.0 * kappa * gamma));
                    wSum += w;
                    sum += w * eVal;
                }
                r.setDouble(i * xNum + j, r.getDouble(i * xNum + j) + sum / wSum);
            }
        }
        return r;
    }

    public static double[][] kriging(double[] x_s, double[] y_s, double[] v_s, double[] X, double[] Y, double beta) {
        KrigingInterpolation2D krigingInterpolation2D = new KrigingInterpolation2D(x_s, y_s, v_s, beta);
        int ny = Y.length;
        int nx = X.length;
        double[][] gData = new double[ny][nx];
        for (int i = 0; i < ny; ++i) {
            for (int j = 0; j < nx; ++j) {
                gData[i][j] = krigingInterpolation2D.interpolate(X[j], Y[i]);
            }
        }
        return gData;
    }

    public static Array interpolation_Inside_Sum(Array x_s, Array y_s, Array a, Array X, Array Y, boolean centerPoint) {
        int j;
        int i;
        double ey;
        double ex;
        double sy;
        double sx;
        x_s = x_s.copyIfView();
        y_s = y_s.copyIfView();
        a = a.copyIfView();
        X = X.copyIfView();
        Y = Y.copyIfView();
        int colNum = (int)X.getSize();
        int rowNum = (int)Y.getSize();
        int pNum = (int)x_s.getSize();
        Array r = Array.factory((DataType)DataType.DOUBLE, (int[])new int[]{rowNum, colNum});
        double dX = X.getDouble(1) - X.getDouble(0);
        double dY = Y.getDouble(1) - Y.getDouble(0);
        int[][] pNums = new int[rowNum][colNum];
        if (centerPoint) {
            sx = X.getDouble(0) - dX * 0.5;
            sy = Y.getDouble(0) - dY * 0.5;
            ex = X.getDouble(colNum - 1) + dX * 0.5;
            ey = Y.getDouble(rowNum - 1) + dY * 0.5;
        } else {
            sx = X.getDouble(0);
            sy = Y.getDouble(0);
            ex = X.getDouble(colNum - 1);
            ey = Y.getDouble(rowNum - 1);
        }
        for (i = 0; i < rowNum; ++i) {
            for (j = 0; j < colNum; ++j) {
                pNums[i][j] = 0;
                r.setDouble(i * colNum + j, 0.0);
            }
        }
        for (int p = 0; p < pNum; ++p) {
            double v = a.getDouble(p);
            if (Double.isNaN(v)) continue;
            double x = x_s.getDouble(p);
            double y = y_s.getDouble(p);
            if (x < sx || x > ex || y < sy || y > ey) continue;
            j = (int)((x - sx) / dX);
            int i2 = (int)((y - sy) / dY);
            if (i2 >= rowNum) {
                i2 = rowNum - 1;
            }
            if (j >= colNum) {
                j = colNum - 1;
            }
            int[] nArray = pNums[i2];
            int n = j;
            nArray[n] = nArray[n] + 1;
            r.setDouble(i2 * colNum + j, r.getDouble(i2 * colNum + j) + v);
        }
        for (i = 0; i < rowNum; ++i) {
            for (j = 0; j < colNum; ++j) {
                if (pNums[i][j] != 0) continue;
                r.setDouble(i * colNum + j, Double.NaN);
            }
        }
        return r;
    }

    public static Array interpolation_Inside_Mean(Array x_s, Array y_s, Array a, Array X, Array Y, boolean centerPoint) {
        int j;
        int i;
        double ey;
        double ex;
        double sy;
        double sx;
        x_s = x_s.copyIfView();
        y_s = y_s.copyIfView();
        a = a.copyIfView();
        X = X.copyIfView();
        Y = Y.copyIfView();
        int colNum = (int)X.getSize();
        int rowNum = (int)Y.getSize();
        int pNum = (int)x_s.getSize();
        Array r = Array.factory((DataType)DataType.DOUBLE, (int[])new int[]{rowNum, colNum});
        double dX = X.getDouble(1) - X.getDouble(0);
        double dY = Y.getDouble(1) - Y.getDouble(0);
        int[][] pNums = new int[rowNum][colNum];
        if (centerPoint) {
            sx = X.getDouble(0) - dX * 0.5;
            sy = Y.getDouble(0) - dY * 0.5;
            ex = X.getDouble(colNum - 1) + dX * 0.5;
            ey = Y.getDouble(rowNum - 1) + dY * 0.5;
        } else {
            sx = X.getDouble(0);
            sy = Y.getDouble(0);
            ex = X.getDouble(colNum - 1);
            ey = Y.getDouble(rowNum - 1);
        }
        for (i = 0; i < rowNum; ++i) {
            for (j = 0; j < colNum; ++j) {
                pNums[i][j] = 0;
                r.setDouble(i * colNum + j, 0.0);
            }
        }
        for (int p = 0; p < pNum; ++p) {
            double v = a.getDouble(p);
            if (Double.isNaN(v)) continue;
            double x = x_s.getDouble(p);
            double y = y_s.getDouble(p);
            if (x < sx || x > ex || y < sy || y > ey) continue;
            j = (int)((x - sx) / dX);
            int i2 = (int)((y - sy) / dY);
            if (i2 >= rowNum) {
                i2 = rowNum - 1;
            }
            if (j >= colNum) {
                j = colNum - 1;
            }
            int[] nArray = pNums[i2];
            int n = j;
            nArray[n] = nArray[n] + 1;
            r.setDouble(i2 * colNum + j, r.getDouble(i2 * colNum + j) + v);
        }
        for (i = 0; i < rowNum; ++i) {
            for (j = 0; j < colNum; ++j) {
                if (pNums[i][j] == 0) {
                    r.setDouble(i * colNum + j, Double.NaN);
                    continue;
                }
                r.setDouble(i * colNum + j, r.getDouble(i * colNum + j) / (double)pNums[i][j]);
            }
        }
        return r;
    }

    public static Array interpolation_Inside_Max(List<Number> x_s, List<Number> y_s, Array a, List<Number> X, List<Number> Y, boolean centerPoint) {
        int j;
        int i;
        double ey;
        double ex;
        double sy;
        double sx;
        a = a.copyIfView();
        int colNum = X.size();
        int rowNum = Y.size();
        int pNum = x_s.size();
        Array r = Array.factory((DataType)DataType.DOUBLE, (int[])new int[]{rowNum, colNum});
        double dX = X.get(1).doubleValue() - X.get(0).doubleValue();
        double dY = Y.get(1).doubleValue() - Y.get(0).doubleValue();
        int[][] pNums = new int[rowNum][colNum];
        double min = Double.NEGATIVE_INFINITY;
        if (centerPoint) {
            sx = X.get(0).doubleValue() - dX * 0.5;
            sy = Y.get(0).doubleValue() - dY * 0.5;
            ex = X.get(colNum - 1).doubleValue() + dX * 0.5;
            ey = Y.get(rowNum - 1).doubleValue() + dY * 0.5;
        } else {
            sx = X.get(0).doubleValue();
            sy = Y.get(0).doubleValue();
            ex = X.get(colNum - 1).doubleValue();
            ey = Y.get(rowNum - 1).doubleValue();
        }
        for (i = 0; i < rowNum; ++i) {
            for (j = 0; j < colNum; ++j) {
                pNums[i][j] = 0;
                r.setDouble(i * colNum + j, min);
            }
        }
        for (int p = 0; p < pNum; ++p) {
            double v = a.getDouble(p);
            if (Double.isNaN(v)) continue;
            double x = x_s.get(p).doubleValue();
            double y = y_s.get(p).doubleValue();
            if (x < sx || x > ex || y < sy || y > ey) continue;
            j = (int)((x - sx) / dX);
            int i2 = (int)((y - sy) / dY);
            if (i2 >= rowNum) {
                i2 = rowNum - 1;
            }
            if (j >= colNum) {
                j = colNum - 1;
            }
            int[] nArray = pNums[i2];
            int n = j;
            nArray[n] = nArray[n] + 1;
            r.setDouble(i2 * colNum + j, Math.max(r.getDouble(i2 * colNum + j), v));
        }
        for (i = 0; i < rowNum; ++i) {
            for (j = 0; j < colNum; ++j) {
                if (pNums[i][j] != 0 && !Double.isInfinite(r.getDouble(i * colNum + j))) continue;
                r.setDouble(i * colNum + j, Double.NaN);
            }
        }
        return r;
    }

    public static Array interpolation_Inside_Min(List<Number> x_s, List<Number> y_s, Array a, List<Number> X, List<Number> Y, boolean centerPoint) {
        int j;
        int i;
        double ey;
        double ex;
        double sy;
        double sx;
        a = a.copyIfView();
        int colNum = X.size();
        int rowNum = Y.size();
        int pNum = x_s.size();
        Array r = Array.factory((DataType)DataType.DOUBLE, (int[])new int[]{rowNum, colNum});
        double dX = X.get(1).doubleValue() - X.get(0).doubleValue();
        double dY = Y.get(1).doubleValue() - Y.get(0).doubleValue();
        int[][] pNums = new int[rowNum][colNum];
        double max = Double.MAX_VALUE;
        if (centerPoint) {
            sx = X.get(0).doubleValue() - dX * 0.5;
            sy = Y.get(0).doubleValue() - dY * 0.5;
            ex = X.get(colNum - 1).doubleValue() + dX * 0.5;
            ey = Y.get(rowNum - 1).doubleValue() + dY * 0.5;
        } else {
            sx = X.get(0).doubleValue();
            sy = Y.get(0).doubleValue();
            ex = X.get(colNum - 1).doubleValue();
            ey = Y.get(rowNum - 1).doubleValue();
        }
        for (i = 0; i < rowNum; ++i) {
            for (j = 0; j < colNum; ++j) {
                pNums[i][j] = 0;
                r.setDouble(i * colNum + j, max);
            }
        }
        for (int p = 0; p < pNum; ++p) {
            double v = a.getDouble(p);
            if (Double.isNaN(v)) continue;
            double x = x_s.get(p).doubleValue();
            double y = y_s.get(p).doubleValue();
            if (x < sx || x > ex || y < sy || y > ey) continue;
            j = (int)((x - sx) / dX);
            int i2 = (int)((y - sy) / dY);
            if (i2 >= rowNum) {
                i2 = rowNum - 1;
            }
            if (j >= colNum) {
                j = colNum - 1;
            }
            int[] nArray = pNums[i2];
            int n = j;
            nArray[n] = nArray[n] + 1;
            r.setDouble(i2 * colNum + j, Math.min(r.getDouble(i2 * colNum + j), v));
        }
        for (i = 0; i < rowNum; ++i) {
            for (j = 0; j < colNum; ++j) {
                if (pNums[i][j] != 0 && r.getDouble(i * colNum + j) != Double.MAX_VALUE) continue;
                r.setDouble(i * colNum + j, Double.NaN);
            }
        }
        return r;
    }

    public static Object interpolation_Inside_Count(List<Number> x_s, List<Number> y_s, List<Number> X, List<Number> Y, boolean pointDensity, boolean centerPoint) {
        double y;
        double x;
        int j;
        int i;
        double ey;
        double ex;
        double sy;
        double sx;
        int colNum = X.size();
        int rowNum = Y.size();
        int pNum = x_s.size();
        Array r = Array.factory((DataType)DataType.INT, (int[])new int[]{rowNum, colNum});
        double dX = X.get(1).doubleValue() - X.get(0).doubleValue();
        double dY = Y.get(1).doubleValue() - Y.get(0).doubleValue();
        int[][] pNums = new int[rowNum][colNum];
        if (centerPoint) {
            sx = X.get(0).doubleValue() - dX * 0.5;
            sy = Y.get(0).doubleValue() - dY * 0.5;
            ex = X.get(colNum - 1).doubleValue() + dX * 0.5;
            ey = Y.get(rowNum - 1).doubleValue() + dY * 0.5;
        } else {
            sx = X.get(0).doubleValue();
            sy = Y.get(0).doubleValue();
            ex = X.get(colNum - 1).doubleValue();
            ey = Y.get(rowNum - 1).doubleValue();
        }
        for (i = 0; i < rowNum; ++i) {
            for (j = 0; j < colNum; ++j) {
                pNums[i][j] = 0;
            }
        }
        for (int p = 0; p < pNum; ++p) {
            x = x_s.get(p).doubleValue();
            y = y_s.get(p).doubleValue();
            if (x < sx || x > ex || y < sy || y > ey) continue;
            j = (int)((x - sx) / dX);
            int i2 = (int)((y - sy) / dY);
            if (i2 >= rowNum) {
                i2 = rowNum - 1;
            }
            if (j >= colNum) {
                j = colNum - 1;
            }
            int[] nArray = pNums[i2];
            int n = j;
            nArray[n] = nArray[n] + 1;
        }
        for (i = 0; i < rowNum; ++i) {
            for (j = 0; j < colNum; ++j) {
                r.setInt(i * colNum + j, pNums[i][j]);
            }
        }
        if (pointDensity) {
            Array pds = Array.factory((DataType)DataType.INT, (int[])new int[]{pNum});
            for (int p = 0; p < pNum; ++p) {
                x = x_s.get(p).doubleValue();
                y = y_s.get(p).doubleValue();
                if (x < sx || x > ex || y < sy || y > ey) continue;
                int j2 = (int)((x - sx) / dX);
                int i3 = (int)((y - sy) / dY);
                if (i3 >= rowNum) {
                    i3 = rowNum - 1;
                }
                if (j2 >= colNum) {
                    j2 = colNum - 1;
                }
                pds.setInt(p, pNums[i3][j2]);
            }
            return new Array[]{r, pds};
        }
        return r;
    }

    public static Object interpolation_Inside_Count(List<Number> x_s, List<Number> y_s, Array a, List<Number> X, List<Number> Y, boolean pointDensity, boolean centerPoint) {
        int j;
        double y;
        double x;
        double ey;
        double ex;
        double sy;
        double sx;
        if (a == null) {
            return InterpUtil.interpolation_Inside_Count(x_s, y_s, X, Y, pointDensity, centerPoint);
        }
        a = a.copyIfView();
        int colNum = X.size();
        int rowNum = Y.size();
        int pNum = x_s.size();
        Array r = Array.factory((DataType)DataType.INT, (int[])new int[]{rowNum, colNum});
        double dX = X.get(1).doubleValue() - X.get(0).doubleValue();
        double dY = Y.get(1).doubleValue() - Y.get(0).doubleValue();
        int[][] pNums = new int[rowNum][colNum];
        if (centerPoint) {
            sx = X.get(0).doubleValue() - dX * 0.5;
            sy = Y.get(0).doubleValue() - dY * 0.5;
            ex = X.get(colNum - 1).doubleValue() + dX * 0.5;
            ey = Y.get(rowNum - 1).doubleValue() + dY * 0.5;
        } else {
            sx = X.get(0).doubleValue();
            sy = Y.get(0).doubleValue();
            ex = X.get(colNum - 1).doubleValue();
            ey = Y.get(rowNum - 1).doubleValue();
        }
        for (int i = 0; i < rowNum; ++i) {
            for (int j2 = 0; j2 < colNum; ++j2) {
                pNums[i][j2] = 0;
            }
        }
        for (int p = 0; p < pNum; ++p) {
            double v = a.getDouble(p);
            if (Double.isNaN(v)) continue;
            x = x_s.get(p).doubleValue();
            y = y_s.get(p).doubleValue();
            if (x < sx || x > ex || y < sy || y > ey) continue;
            j = (int)((x - sx) / dX);
            int i = (int)((y - sy) / dY);
            if (i >= rowNum) {
                i = rowNum - 1;
            }
            if (j >= colNum) {
                j = colNum - 1;
            }
            int[] nArray = pNums[i];
            int n = j;
            nArray[n] = nArray[n] + 1;
        }
        for (int i = 0; i < rowNum; ++i) {
            for (j = 0; j < colNum; ++j) {
                r.setInt(i * colNum + j, pNums[i][j]);
            }
        }
        if (pointDensity) {
            Array pds = Array.factory((DataType)DataType.INT, (int[])new int[]{pNum});
            for (int p = 0; p < pNum; ++p) {
                x = x_s.get(p).doubleValue();
                y = y_s.get(p).doubleValue();
                if (x < sx || x > ex || y < sy || y > ey) continue;
                int j3 = (int)((x - sx) / dX);
                int i = (int)((y - sy) / dY);
                if (i >= rowNum) {
                    i = rowNum - 1;
                }
                if (j3 >= colNum) {
                    j3 = colNum - 1;
                }
                pds.setInt(p, pNums[i][j3]);
            }
            return new Array[]{r, pds};
        }
        return r;
    }

    public static Array interpolation_Nearest(List<Number> x_s, List<Number> y_s, Array a, List<Number> X, List<Number> Y, double radius) {
        int i;
        int colNum = X.size();
        int rowNum = Y.size();
        int pNum = x_s.size();
        Array rdata = Array.factory((DataType)DataType.DOUBLE, (int[])new int[]{rowNum, colNum});
        KDTree.Euclidean<Double> kdTree = new KDTree.Euclidean<Double>(2);
        IndexIterator iter = a.getIndexIterator();
        for (i = 0; i < pNum; ++i) {
            double v = iter.getDoubleNext();
            kdTree.addPoint(new double[]{x_s.get(i).doubleValue(), y_s.get(i).doubleValue()}, v);
        }
        if (radius == Double.POSITIVE_INFINITY) {
            for (i = 0; i < rowNum; ++i) {
                double gy = Y.get(i).doubleValue();
                for (int j = 0; j < colNum; ++j) {
                    double gx = X.get(j).doubleValue();
                    KDTree.SearchResult r = kdTree.nearestNeighbours(new double[]{gx, gy}, 1).get(0);
                    rdata.setDouble(i * colNum + j, ((Double)r.payload).doubleValue());
                }
            }
        } else {
            for (i = 0; i < rowNum; ++i) {
                double gy = Y.get(i).doubleValue();
                for (int j = 0; j < colNum; ++j) {
                    double gx = X.get(j).doubleValue();
                    KDTree.SearchResult r = kdTree.nearestNeighbours(new double[]{gx, gy}, 1).get(0);
                    if (Math.sqrt(r.distance) <= radius) {
                        rdata.setDouble(i * colNum + j, ((Double)r.payload).doubleValue());
                        continue;
                    }
                    rdata.setDouble(i * colNum + j, Double.NaN);
                }
            }
        }
        return rdata;
    }

    public static Array interpolation_Nearest(Array x_s, Array y_s, Array a, Array X, Array Y, double radius) {
        int i;
        x_s = x_s.copyIfView();
        y_s = y_s.copyIfView();
        a = a.copyIfView();
        X = X.copyIfView();
        Y = Y.copyIfView();
        int colNum = (int)X.getSize();
        int rowNum = (int)Y.getSize();
        int pNum = (int)x_s.getSize();
        Array rdata = Array.factory((DataType)DataType.DOUBLE, (int[])new int[]{rowNum, colNum});
        KDTree.Euclidean<Double> kdTree = new KDTree.Euclidean<Double>(2);
        for (i = 0; i < pNum; ++i) {
            double v = a.getDouble(i);
            kdTree.addPoint(new double[]{x_s.getDouble(i), y_s.getDouble(i)}, v);
        }
        if (radius == Double.POSITIVE_INFINITY) {
            for (i = 0; i < rowNum; ++i) {
                double gy = Y.getDouble(i);
                for (int j = 0; j < colNum; ++j) {
                    double gx = X.getDouble(j);
                    KDTree.SearchResult r = kdTree.nearestNeighbours(new double[]{gx, gy}, 1).get(0);
                    rdata.setDouble(i * colNum + j, ((Double)r.payload).doubleValue());
                }
            }
        } else {
            for (i = 0; i < rowNum; ++i) {
                double gy = Y.getDouble(i);
                for (int j = 0; j < colNum; ++j) {
                    double gx = X.getDouble(j);
                    KDTree.SearchResult r = kdTree.nearestNeighbours(new double[]{gx, gy}, 1).get(0);
                    if (Math.sqrt(r.distance) <= radius) {
                        rdata.setDouble(i * colNum + j, ((Double)r.payload).doubleValue());
                        continue;
                    }
                    rdata.setDouble(i * colNum + j, Double.NaN);
                }
            }
        }
        return rdata;
    }

    public static Array interpolation_Nearest(Array x_s, Array y_s, Array z_s, Array a, Array X, Array Y, Array Z, double radius) {
        int ii;
        x_s = x_s.copyIfView();
        y_s = y_s.copyIfView();
        z_s = z_s.copyIfView();
        a = a.copyIfView();
        X = X.copyIfView();
        Y = Y.copyIfView();
        Z = Z.copyIfView();
        int xNum = (int)X.getSize();
        int yNum = (int)Y.getSize();
        int zNum = (int)Z.getSize();
        int pNum = (int)x_s.getSize();
        Array rdata = Array.factory((DataType)DataType.DOUBLE, (int[])new int[]{zNum, yNum, xNum});
        KDTree.Euclidean<Double> kdTree = new KDTree.Euclidean<Double>(3);
        for (int i = 0; i < pNum; ++i) {
            double v = a.getDouble(i);
            kdTree.addPoint(new double[]{x_s.getDouble(i), y_s.getDouble(i), z_s.getDouble(i)}, v);
        }
        if (radius == Double.POSITIVE_INFINITY) {
            ii = 0;
            for (int k = 0; k < zNum; ++k) {
                double gz = Z.getDouble(k);
                for (int i = 0; i < yNum; ++i) {
                    double gy = Y.getDouble(i);
                    for (int j = 0; j < xNum; ++j) {
                        double gx = X.getDouble(j);
                        KDTree.SearchResult r = kdTree.nearestNeighbours(new double[]{gx, gy, gz}, 1).get(0);
                        rdata.setDouble(ii, ((Double)r.payload).doubleValue());
                        ++ii;
                    }
                }
            }
        } else {
            ii = 0;
            for (int k = 0; k < zNum; ++k) {
                double gz = Z.getDouble(k);
                for (int i = 0; i < yNum; ++i) {
                    double gy = Y.getDouble(i);
                    for (int j = 0; j < xNum; ++j) {
                        double gx = X.getDouble(j);
                        KDTree.SearchResult r = kdTree.nearestNeighbours(new double[]{gx, gy, gz}, 1).get(0);
                        if (Math.sqrt(r.distance) <= radius) {
                            rdata.setDouble(ii, ((Double)r.payload).doubleValue());
                        } else {
                            rdata.setDouble(ii, Double.NaN);
                        }
                        ++ii;
                    }
                }
            }
        }
        return rdata;
    }

    public static Array interpolation_IDW_Radius(List<Number> x_s, List<Number> y_s, Array a, List<Number> X, List<Number> Y, int neededPointNum, double radius) {
        double v;
        int i;
        int colNum = X.size();
        int rowNum = Y.size();
        int pNum = x_s.size();
        Array r = Array.factory((DataType)DataType.DOUBLE, (int[])new int[]{rowNum, colNum});
        KDTree.Euclidean<Double> kdTree = new KDTree.Euclidean<Double>(2);
        IndexIterator iter = a.getIndexIterator();
        for (i = 0; i < pNum; ++i) {
            v = iter.getDoubleNext();
            if (Double.isNaN(v)) continue;
            kdTree.addPoint(new double[]{x_s.get(i).doubleValue(), y_s.get(i).doubleValue()}, v);
        }
        for (i = 0; i < rowNum; ++i) {
            double gy = Y.get(i).doubleValue();
            for (int j = 0; j < colNum; ++j) {
                double gx = X.get(j).doubleValue();
                ArrayList srs = kdTree.ballSearch_distance(new double[]{gx, gy}, radius * radius);
                if (srs == null || srs.size() < neededPointNum) {
                    r.setDouble(i * colNum + j, Double.NaN);
                    continue;
                }
                double v_sum = 0.0;
                double weight_sum = 0.0;
                boolean match = false;
                for (KDTree.SearchResult searchResult : srs) {
                    v = (Double)searchResult.payload;
                    if (searchResult.distance == 0.0) {
                        r.setDouble(i * colNum + j, v);
                        match = true;
                        break;
                    }
                    double w = 1.0 / searchResult.distance;
                    weight_sum += w;
                    v_sum += v * w;
                }
                if (match) continue;
                r.setDouble(i * colNum + j, v_sum / weight_sum);
            }
        }
        return r;
    }

    public static Array interpolation_IDW_Radius(Array x_s, Array y_s, Array a, Array X, Array Y, int neededPointNum, double radius) {
        double v;
        int i;
        x_s = x_s.copyIfView();
        y_s = y_s.copyIfView();
        a = a.copyIfView();
        X = X.copyIfView();
        Y = Y.copyIfView();
        int colNum = (int)X.getSize();
        int rowNum = (int)Y.getSize();
        int pNum = (int)x_s.getSize();
        Array r = Array.factory((DataType)DataType.DOUBLE, (int[])new int[]{rowNum, colNum});
        KDTree.Euclidean<Double> kdTree = new KDTree.Euclidean<Double>(2);
        for (i = 0; i < pNum; ++i) {
            v = a.getDouble(i);
            if (Double.isNaN(v)) continue;
            kdTree.addPoint(new double[]{x_s.getDouble(i), y_s.getDouble(i)}, v);
        }
        for (i = 0; i < rowNum; ++i) {
            double gy = Y.getDouble(i);
            for (int j = 0; j < colNum; ++j) {
                double gx = X.getDouble(j);
                ArrayList srs = kdTree.ballSearch_distance(new double[]{gx, gy}, radius * radius);
                if (srs == null || srs.size() < neededPointNum) {
                    r.setDouble(i * colNum + j, Double.NaN);
                    continue;
                }
                double v_sum = 0.0;
                double weight_sum = 0.0;
                boolean match = false;
                for (KDTree.SearchResult searchResult : srs) {
                    v = (Double)searchResult.payload;
                    if (searchResult.distance == 0.0) {
                        r.setDouble(i * colNum + j, v);
                        match = true;
                        break;
                    }
                    double w = 1.0 / searchResult.distance;
                    weight_sum += w;
                    v_sum += v * w;
                }
                if (match) continue;
                r.setDouble(i * colNum + j, v_sum / weight_sum);
            }
        }
        return r;
    }

    public static Array interpolation_IDW_Radius(Array x_s, Array y_s, Array z_s, Array a, Array X, Array Y, Array Z, int neededPointNum, double radius) {
        double v;
        int i;
        x_s = x_s.copyIfView();
        y_s = y_s.copyIfView();
        z_s = z_s.copyIfView();
        a = a.copyIfView();
        X = X.copyIfView();
        Y = Y.copyIfView();
        Z = Z.copyIfView();
        int xNum = (int)X.getSize();
        int yNum = (int)Y.getSize();
        int zNum = (int)Z.getSize();
        int pNum = (int)x_s.getSize();
        Array r = Array.factory((DataType)DataType.DOUBLE, (int[])new int[]{zNum, yNum, xNum});
        KDTree.Euclidean<Double> kdTree = new KDTree.Euclidean<Double>(2);
        for (i = 0; i < pNum; ++i) {
            v = a.getDouble(i);
            if (Double.isNaN(v)) continue;
            kdTree.addPoint(new double[]{x_s.getDouble(i), y_s.getDouble(i), z_s.getDouble(i)}, v);
        }
        int ii = 0;
        for (int k = 0; k < zNum; ++k) {
            double gz = Z.getDouble(k);
            for (i = 0; i < yNum; ++i) {
                double gy = Y.getDouble(i);
                for (int j = 0; j < xNum; ++j) {
                    double gx = X.getDouble(j);
                    ArrayList srs = kdTree.ballSearch_distance(new double[]{gx, gy, gz}, radius * radius);
                    if (srs == null || srs.size() < neededPointNum) {
                        r.setDouble(ii, Double.NaN);
                    } else {
                        double v_sum = 0.0;
                        double weight_sum = 0.0;
                        boolean match = false;
                        for (KDTree.SearchResult searchResult : srs) {
                            v = (Double)searchResult.payload;
                            if (searchResult.distance == 0.0) {
                                r.setDouble(ii, v);
                                match = true;
                                break;
                            }
                            double w = 1.0 / searchResult.distance;
                            weight_sum += w;
                            v_sum += v * w;
                        }
                        if (!match) {
                            r.setDouble(ii, v_sum / weight_sum);
                        }
                    }
                    ++ii;
                }
            }
        }
        return r;
    }

    public static Array interpolation_IDW_Neighbor(List<Number> x_s, List<Number> y_s, Array a, List<Number> X, List<Number> Y, Integer points) {
        double v;
        int i;
        int colNum = X.size();
        int rowNum = Y.size();
        int pNum = x_s.size();
        Array r = Array.factory((DataType)DataType.DOUBLE, (int[])new int[]{rowNum, colNum});
        int n = 0;
        IndexIterator iter = a.getIndexIterator();
        KDTree.Euclidean<Double> kdTree = new KDTree.Euclidean<Double>(2);
        for (i = 0; i < pNum; ++i) {
            v = iter.getDoubleNext();
            if (Double.isNaN(v)) continue;
            kdTree.addPoint(new double[]{x_s.get(i).doubleValue(), y_s.get(i).doubleValue()}, v);
            ++n;
        }
        if (points == null) {
            points = n;
        }
        for (i = 0; i < rowNum; ++i) {
            double gy = Y.get(i).doubleValue();
            for (int j = 0; j < colNum; ++j) {
                double gx = X.get(j).doubleValue();
                ArrayList srs = kdTree.nearestNeighbours(new double[]{gx, gy}, points);
                double v_sum = 0.0;
                double weight_sum = 0.0;
                boolean match = false;
                for (KDTree.SearchResult searchResult : srs) {
                    v = (Double)searchResult.payload;
                    if (searchResult.distance == 0.0) {
                        r.setDouble(i * colNum + j, v);
                        match = true;
                        break;
                    }
                    double w = 1.0 / searchResult.distance;
                    weight_sum += w;
                    v_sum += v * w;
                }
                if (match) continue;
                r.setDouble(i * colNum + j, v_sum / weight_sum);
            }
        }
        return r;
    }

    public static Array interpolation_IDW_Neighbor(Array x_s, Array y_s, Array a, Array X, Array Y, Integer points) {
        double v;
        int i;
        x_s = x_s.copyIfView();
        y_s = y_s.copyIfView();
        a = a.copyIfView();
        X = X.copyIfView();
        Y = Y.copyIfView();
        int colNum = (int)X.getSize();
        int rowNum = (int)Y.getSize();
        int pNum = (int)x_s.getSize();
        Array r = Array.factory((DataType)DataType.DOUBLE, (int[])new int[]{rowNum, colNum});
        int n = 0;
        KDTree.Euclidean<Double> kdTree = new KDTree.Euclidean<Double>(2);
        for (i = 0; i < pNum; ++i) {
            v = a.getDouble(i);
            if (Double.isNaN(v)) continue;
            kdTree.addPoint(new double[]{x_s.getDouble(i), y_s.getDouble(i)}, v);
            ++n;
        }
        if (points == null) {
            points = n;
        }
        for (i = 0; i < rowNum; ++i) {
            double gy = Y.getDouble(i);
            for (int j = 0; j < colNum; ++j) {
                double gx = X.getDouble(j);
                ArrayList srs = kdTree.nearestNeighbours(new double[]{gx, gy}, points);
                double v_sum = 0.0;
                double weight_sum = 0.0;
                boolean match = false;
                for (KDTree.SearchResult searchResult : srs) {
                    v = (Double)searchResult.payload;
                    if (searchResult.distance == 0.0) {
                        r.setDouble(i * colNum + j, v);
                        match = true;
                        break;
                    }
                    double w = 1.0 / searchResult.distance;
                    weight_sum += w;
                    v_sum += v * w;
                }
                if (match) continue;
                r.setDouble(i * colNum + j, v_sum / weight_sum);
            }
        }
        return r;
    }

    public static Array interpolation_IDW_Neighbor(Array x_s, Array y_s, Array z_s, Array a, Array X, Array Y, Array Z, Integer points) {
        double v;
        int i;
        x_s = x_s.copyIfView();
        y_s = y_s.copyIfView();
        z_s = z_s.copyIfView();
        a = a.copyIfView();
        X = X.copyIfView();
        Y = Y.copyIfView();
        Z = Z.copyIfView();
        int xNum = (int)X.getSize();
        int yNum = (int)Y.getSize();
        int zNum = (int)Z.getSize();
        int pNum = (int)x_s.getSize();
        Array r = Array.factory((DataType)DataType.DOUBLE, (int[])new int[]{zNum, yNum, xNum});
        int n = 0;
        KDTree.Euclidean<Double> kdTree = new KDTree.Euclidean<Double>(3);
        for (i = 0; i < pNum; ++i) {
            v = a.getDouble(i);
            if (Double.isNaN(v)) continue;
            kdTree.addPoint(new double[]{x_s.getDouble(i), y_s.getDouble(i), z_s.getDouble(i)}, v);
            ++n;
        }
        if (points == null) {
            points = n;
        }
        int ii = 0;
        for (int k = 0; k < zNum; ++k) {
            double gz = Z.getDouble(k);
            for (i = 0; i < yNum; ++i) {
                double gy = Y.getDouble(i);
                for (int j = 0; j < xNum; ++j) {
                    double gx = X.getDouble(j);
                    ArrayList srs = kdTree.nearestNeighbours(new double[]{gx, gy, gz}, points);
                    double v_sum = 0.0;
                    double weight_sum = 0.0;
                    boolean match = false;
                    for (KDTree.SearchResult searchResult : srs) {
                        v = (Double)searchResult.payload;
                        if (searchResult.distance == 0.0) {
                            r.setDouble(ii, v);
                            match = true;
                            break;
                        }
                        double w = 1.0 / searchResult.distance;
                        weight_sum += w;
                        v_sum += v * w;
                    }
                    if (!match) {
                        r.setDouble(ii, v_sum / weight_sum);
                    }
                    ++ii;
                }
            }
        }
        return r;
    }

    public static Array gridDataKriging(Array x_s, Array y_s, Array a, Array X, Array Y, double beta) {
        X = X.copyIfView();
        Y = Y.copyIfView();
        double[] xd = (double[])ArrayUtil.copyToNDJavaArray_Double((Array)x_s);
        double[] yd = (double[])ArrayUtil.copyToNDJavaArray_Double((Array)y_s);
        double[] ad = (double[])ArrayUtil.copyToNDJavaArray_Double((Array)a);
        int colNum = (int)X.getSize();
        int rowNum = (int)Y.getSize();
        int pNum = (int)x_s.getSize();
        Array r = Array.factory((DataType)DataType.DOUBLE, (int[])new int[]{rowNum, colNum});
        KrigingInterpolation2D ki2d = new KrigingInterpolation2D(xd, yd, ad, beta);
        for (int i = 0; i < rowNum; ++i) {
            double gy = Y.getDouble(i);
            for (int j = 0; j < colNum; ++j) {
                double gx = X.getDouble(j);
                r.setDouble(i * colNum + j, ki2d.interpolate(gx, gy));
            }
        }
        return r;
    }

    private static double bilinear(Array data, Index dindex, Array xdim, Array ydim, double x, double y) {
        xdim = xdim.copyIfView();
        ydim = ydim.copyIfView();
        double iValue = Double.NaN;
        int[] xyIdx = ArrayUtil.gridIndex((Array)xdim, (Array)ydim, (double)x, (double)y);
        if (xyIdx == null) {
            return iValue;
        }
        int i1 = xyIdx[0];
        int j1 = xyIdx[1];
        int i2 = i1 + 1;
        int j2 = j1 + 1;
        Index index = data.getIndex();
        int n = index.getRank();
        for (int i = 0; i < n - 2; ++i) {
            index.setDim(i, dindex.getCurrentCounter()[i]);
        }
        index.setDim(n - 2, i1);
        index.setDim(n - 1, j1);
        double a = data.getDouble(index);
        index.setDim(n - 1, j2);
        double b = data.getDouble(index);
        index.setDim(n - 2, i2);
        index.setDim(n - 1, j1);
        double c = data.getDouble(index);
        index.setDim(n - 2, i2);
        index.setDim(n - 1, j2);
        double d = data.getDouble(index);
        ArrayList<Double> dList = new ArrayList<Double>();
        if (!Double.isNaN(a)) {
            dList.add(a);
        }
        if (!Double.isNaN(b)) {
            dList.add(b);
        }
        if (!Double.isNaN(c)) {
            dList.add(c);
        }
        if (!Double.isNaN(d)) {
            dList.add(d);
        }
        if (dList.isEmpty()) {
            return iValue;
        }
        if (dList.size() == 1) {
            iValue = (Double)dList.get(0);
        } else if (dList.size() <= 3) {
            double aSum = 0.0;
            Iterator iterator = dList.iterator();
            while (iterator.hasNext()) {
                double dd = (Double)iterator.next();
                aSum += dd;
            }
            iValue = aSum / (double)dList.size();
        } else {
            double dx = xdim.getDouble(j1 + 1) - xdim.getDouble(j1);
            double dy = ydim.getDouble(i1 + 1) - ydim.getDouble(i1);
            double x1val = a + (c - a) * (y - ydim.getDouble(i1)) / dy;
            double x2val = b + (d - b) * (y - ydim.getDouble(i1)) / dy;
            iValue = x1val + (x2val - x1val) * (x - xdim.getDouble(j1)) / dx;
        }
        return iValue;
    }

    private static double nearest(Array data, Index dindex, Array xdim, Array ydim, double x, double y) {
        int[] xyIdx = ArrayUtil.gridIndex((Array)(xdim = xdim.copyIfView()), (Array)(ydim = ydim.copyIfView()), (double)x, (double)y);
        if (xyIdx == null) {
            return Double.NaN;
        }
        int i1 = xyIdx[0];
        int j1 = xyIdx[1];
        int i2 = i1 + 1;
        int j2 = j1 + 1;
        double x1 = xdim.getDouble(j1);
        double x2 = xdim.getDouble(j2);
        double y1 = ydim.getDouble(i1);
        double y2 = ydim.getDouble(i2);
        int ii = x - x1 < x2 - x ? i1 : i2;
        int jj = y - y1 < y2 - y ? j1 : j2;
        Index index = data.getIndex();
        int n = index.getRank();
        for (int i = 0; i < n - 2; ++i) {
            index.setDim(i, dindex.getCurrentCounter()[i]);
        }
        index.setDim(n - 2, ii);
        index.setDim(n - 1, jj);
        double v = data.getDouble(index);
        return v;
    }

    public static Array linint2(Array a, Array X, Array Y, Array newX, Array newY) {
        int xn = (int)newX.getSize();
        int yn = (int)newY.getSize();
        int[] shape = a.getShape();
        int n = shape.length;
        shape[n - 1] = xn;
        shape[n - 2] = yn;
        Array r = Array.factory((DataType)DataType.DOUBLE, (int[])shape);
        Index index = r.getIndex();
        int k = 0;
        while ((long)k < r.getSize()) {
            int[] counter = index.getCurrentCounter();
            int yi = counter[n - 2];
            int xi = counter[n - 1];
            double y = newY.getDouble(yi);
            double x = newX.getDouble(xi);
            double v = InterpUtil.bilinear(a, index, X, Y, x, y);
            r.setDouble(index, v);
            index.incr();
            ++k;
        }
        return r;
    }

    public static Array nearestint2(Array a, Array X, Array Y, Array newX, Array newY) {
        int xn = (int)newX.getSize();
        int yn = (int)newY.getSize();
        int[] shape = a.getShape();
        int n = shape.length;
        shape[n - 1] = xn;
        shape[n - 2] = yn;
        Array r = Array.factory((DataType)DataType.DOUBLE, (int[])shape);
        Index index = r.getIndex();
        int k = 0;
        while ((long)k < r.getSize()) {
            int[] counter = index.getCurrentCounter();
            int yi = counter[n - 2];
            int xi = counter[n - 1];
            double y = newY.getDouble(yi);
            double x = newX.getDouble(xi);
            double v = InterpUtil.nearest(a, index, X, Y, x, y);
            r.setDouble(index, v);
            index.incr();
            ++k;
        }
        return r;
    }

    public static Array[] sliceXY(Array xa, Array ya, Array za, Array data, List<Number> xySlice, InterpolationMethod method) {
        xa = xa.copyIfView();
        ya = ya.copyIfView();
        double x1 = xySlice.get(0).doubleValue();
        double y1 = xySlice.get(1).doubleValue();
        double x2 = xySlice.get(2).doubleValue();
        double y2 = xySlice.get(3).doubleValue();
        if (x1 > x2) {
            double temp = x2;
            x2 = x1;
            x1 = temp;
            temp = y2;
            y2 = y1;
            y1 = temp;
        }
        double dx = xa.getDouble(1) - xa.getDouble(0);
        double dy = ya.getDouble(1) - ya.getDouble(0);
        int xn = dx == 0.0 ? 1 : (int)Math.ceil((x2 - x1) / dx);
        int yn = dy == 0.0 ? 1 : (int)Math.ceil(Math.abs(y2 - y1) / dy);
        int rn = Math.max(xn, yn);
        return InterpUtil.sliceXY(xa, ya, za, data, xySlice, rn, method);
    }

    public static Array[] sliceXY(Array xa, Array ya, Array za, Array data, List<Number> xySlice, int steps, InterpolationMethod method) {
        xa = xa.copyIfView();
        ya = ya.copyIfView();
        za = za.copyIfView();
        data = data.copyIfView();
        RectInterpolator3D interpolator3D = RectInterpolator3D.factory(xa, ya, za, data, method);
        double x1 = xySlice.get(0).doubleValue();
        double y1 = xySlice.get(1).doubleValue();
        double x2 = xySlice.get(2).doubleValue();
        double y2 = xySlice.get(3).doubleValue();
        if (x1 > x2) {
            double temp = x2;
            x2 = x1;
            x1 = temp;
            temp = y2;
            y2 = y1;
            y1 = temp;
        }
        Array xs = ArrayUtil.lineSpace((Number)x1, (Number)x2, (int)steps, (boolean)true);
        Array ys = ArrayUtil.lineSpace((Number)y1, (Number)y2, (int)steps, (boolean)true);
        int zn = (int)za.getSize();
        Array xs2d = ArrayUtil.repeat((Array)xs.reshape(new int[]{1, steps}), Arrays.asList(zn), (int)0);
        Array ys2d = ArrayUtil.repeat((Array)ys.reshape(new int[]{1, steps}), Arrays.asList(zn), (int)0);
        Array zs2d = ArrayUtil.repeat((Array)za.reshape(new int[]{zn, 1}), Arrays.asList(steps), (int)1);
        Array r = interpolator3D.interpolate(xs2d, ys2d, zs2d);
        return new Array[]{r, xs, ys, za, xs2d, ys2d, zs2d};
    }

    public static Array[] sliceXY(Array xa, Array ya, Array data, List<Number> xySlice, int steps, InterpolationMethod method) {
        xa = xa.copyIfView();
        ya = ya.copyIfView();
        data = data.copyIfView();
        RectInterpolator interpolator = RectInterpolator.factory(xa, ya, data, method);
        double x1 = xySlice.get(0).doubleValue();
        double y1 = xySlice.get(1).doubleValue();
        double x2 = xySlice.get(2).doubleValue();
        double y2 = xySlice.get(3).doubleValue();
        if (x1 > x2) {
            double temp = x2;
            x2 = x1;
            x1 = temp;
            temp = y2;
            y2 = y1;
            y1 = temp;
        }
        Array xs = ArrayUtil.lineSpace((Number)x1, (Number)x2, (int)steps, (boolean)true);
        Array ys = ArrayUtil.lineSpace((Number)y1, (Number)y2, (int)steps, (boolean)true);
        Array r = interpolator.interpolate(xs, ys);
        return new Array[]{r, xs, ys};
    }
}

