/*
 * Decompiled with CFR 0.152.
 */
package us.hebi.matlab.mat.format;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import us.hebi.matlab.mat.format.BufferAllocator;
import us.hebi.matlab.mat.format.CharEncoding;
import us.hebi.matlab.mat.format.Mat5File;
import us.hebi.matlab.mat.format.Mat5Reader;
import us.hebi.matlab.mat.format.Mat5Serializable;
import us.hebi.matlab.mat.format.Mat5Type;
import us.hebi.matlab.mat.format.Mat5Writer;
import us.hebi.matlab.mat.format.MatCell;
import us.hebi.matlab.mat.format.MatChar;
import us.hebi.matlab.mat.format.MatMatrix;
import us.hebi.matlab.mat.format.MatStruct;
import us.hebi.matlab.mat.format.NumberStore;
import us.hebi.matlab.mat.format.UniversalNumberStore;
import us.hebi.matlab.mat.types.AbstractArray;
import us.hebi.matlab.mat.types.Array;
import us.hebi.matlab.mat.types.Cell;
import us.hebi.matlab.mat.types.Char;
import us.hebi.matlab.mat.types.MatFile;
import us.hebi.matlab.mat.types.MatlabType;
import us.hebi.matlab.mat.types.Matrix;
import us.hebi.matlab.mat.types.Sink;
import us.hebi.matlab.mat.types.Sinks;
import us.hebi.matlab.mat.types.Source;
import us.hebi.matlab.mat.types.Sources;
import us.hebi.matlab.mat.types.Struct;
import us.hebi.matlab.mat.util.Casts;
import us.hebi.matlab.mat.util.Preconditions;
import us.hebi.matlab.mat.util.Unsafe9R;

public class Mat5 {
    private static final BufferAllocator DEFAULT_BUFFER_ALLOCATOR = new BufferAllocator(){

        @Override
        public ByteBuffer allocate(int numBytes) {
            ByteBuffer buffer = numBytes <= 4096 ? ByteBuffer.allocate(numBytes) : ByteBuffer.allocateDirect(numBytes);
            buffer.order(DEFAULT_ORDER);
            return buffer;
        }

        @Override
        public void release(ByteBuffer buffer) {
            if (buffer.isDirect()) {
                Unsafe9R.invokeCleaner(buffer);
            }
        }
    };
    public static final Array EMPTY_MATRIX = Mat5.newMatrix(0, 0);
    public static final ByteOrder DEFAULT_ORDER = ByteOrder.nativeOrder();
    public static final int MATRIX_TAG_SIZE = 8;
    public static final int FILE_HEADER_SIZE = 128;
    public static final int REDUCED_FILE_HEADER_SIZE = 8;

    public static Mat5File readFromFile(String fileName) throws IOException {
        return Mat5.readFromFile(new File(Preconditions.checkNotNull(fileName, "File can't be empty")));
    }

    public static Mat5File readFromFile(File file) throws IOException {
        Preconditions.checkNotNull(file, "Input file can't be empty");
        Source source = Sources.openFile(file);
        try {
            Mat5File mat5File = Mat5.newReader(source).readMat();
            return mat5File;
        }
        finally {
            source.close();
        }
    }

    public static File writeToFile(MatFile mat, String fileName) throws IOException {
        return Mat5.writeToFile(mat, new File(Preconditions.checkNotNull(fileName, "File can't be empty")));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File writeToFile(MatFile mat, File file) throws IOException {
        Preconditions.checkNotNull(mat, "MatFile can't be empty");
        Preconditions.checkNotNull(file, "Output file can't be empty");
        long maxExpectedSize = mat.getUncompressedSerializedSize();
        long minMappingSize = 131072L;
        Sink sink = maxExpectedSize >= minMappingSize && maxExpectedSize <= Integer.MAX_VALUE ? Sinks.newMappedFile(file, Casts.sint32(maxExpectedSize)) : Sinks.newStreamingFile(file);
        try {
            mat.writeTo(sink);
            File file2 = file;
            return file2;
        }
        finally {
            sink.close();
        }
    }

    public static Mat5File newMatFile() {
        return new Mat5File();
    }

    public static Mat5Reader newReader(Source source) {
        return new Mat5Reader(source);
    }

    public static Mat5Writer newWriter(Sink sink) {
        return new Mat5Writer(sink);
    }

    public static int[] index(int rows, int cols) {
        return new int[]{rows, cols};
    }

    public static int[] index(int rows, int cols, int ... other) {
        int[] dims = new int[other.length + 2];
        dims[0] = rows;
        dims[1] = cols;
        System.arraycopy(other, 0, dims, 2, other.length);
        return dims;
    }

    public static int[] dims(int rows, int cols) {
        return Mat5.index(rows, cols);
    }

    public static int[] dims(int rows, int cols, int ... other) {
        return Mat5.index(rows, cols, other);
    }

    public static Cell newCell(int rows, int cols) {
        return Mat5.newCell(Mat5.dims(rows, cols));
    }

    public static Cell newCell(int[] dims) {
        return new MatCell(dims);
    }

    public static Struct newStruct() {
        return Mat5.newStruct(1, 1);
    }

    public static Struct newStruct(int rows, int cols) {
        return Mat5.newStruct(Mat5.dims(rows, cols));
    }

    public static Struct newStruct(int[] dims) {
        return new MatStruct(dims);
    }

    public static Char newChar(int rows, int cols) {
        return Mat5.newChar(Mat5.dims(rows, cols));
    }

    public static Char newChar(int rows, int cols, CharEncoding encoding) {
        return new MatChar(Mat5.dims(rows, cols), encoding, Mat5.getDefaultBufferAllocator());
    }

    public static Char newChar(int[] dims) {
        return Mat5.newChar(dims, CharEncoding.Utf8);
    }

    public static Char newChar(int[] dims, CharEncoding encoding) {
        return new MatChar(dims, encoding, Mat5.getDefaultBufferAllocator());
    }

    public static Char newString(String value) {
        return Mat5.newString(value, CharEncoding.Utf8);
    }

    public static Char newString(String value, CharEncoding encoding) {
        return new MatChar(new int[]{1, value.length()}, encoding, CharEncoding.CloseableCharBuffer.wrap(value));
    }

    public static Matrix newLogicalScalar(boolean value) {
        Matrix logical = Mat5.newLogical(1, 1);
        logical.setBoolean(0, value);
        return logical;
    }

    public static Matrix newScalar(double value) {
        Matrix matrix = Mat5.newMatrix(1, 1);
        matrix.setDouble(0, 0, value);
        return matrix;
    }

    public static Matrix newComplexScalar(double real, double imaginary) {
        Matrix complex = Mat5.newComplex(1, 1);
        complex.setDouble(0, real);
        complex.setImaginaryDouble(0, imaginary);
        return complex;
    }

    public static Matrix newLogical(int rows, int cols) {
        return Mat5.newLogical(Mat5.dims(rows, cols));
    }

    public static Matrix newLogical(int[] dims) {
        return Mat5.newNumerical(dims, MatlabType.Int8, true, false);
    }

    public static Matrix newMatrix(int rows, int cols) {
        return Mat5.newMatrix(Mat5.dims(rows, cols));
    }

    public static Matrix newMatrix(int[] dims) {
        return Mat5.newMatrix(dims, MatlabType.Double);
    }

    public static Matrix newMatrix(int rows, int cols, MatlabType type) {
        return Mat5.newMatrix(Mat5.dims(rows, cols), type);
    }

    public static Matrix newMatrix(int[] dims, MatlabType type) {
        return Mat5.newNumerical(dims, type, false, false);
    }

    public static Matrix newComplex(int rows, int cols) {
        return Mat5.newComplex(Mat5.dims(rows, cols));
    }

    public static Matrix newComplex(int rows, int cols, MatlabType type) {
        return Mat5.newComplex(Mat5.dims(rows, cols), type);
    }

    public static Matrix newComplex(int[] dims) {
        return Mat5.newComplex(dims, MatlabType.Double);
    }

    public static Matrix newComplex(int[] dims, MatlabType type) {
        return Mat5.newNumerical(dims, type, false, true);
    }

    public static int getSerializedSize(String name, Array array) {
        if (array instanceof Mat5Serializable) {
            return ((Mat5Serializable)((Object)array)).getMat5Size(name);
        }
        throw new IllegalArgumentException("Array does not support the MAT5 format");
    }

    private static Matrix newNumerical(int[] dims, MatlabType type, boolean logical, boolean complex) {
        return Mat5.newNumerical(dims, type, logical, complex, Mat5.getDefaultBufferAllocator());
    }

    public static Matrix newNumerical(int[] dims, MatlabType type, boolean logical, boolean complex, BufferAllocator allocator) {
        return new MatMatrix(dims, type, logical, Mat5.createStore(type, dims, allocator), complex ? Mat5.createStore(type, dims, allocator) : null);
    }

    private static NumberStore createStore(MatlabType type, int[] dims, BufferAllocator bufferAllocator) {
        Mat5Type tagType = Mat5Type.fromNumericalType(type);
        int numBytes = Casts.sint32(AbstractArray.getNumElementsLong(dims) * (long)tagType.bytes());
        ByteBuffer buffer = bufferAllocator.allocate(numBytes);
        return new UniversalNumberStore(tagType, buffer, bufferAllocator);
    }

    static BufferAllocator getDefaultBufferAllocator() {
        return DEFAULT_BUFFER_ALLOCATOR;
    }

    static ByteBuffer exportBytes(Matrix matrix) {
        MatMatrix matMatrix;
        if (matrix instanceof MatMatrix && (matMatrix = (MatMatrix)matrix).getRealStore() instanceof UniversalNumberStore) {
            return ((UniversalNumberStore)matMatrix.getRealStore()).getByteBuffer();
        }
        throw new IllegalStateException("Not implemented for input type");
    }

    private Mat5() {
    }
}

