/*
 * Decompiled with CFR 0.152.
 */
package us.hebi.matlab.mat.format;

import java.io.IOException;
import java.nio.CharBuffer;
import java.util.zip.Deflater;
import us.hebi.matlab.mat.format.CharEncoding;
import us.hebi.matlab.mat.format.Charsets;
import us.hebi.matlab.mat.format.Mat5ArrayFlags;
import us.hebi.matlab.mat.format.Mat5Serializable;
import us.hebi.matlab.mat.format.Mat5Type;
import us.hebi.matlab.mat.types.Array;
import us.hebi.matlab.mat.types.MatlabType;
import us.hebi.matlab.mat.types.Opaque;
import us.hebi.matlab.mat.types.Sink;
import us.hebi.matlab.mat.util.Casts;

public class Mat5WriteUtil {
    private static final int NAME_LENGTH_MAX = 63;
    private static final int DUMMY_SIZE = 0;

    public static void writeNestedArray(Array array, Sink sink) throws IOException {
        Mat5WriteUtil.writeArray("", false, array, sink);
    }

    public static void writeArray(String name, boolean isGlobal, Array array, Sink sink) throws IOException {
        if (array instanceof Mat5Serializable) {
            ((Mat5Serializable)((Object)array)).writeMat5(name, isGlobal, sink);
            return;
        }
        throw new IllegalArgumentException("Array does not support the MAT5 format");
    }

    public static int computeArraySize(Array array) {
        return Mat5WriteUtil.computeArraySize("", array);
    }

    public static int computeArraySize(String name, Array array) {
        if (array instanceof Mat5Serializable) {
            return ((Mat5Serializable)((Object)array)).getMat5Size(name);
        }
        throw new IllegalArgumentException("Array does not support the MAT5 format");
    }

    public static int computeArrayHeaderSize(String name, Array array) {
        int arrayFlags = Mat5Type.UInt32.computeSerializedSize(2);
        int dimensions = Mat5Type.Int32.computeSerializedSize(array.getNumDimensions());
        int nameLen = Mat5Type.Int8.computeSerializedSize(Mat5WriteUtil.getLimitedNameLength(name));
        return arrayFlags + dimensions + nameLen;
    }

    public static void writeMatrixTag(String name, Mat5Serializable array, Sink sink) throws IOException {
        Mat5Type.Matrix.writeTag(array.getMat5Size(name) - 8, sink);
    }

    public static void writeArrayHeader(String name, boolean isGlobal, Array array, Sink sink) throws IOException {
        if (array.getType() == MatlabType.Opaque) {
            throw new IllegalArgumentException("Opaque types do not share the same format as other types");
        }
        Mat5Type.UInt32.writeIntsWithTag(Mat5ArrayFlags.forArray(isGlobal, array), sink);
        Mat5Type.Int32.writeIntsWithTag(array.getDimensions(), sink);
        Mat5Type.Int8.writeBytesWithTag(Mat5WriteUtil.getLimitedName(name).getBytes(Charsets.US_ASCII), sink);
    }

    public static int computeOpaqueSize(String name, Opaque array) {
        return 8 + Mat5Type.UInt32.computeSerializedSize(2) + Mat5Type.Int8.computeSerializedSize(name.length()) + Mat5Type.Int8.computeSerializedSize(array.getObjectType().length()) + Mat5Type.Int8.computeSerializedSize(array.getClassName().length()) + Mat5WriteUtil.computeArraySize(array.getContent());
    }

    public static void writeOpaque(String name, boolean global, Opaque opaque, Sink sink) throws IOException {
        int numBytes = Mat5WriteUtil.computeOpaqueSize(name, opaque) - 8;
        Mat5Type.Matrix.writeTag(numBytes, sink);
        Mat5Type.UInt32.writeIntsWithTag(Mat5ArrayFlags.forOpaque(global, opaque), sink);
        Mat5Type.Int8.writeBytesWithTag(name.getBytes(Charsets.US_ASCII), sink);
        Mat5Type.Int8.writeBytesWithTag(opaque.getObjectType().getBytes(Charsets.US_ASCII), sink);
        Mat5Type.Int8.writeBytesWithTag(opaque.getClassName().getBytes(Charsets.US_ASCII), sink);
        Mat5WriteUtil.writeNestedArray(opaque.getContent(), sink);
    }

    static int computeCharBufferSize(CharEncoding encoding, CharBuffer buffer) {
        Mat5Type tagType = Mat5Type.fromCharEncoding(encoding);
        int numElements = Casts.checkedDivide(encoding.getEncodedLength(buffer), tagType.bytes());
        return tagType.computeSerializedSize(numElements);
    }

    static void writeCharBufferWithTag(CharEncoding encoding, CharBuffer buffer, Sink sink) throws IOException {
        Mat5Type tagType = Mat5Type.fromCharEncoding(encoding);
        int numElements = Casts.checkedDivide(encoding.getEncodedLength(buffer), tagType.bytes());
        tagType.writeTag(numElements, sink);
        encoding.writeEncoded(buffer, sink);
        tagType.writePadding(numElements, sink);
    }

    static void writeArrayDeflated(String name, boolean global, Array array, Sink sink, Deflater deflater) throws IOException {
        long tagPosition = sink.position();
        Mat5Type.Compressed.writeTag(0, false, sink);
        long start = sink.position();
        Sink compressed = sink.writeDeflated(deflater);
        Mat5WriteUtil.writeArray(name, global, array, compressed);
        compressed.close();
        long end = sink.position();
        long compressedSize = end - start;
        sink.position(tagPosition);
        Mat5Type.Compressed.writeTag(Casts.sint32(compressedSize), false, sink);
        sink.position(end);
    }

    static String getLimitedName(String name) {
        if (name.length() <= 63) {
            return name;
        }
        String truncated = name.substring(0, 63);
        String warning = "Warning: '%s' exceeds MATLAB's maximum name length and will be truncated to '%s'.";
        System.err.println(String.format(warning, name, truncated));
        return truncated;
    }

    static int getLimitedNameLength(String name) {
        if (name == null) {
            return 0;
        }
        return Math.min(63, name.length());
    }
}

