print 'Open data files...'
f_air = addfile('D:/Temp/nc/air.2011.nc')
f_uwnd = addfile('D:/Temp/nc/uwnd.2011.nc')
f_vwnd = addfile('D:/Temp/nc/vwnd.2011.nc')
f_rhum = addfile('D:/Temp/nc/rhum.2011.nc')

print 'Read data array...'
tidx = 173    # Jun 23, 2011
t = f_air.gettime(tidx)
lidx = 3    # 700 hPa
air = f_air['air'][tidx,lidx,:,:]
uwnd = f_uwnd['uwnd'][tidx,lidx,:,:]
vwnd = f_vwnd['vwnd'][tidx,lidx,:,:]
rhum = f_rhum['rhum'][tidx,lidx,:,:]

# Calculate
print 'Calculate...'
prs = 700
g = 9.8
qs = meteolib.saturation_mixing_ratio(prs, air-273.15)
q = qs * rhum / 100
qhdivg = meteolib.divergence(q*uwnd/g, q*vwnd/g) * 1000

#Plot
print 'Plot...'
axesm()
geoshow('coastline', color='k')
layer = contourf(qhdivg, 20)
title('Water Vapor Flux Divergency (' + t.strftime('%Y-%m-%d') + ')')
colorbar(layer)
xlim(0, 360)
ylim(-90, 90)

#savefig('D:/Temp/figure/water_vapor_flux_divg.png', 600, 300, dpi=300)