fn = os.path.join(migl.get_sample_folder(), 'GrADS', 'model.ctl')
f = addfile(fn)
u = f['U'][0]
v = f['V'][0]
levels = u.dimvalue(0)
height = meteolib.pressure_to_height_std(levels) / 10
lat = u.dimvalue(1)
lon = u.dimvalue(2)
w = zeros(u.shape)
speed = sqrt(u*u + v*v)

ax = axes3d(projection='earth')
geoshow('country', edgecolor='gray')
levs = arange(2, 20, 2)
streamslice(lon, lat, height, u, v, w, speed, levels=levs, zslice=[300],
    interval=10)
colorbar(tickcolor='w', xshift=80)