#Read data
fn = os.path.join(migl.get_sample_folder(), 'ASCII', 'wp.csv')
df = DataFrame.read_table(fn, delimiter=',', format='%9f', index_col=0)
lons = df['lon'].values
lats = df['lat'].values
models = df['model%'].values
ois = df['oi%'].values
enois = df['enoi%'].values
n = len(lons)
maxv = max([models.max(), ois.max(), enois.max()])

#Creat a map axes
#figure(figsize=[700,550], newfig=False)
proj = projinfo(proj='lcc', lon_0=105, lat_1=25, lat_2=47)
ax = axesm(outerposition=[0,0,1,1], projinfo=proj, gridline=False)
geoshow('cn_province', edgecolor='gray')
geoshow('china', edgecolor='b')
scatterm(lons, lats, color='k', edge=False, size=4)
axism([78, 130, 14, 53])

#Draw figure so we can use data2pixel function
draw()
h = 25
w = 20
cols = ['r','b','g']
for lon,lat,model,oi,enoi in zip(lons,lats,models,ois,enois):
    x, y = ax.data2pixel(lon, lat)
    print lon, lat
    data = [model, oi, enoi]
    #Draw fixed pixels size pie charts at specific longitude/latitude
    ax1 = axes(position=[x, y, w, h], units='pixels', axis=False)    
    left = 0
    width = .1
    for i in range(3):
        bar(left, data[i], width, color=cols[i], edgecolor='gray')
        left += width  
    ylim(0, maxv)  

ax1 = axes(position=[150, 100, w * 3, h], units='pixels', axis=False)
left = 0
width = 1
labels = ['model (%)','oi (%)','enoi (%)']
bb = []
data = [60, 80, 100]
for i in range(3):
    b = bar(left, data[i], width, color=cols[i], edgecolor='gray', label=labels[i])
    bb.append(b)
    left += width  
text(left+0.5, 50, '100', xalign='left', yalign='center', fontsize=12)
ylim(0, maxv) 
xlim(0, 9)
ax2 = axes(position=[130, 30, 100, 100], units='pixels', axis=False)
legend(ax1.get_legend(), loc='lower left', fontsize=12, frameon=False)