# Add file
fn = 'D:/Temp/hdf/CAL_LID_L2_VFM-Standard-V4-10.2013-12-08T04-46-10ZD.hdf'
f = addfile(fn)

# Read data
vname = 'Feature_Classification_Flags'
var = f[vname]
data = var[:,:]
lat = f['Latitude'][:,0]

# Extract Feature Type only through bitmask.
data = data & 7

# Subset latitude values for the region of interest (40N to 62N).
lat = lat[3000:4000]
size = lat.shape[0]

data2d = data[3000:4000, 1165:]  # -0.5km to  8.2km
data3d = reshape(data2d, (size, 15, 290))
data = data3d[:,0,:]

# Generate altitude data according to file specification [1].
alt = zeros(290)
# -0.5km to 8.2km
for i in range (0, 290):
    alt[i] = -0.5 + i*0.03

# Plot
levs = arange(8)
cols = [(255,255,255),(0,0,255),(51,255,255),(255,153,0),(255,255,0),(0,255,0),(127,127,127),(0,0,0)]
ls = makesymbolspec('image', levels=levs, colors=cols)
layer = imshow(rot90(data, 1), symbolspec=ls, extent=[lat[0],lat[-1],alt[0],alt[-1]])
colorbar(layer, ticklabels=['Invalid', 'Clear Air', 'Cloud', 'Aerosol', 'Strato Feature', 'Surface', 'Subsurface', 'No Signal'])
basename = os.path.basename(fn)
title([basename, 'Feature Type (Bits 1-3) in Feature Classification Flag'])
xlabel('Latitude (degrees north)')
ylabel('Altitude (km)')
xaxis(tickin=False)
yaxis(tickin=False)

#savefig('D:/Temp/figure/calipso_L2_Flag.png', 600, 300, dpi=300)