/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.geometry.graphic;

import java.util.ArrayList;
import java.util.List;
import org.meteoinfo.geometry.graphic.GraphicCollection;
import org.meteoinfo.geometry.graphic.Line2DGraphic;
import org.meteoinfo.geometry.legend.LegendScheme;
import org.meteoinfo.geometry.legend.PolylineBreak;
import org.meteoinfo.ndarray.Array;
import org.meteoinfo.ndarray.IndexIterator;

public class Line2DGraphicCollection
extends GraphicCollection {
    private Array cData;
    private List<Array> data;
    private boolean curve = false;

    public Line2DGraphicCollection() {
        this(new ArrayList<Line2DGraphic>());
    }

    public Line2DGraphicCollection(List<Line2DGraphic> graphics) {
        this.graphics = graphics;
        this.legend = new PolylineBreak();
    }

    public Line2DGraphicCollection(List<Array> data, PolylineBreak lineBreak) {
        this.updateGraphics(data, lineBreak);
    }

    public Line2DGraphicCollection(List<Array> data, List<PolylineBreak> lineBreaks) {
        this.updateGraphics(data, lineBreaks);
    }

    public Line2DGraphicCollection(List<Array> data, Array cData, LegendScheme ls) {
        this.legendScheme = ls;
        this.setSingleLegend(false);
        if (cData.getSize() == (long)data.size()) {
            ArrayList<PolylineBreak> lineBreaks = new ArrayList<PolylineBreak>();
            IndexIterator iterC = cData.getIndexIterator();
            while (iterC.hasNext()) {
                lineBreaks.add((PolylineBreak)ls.findLegendBreak(iterC.getDoubleNext()));
            }
            this.updateGraphics(data, lineBreaks);
        } else {
            this.updateGraphics(data, cData, ls);
        }
    }

    public Line2DGraphicCollection(List<Array> data, List<Array> cData, LegendScheme ls) {
        this.legendScheme = ls;
        this.setSingleLegend(false);
        this.updateGraphics(data, cData, ls);
    }

    protected void updateGraphics(List<Array> data, PolylineBreak lineBreak) {
        this.data = data;
        this.graphics = new ArrayList();
        int[] origin = new int[2];
        int[] shape = new int[2];
        try {
            for (Array array : data) {
                origin = new int[]{0, 0};
                shape = new int[]{array.getShape()[0], 1};
                Array x = array.section(origin, shape);
                origin = new int[]{0, 1};
                Array y = array.section(origin, shape);
                this.add(new Line2DGraphic(x, y, lineBreak));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void updateGraphics(List<Array> data, List<PolylineBreak> lineBreaks) {
        this.singleLegend = false;
        this.data = data;
        this.graphics = new ArrayList();
        int[] origin = new int[2];
        int[] shape = new int[2];
        try {
            int i = 0;
            for (Array array : data) {
                origin = new int[]{0, 0};
                shape = new int[]{array.getShape()[0], 1};
                Array x = array.section(origin, shape);
                origin = new int[]{0, 1};
                Array y = array.section(origin, shape);
                if (i >= lineBreaks.size()) {
                    i = 0;
                }
                this.add(new Line2DGraphic(x, y, lineBreaks.get(i)));
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void updateGraphics(List<Array> data, List<Array> cData, LegendScheme ls) {
        this.singleLegend = false;
        this.data = data;
        this.graphics = new ArrayList();
        int[] origin = new int[2];
        int[] shape = new int[2];
        try {
            int i = 0;
            for (Array array : data) {
                origin = new int[]{0, 0};
                shape = new int[]{array.getShape()[0], 1};
                Array x = array.section(origin, shape);
                origin = new int[]{0, 1};
                Array y = array.section(origin, shape);
                this.add(new Line2DGraphic(x, y, cData.get(i), ls));
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void updateGraphics(List<Array> data, Array cData, LegendScheme ls) {
        this.singleLegend = false;
        this.data = data;
        this.cData = cData;
        this.graphics = new ArrayList();
        int[] origin = new int[2];
        int[] shape = new int[2];
        try {
            int i = 0;
            for (Array array : data) {
                origin = new int[]{0, 0};
                shape = new int[]{array.getShape()[0], 1};
                Array x = array.section(origin, shape);
                origin = new int[]{0, 1};
                Array y = array.section(origin, shape);
                origin = new int[]{0, i++};
                Array c = cData.section(origin, shape);
                this.add(new Line2DGraphic(x, y, c, ls));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean hasColorData() {
        return this.cData != null;
    }

    public boolean isCurve() {
        return this.curve;
    }

    public void setCurve(boolean value) {
        this.curve = value;
    }

    public List<Array> getData() {
        return this.data;
    }

    public void setData(List<Array> value) {
        if (this.cData != null) {
            this.updateGraphics(value, this.cData, this.legendScheme);
        } else {
            List<PolylineBreak> lineBreaks = this.getLegendBreaks();
            this.updateGraphics(value, lineBreaks);
        }
    }

    public void setData(List<Array> value, Array cData) {
        this.updateGraphics(value, cData, this.legendScheme);
    }

    public List<PolylineBreak> getLegendBreaks() {
        ArrayList<PolylineBreak> lineBreaks = new ArrayList<PolylineBreak>();
        for (Line2DGraphic line2DGraphic : this.getGraphics()) {
            lineBreaks.add((PolylineBreak)line2DGraphic.legend);
        }
        return lineBreaks;
    }
}

