/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.geometry.graphic;

import java.util.ArrayList;
import org.meteoinfo.common.PointD;
import org.meteoinfo.geometry.graphic.Graphic;
import org.meteoinfo.geometry.legend.ColorBreak;
import org.meteoinfo.geometry.legend.ColorBreakCollection;
import org.meteoinfo.geometry.legend.LegendScheme;
import org.meteoinfo.geometry.legend.PolygonBreak;
import org.meteoinfo.geometry.shape.PolygonShape;
import org.meteoinfo.ndarray.Array;
import org.meteoinfo.ndarray.IndexIterator;

public class PolygonGraphic
extends Graphic {
    private Array xData;
    private Array yData;
    private Array cData;
    private LegendScheme legendScheme;

    public PolygonGraphic(PolygonShape shape, PolygonBreak legend) {
        this.shape = shape;
        this.legend = legend;
    }

    public PolygonGraphic(Array xData, Array yData, PolygonBreak polygonBreak) {
        this.xData = xData;
        this.yData = yData;
        this.updateShape();
        if (polygonBreak == null) {
            polygonBreak = new PolygonBreak();
        }
        this.legend = polygonBreak;
    }

    public PolygonGraphic(Array xData, Array yData) {
        this(xData, yData, new PolygonBreak());
    }

    public PolygonGraphic(Array xData, Array yData, Array cData, LegendScheme legendScheme) {
        this.xData = xData;
        this.yData = yData;
        this.cData = cData;
        this.updateShapeLegend(legendScheme);
    }

    protected void updateShape() {
        ArrayList<PointD> points = new ArrayList<PointD>();
        IndexIterator xIter = this.xData.getIndexIterator();
        IndexIterator yIter = this.yData.getIndexIterator();
        while (xIter.hasNext() && yIter.hasNext()) {
            double x = xIter.getDoubleNext();
            double y = yIter.getDoubleNext();
            if (Double.isNaN(x) || Double.isNaN(y)) continue;
            points.add(new PointD(x, y));
        }
        if (this.shape == null) {
            this.shape = new PolygonShape();
        }
        this.shape.setPoints(points);
    }

    protected void updateShapeLegend(LegendScheme legendScheme) {
        this.legendScheme = legendScheme;
        ArrayList<PointD> points = new ArrayList<PointD>();
        IndexIterator xIter = this.xData.getIndexIterator();
        IndexIterator yIter = this.yData.getIndexIterator();
        IndexIterator cIter = this.cData.getIndexIterator();
        ColorBreakCollection cbc = new ColorBreakCollection();
        while (xIter.hasNext()) {
            double x = xIter.getDoubleNext();
            double y = yIter.getDoubleNext();
            double c = cIter.getDoubleNext();
            if (Double.isNaN(x) || Double.isNaN(y)) continue;
            points.add(new PointD(x, y));
            ColorBreak cb = legendScheme.findLegendBreakAlways(c);
            cbc.add(cb);
        }
        if (this.shape == null) {
            this.shape = new PolygonShape();
        }
        if (points.size() >= 2) {
            this.shape.setPoints(points);
        }
        this.legend = cbc;
    }

    public Array getXData() {
        return this.xData;
    }

    public void setXData(Array xData) {
        this.xData = xData;
        this.updateShape();
    }

    public Array getYData() {
        return this.yData;
    }

    public void setYData(Array yData) {
        this.yData = yData;
        this.updateShape();
    }

    public void setData(Array xData, Array yData) {
        this.xData = xData;
        this.yData = yData;
        this.updateShape();
    }
}

