/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.geometry.shape;

import java.util.ArrayList;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.meteoinfo.common.PointD;
import org.meteoinfo.geometry.shape.Shape;
import org.meteoinfo.geometry.shape.ShapeTypes;

public class PointShape
extends Shape
implements Cloneable {
    public PointShape() {
        this(new PointD());
    }

    public PointShape(PointD point) {
        this.setPoint(point);
    }

    public PointShape(Geometry geometry) {
        Coordinate c = geometry.getCoordinate();
        this.setPoint(new PointD(c.x, c.y));
    }

    @Override
    public ShapeTypes getShapeType() {
        return ShapeTypes.POINT;
    }

    @Override
    public Geometry toGeometry(GeometryFactory factory) {
        PointD point = this.getPoint();
        Coordinate c = new Coordinate(point.X, point.Y);
        return factory.createPoint(c);
    }

    public PointD getPoint() {
        return (PointD)this.points.get(0);
    }

    public void setPoint(PointD point) {
        this.points = new ArrayList();
        this.points.add(point);
        this.updateExtent();
    }

    @Override
    public Object clone() {
        PointShape ps = new PointShape();
        ps.setValue(this.getValue());
        ps.setPoint((PointD)this.getPoint().clone());
        ps.setVisible(this.isVisible());
        ps.setSelected(this.isSelected());
        ps.setLegendIndex(this.getLegendIndex());
        return ps;
    }
}

