/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.geometry.shape;

import java.util.ArrayList;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateXYM;
import org.locationtech.jts.geom.Geometry;
import org.meteoinfo.common.MIMath;
import org.meteoinfo.geometry.shape.PointM;
import org.meteoinfo.geometry.shape.PointZ;
import org.meteoinfo.geometry.shape.PolygonShape;
import org.meteoinfo.geometry.shape.ShapeTypes;

public class PolygonMShape
extends PolygonShape {
    public PolygonMShape() {
    }

    public PolygonMShape(Geometry geometry) {
        Coordinate[] cs = geometry.getCoordinates();
        ArrayList<PointZ> points = new ArrayList<PointZ>();
        for (Coordinate c1 : cs) {
            CoordinateXYM c = (CoordinateXYM)c1;
            points.add(new PointZ(c.x, c.y, c.getZ(), c.getM()));
        }
        this.setPoints(points);
    }

    @Override
    public ShapeTypes getShapeType() {
        return ShapeTypes.POLYGON_M;
    }

    public double[] getMArray() {
        double[] mArray = new double[this.getPoints().size()];
        for (int i = 0; i < this.getPoints().size(); ++i) {
            mArray[i] = ((PointM)this.getPoints().get((int)i)).M;
        }
        return mArray;
    }

    public double[] getMRange() {
        return MIMath.arrayMinMax((double[])this.getMArray());
    }
}

