/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.geometry.shape;

import java.util.ArrayList;
import java.util.List;
import org.meteoinfo.common.PointD;
import org.meteoinfo.geometry.shape.CircleShape;
import org.meteoinfo.geometry.shape.PointShape;
import org.meteoinfo.geometry.shape.PointZ;
import org.meteoinfo.geometry.shape.PointZShape;
import org.meteoinfo.geometry.shape.PolygonShape;
import org.meteoinfo.geometry.shape.PolylineShape;
import org.meteoinfo.geometry.shape.PolylineZShape;
import org.meteoinfo.ndarray.Array;
import org.meteoinfo.ndarray.IndexIterator;

public class ShapeUtil {
    public static List<PointShape> createPointShapes(List<Number> x, List<Number> y) {
        ArrayList<PointShape> shapes = new ArrayList<PointShape>();
        for (int i = 0; i < x.size(); ++i) {
            PointShape ps = new PointShape();
            double xx = x.get(i).doubleValue();
            double yy = y.get(i).doubleValue();
            ps.setPoint(new PointD(xx, yy));
            shapes.add(ps);
        }
        return shapes;
    }

    public static List<PointShape> createPointShapes(Array x, Array y) {
        ArrayList<PointShape> shapes = new ArrayList<PointShape>();
        int i = 0;
        while ((long)i < x.getSize()) {
            PointShape ps = new PointShape();
            double xx = x.getDouble(i);
            double yy = y.getDouble(i);
            ps.setPoint(new PointD(xx, yy));
            shapes.add(ps);
            ++i;
        }
        return shapes;
    }

    public static List<PointZShape> createPointShapes(Array x, Array y, Array z, Array m) {
        ArrayList<PointZShape> shapes = new ArrayList<PointZShape>();
        int i = 0;
        while ((long)i < x.getSize()) {
            PointZShape ps = new PointZShape();
            double xx = x.getDouble(i);
            double yy = y.getDouble(i);
            ps.setPoint(new PointZ(xx, yy, z.getDouble(i), m.getDouble(i)));
            shapes.add(ps);
            ++i;
        }
        return shapes;
    }

    public static List<PolylineShape> createPolylineShapes(List<Number> x, List<Number> y) {
        PolylineShape pls;
        ArrayList<PointD> points = new ArrayList<PointD>();
        ArrayList<PolylineShape> shapes = new ArrayList<PolylineShape>();
        for (int i = 0; i < x.size(); ++i) {
            double xx = x.get(i).doubleValue();
            double yy = y.get(i).doubleValue();
            if (Double.isNaN(xx)) {
                if (points.size() >= 2) {
                    pls = new PolylineShape();
                    pls.setPoints(points);
                    shapes.add(pls);
                }
                points = new ArrayList();
                continue;
            }
            points.add(new PointD(xx, yy));
        }
        if (points.size() >= 2) {
            pls = new PolylineShape();
            pls.setPoints(points);
            shapes.add(pls);
        }
        return shapes;
    }

    public static PolylineShape createPolylineShape(Array x, Array y) {
        ArrayList<PointD> points = new ArrayList<PointD>();
        IndexIterator xIter = x.getIndexIterator();
        IndexIterator yIter = y.getIndexIterator();
        while (xIter.hasNext()) {
            double xx = xIter.getDoubleNext();
            double yy = yIter.getDoubleNext();
            points.add(new PointD(xx, yy));
        }
        PolylineShape pls = new PolylineShape();
        pls.setPoints(points);
        return pls;
    }

    public static List<PolylineShape> createPolylineShapes(Array x, Array y) {
        PolylineShape pls;
        ArrayList<PointD> points = new ArrayList<PointD>();
        ArrayList<PolylineShape> shapes = new ArrayList<PolylineShape>();
        int i = 0;
        while ((long)i < x.getSize()) {
            double xx = x.getDouble(i);
            double yy = y.getDouble(i);
            if (Double.isNaN(xx)) {
                if (points.size() >= 2) {
                    pls = new PolylineShape();
                    pls.setPoints(points);
                    shapes.add(pls);
                }
                points = new ArrayList();
            } else {
                points.add(new PointD(xx, yy));
            }
            ++i;
        }
        if (points.size() >= 2) {
            pls = new PolylineShape();
            pls.setPoints(points);
            shapes.add(pls);
        }
        return shapes;
    }

    public static List<PolylineZShape> createPolylineShapes(Array x, Array y, Array z, Array m) {
        PolylineZShape pls;
        ArrayList<PointZ> points = new ArrayList<PointZ>();
        ArrayList<PolylineZShape> shapes = new ArrayList<PolylineZShape>();
        int i = 0;
        while ((long)i < x.getSize()) {
            double xx = x.getDouble(i);
            double yy = y.getDouble(i);
            if (Double.isNaN(xx)) {
                if (points.size() >= 2) {
                    pls = new PolylineZShape();
                    pls.setPoints(points);
                    shapes.add(pls);
                }
                points = new ArrayList();
            } else {
                points.add(new PointZ(xx, yy, z.getDouble(i), m.getDouble(i)));
            }
            ++i;
        }
        if (points.size() >= 2) {
            pls = new PolylineZShape();
            pls.setPoints(points);
            shapes.add(pls);
        }
        return shapes;
    }

    public static List<PolygonShape> createPolygonShapes(List<Number> x, List<Number> y) {
        PolygonShape pls;
        ArrayList<PointD> points = new ArrayList<PointD>();
        ArrayList<PolygonShape> shapes = new ArrayList<PolygonShape>();
        for (int i = 0; i < x.size(); ++i) {
            double xx = x.get(i).doubleValue();
            double yy = y.get(i).doubleValue();
            if (Double.isNaN(xx)) {
                if (points.size() > 2) {
                    pls = new PolygonShape();
                    pls.setPoints(points);
                    shapes.add(pls);
                }
                points = new ArrayList();
                continue;
            }
            points.add(new PointD(xx, yy));
        }
        if (points.size() > 2) {
            pls = new PolygonShape();
            pls.setPoints(points);
            shapes.add(pls);
        }
        return shapes;
    }

    public static List<PolygonShape> createPolygonShapes(Array x, Array y) {
        PolygonShape pls;
        ArrayList<PointD> points = new ArrayList<PointD>();
        ArrayList<PolygonShape> shapes = new ArrayList<PolygonShape>();
        int i = 0;
        while ((long)i < x.getSize()) {
            double xx = x.getDouble(i);
            double yy = y.getDouble(i);
            if (Double.isNaN(xx)) {
                if (points.size() > 2) {
                    pls = new PolygonShape();
                    pls.setPoints(points);
                    shapes.add(pls);
                }
                points = new ArrayList();
            } else {
                points.add(new PointD(xx, yy));
            }
            ++i;
        }
        if (points.size() > 2) {
            pls = new PolygonShape();
            pls.setPoints(points);
            shapes.add(pls);
        }
        return shapes;
    }

    public static PolygonShape createPolygonShape(List<Number> x_p, List<Number> y_p) {
        PolygonShape ps = new PolygonShape();
        ArrayList<PointD> points = new ArrayList<PointD>();
        for (int i = 0; i < x_p.size(); ++i) {
            points.add(new PointD(x_p.get(i).doubleValue(), y_p.get(i).doubleValue()));
        }
        if (!((PointD)points.get(points.size() - 1)).equals((PointD)points.get(0))) {
            points.add((PointD)((PointD)points.get(0)).clone());
        }
        ps.setPoints(points);
        return ps;
    }

    public static PolygonShape createPolygonShape(List<List<Number>> xy) {
        PolygonShape ps = new PolygonShape();
        ArrayList<PointD> points = new ArrayList<PointD>();
        for (List<Number> xy1 : xy) {
            points.add(new PointD(xy1.get(0).doubleValue(), xy1.get(1).doubleValue()));
        }
        if (!((PointD)points.get(points.size() - 1)).equals((PointD)points.get(0))) {
            points.add((PointD)((PointD)points.get(0)).clone());
        }
        ps.setPoints(points);
        return ps;
    }

    public static PolygonShape createPolygon(Array xa, Array ya) {
        int n = (int)xa.getSize();
        ArrayList<PointD> points = new ArrayList<PointD>();
        IndexIterator xIter = xa.getIndexIterator();
        IndexIterator yIter = ya.getIndexIterator();
        while (xIter.hasNext()) {
            double x = xIter.getDoubleNext();
            double y = yIter.getDoubleNext();
            PointD p = new PointD(x, y);
            points.add(p);
        }
        if (points.size() > 2) {
            PolygonShape pgs = new PolygonShape();
            pgs.setPoints(points);
            return pgs;
        }
        return null;
    }

    public static PolygonShape createPolygonShape(Array xy) {
        int n = xy.getShape()[0];
        ArrayList<PointD> points = new ArrayList<PointD>();
        IndexIterator iter = xy.getIndexIterator();
        while (iter.hasNext()) {
            double x = iter.getDoubleNext();
            double y = iter.getDoubleNext();
            PointD p = new PointD(x, y);
            points.add(p);
        }
        if (points.size() > 2) {
            PolygonShape pgs = new PolygonShape();
            pgs.setPoints(points);
            return pgs;
        }
        return null;
    }

    public static CircleShape createCircleShape(float x, float y, float radius) {
        ArrayList<PointD> points = new ArrayList<PointD>();
        points.add(new PointD((double)(x - radius), (double)y));
        points.add(new PointD((double)x, (double)(y - radius)));
        points.add(new PointD((double)(x + radius), (double)y));
        points.add(new PointD((double)x, (double)(y + radius)));
        CircleShape aPGS = new CircleShape();
        aPGS.setPoints(points);
        return aPGS;
    }
}

