/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.grib.collection;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import thredds.filesystem.MFileOS;
import thredds.inventory.MFile;
import ucar.nc2.util.IO;
import ucar.unidata.io.RandomAccessFile;
import ucar.unidata.util.StringUtil2;

public class GcMFile
implements MFile {
    public final File directory;
    public final String name;
    public final long lastModified;
    public final long length;
    public final int index;

    static List<GcMFile> makeFiles(File directory, List<MFile> files, Set<Integer> allFileSet) {
        ArrayList<GcMFile> result = new ArrayList<GcMFile>(files.size());
        String dirPath = StringUtil2.replace((String)directory.getPath(), (char)'\\', (String)"/");
        for (int index : allFileSet) {
            String filename;
            MFile file = files.get(index);
            if (file.getPath().startsWith(dirPath)) {
                filename = file.getPath().substring(dirPath.length());
                if (filename.startsWith("/")) {
                    filename = filename.substring(1);
                }
            } else {
                filename = file.getPath();
            }
            result.add(new GcMFile(directory, filename, file.getLastModified(), file.getLength(), index));
        }
        return result;
    }

    GcMFile(File directory, String name, long lastModified, long length, int index) {
        this.directory = directory;
        this.name = name;
        this.lastModified = lastModified;
        this.index = index;
        this.length = length;
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public long getLength() {
        return this.length;
    }

    public boolean isDirectory() {
        return false;
    }

    public String getPath() {
        String path = new File(this.directory, this.name).getPath();
        return StringUtil2.replace((String)path, (char)'\\', (String)"/");
    }

    public String getName() {
        return this.name;
    }

    public MFile getParent() {
        return new MFileOS(this.directory);
    }

    public int compareTo(MFile o) {
        return this.name.compareTo(o.getName());
    }

    @Nullable
    public Object getAuxInfo() {
        return null;
    }

    public void setAuxInfo(Object info) {
    }

    public File getDirectory() {
        return this.directory;
    }

    public String toString() {
        return "GcMFile{directory=" + this.directory + ", name='" + this.name + '\'' + ", lastModified=" + this.lastModified + ", length=" + this.length + ", index=" + this.index + '}';
    }

    public boolean exists() {
        return new File(this.directory, this.name).exists();
    }

    public FileInputStream getInputStream() throws FileNotFoundException {
        return new FileInputStream(new File(this.directory, this.name));
    }

    public void writeToStream(OutputStream outputStream) throws IOException {
        IO.copyFile((String)this.getPath(), (OutputStream)outputStream);
    }

    public void writeToStream(OutputStream outputStream, long offset, long maxBytes) throws IOException {
        try (RandomAccessFile randomAccessFile = RandomAccessFile.acquire((String)this.getPath());){
            IO.copyRafB((RandomAccessFile)randomAccessFile, (long)offset, (long)maxBytes, (OutputStream)outputStream);
        }
    }

    public GcMFile getChild(String newFilename) {
        throw new UnsupportedOperationException("GcMFile::getChild not implemented. Filename: " + this.getName());
    }

    public String relativize(MFile other) {
        throw new UnsupportedOperationException("GcMFile::relativize not implemented. Filename: " + this.getName());
    }
}

