/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.grib.collection;

import com.google.common.base.MoreObjects;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Formatter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.featurecollection.FeatureCollectionConfig;
import thredds.inventory.MFile;
import ucar.nc2.grib.GribIndexCache;
import ucar.nc2.grib.GribTables;
import ucar.nc2.grib.collection.GcMFile;
import ucar.nc2.grib.collection.GribCdmIndex;
import ucar.nc2.grib.collection.GribCollectionImmutable;
import ucar.nc2.grib.collection.GribHorizCoordSystem;
import ucar.nc2.grib.coord.Coordinate;
import ucar.nc2.grib.coord.CoordinateRuntime;
import ucar.nc2.grib.coord.CoordinateTime2D;
import ucar.nc2.grib.coord.CoordinateTimeAbstract;
import ucar.nc2.grib.coord.CoordinateTimeIntv;
import ucar.nc2.grib.grib1.Grib1Gds;
import ucar.nc2.grib.grib1.Grib1ParamTime;
import ucar.nc2.grib.grib1.Grib1SectionProductDefinition;
import ucar.nc2.grib.grib1.Grib1Variable;
import ucar.nc2.grib.grib1.tables.Grib1Customizer;
import ucar.nc2.grib.grib2.Grib2Gds;
import ucar.nc2.grib.grib2.Grib2Pds;
import ucar.nc2.grib.grib2.Grib2SectionProductDefinition;
import ucar.nc2.grib.grib2.Grib2Utils;
import ucar.nc2.grib.grib2.Grib2Variable;
import ucar.nc2.grib.grib2.table.Grib2Tables;
import ucar.nc2.time.CalendarDate;
import ucar.nc2.time.CalendarDateFormatter;
import ucar.nc2.time.CalendarDateRange;
import ucar.nc2.time.CalendarTimeZone;
import ucar.unidata.io.RandomAccessFile;
import ucar.unidata.util.Parameter;
import ucar.unidata.util.StringUtil2;

public class GribCollectionMutable
implements Closeable {
    private static final Logger logger = LoggerFactory.getLogger(GribCollectionMutable.class);
    static final long MISSING_RECORD = -1L;
    private static final CalendarDateFormatter cf = new CalendarDateFormatter("yyyyMMdd-HHmmss", new CalendarTimeZone("UTC"));
    protected final String name;
    protected final FeatureCollectionConfig config;
    protected final boolean isGrib1;
    protected File directory;
    protected String orgDirectory;
    public int version;
    public int center;
    public int subcenter;
    public int master;
    public int local;
    public int genProcessType;
    public int genProcessId;
    public int backProcessId;
    public List<Parameter> params;
    protected Map<Integer, MFile> fileMap;
    protected List<Dataset> datasets;
    protected CoordinateRuntime masterRuntime;
    protected GribTables cust;
    protected int indexVersion;
    protected CalendarDateRange dateRange;
    protected RandomAccessFile indexRaf;
    protected String indexFilename;
    protected long lastModified;
    protected long fileSize;
    private static int countGC;

    static MFile makeIndexMFile(String collectionName, File directory) {
        String nameNoBlanks = StringUtil2.replace((String)collectionName, (char)' ', (String)"_");
        return new GcMFile(directory, nameNoBlanks + ".ncx4", -1L, -1L, -1);
    }

    static String makeName(String collectionName, CalendarDate runtime) {
        String nameNoBlanks = StringUtil2.replace((String)collectionName, (char)' ', (String)"_");
        return nameNoBlanks + "-" + cf.toString(runtime);
    }

    void setCalendarDateRange(long startMsecs, long endMsecs) {
        this.dateRange = CalendarDateRange.of((CalendarDate)CalendarDate.of((long)startMsecs), (CalendarDate)CalendarDate.of((long)endMsecs));
    }

    protected GribCollectionMutable(String name, File directory, FeatureCollectionConfig config, boolean isGrib1) {
        ++countGC;
        this.name = name;
        this.directory = directory;
        this.config = config;
        this.isGrib1 = isGrib1;
        if (config == null) {
            logger.error("GribCollection {} has empty config%n", (Object)name);
        }
        if (name == null) {
            logger.error("GribCollection has null name dir={}%n", (Object)directory);
        }
    }

    void copyInfo(GribCollectionMutable from) {
        this.center = from.center;
        this.subcenter = from.subcenter;
        this.master = from.master;
        this.local = from.local;
        this.genProcessType = from.genProcessType;
        this.genProcessId = from.genProcessId;
        this.backProcessId = from.backProcessId;
    }

    public String getName() {
        return this.name;
    }

    public File getDirectory() {
        return this.directory;
    }

    public String getLocation() {
        if (this.indexRaf != null) {
            return this.indexRaf.getLocation();
        }
        return this.getIndexFilepathInCache();
    }

    public Collection<MFile> getFiles() {
        return this.fileMap.values();
    }

    public FeatureCollectionConfig getConfig() {
        return this.config;
    }

    public List<String> getFilenames() {
        ArrayList<String> result = new ArrayList<String>();
        for (MFile file : this.fileMap.values()) {
            result.add(file.getPath());
        }
        Collections.sort(result);
        return result;
    }

    @Nullable
    File getIndexParentFile() {
        if (this.indexRaf == null) {
            return null;
        }
        Path index = Paths.get(this.indexRaf.getLocation(), new String[0]);
        Path parent = index.getParent();
        return parent.toFile();
    }

    public String getFilename(int fileno) {
        return this.fileMap.get(fileno).getPath();
    }

    public List<Dataset> getDatasets() {
        return this.datasets;
    }

    Dataset makeDataset(GribCollectionImmutable.Type type) {
        Dataset result = new Dataset(type);
        this.datasets.add(result);
        return result;
    }

    Dataset getDatasetCanonical() {
        for (Dataset ds : this.datasets) {
            if (ds.gctype == GribCollectionImmutable.Type.Best) continue;
            return ds;
        }
        throw new IllegalStateException("GC.getDatasetCanonical failed on=" + this.name);
    }

    public void setFileMap(Map<Integer, MFile> fileMap) {
        this.fileMap = fileMap;
    }

    void setIndexRaf(RandomAccessFile indexRaf) {
        this.indexRaf = indexRaf;
        if (indexRaf != null) {
            this.indexFilename = indexRaf.getLocation();
        }
    }

    private String getIndexFilepathInCache() {
        File indexFile = GribCdmIndex.makeIndexFile(this.name, this.directory);
        return GribIndexCache.getFileOrCache(indexFile.getPath()).getPath();
    }

    File setOrgDirectory(String orgDirectory) {
        File indexFile;
        File parent;
        this.orgDirectory = orgDirectory;
        this.directory = new File(orgDirectory);
        if (!this.directory.exists() && (parent = (indexFile = new File(this.indexFilename)).getParentFile()).exists()) {
            this.directory = parent;
        }
        return this.directory;
    }

    @Override
    public void close() throws IOException {
        if (this.indexRaf != null) {
            this.indexRaf.close();
            this.indexRaf = null;
        }
    }

    VariableIndex makeVariableIndex(GroupGC g, GribTables customizer, int discipline, int center, int subcenter, byte[] rawPds, List<Integer> index, long recordsPos, int recordsLen) {
        return new VariableIndex(g, customizer, discipline, center, subcenter, rawPds, index, recordsPos, recordsLen);
    }

    VariableIndex makeVariableIndex(GroupGC group, VariableIndex from) {
        VariableIndex vip = new VariableIndex(group, from);
        group.addVariable(vip);
        return vip;
    }

    public void showIndex(Formatter f) {
        f.format("Class (%s)%n", this.getClass().getName());
        f.format("%s%n%n", this.toString());
        for (Dataset ds : this.datasets) {
            f.format("Dataset %s%n", new Object[]{ds.gctype});
            for (GroupGC g : ds.groups) {
                f.format(" Group %s%n", g.horizCoordSys.getId());
                for (VariableIndex v : g.variList) {
                    f.format("  %s%n", v.toStringShort());
                }
            }
        }
        if (this.fileMap == null) {
            f.format("Files empty%n", new Object[0]);
        } else {
            f.format("Files (%d)%n", this.fileMap.size());
            Iterator<Object> iterator = this.fileMap.keySet().iterator();
            while (iterator.hasNext()) {
                int index = (Integer)iterator.next();
                f.format("  %d: %s%n", index, this.fileMap.get(index));
            }
            f.format("%n", new Object[0]);
        }
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name).add("config", (Object)this.config).add("isGrib1", this.isGrib1).add("directory", (Object)this.directory).add("orgDirectory", (Object)this.orgDirectory).add("version", this.version).add("center", this.center).add("subcenter", this.subcenter).add("master", this.master).add("local", this.local).add("genProcessType", this.genProcessType).add("genProcessId", this.genProcessId).add("backProcessId", this.backProcessId).add("params", this.params).add("fileMap", this.fileMap).add("datasets", this.datasets).add("masterRuntime", (Object)this.masterRuntime).add("cust", (Object)this.cust).add("indexVersion", this.indexVersion).add("dateRange", (Object)this.dateRange).add("indexRaf", (Object)this.indexRaf).add("indexFilename", (Object)this.indexFilename).add("lastModified", this.lastModified).add("fileSize", this.fileSize).toString();
    }

    public String showLocation() {
        return "name=" + this.name + " directory=" + this.directory;
    }

    public GroupGC makeGroup() {
        return new GroupGC();
    }

    @Immutable
    public static class Record {
        public final int fileno;
        public final long pos;
        public final long bmsPos;
        public final int scanMode;

        public Record(int fileno, long pos, long bmsPos, int scanMode) {
            this.fileno = fileno;
            this.pos = pos;
            this.bmsPos = bmsPos;
            this.scanMode = scanMode;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("fileno", this.fileno).add("pos", this.pos).add("bmsPos", this.bmsPos).add("scanMode", this.scanMode).toString();
        }
    }

    public class VariableIndex
    implements Comparable<VariableIndex> {
        public final GroupGC group;
        public final int tableVersion;
        public final int discipline;
        public final int center;
        public final int subcenter;
        public final byte[] rawPds;
        public final long recordsPos;
        public final int recordsLen;
        public Object gribVariable;
        List<Integer> coordIndex;
        public final int category;
        public final int parameter;
        public final int levelType;
        public final int intvType;
        public final int ensDerivedType;
        public final int probType;
        public final int percentile;
        private String intvName;
        public final String probabilityName;
        public final boolean isLayer;
        public final boolean isEnsemble;
        public final int genProcessType;
        public final int spatialStatType;
        public int ndups;
        public int nrecords;
        public int nmissing;
        List<Coordinate> coords;

        private VariableIndex(GroupGC g, GribTables customizer, int discipline, int center, int subcenter, byte[] rawPds, List<Integer> index, long recordsPos, int recordsLen) {
            this.group = g;
            this.discipline = discipline;
            this.rawPds = rawPds;
            this.center = center;
            this.subcenter = subcenter;
            this.coordIndex = index;
            this.recordsPos = recordsPos;
            this.recordsLen = recordsLen;
            if (GribCollectionMutable.this.isGrib1) {
                Grib1Customizer cust = (Grib1Customizer)customizer;
                Grib1SectionProductDefinition pds = new Grib1SectionProductDefinition(rawPds);
                this.category = 0;
                this.tableVersion = pds.getTableVersion();
                this.parameter = pds.getParameterNumber();
                this.levelType = pds.getLevelType();
                Grib1ParamTime ptime = cust.getParamTime(pds);
                this.intvType = ptime.isInterval() ? pds.getTimeRangeIndicator() : -1;
                this.isLayer = cust.isLayer(pds.getLevelType());
                this.ensDerivedType = -1;
                this.probType = -1;
                this.probabilityName = null;
                this.percentile = -1;
                this.genProcessType = pds.getGenProcess();
                this.isEnsemble = pds.isEnsemble();
                this.spatialStatType = -1;
                this.gribVariable = new Grib1Variable(cust, pds, (Grib1Gds)g.getGdsHash(), GribCollectionMutable.this.config.gribConfig.useTableVersion, GribCollectionMutable.this.config.gribConfig.intvMerge, GribCollectionMutable.this.config.gribConfig.useCenter);
            } else {
                Grib2Tables cust2 = (Grib2Tables)customizer;
                Grib2SectionProductDefinition pdss = new Grib2SectionProductDefinition(rawPds);
                Grib2Pds pds = pdss.getPDS();
                assert (pds != null);
                this.tableVersion = -1;
                this.category = pds.getParameterCategory();
                this.parameter = pds.getParameterNumber();
                this.levelType = pds.getLevelType1();
                this.intvType = pds.getStatisticalProcessType();
                this.isLayer = Grib2Utils.isLayer(pds);
                if (pds.isEnsembleDerived()) {
                    Grib2Pds.PdsEnsembleDerived pdsDerived = (Grib2Pds.PdsEnsembleDerived)((Object)pds);
                    this.ensDerivedType = pdsDerived.getDerivedForecastType();
                } else {
                    this.ensDerivedType = -1;
                }
                if (pds.isProbability()) {
                    Grib2Pds.PdsProbability pdsProb = (Grib2Pds.PdsProbability)((Object)pds);
                    this.probabilityName = pdsProb.getProbabilityName();
                    this.probType = pdsProb.getProbabilityType();
                } else {
                    this.probType = -1;
                    this.probabilityName = null;
                }
                if (pds.isPercentile()) {
                    Grib2Pds.PdsPercentile pdsPctl = (Grib2Pds.PdsPercentile)((Object)pds);
                    this.percentile = pdsPctl.getPercentileValue();
                } else {
                    this.percentile = -1;
                }
                this.genProcessType = pds.getGenProcessType();
                this.isEnsemble = pds.isEnsemble();
                if (pds.isSpatialInterval()) {
                    Grib2Pds.PdsSpatialInterval pdsSpatial = (Grib2Pds.PdsSpatialInterval)((Object)pds);
                    this.spatialStatType = pdsSpatial.getSpatialStatisticalProcessType();
                } else {
                    this.spatialStatType = -1;
                }
                this.gribVariable = new Grib2Variable(cust2, discipline, center, subcenter, (Grib2Gds)g.getGdsHash(), pds, GribCollectionMutable.this.config.gribConfig.intvMerge, GribCollectionMutable.this.config.gribConfig.useGenType);
            }
        }

        protected VariableIndex(GroupGC g, VariableIndex other) {
            this.group = g;
            this.tableVersion = other.tableVersion;
            this.discipline = other.discipline;
            this.center = other.center;
            this.subcenter = other.subcenter;
            this.rawPds = other.rawPds;
            this.gribVariable = other.gribVariable;
            this.coordIndex = new ArrayList<Integer>(other.coordIndex);
            this.recordsPos = 0L;
            this.recordsLen = 0;
            this.category = other.category;
            this.parameter = other.parameter;
            this.levelType = other.levelType;
            this.intvType = other.intvType;
            this.isLayer = other.isLayer;
            this.ensDerivedType = other.ensDerivedType;
            this.probabilityName = other.probabilityName;
            this.probType = other.probType;
            this.genProcessType = other.genProcessType;
            this.spatialStatType = other.spatialStatType;
            this.isEnsemble = other.isEnsemble;
            this.percentile = other.percentile;
        }

        public List<Coordinate> getCoordinates() {
            ArrayList<Coordinate> result = new ArrayList<Coordinate>(this.coordIndex.size());
            for (int idx : this.coordIndex) {
                result.add(this.group.coords.get(idx));
            }
            return result;
        }

        @Nullable
        public Coordinate getCoordinate(Coordinate.Type want) {
            for (int idx : this.coordIndex) {
                if (this.group.coords.get(idx).getType() != want) continue;
                return this.group.coords.get(idx);
            }
            return null;
        }

        public int getCoordinateIdx(Coordinate.Type want) {
            for (int idx : this.coordIndex) {
                if (this.group.coords.get(idx).getType() != want) continue;
                return idx;
            }
            return -1;
        }

        @Nullable
        public String getTimeIntvName() {
            if (this.intvName != null) {
                return this.intvName;
            }
            CoordinateTimeIntv timeiCoord = (CoordinateTimeIntv)this.getCoordinate(Coordinate.Type.timeIntv);
            if (timeiCoord != null) {
                this.intvName = timeiCoord.getTimeIntervalName();
                return this.intvName;
            }
            CoordinateTime2D time2DCoord = (CoordinateTime2D)this.getCoordinate(Coordinate.Type.time2D);
            if (time2DCoord == null || !time2DCoord.isTimeInterval()) {
                return null;
            }
            this.intvName = time2DCoord.getTimeIntervalName();
            return this.intvName;
        }

        public String id() {
            return this.discipline + "-" + this.category + "-" + this.parameter;
        }

        public int getVarid() {
            return (this.discipline << 16) + (this.category << 8) + this.parameter;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("tableVersion", this.tableVersion).add("discipline", this.discipline).add("category", this.category).add("parameter", this.parameter).add("levelType", this.levelType).add("intvType", this.intvType).add("ensDerivedType", this.ensDerivedType).add("probType", this.probType).add("intvName", (Object)this.intvName).add("probabilityName", (Object)this.probabilityName).add("isLayer", this.isLayer).add("genProcessType", this.genProcessType).add("cdmHash", this.gribVariable.hashCode()).toString();
        }

        public String toStringComplete() {
            return MoreObjects.toStringHelper((Object)this).add("group", (Object)this.group).add("tableVersion", this.tableVersion).add("discipline", this.discipline).add("center", this.center).add("subcenter", this.subcenter).add("recordsPos", this.recordsPos).add("recordsLen", this.recordsLen).add("gribVariable", this.gribVariable).add("coordIndex", this.coordIndex).add("category", this.category).add("parameter", this.parameter).add("levelType", this.levelType).add("intvType", this.intvType).add("ensDerivedType", this.ensDerivedType).add("probType", this.probType).add("intvName", (Object)this.intvName).add("probabilityName", (Object)this.probabilityName).add("isLayer", this.isLayer).add("isEnsemble", this.isEnsemble).add("genProcessType", this.genProcessType).add("spatialStatType", this.spatialStatType).toString();
        }

        public String toStringShort() {
            try (Formatter sb = new Formatter();){
                sb.format("Variable {%d-%d-%d", this.discipline, this.category, this.parameter);
                sb.format(", levelType=%d", this.levelType);
                sb.format(", intvType=%d", this.intvType);
                if (this.intvName != null && !this.intvName.isEmpty()) {
                    sb.format(" intv=%s", this.intvName);
                }
                if (this.probabilityName != null && !this.probabilityName.isEmpty()) {
                    sb.format(" prob=%s", this.probabilityName);
                }
                sb.format(" cdmHash=%d}", this.gribVariable.hashCode());
                String string = sb.toString();
                return string;
            }
        }

        @Override
        public int compareTo(@Nonnull VariableIndex o) {
            int r = this.discipline - o.discipline;
            if (r != 0) {
                return r;
            }
            r = this.category - o.category;
            if (r != 0) {
                return r;
            }
            r = this.parameter - o.parameter;
            if (r != 0) {
                return r;
            }
            r = this.levelType - o.levelType;
            if (r != 0) {
                return r;
            }
            r = this.intvType - o.intvType;
            return r;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof VariableIndex)) {
                return false;
            }
            VariableIndex that = (VariableIndex)o;
            return this.gribVariable.equals(that.gribVariable);
        }

        public int hashCode() {
            return this.gribVariable.hashCode();
        }
    }

    public class GroupGC
    implements Comparable<GroupGC> {
        GribHorizCoordSystem horizCoordSys;
        final List<VariableIndex> variList;
        List<Coordinate> coords;
        int[] filenose;
        HashMap<VariableIndex, VariableIndex> varMap;
        boolean isTwoD = true;
        private CalendarDateRange dateRange;

        GroupGC() {
            this.variList = new ArrayList<VariableIndex>();
            this.coords = new ArrayList<Coordinate>();
        }

        GroupGC(GroupGC from) {
            this.horizCoordSys = from.horizCoordSys;
            this.variList = new ArrayList<VariableIndex>(from.variList.size());
            this.coords = new ArrayList<Coordinate>(from.coords.size());
            this.isTwoD = from.isTwoD;
        }

        public VariableIndex addVariable(VariableIndex vi) {
            this.variList.add(vi);
            return vi;
        }

        public GribCollectionMutable getGribCollection() {
            return GribCollectionMutable.this;
        }

        public Iterable<VariableIndex> getVariables() {
            return this.variList;
        }

        public Iterable<Coordinate> getCoordinates() {
            return this.coords;
        }

        public String getId() {
            return this.horizCoordSys.getId();
        }

        public String getDescription() {
            return this.horizCoordSys.getDescription();
        }

        public byte[] getGdsBytes() {
            return this.horizCoordSys.getRawGds();
        }

        public Object getGdsHash() {
            return this.horizCoordSys.getGdsHash();
        }

        @Override
        public int compareTo(@Nonnull GroupGC o) {
            return this.getDescription().compareTo(o.getDescription());
        }

        public List<MFile> getFiles() {
            ArrayList<MFile> result = new ArrayList<MFile>();
            if (this.filenose == null) {
                return result;
            }
            for (int fileno : this.filenose) {
                result.add(GribCollectionMutable.this.fileMap.get(fileno));
            }
            Collections.sort(result);
            return result;
        }

        public List<String> getFilenames() {
            ArrayList<String> result = new ArrayList<String>();
            if (this.filenose == null) {
                return result;
            }
            for (int fileno : this.filenose) {
                result.add(GribCollectionMutable.this.fileMap.get(fileno).getPath());
            }
            Collections.sort(result);
            return result;
        }

        public VariableIndex findVariableByHash(VariableIndex want) {
            if (this.varMap == null) {
                this.varMap = new HashMap(this.variList.size() * 2);
                for (VariableIndex vi : this.variList) {
                    VariableIndex old = this.varMap.put(vi, vi);
                    if (old == null) continue;
                    logger.error("GribCollectionMutable has duplicate variable hash {} == {}", (Object)vi, (Object)old);
                }
            }
            return this.varMap.get(want);
        }

        public CalendarDateRange getCalendarDateRange() {
            if (this.dateRange == null) {
                CalendarDateRange result = null;
                for (Coordinate coord : this.coords) {
                    switch (coord.getType()) {
                        case time: 
                        case timeIntv: 
                        case time2D: {
                            CoordinateTimeAbstract time = (CoordinateTimeAbstract)coord;
                            CalendarDateRange range = time.makeCalendarDateRange(null);
                            result = result == null ? range : result.extend(range);
                        }
                    }
                }
                this.dateRange = result;
            }
            return this.dateRange;
        }

        public int getNFiles() {
            if (this.filenose == null) {
                return 0;
            }
            return this.filenose.length;
        }

        public void show(Formatter f) {
            f.format("Group %s (%d) isTwoD=%s%n", this.horizCoordSys.getId(), this.horizCoordSys.getGdsHash().hashCode(), this.isTwoD);
            f.format(" nfiles %d%n", this.filenose == null ? 0 : this.filenose.length);
            f.format(" hcs = %s%n", this.horizCoordSys.getHcs());
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("horizCoordSys", (Object)this.horizCoordSys).add("variList", this.variList).add("coords", this.coords).add("filenose", (Object)this.filenose).add("varMap", this.varMap).add("isTwoD", this.isTwoD).add("dateRange", (Object)this.dateRange).toString();
        }
    }

    public class Dataset {
        public GribCollectionImmutable.Type gctype;
        List<GroupGC> groups;

        public Dataset(GribCollectionImmutable.Type type) {
            this.gctype = type;
            this.groups = new ArrayList<GroupGC>();
        }

        Dataset(Dataset from) {
            this.gctype = from.gctype;
            this.groups = new ArrayList<GroupGC>(from.groups.size());
        }

        GroupGC addGroupCopy(GroupGC from) {
            GroupGC g = new GroupGC(from);
            this.groups.add(g);
            return g;
        }

        public List<GroupGC> getGroups() {
            return this.groups;
        }
    }
}

