/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.ui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;

public class WrappingLayout
implements LayoutManager {
    public static final int LEFT = 0;
    public static final int CENTER = 1;
    public static final int RIGHT = 2;
    public static final int LEADING = 3;
    public static final int TRAILING = 4;
    int align;
    int hgap;
    int vgap;

    public WrappingLayout() {
        this(1, 5, 5);
    }

    public WrappingLayout(int align) {
        this(align, 5, 5);
    }

    public WrappingLayout(int align, int hgap, int vgap) {
        this.hgap = hgap;
        this.vgap = vgap;
        this.setAlignment(align);
    }

    public int getAlignment() {
        return this.align;
    }

    public void setAlignment(int align) {
        switch (align) {
            case 3: {
                this.align = 0;
                break;
            }
            case 4: {
                this.align = 2;
                break;
            }
            default: {
                this.align = align;
            }
        }
    }

    public int getHgap() {
        return this.hgap;
    }

    public void setHgap(int hgap) {
        this.hgap = hgap;
    }

    public int getVgap() {
        return this.vgap;
    }

    public void setVgap(int vgap) {
        this.vgap = vgap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dimension preferredLayoutSize(Container parent) {
        Object object = parent.getTreeLock();
        synchronized (object) {
            Dimension dim = new Dimension(0, 0);
            int maxWidth = 0;
            int componentCount = parent.getComponentCount();
            for (int i = 0; i < componentCount; ++i) {
                Component c = parent.getComponent(i);
                if (!c.isVisible()) continue;
                Dimension d = c.getPreferredSize();
                if (dim.width + d.width + this.hgap <= parent.getWidth()) {
                    dim.height = Math.max(dim.height, d.height);
                } else {
                    dim.height += this.vgap + d.height;
                    dim.width = 0;
                }
                if (dim.width > 0) {
                    dim.width += this.hgap;
                }
                dim.width += d.width;
                if (dim.width <= maxWidth) continue;
                maxWidth = dim.width;
            }
            Insets insets = parent.getInsets();
            dim.width = Math.max(dim.width, maxWidth);
            dim.width += insets.left + insets.right + 2 * this.hgap;
            dim.height += insets.top + insets.bottom + 2 * this.vgap;
            return dim;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dimension minimumLayoutSize(Container parent) {
        Object object = parent.getTreeLock();
        synchronized (object) {
            Dimension dim = new Dimension(0, 0);
            int componentCount = parent.getComponentCount();
            for (int i = 0; i < componentCount; ++i) {
                Component c = parent.getComponent(i);
                if (!c.isVisible()) continue;
                Dimension d = c.getMinimumSize();
                dim.height = Math.max(dim.height, d.height);
                if (i > 0) {
                    dim.width += this.hgap;
                }
                dim.width += d.width;
            }
            Insets insets = parent.getInsets();
            dim.width += insets.left + insets.right + 2 * this.hgap;
            dim.height += insets.top + insets.bottom + 2 * this.vgap;
            return dim;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void layoutContainer(Container parent) {
        Object object = parent.getTreeLock();
        synchronized (object) {
            Insets insets = parent.getInsets();
            int maxWidth = parent.getWidth() - (insets.left + insets.right + this.hgap * 2);
            int componentCount = parent.getComponentCount();
            int x = 0;
            int y = insets.top + this.vgap;
            int rowh = 0;
            int start = 0;
            boolean ltr = parent.getComponentOrientation().isLeftToRight();
            for (int i = 0; i < componentCount; ++i) {
                Component c = parent.getComponent(i);
                if (!c.isVisible()) continue;
                Dimension d = c.getPreferredSize();
                c.setSize(d.width, d.height);
                if (x == 0 || x + d.width <= maxWidth) {
                    if (x > 0) {
                        x += this.hgap;
                    }
                    x += d.width;
                    rowh = Math.max(rowh, d.height);
                    continue;
                }
                rowh = this.moveComponents(parent, insets.left + this.hgap, y, maxWidth - x, rowh, start, i, ltr);
                x = d.width;
                y += this.vgap + rowh;
                rowh = d.height;
                start = i;
            }
            this.moveComponents(parent, insets.left + this.hgap, y, maxWidth - x, rowh, start, componentCount, ltr);
        }
    }

    private int moveComponents(Container parent, int x, int y, int width, int height, int rowStart, int rowEnd, boolean ltr) {
        switch (this.align) {
            case 0: {
                x += ltr ? 0 : width;
                break;
            }
            case 1: {
                x += width / 2;
                break;
            }
            case 2: {
                x += ltr ? width : 0;
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                x += width;
            }
        }
        for (int i = rowStart; i < rowEnd; ++i) {
            Component c = parent.getComponent(i);
            if (!c.isVisible()) continue;
            int cy = y + (height - c.getHeight()) / 2;
            if (ltr) {
                c.setLocation(x, cy);
            } else {
                c.setLocation(parent.getWidth() - x - c.getWidth(), cy);
            }
            x += c.getWidth() + this.hgap;
        }
        return height;
    }

    @Override
    public void addLayoutComponent(String name, Component comp) {
    }

    @Override
    public void removeLayoutComponent(Component comp) {
    }
}

