/*
 * Decompiled with CFR 0.152.
 */
package org.meteothink.imep.verification;

import java.util.List;
import org.meteothink.imep.verification.MethodType;
import org.meteothink.imep.verification.VerifyMethod;

public class MultiCategoryMethod
extends VerifyMethod
implements Cloneable {
    private double[] _categoryValues;

    public MultiCategoryMethod() {
        this.setMethodType(MethodType.MULTICATEGORY);
    }

    public MultiCategoryMethod(List<Number> value) {
        this.setMethodType(MethodType.MULTICATEGORY);
        this._categoryValues = new double[value.size()];
        for (int i = 0; i < value.size(); ++i) {
            this._categoryValues[i] = value.get(i).doubleValue();
        }
    }

    public double[] getCategoryValues() {
        return this._categoryValues;
    }

    public void setCategoryValues(double[] value) {
        this._categoryValues = value;
    }

    public void setCategoryValues(List<Number> value) {
        this._categoryValues = new double[value.size()];
        for (int i = 0; i < value.size(); ++i) {
            this._categoryValues[i] = value.get(i).doubleValue();
        }
    }

    public int getCategoryNum() {
        return this._categoryValues.length + 1;
    }

    public String valuesToString() {
        String str = String.valueOf(this._categoryValues[0]);
        for (int i = 1; i < this._categoryValues.length; ++i) {
            str = str + ";" + String.valueOf(this._categoryValues[i]);
        }
        return str;
    }

    public void setValues(String str) {
        str = str.trim();
        String[] vstrs = str.split(";");
        this._categoryValues = new double[vstrs.length];
        for (int i = 0; i < vstrs.length; ++i) {
            this._categoryValues[i] = Double.parseDouble(vstrs[i]);
        }
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

