/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.bufr;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.ma2.Array;
import ucar.ma2.ArraySequence;
import ucar.ma2.ArrayStructure;
import ucar.ma2.Section;
import ucar.ma2.StructureData;
import ucar.ma2.StructureDataIterator;
import ucar.nc2.Group;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Sequence;
import ucar.nc2.Structure;
import ucar.nc2.Variable;
import ucar.nc2.constants.DataFormatType;
import ucar.nc2.iosp.AbstractIOServiceProvider;
import ucar.nc2.iosp.bufr.BufrConfig;
import ucar.nc2.iosp.bufr.BufrIospBuilder;
import ucar.nc2.iosp.bufr.Construct2;
import ucar.nc2.iosp.bufr.DataDescriptor;
import ucar.nc2.iosp.bufr.Message;
import ucar.nc2.iosp.bufr.MessageCompressedDataReader;
import ucar.nc2.iosp.bufr.MessageScanner;
import ucar.nc2.iosp.bufr.MessageUncompressedDataReader;
import ucar.nc2.util.CancelTask;
import ucar.nc2.util.DebugFlags;
import ucar.unidata.io.RandomAccessFile;

public class BufrIosp2
extends AbstractIOServiceProvider {
    private static final Logger log = LoggerFactory.getLogger(BufrIosp2.class);
    public static final String obsRecordName = "obs";
    public static final String fxyAttName = "BUFR:TableB_descriptor";
    public static final String centerId = "BUFR:centerId";
    private static boolean debugIter;
    private MessageScanner scanner;
    private List<Message> protoMessages;
    private List<RootVariable> rootVariables;
    private HashSet<Integer> messHash;
    private boolean isSingle;
    private BufrConfig config;
    private Element iospParam;
    private int nelems = -1;

    public static void setDebugFlags(DebugFlags debugFlag) {
        debugIter = debugFlag.isSet("Bufr/iter");
    }

    public boolean isValidFile(RandomAccessFile raf) throws IOException {
        return MessageScanner.isValidFile(raf);
    }

    public boolean isBuilder() {
        return true;
    }

    public void build(RandomAccessFile raf, Group.Builder rootGroup, CancelTask cancelTask) throws IOException {
        super.open(raf, rootGroup.getNcfile(), cancelTask);
        this.scanner = new MessageScanner(raf);
        Message protoMessage = this.scanner.getFirstDataMessage();
        if (protoMessage == null) {
            throw new IOException("No data messages in the file= " + raf.getLocation());
        }
        if (!protoMessage.isTablesComplete()) {
            throw new IllegalStateException("BUFR file has incomplete tables");
        }
        this.protoMessages = new ArrayList<Message>();
        this.protoMessages.add(protoMessage);
        int category = protoMessage.ids.getCategory();
        ArrayList<Integer> categories = new ArrayList<Integer>();
        categories.add(category);
        while (this.scanner.hasNext()) {
            Message message = this.scanner.next();
            if (categories.contains(message.ids.getCategory())) continue;
            this.protoMessages.add(message);
            categories.add(message.ids.getCategory());
        }
        this.config = BufrConfig.openFromMessage(raf, protoMessage, this.iospParam);
        if (this.protoMessages.size() == 1) {
            new BufrIospBuilder(protoMessage, this.config, rootGroup, raf.getLocation());
        } else {
            ArrayList<BufrConfig> configs = new ArrayList<BufrConfig>();
            for (Message message : this.protoMessages) {
                configs.add(BufrConfig.openFromMessage(raf, message, this.iospParam));
            }
            new BufrIospBuilder(protoMessage, configs, rootGroup, raf.getLocation());
        }
        this.isSingle = false;
    }

    public void buildFinish(NetcdfFile ncfile) {
        this.rootVariables = new ArrayList<RootVariable>();
        if (this.protoMessages.size() == 1) {
            Structure obsStructure = (Structure)ncfile.findVariable(obsRecordName);
            this.connectSequences((List<Variable>)obsStructure.getVariables(), this.protoMessages.get(0).getRootDataDescriptor().getSubKeys());
            this.rootVariables.add(new RootVariable(this.protoMessages.get(0), obsStructure));
        } else {
            for (int i = 0; i < this.protoMessages.size(); ++i) {
                Structure variable = (Structure)ncfile.getVariables().get(i);
                Message message = this.protoMessages.get(i);
                this.connectSequences((List<Variable>)variable.getVariables(), message.getRootDataDescriptor().getSubKeys());
                this.rootVariables.add(new RootVariable(message, variable));
            }
        }
    }

    private void connectSequences(List<Variable> variables, List<DataDescriptor> dataDescriptors) {
        for (Variable v : variables) {
            if (v instanceof Sequence) {
                this.findDataDescriptor(dataDescriptors, v.getShortName()).ifPresent(dds -> {
                    dds.refersTo = (Sequence)v;
                });
            }
            if (!(v instanceof Structure)) continue;
            this.findDataDescriptor(dataDescriptors, v.getShortName()).ifPresent(dds -> this.connectSequences((List<Variable>)((Structure)v).getVariables(), dds.getSubKeys()));
        }
    }

    private Optional<DataDescriptor> findDataDescriptor(List<DataDescriptor> dataDescriptors, String name) {
        Optional<DataDescriptor> ddsOpt = dataDescriptors.stream().filter(d -> name.equals(d.name)).findFirst();
        if (ddsOpt.isPresent()) {
            return ddsOpt;
        }
        throw new IllegalStateException("DataDescriptor does not contain " + name);
    }

    public void open(RandomAccessFile raf, NetcdfFile ncfile, CancelTask cancelTask) throws IOException {
        Object message;
        super.open(raf, ncfile, cancelTask);
        this.scanner = new MessageScanner(raf);
        Message protoMessage = this.scanner.getFirstDataMessage();
        if (protoMessage == null) {
            throw new IOException("No data messages in the file= " + ncfile.getLocation());
        }
        if (!protoMessage.isTablesComplete()) {
            throw new IllegalStateException("BUFR file has incomplete tables");
        }
        this.protoMessages = new ArrayList<Message>();
        this.protoMessages.add(protoMessage);
        int category = protoMessage.ids.getCategory();
        ArrayList<Integer> categories = new ArrayList<Integer>();
        categories.add(category);
        while (this.scanner.hasNext()) {
            message = this.scanner.next();
            if (categories.contains(((Message)message).ids.getCategory())) continue;
            this.protoMessages.add((Message)message);
            categories.add(((Message)message).ids.getCategory());
        }
        this.config = BufrConfig.openFromMessage(raf, protoMessage, this.iospParam);
        if (this.protoMessages.size() == 1) {
            message = new Construct2(protoMessage, this.config, ncfile);
        } else {
            ArrayList<BufrConfig> configs = new ArrayList<BufrConfig>();
            for (Message message2 : this.protoMessages) {
                configs.add(BufrConfig.openFromMessage(raf, message2, this.iospParam));
            }
            Construct2 construct2 = new Construct2(protoMessage, configs, ncfile);
        }
        ncfile.finish();
        this.buildFinish(ncfile);
        this.isSingle = false;
    }

    public void open(RandomAccessFile raf, NetcdfFile ncfile, Message single) throws IOException {
        this.raf = raf;
        Message protoMessage = single;
        protoMessage.getRootDataDescriptor();
        if (!protoMessage.isTablesComplete()) {
            throw new IllegalStateException("BUFR file has incomplete tables");
        }
        BufrConfig config = BufrConfig.openFromMessage(raf, protoMessage, null);
        Construct2 construct = new Construct2(protoMessage, config, ncfile);
        Sequence obsStructure = construct.getObsStructure();
        this.isSingle = true;
        ncfile.finish();
        this.ncfile = ncfile;
    }

    public Object sendIospMessage(Object message) {
        if (message instanceof Element) {
            this.iospParam = (Element)message;
            this.iospParam.detach();
            return true;
        }
        return super.sendIospMessage(message);
    }

    public BufrConfig getConfig() {
        return this.config;
    }

    public Element getElem() {
        return this.iospParam;
    }

    public Array readData(Variable v2, Section section) {
        RootVariable rootVariable = this.findRootSequence(v2);
        Structure obsStructure = rootVariable.getVariable();
        return new ArraySequence(obsStructure.makeStructureMembers(), (StructureDataIterator)new SeqIter(rootVariable), this.nelems);
    }

    public StructureDataIterator getStructureIterator(Structure s, int bufferSize) {
        RootVariable rootVariable = this.findRootSequence((Variable)s);
        return this.isSingle ? new SeqIterSingle(rootVariable) : new SeqIter(rootVariable);
    }

    private Structure findRootSequence() {
        return (Structure)this.ncfile.findVariable(obsRecordName);
    }

    private RootVariable findRootSequence(Variable var) {
        for (RootVariable rootVariable : this.rootVariables) {
            if (!rootVariable.getVariable().getShortName().equals(var.getShortName())) continue;
            return rootVariable;
        }
        return null;
    }

    public String getDetailInfo() {
        Formatter ff = new Formatter();
        ff.format("%s", super.getDetailInfo());
        this.protoMessages.get(0).dump(ff);
        ff.format("%n", new Object[0]);
        this.config.show(ff);
        return ff.toString();
    }

    public String getFileTypeId() {
        return DataFormatType.BUFR.getDescription();
    }

    public String getFileTypeDescription() {
        return "WMO Binary Universal Form";
    }

    private class SeqIterSingle
    implements StructureDataIterator {
        StructureDataIterator currIter;
        int recnum;
        Message protoMessage;
        Structure obsStructure;

        SeqIterSingle(Message message, Structure structure) {
            this.protoMessage = message;
            this.obsStructure = structure;
            this.reset();
        }

        SeqIterSingle(RootVariable rootVariable) {
            this(rootVariable.protoMessage, rootVariable.variable);
        }

        public StructureDataIterator reset() {
            this.recnum = 0;
            this.currIter = null;
            return this;
        }

        public boolean hasNext() throws IOException {
            if (this.currIter == null) {
                this.currIter = this.readProtoMessage();
                if (this.currIter == null) {
                    BufrIosp2.this.nelems = this.recnum;
                    return false;
                }
            }
            return this.currIter.hasNext();
        }

        public StructureData next() throws IOException {
            ++this.recnum;
            return this.currIter.next();
        }

        private StructureDataIterator readProtoMessage() throws IOException {
            ArrayStructure as;
            Message m = this.protoMessage;
            if (m.dds.isCompressed()) {
                MessageCompressedDataReader reader = new MessageCompressedDataReader();
                as = reader.readEntireMessage(this.obsStructure, this.protoMessage, m, BufrIosp2.this.raf, null);
            } else {
                MessageUncompressedDataReader reader = new MessageUncompressedDataReader();
                as = reader.readEntireMessage(this.obsStructure, this.protoMessage, m, BufrIosp2.this.raf, null);
            }
            return as.getStructureDataIterator();
        }

        public int getCurrentRecno() {
            return this.recnum - 1;
        }

        public void close() {
            if (this.currIter != null) {
                this.currIter.close();
            }
            this.currIter = null;
        }
    }

    private class SeqIter
    implements StructureDataIterator {
        StructureDataIterator currIter;
        int recnum;
        Message protoMessage;
        Structure obsStructure;

        SeqIter(Message message, Structure structure) {
            this.protoMessage = message;
            this.obsStructure = structure;
            this.reset();
        }

        SeqIter(RootVariable rootVariable) {
            this(rootVariable.protoMessage, rootVariable.variable);
        }

        public StructureDataIterator reset() {
            this.recnum = 0;
            this.currIter = null;
            BufrIosp2.this.scanner.reset();
            return this;
        }

        public boolean hasNext() throws IOException {
            if (this.currIter == null) {
                this.currIter = this.readNextMessage();
                if (this.currIter == null) {
                    BufrIosp2.this.nelems = this.recnum;
                    return false;
                }
            }
            if (!this.currIter.hasNext()) {
                this.currIter = this.readNextMessage();
                return this.hasNext();
            }
            return true;
        }

        public StructureData next() throws IOException {
            ++this.recnum;
            return this.currIter.next();
        }

        private StructureDataIterator readNextMessage() throws IOException {
            if (!BufrIosp2.this.scanner.hasNext()) {
                return null;
            }
            Message m = BufrIosp2.this.scanner.next();
            if (m == null) {
                log.warn("BUFR scanner hasNext() true but next() null!");
                return null;
            }
            if (m.containsBufrTable()) {
                return this.readNextMessage();
            }
            if (!this.protoMessage.equals(m)) {
                if (BufrIosp2.this.messHash == null) {
                    BufrIosp2.this.messHash = new HashSet(20);
                }
                if (!BufrIosp2.this.messHash.contains(m.hashCode())) {
                    log.warn("File " + BufrIosp2.this.raf.getLocation() + " has different BUFR message types hash=" + this.protoMessage.hashCode() + "; skipping");
                    BufrIosp2.this.messHash.add(m.hashCode());
                }
                return this.readNextMessage();
            }
            ArrayStructure as = this.readMessage(m);
            return as.getStructureDataIterator();
        }

        private ArrayStructure readMessage(Message m) throws IOException {
            ArrayStructure as;
            if (m.dds.isCompressed()) {
                MessageCompressedDataReader reader = new MessageCompressedDataReader();
                as = reader.readEntireMessage(this.obsStructure, this.protoMessage, m, BufrIosp2.this.raf, null);
            } else {
                MessageUncompressedDataReader reader = new MessageUncompressedDataReader();
                as = reader.readEntireMessage(this.obsStructure, this.protoMessage, m, BufrIosp2.this.raf, null);
            }
            return as;
        }

        public int getCurrentRecno() {
            return this.recnum - 1;
        }

        public void close() {
            if (this.currIter != null) {
                this.currIter.close();
            }
            this.currIter = null;
            if (debugIter) {
                System.out.printf("BUFR read recnum %d%n", this.recnum);
            }
        }
    }

    private class RootVariable {
        private Message protoMessage;
        private Structure variable;

        public RootVariable(Message message, Structure variable) {
            this.protoMessage = message;
            this.variable = variable;
        }

        public Message getProtoMessage() {
            return this.protoMessage;
        }

        public Structure getVariable() {
            return this.variable;
        }
    }
}

