/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.sigmet;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Formatter;
import java.util.Iterator;
import ucar.ma2.DataType;
import ucar.ma2.IndexIterator;
import ucar.ma2.Range;
import ucar.nc2.iosp.sigmet.SigmetIOServiceProvider;
import ucar.nc2.iosp.sigmet.SigmetVolumeScan;
import ucar.unidata.io.RandomAccessFile;

public class Ray {
    private short bins;
    private short bins_actual;
    int dataRead;
    int offset;
    int offset1;
    private float range;
    private float step;
    private float az;
    private float elev;
    private int time;
    String varName;
    int nsweep;
    short datatype;
    int bytesPerBin;

    public Ray(float range, float step, float az, float elev, short bins, int time, int offset, int dataRead, int offset1, int nsweep, String name, short datatype, int bytesPerBin) {
        this(range, step, az, elev, bins, bins, time, offset, dataRead, offset1, nsweep, name, datatype, 1);
    }

    public Ray(float range, float step, float az, float elev, short bins, short bins_actual, int time, int offset, int dataRead, int offset1, int nsweep, String name, short datatype, int bytesPerBin) {
        this.setRange(range);
        this.setStep(step);
        this.setAz(az);
        this.setElev(elev);
        this.setBins(bins);
        this.setBinsActual(bins_actual);
        this.setTime(time);
        this.setOffset(offset);
        this.setDataRead(dataRead);
        this.setOffset1(offset1);
        this.setName(name);
        this.setNsweep(nsweep);
        this.setDataType(datatype);
        this.setBytesPerBin(bytesPerBin);
    }

    public short getDataType() {
        return this.datatype;
    }

    public void setDataType(short datatype) {
        this.datatype = datatype;
    }

    public int getBytesPerBin() {
        return this.bytesPerBin;
    }

    public void setBytesPerBin(int bytesPerBin) {
        this.bytesPerBin = bytesPerBin;
    }

    public float getRange() {
        return this.range;
    }

    public void setRange(float range) {
        this.range = range;
    }

    public float getStep() {
        return this.step;
    }

    public void setStep(float step) {
        this.step = step;
    }

    public int getNsweep() {
        return this.nsweep;
    }

    public void setNsweep(int nsweep) {
        this.nsweep = nsweep;
    }

    public float getAz() {
        if (this.az < 0.0f & this.az > -361.0f) {
            this.az = 360.0f + this.az;
        }
        return this.az;
    }

    public void setAz(float az) {
        this.az = az;
    }

    public float getElev() {
        return this.elev;
    }

    public void setElev(float elev) {
        this.elev = elev;
    }

    public short getBins() {
        return this.bins;
    }

    public void setBins(short bins) {
        this.bins = bins;
    }

    public short getBinsActual() {
        return this.bins_actual;
    }

    public void setBinsActual(short bins_actual) {
        this.bins_actual = bins_actual;
    }

    public int getTime() {
        return this.time;
    }

    public void setTime(int time) {
        this.time = time;
    }

    public int getOffset() {
        return this.offset;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public int getDataRead() {
        return this.dataRead;
    }

    public void setDataRead(int dataRead) {
        this.dataRead = dataRead;
    }

    public int getOffset1() {
        return this.offset1;
    }

    public void setOffset1(int offset1) {
        this.offset1 = offset1;
    }

    public void setName(String name) {
        this.varName = name;
    }

    public String getName() {
        return this.varName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof Ray) {
            Ray oo = (Ray)o;
            return this.range == oo.range & this.step == oo.step & this.az == oo.az & this.elev == oo.elev & this.bins == oo.bins & this.bins_actual == oo.bins_actual & this.time == oo.time & this.bytesPerBin == oo.bytesPerBin;
        }
        return false;
    }

    public int hashCode() {
        return new Float(this.range).hashCode() + new Float(this.step).hashCode() + new Float(this.az).hashCode() + new Float(this.elev).hashCode() + new Short(this.bins).hashCode() + new Short(this.bins_actual).hashCode() + new Integer(this.time).hashCode() + new Integer(this.bytesPerBin).hashCode();
    }

    public String toString() {
        Formatter sb = new Formatter();
        sb.format("Range=%f Step=%f", Float.valueOf(this.range), Float.valueOf(this.step));
        if (this.az > -361.0f & this.az < 0.0f) {
            this.az = 360.0f + this.az;
        }
        sb.format(" Az=%f Elev=%f Bins=%d (%d) Time=%d", Float.valueOf(this.az), Float.valueOf(this.elev), this.bins, this.bins_actual, this.time);
        return sb.toString();
    }

    public void readData(RandomAccessFile raf, Range gateRange, IndexIterator ii) throws IOException {
        Byte[] dd = new Byte[this.bins * this.bytesPerBin];
        int nb = 0;
        short dty = this.getDataType();
        int posInRay_absolute = 0;
        if (this.dataRead > 0) {
            raf.seek((long)this.offset);
            for (int i = 0; i < this.dataRead; ++i) {
                dd[i] = raf.readByte();
                if (++posInRay_absolute % this.bytesPerBin != 0) continue;
                ++nb;
            }
        }
        raf.seek((long)this.offset1);
        int cur_len = this.offset1;
        block6: while (nb < this.bins) {
            int num_zero;
            int dataRead1;
            short a00 = raf.readShort();
            cur_len += 2;
            if (a00 == 1) break;
            if (a00 < 0) {
                int nwords = a00 & Short.MAX_VALUE;
                dataRead1 = nwords * 2;
                boolean breakOuterLoop = false;
                if (cur_len % 6144 == 0) break;
                raf.seek((long)cur_len);
                for (int i = 0; i < dataRead1 && nb < this.bins; ++i) {
                    dd[posInRay_absolute] = raf.readByte();
                    if (++posInRay_absolute % this.bytesPerBin == 0) {
                        ++nb;
                    }
                    if (++cur_len % 6144 != 0) continue;
                    breakOuterLoop = true;
                    break;
                }
                if (!breakOuterLoop) continue;
                break;
            }
            if (!(a00 > 0 & a00 != 1)) continue;
            dataRead1 = num_zero = a00 * 2;
            for (int k = 0; k < dataRead1 && nb < this.bins; ++k) {
                dd[posInRay_absolute] = 0;
                if (++posInRay_absolute % this.bytesPerBin == 0) {
                    ++nb;
                }
                if (cur_len % 6144 == 0) continue block6;
            }
        }
        DataType dType = SigmetIOServiceProvider.calcDataType(dty, this.bytesPerBin);
        switch (dType) {
            case FLOAT: {
                int offset;
                int gateIdx;
                Iterator iterator = gateRange.iterator();
                while (iterator.hasNext()) {
                    gateIdx = (Integer)iterator.next();
                    if (gateIdx >= this.bins) {
                        ii.setFloatNext(Float.NaN);
                        continue;
                    }
                    if (gateIdx >= this.bins_actual) {
                        ii.setFloatNext(-999.99f);
                        continue;
                    }
                    offset = gateIdx * this.bytesPerBin;
                    Byte ddx = dd[offset];
                    if (ddx == null) {
                        ii.setFloatNext(-999.99f);
                        continue;
                    }
                    ii.setFloatNext(SigmetIOServiceProvider.calcData(SigmetIOServiceProvider.recHdr, dty, ddx));
                }
                break;
            }
            case DOUBLE: {
                int offset;
                int gateIdx;
                Iterator iterator = gateRange.iterator();
                while (iterator.hasNext()) {
                    gateIdx = (Integer)iterator.next();
                    if (gateIdx >= this.bins) {
                        ii.setDoubleNext(Double.NaN);
                        continue;
                    }
                    if (gateIdx >= this.bins_actual) {
                        ii.setDoubleNext(-999.99);
                        continue;
                    }
                    offset = gateIdx * this.bytesPerBin;
                    Byte ddx = dd[offset];
                    if (ddx == null) {
                        ii.setDoubleNext(-999.99);
                        continue;
                    }
                    byte ddx2 = dd[offset + 1];
                    int rawValue = ddx & 0xFF | (ddx2 & 0xFF) << 8;
                    ii.setDoubleNext(SigmetIOServiceProvider.calcData(SigmetIOServiceProvider.recHdr, dty, rawValue));
                }
                break;
            }
            case BYTE: {
                int offset;
                int gateIdx;
                Iterator iterator = gateRange.iterator();
                while (iterator.hasNext()) {
                    gateIdx = (Integer)iterator.next();
                    if (gateIdx >= this.bins) {
                        ii.setByteNext((byte)0);
                        continue;
                    }
                    if (gateIdx >= this.bins_actual) {
                        ii.setByteNext((byte)0);
                        continue;
                    }
                    offset = gateIdx * this.bytesPerBin;
                    Byte ddx = dd[offset];
                    if (ddx == null) {
                        ii.setByteNext((byte)0);
                        continue;
                    }
                    ii.setByteNext(ddx.byteValue());
                }
                break;
            }
            default: {
                int offset;
                int gateIdx;
                Iterator iterator = gateRange.iterator();
                while (iterator.hasNext()) {
                    gateIdx = (Integer)iterator.next();
                    if (gateIdx >= this.bins) {
                        ii.setObjectNext((Object)SigmetVolumeScan.MISSING_VALUE_BYTE_ARRAY_BB);
                        continue;
                    }
                    if (gateIdx >= this.bins_actual) {
                        ii.setObjectNext((Object)SigmetVolumeScan.MISSING_VALUE_BYTE_ARRAY_BB);
                        continue;
                    }
                    offset = gateIdx * this.bytesPerBin;
                    Byte ddx = dd[offset];
                    if (ddx == null) {
                        ii.setObjectNext((Object)SigmetVolumeScan.MISSING_VALUE_BYTE_ARRAY_BB);
                        continue;
                    }
                    byte[] b = new byte[this.bytesPerBin];
                    for (int i = 0; i < this.bytesPerBin; ++i) {
                        ddx = dd[offset + i];
                        b[i] = ddx == null ? (byte)0 : ddx;
                    }
                    ii.setObjectNext((Object)ByteBuffer.wrap(b));
                }
                break block0;
            }
        }
    }
}

