/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.array;

import java.util.function.LongFunction;
import org.ojalgo.array.DenseArray;
import org.ojalgo.array.OffHeapR032;
import org.ojalgo.array.OffHeapR064;
import org.ojalgo.array.OffHeapZ008;
import org.ojalgo.array.OffHeapZ016;
import org.ojalgo.array.OffHeapZ032;
import org.ojalgo.array.OffHeapZ064;
import org.ojalgo.function.BinaryFunction;
import org.ojalgo.function.FunctionSet;
import org.ojalgo.function.NullaryFunction;
import org.ojalgo.function.PrimitiveFunction;
import org.ojalgo.function.UnaryFunction;
import org.ojalgo.function.VoidFunction;
import org.ojalgo.function.aggregator.AggregatorSet;
import org.ojalgo.function.aggregator.PrimitiveAggregator;
import org.ojalgo.scalar.PrimitiveScalar;
import org.ojalgo.scalar.Scalar;
import org.ojalgo.structure.Access1D;
import org.ojalgo.type.math.MathType;

public abstract class OffHeapArray
extends DenseArray<Double> {
    public static final DenseArray.Factory<Double> R032 = new Factory(MathType.R032, OffHeapR032::new);
    public static final DenseArray.Factory<Double> R064 = new Factory(MathType.R064, OffHeapR064::new);
    public static final DenseArray.Factory<Double> Z008 = new Factory(MathType.Z008, OffHeapZ008::new);
    public static final DenseArray.Factory<Double> Z016 = new Factory(MathType.Z016, OffHeapZ016::new);
    public static final DenseArray.Factory<Double> Z032 = new Factory(MathType.Z032, OffHeapZ032::new);
    public static final DenseArray.Factory<Double> Z064 = new Factory(MathType.Z064, OffHeapZ064::new);
    @Deprecated
    public static final DenseArray.Factory<Double> NATIVE32 = R032;
    @Deprecated
    public static final DenseArray.Factory<Double> NATIVE64 = R064;
    private final long myCount;

    @Deprecated
    public static OffHeapArray makeNative32(long count) {
        return new OffHeapR032(count);
    }

    @Deprecated
    public static OffHeapArray makeNative64(long count) {
        return new OffHeapR064(count);
    }

    OffHeapArray(DenseArray.Factory<Double> factory, long count) {
        super(factory);
        this.myCount = count;
    }

    @Override
    public final void add(long index, double addend) {
        this.set(index, this.doubleValue(index) + addend);
    }

    @Override
    public final void add(long index, float addend) {
        this.set(index, this.floatValue(index) + addend);
    }

    @Override
    public final void add(long index, long addend) {
        this.set(index, this.longValue(index) + addend);
    }

    @Override
    public final void add(long index, int addend) {
        this.set(index, this.intValue(index) + addend);
    }

    @Override
    public final void add(long index, short addend) {
        this.set(index, this.shortValue(index) + addend);
    }

    @Override
    public final void add(long index, byte addend) {
        this.set(index, this.byteValue(index) + addend);
    }

    @Override
    public final long count() {
        return this.myCount;
    }

    @Override
    public void fillAll(Double value) {
        this.fill(0L, this.count(), 1L, value);
    }

    @Override
    public void fillOne(long index, Access1D<?> values, long valueIndex) {
        this.set(index, values.doubleValue(valueIndex));
    }

    @Override
    public void fillOne(long index, Double value) {
        this.set(index, value);
    }

    @Override
    public void fillOne(long index, NullaryFunction<?> supplier) {
        this.set(index, supplier.doubleValue());
    }

    @Override
    public Double get(long index) {
        return this.doubleValue(index);
    }

    @Override
    public void modifyOne(long index, UnaryFunction<Double> modifier) {
        this.set(index, modifier.invoke(this.doubleValue(index)));
    }

    @Override
    public void visitOne(long index, VoidFunction<Double> visitor) {
        visitor.accept(this.doubleValue(index));
    }

    @Override
    protected void exchange(long firstA, long firstB, long step, long count) {
        long tmpIndexA = firstA;
        long tmpIndexB = firstB;
        for (long i = 0L; i < count; ++i) {
            double tmpVal = this.doubleValue(tmpIndexA);
            this.set(tmpIndexA, this.doubleValue(tmpIndexB));
            this.set(tmpIndexB, tmpVal);
            tmpIndexA += step;
            tmpIndexB += step;
        }
    }

    @Override
    void modify(long extIndex, int intIndex, Access1D<Double> left, BinaryFunction<Double> function) {
        this.set((long)intIndex, function.invoke(left.doubleValue(extIndex), this.doubleValue(intIndex)));
    }

    @Override
    void modify(long extIndex, int intIndex, BinaryFunction<Double> function, Access1D<Double> right) {
        this.set((long)intIndex, function.invoke(this.doubleValue(intIndex), right.doubleValue(extIndex)));
    }

    @Override
    void modify(long extIndex, int intIndex, UnaryFunction<Double> function) {
        this.set((long)intIndex, function.invoke(this.doubleValue(intIndex)));
    }

    static final class Factory
    extends DenseArray.Factory<Double> {
        private final LongFunction<OffHeapArray> myConstructor;
        private final MathType myMathType;

        Factory(MathType mathType, LongFunction<OffHeapArray> constructor) {
            this.myMathType = mathType;
            this.myConstructor = constructor;
        }

        @Override
        public AggregatorSet<Double> aggregator() {
            return PrimitiveAggregator.getSet();
        }

        @Override
        public FunctionSet<Double> function() {
            return PrimitiveFunction.getSet();
        }

        @Override
        public DenseArray<Double> makeDenseArray(long size) {
            return this.myConstructor.apply(size);
        }

        @Override
        public Scalar.Factory<Double> scalar() {
            return PrimitiveScalar.FACTORY;
        }

        @Override
        long getCapacityLimit() {
            return Long.MAX_VALUE;
        }

        @Override
        MathType getMathType() {
            return this.myMathType;
        }
    }
}

