/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.array.operation;

import org.ojalgo.array.operation.ArrayOperation;
import org.ojalgo.scalar.Scalar;

public abstract class RotateRight
implements ArrayOperation {
    public static int THRESHOLD = 128;

    public static void invoke(double[] data, int structure, int colA, int colB, double cos, double sin) {
        int indexA = colA * structure;
        int indexB = colB * structure;
        for (int i = 0; i < structure; ++i) {
            double oldA = data[indexA];
            double oldB = data[indexB];
            data[indexA] = cos * oldA - sin * oldB;
            data[indexB] = cos * oldB + sin * oldA;
            ++indexA;
            ++indexB;
        }
    }

    public static void invoke(float[] data, int structure, int colA, int colB, float cos, float sin) {
        int indexA = colA * structure;
        int indexB = colB * structure;
        for (int i = 0; i < structure; ++i) {
            float oldA = data[indexA];
            float oldB = data[indexB];
            data[indexA] = cos * oldA - sin * oldB;
            data[indexB] = cos * oldB + sin * oldA;
            ++indexA;
            ++indexB;
        }
    }

    public static <N extends Scalar<N>> void invoke(N[] data, int structure, int colA, int colB, N cos, N sin) {
        int indexA = colA * structure;
        int indexB = colB * structure;
        for (int i = 0; i < structure; ++i) {
            N oldA = data[indexA];
            N oldB = data[indexB];
            data[indexA] = (Scalar)((Scalar)cos.multiply(oldA)).subtract((Scalar)sin.multiply(oldB)).get();
            data[indexB] = (Scalar)((Scalar)cos.multiply(oldB)).add((Scalar)sin.multiply(oldA)).get();
            ++indexA;
            ++indexB;
        }
    }
}

