/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.data.domain.finance;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.ojalgo.array.Array1D;
import org.ojalgo.function.aggregator.Aggregator;
import org.ojalgo.function.constant.PrimitiveMath;
import org.ojalgo.function.special.ErrorFunction;
import org.ojalgo.matrix.Primitive64Matrix;
import org.ojalgo.matrix.decomposition.Eigenvalue;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.matrix.store.PhysicalStore;
import org.ojalgo.matrix.store.Primitive64Store;
import org.ojalgo.random.Deterministic;
import org.ojalgo.random.RandomNumber;
import org.ojalgo.random.SampleSet;
import org.ojalgo.random.process.GeometricBrownianMotion;
import org.ojalgo.scalar.ComplexNumber;
import org.ojalgo.scalar.Scalar;
import org.ojalgo.series.CalendarDateSeries;
import org.ojalgo.series.CoordinationSet;
import org.ojalgo.series.TreeSeries;
import org.ojalgo.series.primitive.PrimitiveSeries;
import org.ojalgo.structure.Access1D;
import org.ojalgo.structure.Access2D;
import org.ojalgo.type.CalendarDate;
import org.ojalgo.type.CalendarDateUnit;

public abstract class FinanceUtils {
    public static double calculateValueAtRisk(double expRet, double stdDev, double confidence, double time) {
        double tmpConfidenceScale = PrimitiveMath.SQRT_TWO * ErrorFunction.erfi(PrimitiveMath.ONE - PrimitiveMath.TWO * (PrimitiveMath.ONE - confidence));
        return PrimitiveMath.MAX.invoke(PrimitiveMath.SQRT.invoke(time) * stdDev * tmpConfidenceScale - time * expRet, PrimitiveMath.ZERO);
    }

    public static GeometricBrownianMotion estimateExcessDiffusionProcess(CalendarDateSeries<?> priceSeries, CalendarDateSeries<?> riskFreeInterestRateSeries, CalendarDateUnit timeUnit) {
        SampleSet tmpSampleSet = FinanceUtils.makeExcessGrowthRateSampleSet(priceSeries, riskFreeInterestRateSeries);
        double tmpStepSize = priceSeries.getResolution().toDurationInMillis();
        double tmpExp = tmpSampleSet.getMean();
        double tmpVar = tmpSampleSet.getVariance();
        double tmpDiff = PrimitiveMath.SQRT.invoke(tmpVar / (tmpStepSize /= (double)timeUnit.toDurationInMillis()));
        double tmpDrift = tmpExp / tmpStepSize + tmpDiff * tmpDiff / PrimitiveMath.TWO;
        return new GeometricBrownianMotion(tmpDrift, tmpDiff);
    }

    public static CalendarDateSeries<RandomNumber> forecast(CalendarDateSeries<? extends Comparable<?>> series, int pointCount, CalendarDateUnit timeUnit, boolean includeOriginalSeries) {
        CalendarDateSeries<RandomNumber> retVal = new CalendarDateSeries<RandomNumber>(timeUnit);
        ((CalendarDateSeries)retVal.name(series.getName())).colour(series.getColour());
        double tmpSamplePeriod = (double)series.getAverageStepSize() / (double)timeUnit.toDurationInMillis();
        GeometricBrownianMotion tmpProcess = GeometricBrownianMotion.estimate(series.asPrimitive(), tmpSamplePeriod);
        if (includeOriginalSeries) {
            for (Map.Entry tmpEntry : series.entrySet()) {
                retVal.put((CalendarDate)tmpEntry.getKey(), (RandomNumber)new Deterministic((Comparable)tmpEntry.getValue()));
            }
        }
        CalendarDate tmpLastKey = (CalendarDate)series.lastKey();
        double tmpLastValue = Scalar.doubleValue(series.lastValue());
        tmpProcess.setValue(tmpLastValue);
        for (int i = 1; i <= pointCount; ++i) {
            retVal.put(tmpLastKey.step(i, timeUnit), (RandomNumber)tmpProcess.getDistribution(i));
        }
        return retVal;
    }

    public static CalendarDateSeries<BigDecimal> makeCalendarPriceSeries(double[] prices, Calendar startCalendar, CalendarDateUnit resolution) {
        CalendarDateSeries<BigDecimal> retVal = new CalendarDateSeries<BigDecimal>(resolution);
        FinanceUtils.copyValues(retVal, new CalendarDate(startCalendar), prices);
        return retVal;
    }

    public static <V extends Comparable<V>> Primitive64Matrix makeCovarianceMatrix(Collection<CalendarDateSeries<V>> timeSeriesCollection) {
        CoordinationSet tmpCoordinator = new CoordinationSet(timeSeriesCollection).prune();
        ArrayList<SampleSet> tmpSampleSets = new ArrayList<SampleSet>();
        for (CalendarDateSeries tmpTimeSeries : timeSeriesCollection) {
            double[] values = tmpCoordinator.get(tmpTimeSeries.getName()).asPrimitive().toRawCopy1D();
            int tmpSize1 = values.length - 1;
            double[] retVal = new double[tmpSize1];
            for (int i = 0; i < tmpSize1; ++i) {
                retVal[i] = PrimitiveMath.LOG.invoke(values[i + 1] / values[i]);
            }
            SampleSet tmpMakeUsingLogarithmicChanges = SampleSet.wrap(Access1D.wrap(retVal));
            tmpSampleSets.add(tmpMakeUsingLogarithmicChanges);
        }
        int tmpSize = timeSeriesCollection.size();
        Primitive64Matrix.DenseReceiver retValStore = (Primitive64Matrix.DenseReceiver)Primitive64Matrix.FACTORY.makeDense(tmpSize, tmpSize);
        double tmpToYearFactor = (double)CalendarDateUnit.YEAR.toDurationInMillis() / (double)tmpCoordinator.getResolution().toDurationInMillis();
        for (int j = 0; j < tmpSize; ++j) {
            SampleSet tmpColSet = (SampleSet)tmpSampleSets.get(j);
            for (int i = 0; i < tmpSize; ++i) {
                SampleSet tmpRowSet = (SampleSet)tmpSampleSets.get(i);
                retValStore.set((long)i, (long)j, tmpToYearFactor * tmpRowSet.getCovariance(tmpColSet));
            }
        }
        return (Primitive64Matrix)retValStore.get();
    }

    public static <N extends Comparable<N>> Primitive64Matrix makeCovarianceMatrix(List<CalendarDateSeries<N>> listOfTimeSeries, boolean mayBeMissingValues) {
        int tmpSize = listOfTimeSeries.size();
        CoordinationSet<N> tmpUncoordinated = new CoordinationSet<N>(listOfTimeSeries);
        CalendarDateUnit tmpDataResolution = tmpUncoordinated.getResolution();
        if (mayBeMissingValues) {
            tmpUncoordinated.complete();
        }
        CoordinationSet<N> tmpCoordinated = tmpUncoordinated.prune(tmpDataResolution);
        Primitive64Matrix.DenseReceiver tmpMatrixBuilder = (Primitive64Matrix.DenseReceiver)Primitive64Matrix.FACTORY.makeDense(tmpSize, tmpSize);
        double tmpToYearFactor = (double)CalendarDateUnit.YEAR.toDurationInMillis() / (double)tmpDataResolution.toDurationInMillis();
        SampleSet[] tmpSampleSets = new SampleSet[tmpSize];
        for (int j = 0; j < tmpSize; ++j) {
            PrimitiveSeries tmpPrimitiveSeries = tmpCoordinated.get(listOfTimeSeries.get(j).getName()).asPrimitive();
            SampleSet tmpSampleSet = SampleSet.wrap(tmpPrimitiveSeries.quotients().log().toDataSeries());
            tmpMatrixBuilder.set((long)j, (long)j, tmpToYearFactor * tmpSampleSet.getVariance());
            for (int i = 0; i < j; ++i) {
                double tmpCovariance = tmpToYearFactor * tmpSampleSets[i].getCovariance(tmpSampleSet);
                tmpMatrixBuilder.set((long)i, (long)j, tmpCovariance);
                tmpMatrixBuilder.set((long)j, (long)i, tmpCovariance);
            }
            tmpSampleSets[j] = tmpSampleSet;
        }
        return (Primitive64Matrix)tmpMatrixBuilder.get();
    }

    public static CalendarDateSeries<BigDecimal> makeDatePriceSeries(double[] prices, Date startDate, CalendarDateUnit resolution) {
        CalendarDateSeries<BigDecimal> retVal = new CalendarDateSeries<BigDecimal>(resolution);
        FinanceUtils.copyValues(retVal, new CalendarDate(startDate), prices);
        return retVal;
    }

    public static SampleSet makeExcessGrowthRateSampleSet(CalendarDateSeries<?> priceSeries, CalendarDateSeries<?> riskFreeInterestRateSeries) {
        if (priceSeries.size() != riskFreeInterestRateSeries.size()) {
            throw new IllegalArgumentException("The two series must have the same size (number of elements).");
        }
        if (!((CalendarDate)priceSeries.firstKey()).equals(riskFreeInterestRateSeries.firstKey())) {
            throw new IllegalArgumentException("The two series must have the same first key (date or calendar).");
        }
        if (!((CalendarDate)priceSeries.lastKey()).equals(riskFreeInterestRateSeries.lastKey())) {
            throw new IllegalArgumentException("The two series must have the same last key (date or calendar).");
        }
        double[] tmpPrices = priceSeries.asPrimitive().toRawCopy1D();
        double[] tmpRiskFreeInterestRates = riskFreeInterestRateSeries.asPrimitive().toRawCopy1D();
        Array1D retVal = (Array1D)Array1D.R064.make(tmpPrices.length - 1);
        CalendarDateUnit tmpUnit = priceSeries.getResolution();
        for (int i = 0; i < retVal.size(); ++i) {
            double tmpThisRiskFree = tmpRiskFreeInterestRates[i] / PrimitiveMath.HUNDRED;
            double tmpNextRiskFree = tmpRiskFreeInterestRates[i + 1] / PrimitiveMath.HUNDRED;
            double tmpAvgRiskFree = (tmpThisRiskFree + tmpNextRiskFree) / PrimitiveMath.TWO;
            double tmpRiskFreeGrowthRate = FinanceUtils.toGrowthRateFromAnnualReturn(tmpAvgRiskFree, tmpUnit);
            double tmpThisPrice = tmpPrices[i];
            double tmpNextPrice = tmpPrices[i + 1];
            double tmpPriceGrowthFactor = tmpNextPrice / tmpThisPrice;
            double tmpPriceGrowthRate = PrimitiveMath.LOG.invoke(tmpPriceGrowthFactor);
            double tmpAdjustedPriceGrowthRate = tmpPriceGrowthRate - tmpRiskFreeGrowthRate;
            retVal.set((long)i, tmpAdjustedPriceGrowthRate);
        }
        return SampleSet.wrap(retVal);
    }

    public static CalendarDateSeries<Double> makeNormalisedExcessPrice(CalendarDateSeries<?> priceSeries, CalendarDateSeries<?> riskFreeInterestRateSeries) {
        if (priceSeries.size() != riskFreeInterestRateSeries.size()) {
            throw new IllegalArgumentException("The two series must have the same size (number of elements).");
        }
        if (!((CalendarDate)priceSeries.firstKey()).equals(riskFreeInterestRateSeries.firstKey())) {
            throw new IllegalArgumentException("The two series must have the same first key (date or calendar).");
        }
        if (!((CalendarDate)priceSeries.lastKey()).equals(riskFreeInterestRateSeries.lastKey())) {
            throw new IllegalArgumentException("The two series must have the same last key (date or calendar).");
        }
        long[] tmpDates = priceSeries.getPrimitiveKeys();
        double[] tmpPrices = priceSeries.asPrimitive().toRawCopy1D();
        double[] tmpRiskFreeInterestRates = riskFreeInterestRateSeries.asPrimitive().toRawCopy1D();
        CalendarDateUnit tmpResolution = priceSeries.getResolution();
        CalendarDateSeries retVal = new CalendarDateSeries(tmpResolution);
        double tmpAggregatedExcessPrice = PrimitiveMath.ONE;
        ((TreeSeries)retVal).put(new CalendarDate(tmpDates[0]), tmpAggregatedExcessPrice);
        for (int i = 1; i < priceSeries.size(); ++i) {
            double tmpThisRiskFree = tmpRiskFreeInterestRates[i] / PrimitiveMath.HUNDRED;
            double tmpLastRiskFree = tmpRiskFreeInterestRates[i - 1] / PrimitiveMath.HUNDRED;
            double tmpAvgRiskFree = (tmpThisRiskFree + tmpLastRiskFree) / PrimitiveMath.TWO;
            double tmpRiskFreeGrowthFactor = FinanceUtils.toGrowthFactorFromAnnualReturn(tmpAvgRiskFree, tmpResolution);
            double tmpThisPrice = tmpPrices[i];
            double tmpLastPrice = tmpPrices[i - 1];
            double tmpPriceGrowthFactor = tmpThisPrice / tmpLastPrice;
            double tmpAdjustedPriceGrowthFactor = tmpPriceGrowthFactor / tmpRiskFreeGrowthFactor;
            ((TreeSeries)retVal).put(new CalendarDate(tmpDates[i]), tmpAggregatedExcessPrice *= tmpAdjustedPriceGrowthFactor);
        }
        return (CalendarDateSeries)((CalendarDateSeries)retVal.name(priceSeries.getName())).colour(priceSeries.getColour());
    }

    public static double toAnnualReturnFromGrowthFactor(double growthFactor, CalendarDateUnit growthFactorUnit) {
        double tmpGrowthFactorUnitsPerYear = growthFactorUnit.convert(CalendarDateUnit.YEAR);
        return PrimitiveMath.POW.invoke(growthFactor, tmpGrowthFactorUnitsPerYear) - PrimitiveMath.ONE;
    }

    public static double toAnnualReturnFromGrowthRate(double growthRate, CalendarDateUnit growthRateUnit) {
        double tmpGrowthRateUnitsPerYear = growthRateUnit.convert(CalendarDateUnit.YEAR);
        return PrimitiveMath.EXPM1.invoke(growthRate * tmpGrowthRateUnitsPerYear);
    }

    public static Primitive64Matrix toCorrelations(Access2D<?> covariances) {
        return FinanceUtils.toCorrelations(covariances, false);
    }

    public static Primitive64Matrix toCorrelations(Access2D<?> covariances, boolean clean) {
        int size = Math.toIntExact(Math.min(covariances.countRows(), covariances.countColumns()));
        MatrixStore<Object> covarianceMtrx = Primitive64Store.FACTORY.makeWrapper(covariances);
        if (clean) {
            Eigenvalue<Double> evd = Eigenvalue.PRIMITIVE.make(covarianceMtrx, true);
            evd.decompose(covarianceMtrx);
            MatrixStore<Double> mtrxV = evd.getV();
            PhysicalStore<Double> mtrxD = evd.getD().copy();
            double largest = ((ComplexNumber)evd.getEigenvalues().get(0)).norm();
            double limit = largest * (double)size * PrimitiveMath.RELATIVELY_SMALL;
            for (int ij = 0; ij < size; ++ij) {
                if (!(mtrxD.doubleValue(ij, ij) < limit)) continue;
                mtrxD.set((long)ij, (long)ij, limit);
            }
            covarianceMtrx = mtrxV.multiply((Double)((Object)mtrxD)).multiply((PhysicalStore<Double>)mtrxV.transpose());
        }
        Primitive64Matrix.DenseReceiver retVal = (Primitive64Matrix.DenseReceiver)Primitive64Matrix.FACTORY.makeDense(size, size);
        double[] volatilities = new double[size];
        for (int ij = 0; ij < size; ++ij) {
            volatilities[ij] = PrimitiveMath.SQRT.invoke(covarianceMtrx.doubleValue(ij, ij));
        }
        for (int j = 0; j < size; ++j) {
            double colVol = volatilities[j];
            retVal.set((long)j, (long)j, PrimitiveMath.ONE);
            for (int i = j + 1; i < size; ++i) {
                double rowVol = volatilities[i];
                if (rowVol <= PrimitiveMath.ZERO || colVol <= PrimitiveMath.ZERO) {
                    retVal.set((long)i, (long)j, PrimitiveMath.ZERO);
                    retVal.set((long)j, (long)i, PrimitiveMath.ZERO);
                    continue;
                }
                double covariance = covarianceMtrx.doubleValue(i, j);
                double correlation = covariance / (rowVol * colVol);
                retVal.set((long)i, (long)j, correlation);
                retVal.set((long)j, (long)i, correlation);
            }
        }
        return (Primitive64Matrix)retVal.get();
    }

    public static Primitive64Matrix toCovariances(Access1D<?> volatilities, Access2D<?> correlations) {
        int tmpSize = (int)volatilities.count();
        Primitive64Matrix.DenseReceiver retVal = (Primitive64Matrix.DenseReceiver)Primitive64Matrix.FACTORY.makeDense(tmpSize, tmpSize);
        for (int j = 0; j < tmpSize; ++j) {
            double tmpColumnVolatility = volatilities.doubleValue(j);
            retVal.set((long)j, (long)j, tmpColumnVolatility * tmpColumnVolatility);
            for (int i = j + 1; i < tmpSize; ++i) {
                double tmpCovariance = volatilities.doubleValue(i) * correlations.doubleValue(i, j) * tmpColumnVolatility;
                retVal.set((long)i, (long)j, tmpCovariance);
                retVal.set((long)j, (long)i, tmpCovariance);
            }
        }
        return (Primitive64Matrix)retVal.get();
    }

    public static double toGrowthFactorFromAnnualReturn(double annualReturn, CalendarDateUnit growthFactorUnit) {
        double tmpAnnualGrowthFactor = PrimitiveMath.ONE + annualReturn;
        double tmpYearsPerGrowthFactorUnit = CalendarDateUnit.YEAR.convert(growthFactorUnit);
        return PrimitiveMath.POW.invoke(tmpAnnualGrowthFactor, tmpYearsPerGrowthFactorUnit);
    }

    public static double toGrowthRateFromAnnualReturn(double annualReturn, CalendarDateUnit growthRateUnit) {
        double tmpAnnualGrowthRate = PrimitiveMath.LOG1P.invoke(annualReturn);
        double tmpYearsPerGrowthRateUnit = CalendarDateUnit.YEAR.convert(growthRateUnit);
        return tmpAnnualGrowthRate * tmpYearsPerGrowthRateUnit;
    }

    public static Primitive64Matrix toVolatilities(Access2D<?> covariances) {
        return FinanceUtils.toVolatilities(covariances, false);
    }

    public static Primitive64Matrix toVolatilities(Access2D<?> covariances, boolean clean) {
        int size = Math.toIntExact(Math.min(covariances.countRows(), covariances.countColumns()));
        Primitive64Matrix.DenseReceiver retVal = (Primitive64Matrix.DenseReceiver)Primitive64Matrix.FACTORY.makeDense(size);
        if (clean) {
            MatrixStore<Double> covarianceMtrx = Primitive64Store.FACTORY.makeWrapper(covariances);
            double largest = (Double)covarianceMtrx.aggregateDiagonal(Aggregator.LARGEST);
            double limit = largest * (double)size * PrimitiveMath.RELATIVELY_SMALL;
            double smallest = PrimitiveMath.SQRT.invoke(limit);
            for (int ij = 0; ij < size; ++ij) {
                double variance = covariances.doubleValue(ij, ij);
                if (variance < limit) {
                    retVal.set((long)ij, smallest);
                    continue;
                }
                retVal.set((long)ij, PrimitiveMath.SQRT.invoke(variance));
            }
        } else {
            for (int ij = 0; ij < size; ++ij) {
                double variance = covariances.doubleValue(ij, ij);
                if (variance <= PrimitiveMath.ZERO) {
                    retVal.set((long)ij, PrimitiveMath.ZERO);
                    continue;
                }
                retVal.set((long)ij, PrimitiveMath.SQRT.invoke(variance));
            }
        }
        return (Primitive64Matrix)retVal.get();
    }

    private static <K extends Comparable<? super K>> void copyValues(CalendarDateSeries<BigDecimal> series, CalendarDate firstKey, double[] values) {
        CalendarDate tmpKey = firstKey;
        for (int i = 0; i < values.length; ++i) {
            series.put(tmpKey, BigDecimal.valueOf(values[i]));
            tmpKey = series.step(tmpKey);
        }
    }

    private FinanceUtils() {
    }
}

