/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.data.domain.finance.series;

import java.time.LocalDate;
import java.util.List;
import org.ojalgo.data.domain.finance.series.DatePrice;
import org.ojalgo.series.BasicSeries;
import org.ojalgo.series.SimpleSeries;
import org.ojalgo.type.PrimitiveNumber;
import org.ojalgo.type.keyvalue.KeyValue;

@FunctionalInterface
public interface FinanceData<DP extends DatePrice> {
    public KeyValue<String, List<DP>> getHistoricalData();

    @Deprecated
    default public List<DP> getHistoricalPrices() {
        return this.getHistoricalData().getValue();
    }

    @Deprecated
    default public BasicSeries<LocalDate, PrimitiveNumber> getPriceSeries() {
        KeyValue<String, List<DP>> data = this.getHistoricalData();
        SimpleSeries<LocalDate, PrimitiveNumber> series = new SimpleSeries<LocalDate, PrimitiveNumber>();
        series.setName(data.getKey());
        for (DatePrice item : data.getValue()) {
            series.put(item.getKey(), item.getValue());
        }
        return series;
    }

    @Deprecated
    default public String getSymbol() {
        return this.getHistoricalData().getKey();
    }
}

