/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.optimisation;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Objects;
import org.ojalgo.function.aggregator.AggregatorFunction;
import org.ojalgo.function.aggregator.AggregatorSet;
import org.ojalgo.function.aggregator.BigAggregator;
import org.ojalgo.function.constant.BigMath;
import org.ojalgo.netio.BasicLogger;
import org.ojalgo.optimisation.Expression;
import org.ojalgo.optimisation.ModelEntity;
import org.ojalgo.structure.Structure1D;
import org.ojalgo.type.TypeUtils;
import org.ojalgo.type.context.NumberContext;

public final class Variable
extends ModelEntity<Variable> {
    private Structure1D.IntIndex myIndex = null;
    private boolean myInteger = false;
    private transient boolean myUnbounded = false;
    private BigDecimal myValue = null;

    public static Variable make(String name) {
        return new Variable(name);
    }

    public static Variable makeBinary(String name) {
        return Variable.make(name).binary();
    }

    public static Variable makeInteger(String name) {
        return Variable.make(name).integer();
    }

    public Variable(String name) {
        super(name);
    }

    protected Variable(Variable variableToCopy) {
        super(variableToCopy);
        this.myIndex = null;
        this.myInteger = variableToCopy.isInteger();
        this.myValue = variableToCopy.getValue();
    }

    @Override
    public void addTo(Expression target, BigDecimal scale) {
        target.add(this, scale);
    }

    public Variable binary() {
        return ((Variable)((Variable)this.lower((Comparable)BigMath.ZERO)).upper((Comparable)BigMath.ONE)).integer(true);
    }

    @Override
    public int compareTo(Variable obj) {
        return this.getIndex().compareTo(obj.getIndex());
    }

    public Variable copy() {
        return new Variable(this);
    }

    public BigDecimal getLowerSlack() {
        BigDecimal retVal = null;
        if (this.getLowerLimit() != null) {
            retVal = this.myValue != null ? this.getLowerLimit().subtract(this.myValue) : this.getLowerLimit();
        }
        if (retVal != null && this.isInteger()) {
            retVal = retVal.setScale(0, 2);
        }
        return retVal;
    }

    public BigDecimal getUpperSlack() {
        BigDecimal retVal = null;
        if (this.getUpperLimit() != null) {
            retVal = this.myValue != null ? this.getUpperLimit().subtract(this.myValue) : this.getUpperLimit();
        }
        if (retVal != null && this.isInteger()) {
            retVal = retVal.setScale(0, 3);
        }
        return retVal;
    }

    public BigDecimal getValue() {
        if (this.myValue == null && this.isEqualityConstraint()) {
            this.myValue = this.getLowerLimit();
        }
        return this.myValue;
    }

    public Variable integer() {
        return this.integer(true);
    }

    public Variable integer(boolean integer) {
        this.setInteger(integer);
        return this;
    }

    public boolean isBinary() {
        return this.myInteger && this.isClosedRange(BigMath.ZERO, BigMath.ONE);
    }

    @Override
    public boolean isInteger() {
        return this.myInteger;
    }

    public boolean isNegative() {
        return !this.isLowerLimitSet() || this.getLowerLimit().signum() < 0;
    }

    public boolean isPositive() {
        return !this.isUpperLimitSet() || this.getUpperLimit().signum() > 0;
    }

    public boolean isValueSet() {
        return this.myValue != null;
    }

    @Override
    public Variable lower(Comparable<?> lower) {
        Variable retVal = (Variable)super.lower(lower);
        this.assertFixedValue();
        return retVal;
    }

    public BigDecimal quantifyContribution() {
        BigDecimal retVal = BigMath.ZERO;
        BigDecimal contributionWeight = this.getContributionWeight();
        if (contributionWeight != null && this.myValue != null) {
            retVal = contributionWeight.multiply(this.myValue);
        }
        return retVal;
    }

    public Variable relax() {
        return this.integer(false);
    }

    public void setInteger(boolean integer) {
        this.myInteger = integer;
    }

    public void setValue(Comparable<?> value) {
        BigDecimal tmpValue = null;
        if (value != null) {
            tmpValue = TypeUtils.toBigDecimal(value);
            if (this.isUpperLimitSet()) {
                tmpValue = tmpValue.min(this.getUpperLimit());
            }
            if (this.isLowerLimitSet()) {
                tmpValue = tmpValue.max(this.getLowerLimit());
            }
        }
        this.myValue = tmpValue;
    }

    @Override
    public Variable upper(Comparable<?> upper) {
        Variable retVal = (Variable)super.upper(upper);
        this.assertFixedValue();
        return retVal;
    }

    private void assertFixedValue() {
        if (this.isLowerLimitSet() && this.isUpperLimitSet() && this.getLowerLimit().compareTo(this.getUpperLimit()) == 0) {
            this.myValue = this.getLowerLimit();
        }
    }

    @Override
    protected void appendMiddlePart(StringBuilder aStringBuilder) {
        aStringBuilder.append(this.getName());
        if (this.myValue != null) {
            aStringBuilder.append(": ");
            aStringBuilder.append(ModelEntity.DISPLAY.enforce(this.myValue).toPlainString());
        }
        if (this.isObjective()) {
            aStringBuilder.append(" (");
            aStringBuilder.append(ModelEntity.DISPLAY.enforce(this.getContributionWeight()).toPlainString());
            aStringBuilder.append(")");
        }
    }

    protected Variable clone() {
        Variable retVal = this.copy();
        retVal.setIndex(this.myIndex);
        return retVal;
    }

    @Override
    protected void destroy() {
        super.destroy();
        this.myIndex = null;
        this.myValue = null;
    }

    @Override
    protected boolean validate(BigDecimal value, NumberContext context, BasicLogger appender) {
        return this.validate(value, context, appender, false);
    }

    @Override
    int deriveAdjustmentExponent() {
        BigDecimal upperLimit;
        if (!this.isConstraint() || this.isInteger()) {
            return 0;
        }
        BigAggregator aggregators = BigAggregator.getSet();
        AggregatorFunction<BigDecimal> largest = ((AggregatorSet)aggregators).largest();
        AggregatorFunction<BigDecimal> smallest = ((AggregatorSet)aggregators).smallest();
        BigDecimal lowerLimit = this.getLowerLimit();
        if (lowerLimit != null) {
            if (lowerLimit.signum() == 0) {
                largest.invoke(BigMath.ONE);
                smallest.invoke(BigMath.ONE);
            } else {
                largest.invoke(lowerLimit);
                smallest.invoke(lowerLimit);
            }
        }
        if ((upperLimit = this.getUpperLimit()) != null) {
            if (upperLimit.signum() == 0) {
                largest.invoke(BigMath.ONE);
                smallest.invoke(BigMath.ONE);
            } else {
                largest.invoke(upperLimit);
                smallest.invoke(upperLimit);
            }
        }
        return ModelEntity.deriveAdjustmentExponent(largest, smallest, 12);
    }

    @Override
    void doIntegerRounding() {
        if (this.myInteger) {
            BigDecimal limit = this.getUpperLimit();
            if (limit != null && limit.scale() > 0) {
                this.upper((Comparable)limit.setScale(0, RoundingMode.FLOOR));
            }
            if ((limit = this.getLowerLimit()) != null && limit.scale() > 0) {
                this.lower((Comparable)limit.setScale(0, RoundingMode.CEILING));
            }
        }
    }

    Structure1D.IntIndex getIndex() {
        return this.myIndex;
    }

    boolean isFixed() {
        return this.isEqualityConstraint();
    }

    boolean isUnbounded() {
        return this.myUnbounded;
    }

    void setFixed(BigDecimal value) {
        ((Variable)this.level(value)).setValue(value);
    }

    void setIndex(Structure1D.IntIndex index) {
        Objects.requireNonNull(index, "The index cannot be null!");
        if (this.myIndex != null && this.myIndex.index != index.index) {
            throw new IllegalStateException("Cannot change a variable's index, or add a variable to more than one model!");
        }
        this.myIndex = index;
    }

    void setUnbounded(boolean uncorrelated) {
        this.myUnbounded = uncorrelated;
    }

    boolean validate(BigDecimal value, NumberContext context, BasicLogger appender, boolean relaxed) {
        boolean retVal = super.validate(value, context, appender);
        if (retVal && !relaxed && this.myInteger) {
            try {
                context.enforce(value).longValueExact();
            }
            catch (ArithmeticException ex) {
                if (appender != null) {
                    appender.println(value + " ! Integer: " + this.getName());
                }
                retVal = false;
            }
        }
        return retVal;
    }
}

