/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.optimisation.linear;

import java.math.BigDecimal;
import java.util.List;
import org.ojalgo.ProgrammingError;
import org.ojalgo.array.ArrayR064;
import org.ojalgo.array.SparseArray;
import org.ojalgo.function.constant.PrimitiveMath;
import org.ojalgo.function.multiary.LinearFunction;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.matrix.store.PhysicalStore;
import org.ojalgo.optimisation.ExpressionsBasedModel;
import org.ojalgo.optimisation.GenericSolver;
import org.ojalgo.optimisation.Optimisation;
import org.ojalgo.optimisation.UpdatableSolver;
import org.ojalgo.optimisation.Variable;
import org.ojalgo.optimisation.convex.ConvexSolver;
import org.ojalgo.optimisation.linear.DualSimplex;
import org.ojalgo.optimisation.linear.PrimalSimplex;
import org.ojalgo.optimisation.linear.Primitive1D;
import org.ojalgo.optimisation.linear.Primitive2D;
import org.ojalgo.optimisation.linear.SimplexTableau;
import org.ojalgo.structure.Access1D;
import org.ojalgo.structure.Access2D;
import org.ojalgo.structure.Structure1D;
import org.ojalgo.type.IndexSelector;

public abstract class LinearSolver
extends GenericSolver
implements UpdatableSolver {
    public static final ModelIntegration INTEGRATION = new ModelIntegration();

    public static GeneralBuilder newGeneralBuilder() {
        return new GeneralBuilder();
    }

    public static LinearSolver newSolver(ExpressionsBasedModel model) {
        SimplexTableau tableau = PrimalSimplex.build(model);
        return new PrimalSimplex(tableau, model.options);
    }

    public static StandardBuilder newStandardBuilder() {
        return new StandardBuilder();
    }

    public static Optimisation.Result solve(ConvexSolver.Builder convex, Optimisation.Options options, boolean zeroC) {
        int primSize;
        int dualSize = DualSimplex.size(convex);
        boolean dual = dualSize <= (primSize = PrimalSimplex.size(convex));
        return dual ? DualSimplex.doSolve(convex, options, zeroC) : PrimalSimplex.doSolve(convex, options, zeroC);
    }

    static LinearFunction<Double> toObjectiveFunction(MatrixStore<Double> mtrxC) {
        ProgrammingError.throwIfNull(mtrxC);
        PhysicalStore<Double> tmpC = null;
        tmpC = mtrxC instanceof PhysicalStore ? (PhysicalStore<Double>)mtrxC : mtrxC.copy();
        return LinearFunction.wrap(tmpC);
    }

    protected LinearSolver(Optimisation.Options solverOptions) {
        super(solverOptions);
    }

    public static final class StandardBuilder
    extends Builder {
        @Deprecated
        public StandardBuilder() {
        }

        @Deprecated
        public StandardBuilder(MatrixStore<Double> mtrxC) {
            this.objective(mtrxC);
        }

        @Override
        public StandardBuilder objective(MatrixStore<Double> mtrxC) {
            return super.objective(mtrxC);
        }
    }

    public static final class ModelIntegration
    extends ExpressionsBasedModel.Integration<LinearSolver> {
        private static ArrayR064 toModelVariableValues(Access1D<?> solverVariableValues, ExpressionsBasedModel model, ArrayR064 modelVariableValues) {
            List<Variable> positiveVariables = model.getPositiveVariables();
            for (int p = 0; p < positiveVariables.size(); ++p) {
                Variable variable = positiveVariables.get(p);
                int index = model.indexOf(variable);
                modelVariableValues.set((long)index, solverVariableValues.doubleValue(p));
            }
            List<Variable> negativeVariables = model.getNegativeVariables();
            for (int n = 0; n < negativeVariables.size(); ++n) {
                Variable variable = negativeVariables.get(n);
                int index = model.indexOf(variable);
                modelVariableValues.add((long)index, -solverVariableValues.doubleValue(positiveVariables.size() + n));
            }
            return modelVariableValues;
        }

        public LinearSolver build(ConvexSolver.Builder convexBuilder, Optimisation.Options options) {
            SimplexTableau tableau = PrimalSimplex.build(convexBuilder, options, false);
            return new PrimalSimplex(tableau, options);
        }

        @Override
        public LinearSolver build(ExpressionsBasedModel model) {
            SimplexTableau tableau = PrimalSimplex.build(model);
            return new PrimalSimplex(tableau, model.options);
        }

        @Override
        public boolean isCapable(ExpressionsBasedModel model) {
            return !model.isAnyVariableInteger() && !model.isAnyExpressionQuadratic();
        }

        @Override
        public Optimisation.Result toModelState(Optimisation.Result solverState, ExpressionsBasedModel model) {
            ArrayR064 modelSolution = ArrayR064.make(model.countVariables());
            for (Structure1D.IntIndex fixed : model.getFixedVariables()) {
                modelSolution.set((long)fixed.index, model.getVariable(fixed.index).getValue().doubleValue());
            }
            ModelIntegration.toModelVariableValues(solverState, model, modelSolution);
            return new Optimisation.Result(solverState.getState(), solverState.getValue(), modelSolution);
        }

        @Override
        public Optimisation.Result toSolverState(Optimisation.Result modelState, ExpressionsBasedModel model) {
            int tmpIndex;
            Variable tmpVariable;
            List<Variable> tmpPositives = model.getPositiveVariables();
            List<Variable> tmpNegatives = model.getNegativeVariables();
            int tmpCountPositives = tmpPositives.size();
            int tmpCountNegatives = tmpNegatives.size();
            ArrayR064 tmpSolverSolution = ArrayR064.make(tmpCountPositives + tmpCountNegatives);
            for (int p = 0; p < tmpCountPositives; ++p) {
                tmpVariable = tmpPositives.get(p);
                tmpIndex = model.indexOf(tmpVariable);
                tmpSolverSolution.set((long)p, PrimitiveMath.MAX.invoke(modelState.doubleValue(tmpIndex), PrimitiveMath.ZERO));
            }
            for (int n = 0; n < tmpCountNegatives; ++n) {
                tmpVariable = tmpNegatives.get(n);
                tmpIndex = model.indexOf(tmpVariable);
                tmpSolverSolution.set((long)(tmpCountPositives + n), PrimitiveMath.MAX.invoke(-modelState.doubleValue(tmpIndex), PrimitiveMath.ZERO));
            }
            return new Optimisation.Result(modelState.getState(), modelState.getValue(), tmpSolverSolution);
        }

        @Override
        protected int getIndexInSolver(ExpressionsBasedModel model, Variable variable) {
            int retVal = -1;
            BigDecimal value = variable.getValue();
            if ((value != null && value.signum() >= 0 || variable.isPositive()) && (retVal = model.indexOfPositiveVariable(variable)) >= 0) {
                return retVal;
            }
            if ((value != null && value.signum() <= 0 || variable.isNegative()) && (retVal = model.indexOfNegativeVariable(variable)) >= 0) {
                return retVal += model.getPositiveVariables().size();
            }
            return -1;
        }

        @Override
        protected boolean isSolutionMapped() {
            return true;
        }
    }

    public static final class GeneralBuilder
    extends GenericSolver.Builder<GeneralBuilder, LinearSolver> {
        GeneralBuilder() {
        }

        @Override
        public GeneralBuilder inequalities(Access2D<Double> mtrxAI, Access1D<Double> mtrxBI) {
            return (GeneralBuilder)super.inequalities(mtrxAI, mtrxBI);
        }

        public GeneralBuilder objective(MatrixStore<Double> mtrxC) {
            this.setObjective(LinearSolver.toObjectiveFunction(mtrxC));
            return this;
        }

        public StandardBuilder toStandardForm() {
            int nbInequalites = this.countInequalityConstraints();
            int nbEqualites = this.countEqualityConstraints();
            int nbVariables = this.countVariables();
            StandardBuilder retVal = LinearSolver.newStandardBuilder();
            PhysicalStore mtrxC = null;
            PhysicalStore mtrxAE = null;
            PhysicalStore mtrxBE = null;
            if (nbEqualites > 0) {
                if (nbInequalites > 0) {
                    mtrxC = (PhysicalStore)this.getC().below(nbInequalites).collect(FACTORY);
                    mtrxAE = (PhysicalStore)this.getAE().below((Access2D<Double>)this.getAI()).right(nbInequalites).collect(FACTORY);
                    mtrxAE.fillDiagonal((long)nbEqualites, (long)nbVariables, PrimitiveMath.ONE);
                    mtrxBE = (PhysicalStore)this.getBE().below((Access2D<Double>)this.getBI()).collect(FACTORY);
                } else {
                    mtrxC = (PhysicalStore)this.getC().collect(FACTORY);
                    mtrxAE = (PhysicalStore)this.getAE().collect(FACTORY);
                    mtrxBE = (PhysicalStore)this.getBE().collect(FACTORY);
                }
            } else if (nbInequalites > 0) {
                mtrxC = (PhysicalStore)this.getC().below(nbInequalites).collect(FACTORY);
                mtrxAE = (PhysicalStore)this.getAI().right(nbInequalites).collect(FACTORY);
                mtrxAE.fillDiagonal((long)nbEqualites, (long)nbVariables, PrimitiveMath.ONE);
                mtrxBE = (PhysicalStore)this.getBI().collect(FACTORY);
            } else {
                throw new IllegalStateException("The problem is unconstrained!");
            }
            for (int i = 0; i < mtrxBE.getRowDim(); ++i) {
                double rhs = mtrxBE.doubleValue(i, 0L);
                if (!(rhs < PrimitiveMath.ZERO)) continue;
                mtrxAE.modifyRow(i, PrimitiveMath.NEGATE);
                mtrxBE.set((long)i, 0L, -rhs);
            }
            retVal.objective(mtrxC);
            retVal.equalities(mtrxAE, mtrxBE);
            return retVal;
        }

        @Override
        protected LinearSolver doBuild(Optimisation.Options options) {
            int i;
            int nbInequalites = this.countInequalityConstraints();
            int nbEqualites = this.countEqualityConstraints();
            int nbVariables = this.countVariables();
            IndexSelector ineqSign = new IndexSelector(nbInequalites);
            if (nbInequalites > 0) {
                MatrixStore<Double> mtrxBI = this.getBI();
                for (int i2 = 0; i2 < nbInequalites; ++i2) {
                    double valRHS = mtrxBI.doubleValue(i2);
                    if (valRHS < PrimitiveMath.ZERO) {
                        ineqSign.exclude(i2);
                        continue;
                    }
                    ineqSign.include(i2);
                }
            }
            int nbIdentitySlackVariables = ineqSign.countIncluded();
            int nbSlackVariables = ineqSign.countExcluded();
            int nbProblemVariables = nbVariables;
            int nbConstraints = nbEqualites + nbInequalites;
            boolean needDual = true;
            SimplexTableau tableau = SimplexTableau.make(nbConstraints, nbProblemVariables, 0, nbSlackVariables, nbIdentitySlackVariables, needDual, options);
            Primitive2D constraintsBody = tableau.constraintsBody();
            Primitive1D constraintsRHS = tableau.constraintsRHS();
            Primitive1D objective = tableau.objective();
            if (nbInequalites > 0) {
                int insIdSlack = 0;
                int insGnSlack = 0;
                for (i = 0; i < nbInequalites; ++i) {
                    SparseArray<Double> body = this.getAI(i);
                    double valRHS = this.getBI(i);
                    boolean positive = ineqSign.isIncluded(i);
                    int row = positive ? insIdSlack : nbIdentitySlackVariables + insGnSlack;
                    int col = positive ? nbProblemVariables + nbSlackVariables + insIdSlack++ : nbProblemVariables + insGnSlack++;
                    for (SparseArray.NonzeroView nz : body.nonzeros()) {
                        constraintsBody.set((long)row, nz.index(), positive ? nz.doubleValue() : -nz.doubleValue());
                    }
                    constraintsBody.set(row, col, positive ? PrimitiveMath.ONE : PrimitiveMath.NEG);
                    constraintsRHS.set(row, positive ? valRHS : -valRHS);
                }
            }
            if (nbEqualites > 0) {
                MatrixStore<Double> mtrxAE = this.getAE();
                MatrixStore<Double> mtrxBE = this.getBE();
                for (i = 0; i < nbEqualites; ++i) {
                    double valRHS = mtrxBE.doubleValue(i);
                    boolean positive = valRHS >= PrimitiveMath.ZERO;
                    int row = nbInequalites + i;
                    for (int j = 0; j < nbVariables; ++j) {
                        double value = mtrxAE.doubleValue(i, j);
                        if (!(Math.abs(value) > PrimitiveMath.MACHINE_EPSILON)) continue;
                        constraintsBody.set(row, j, positive ? value : -value);
                    }
                    constraintsRHS.set(row, positive ? valRHS : -valRHS);
                }
            }
            MatrixStore<Double> mtrxC = this.getC();
            for (int i3 = 0; i3 < nbVariables; ++i3) {
                objective.set(i3, mtrxC.doubleValue(i3));
            }
            return new PrimalSimplex(tableau, options);
        }
    }

    @Deprecated
    public static abstract class Builder
    extends GenericSolver.Builder<StandardBuilder, LinearSolver> {
        Builder() {
        }

        public StandardBuilder objective(MatrixStore<Double> mtrxC) {
            this.setObjective(LinearSolver.toObjectiveFunction(mtrxC));
            return (StandardBuilder)this;
        }

        @Override
        protected LinearSolver doBuild(Optimisation.Options options) {
            SimplexTableau tableau = SimplexTableau.make(this, options);
            return new PrimalSimplex(tableau, options);
        }
    }
}

