/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.random.process;

import org.ojalgo.array.Array2D;
import org.ojalgo.function.constant.PrimitiveMath;
import org.ojalgo.random.Distribution;
import org.ojalgo.random.process.AbstractProcess;
import org.ojalgo.random.process.RandomProcess;

abstract class SingleValueBasedProcess<D extends Distribution>
extends AbstractProcess<D> {
    private double myCurrentValue = PrimitiveMath.ONE;

    SingleValueBasedProcess() {
    }

    @Override
    public RandomProcess.SimulationResults simulate(int numberOfRealisations, int numberOfSteps, double stepSize) {
        double tmpInitialValue = this.myCurrentValue;
        Array2D tmpRealisationValues = (Array2D)Array2D.R064.make(numberOfRealisations, numberOfSteps);
        for (int r = 0; r < numberOfRealisations; ++r) {
            double tmpCurrentValue = tmpInitialValue;
            for (int s = 0; s < numberOfSteps; ++s) {
                tmpCurrentValue = this.doStep(stepSize, this.getNormalisedRandomIncrement());
                tmpRealisationValues.set((long)r, (long)s, tmpCurrentValue);
            }
            this.myCurrentValue = tmpInitialValue;
        }
        return new RandomProcess.SimulationResults(tmpInitialValue, tmpRealisationValues);
    }

    @Override
    double getCurrentValue() {
        return this.myCurrentValue;
    }

    @Override
    void setCurrentValue(double currentValue) {
        this.myCurrentValue = currentValue;
    }
}

