/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.series;

import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import org.ojalgo.series.BasicSeries;
import org.ojalgo.series.TreeSeries;
import org.ojalgo.series.primitive.ExplicitTimeSeries;
import org.ojalgo.type.CalendarDate;
import org.ojalgo.type.CalendarDateUnit;

public final class CalendarDateSeries<N extends Comparable<N>>
extends TreeSeries<CalendarDate, N, CalendarDateSeries<N>>
implements BasicSeries.NaturallySequenced<CalendarDate, N> {
    private final NavigableMap<CalendarDate, N> myDelegate;
    private final CalendarDateUnit myResolution;

    public CalendarDateSeries() {
        this(CalendarDateUnit.MILLIS);
    }

    public CalendarDateSeries(CalendarDateUnit resolution) {
        this(new TreeMap(), resolution);
    }

    CalendarDateSeries(NavigableMap<CalendarDate, N> delegate, CalendarDateUnit resolution) {
        super(delegate);
        this.myDelegate = delegate;
        this.myResolution = resolution;
    }

    @Override
    public void complete() {
        this.complete(key -> key.step(1, this.myResolution));
    }

    @Override
    public N get(CalendarDate key) {
        return (N)((Comparable)this.myDelegate.get(key.filter(this.myResolution)));
    }

    public long getAverageStepSize() {
        return (((CalendarDate)this.lastKey()).millis - ((CalendarDate)this.firstKey()).millis) / (long)(this.size() - 1);
    }

    public long[] getPrimitiveKeys() {
        long[] retVal = new long[this.size()];
        int i = 0;
        for (CalendarDate tmpKey : this.keySet()) {
            retVal[i] = tmpKey.millis;
            ++i;
        }
        return retVal;
    }

    public ExplicitTimeSeries getPrimitiveTimeSeries() {
        return new ExplicitTimeSeries(this.getPrimitiveKeys(), this.asPrimitive());
    }

    public CalendarDateUnit getResolution() {
        return this.myResolution;
    }

    public CalendarDateSeries<N> headMap(CalendarDate toKey) {
        return this.headMap(toKey, false);
    }

    public CalendarDateSeries<N> headMap(CalendarDate toKey, boolean inclusive) {
        CalendarDateSeries<N> retVal = new CalendarDateSeries<N>(this.myDelegate.headMap(toKey, inclusive), this.getResolution());
        retVal.setColour(this.getColour());
        retVal.setName(this.getName());
        return retVal;
    }

    @Override
    public CalendarDate nextKey() {
        return ((CalendarDate)this.lastKey()).step(1, this.myResolution);
    }

    @Override
    public N put(Calendar key, N value) {
        return super.put(CalendarDate.make(key, (CalendarDate.Resolution)this.myResolution), value);
    }

    @Override
    public N put(CalendarDate key, N value) {
        return super.put(key.filter(this.myResolution), value);
    }

    @Override
    public N put(Date key, N value) {
        return super.put(CalendarDate.make(key, (CalendarDate.Resolution)this.myResolution), value);
    }

    @Override
    public void putAll(Map<? extends CalendarDate, ? extends N> data) {
        for (Map.Entry<CalendarDate, N> tmpEntry : data.entrySet()) {
            this.put(tmpEntry.getKey(), (N)((Comparable)tmpEntry.getValue()));
        }
    }

    public BasicSeries<CalendarDate, N> resample(CalendarDateUnit resolution) {
        return this.resample(resolution, resolution::adjustInto);
    }

    @Override
    public BasicSeries<CalendarDate, N> resample(UnaryOperator<CalendarDate> keyTranslator) {
        return this.resample(this.myResolution, keyTranslator);
    }

    @Override
    public CalendarDate step(CalendarDate key) {
        return key.step(1, this.myResolution);
    }

    public CalendarDateSeries<N> subMap(CalendarDate fromKey, boolean inclusiveFromKey, CalendarDate toKey, boolean inclusiveToKey) {
        CalendarDateSeries<N> retVal = new CalendarDateSeries<N>(this.myDelegate.subMap(fromKey, inclusiveFromKey, toKey, inclusiveToKey), this.getResolution());
        retVal.setColour(this.getColour());
        retVal.setName(this.getName());
        return retVal;
    }

    public CalendarDateSeries<N> subMap(CalendarDate fromKey, CalendarDate toKey) {
        return this.subMap(fromKey, true, toKey, false);
    }

    public CalendarDateSeries<N> tailMap(CalendarDate fromKey) {
        return this.tailMap(fromKey, true);
    }

    public CalendarDateSeries<N> tailMap(CalendarDate fromKey, boolean inclusive) {
        CalendarDateSeries<N> retVal = new CalendarDateSeries<N>(this.myDelegate.tailMap(fromKey, inclusive), this.getResolution());
        retVal.setColour(this.getColour());
        retVal.setName(this.getName());
        return retVal;
    }

    @Override
    public String toString() {
        StringBuilder retVal = this.toStringFirstPart();
        retVal.append(this.myResolution);
        retVal.append('\u00a0');
        this.appendLastPartToString(retVal);
        return retVal.toString();
    }

    private BasicSeries<CalendarDate, N> resample(CalendarDateUnit resolution, Function<CalendarDate, CalendarDate> keyMapper) {
        CalendarDateSeries<Comparable> retVal = new CalendarDateSeries<Comparable>(resolution);
        retVal.setColour(this.getColour());
        retVal.setName(this.getName());
        for (Map.Entry entry : this.entrySet()) {
            CalendarDate key = keyMapper.apply((CalendarDate)entry.getKey());
            Comparable value = (Comparable)entry.getValue();
            retVal.put(key, value);
        }
        return retVal;
    }
}

