/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.series;

import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.Set;
import java.util.SortedMap;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.ojalgo.series.BasicSeries;
import org.ojalgo.type.ColourData;
import org.ojalgo.type.TypeUtils;

abstract class TreeSeries<K extends Comparable<? super K>, V extends Comparable<V>, I extends TreeSeries<K, V, I>>
implements NavigableMap<K, V>,
BasicSeries<K, V> {
    private ColourData myColour = null;
    private final NavigableMap<K, V> myDelegate;
    private String myName = null;

    protected TreeSeries(NavigableMap<K, V> delegate) {
        this.myDelegate = delegate;
    }

    @Override
    public Map.Entry<K, V> ceilingEntry(K key) {
        return this.myDelegate.ceilingEntry(key);
    }

    @Override
    public K ceilingKey(K key) {
        return (K)((Comparable)this.myDelegate.ceilingKey(key));
    }

    @Override
    public void clear() {
        this.myDelegate.clear();
    }

    public final I colour(ColourData colour) {
        return (I)((TreeSeries)BasicSeries.super.colour(colour));
    }

    @Override
    public Comparator<? super K> comparator() {
        return this.myDelegate.comparator();
    }

    @Override
    public V compute(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        return (V)((Comparable)this.myDelegate.compute((K)key, (BiFunction<? super K, ? extends V, ? extends V>)remappingFunction));
    }

    @Override
    public V computeIfAbsent(K key, Function<? super K, ? extends V> mappingFunction) {
        return (V)((Comparable)this.myDelegate.computeIfAbsent((K)key, mappingFunction));
    }

    @Override
    public V computeIfPresent(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        return (V)((Comparable)this.myDelegate.computeIfPresent((K)key, (BiFunction<? super K, ? extends V, ? extends V>)remappingFunction));
    }

    @Override
    public boolean containsKey(Object key) {
        return this.myDelegate.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.myDelegate.containsValue(value);
    }

    @Override
    public NavigableSet<K> descendingKeySet() {
        return this.myDelegate.descendingKeySet();
    }

    @Override
    public NavigableMap<K, V> descendingMap() {
        return this.myDelegate.descendingMap();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.myDelegate.entrySet();
    }

    @Override
    public boolean equals(Object o) {
        return this.myDelegate.equals(o);
    }

    @Override
    public Map.Entry<K, V> firstEntry() {
        return this.myDelegate.firstEntry();
    }

    @Override
    public K firstKey() {
        return (K)((Comparable)this.myDelegate.firstKey());
    }

    @Override
    public Map.Entry<K, V> floorEntry(K key) {
        return this.myDelegate.floorEntry(key);
    }

    @Override
    public K floorKey(K key) {
        return (K)((Comparable)this.myDelegate.floorKey(key));
    }

    @Override
    public void forEach(BiConsumer<? super K, ? super V> action) {
        this.myDelegate.forEach(action);
    }

    @Override
    public V get(K key) {
        return (V)((Comparable)this.myDelegate.get(key));
    }

    @Override
    public V get(Object key) {
        return (V)((Comparable)this.myDelegate.get(key));
    }

    @Override
    public ColourData getColour() {
        return this.myColour;
    }

    @Override
    public String getName() {
        return this.myName;
    }

    @Override
    public V getOrDefault(Object key, V defaultValue) {
        return (V)((Comparable)this.myDelegate.getOrDefault(key, defaultValue));
    }

    @Override
    public int hashCode() {
        return this.myDelegate.hashCode();
    }

    @Override
    public SortedMap<K, V> headMap(K toKey) {
        return this.myDelegate.headMap(toKey);
    }

    @Override
    public NavigableMap<K, V> headMap(K toKey, boolean inclusive) {
        return this.myDelegate.headMap(toKey, inclusive);
    }

    @Override
    public Map.Entry<K, V> higherEntry(K key) {
        return this.myDelegate.higherEntry(key);
    }

    @Override
    public K higherKey(K key) {
        return (K)((Comparable)this.myDelegate.higherKey(key));
    }

    @Override
    public boolean isEmpty() {
        return this.myDelegate.isEmpty();
    }

    @Override
    public Set<K> keySet() {
        return this.myDelegate.keySet();
    }

    @Override
    public Map.Entry<K, V> lastEntry() {
        return this.myDelegate.lastEntry();
    }

    @Override
    public K lastKey() {
        return (K)((Comparable)this.myDelegate.lastKey());
    }

    @Override
    public Map.Entry<K, V> lowerEntry(K key) {
        return this.myDelegate.lowerEntry(key);
    }

    @Override
    public K lowerKey(K key) {
        return (K)((Comparable)this.myDelegate.lowerKey(key));
    }

    @Override
    public V merge(K key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction) {
        return (V)((Comparable)this.myDelegate.merge(key, (V)value, (BiFunction<? extends V, ? extends V, ? extends V>)remappingFunction));
    }

    public final I name(String name) {
        return (I)((TreeSeries)BasicSeries.super.name(name));
    }

    @Override
    public NavigableSet<K> navigableKeySet() {
        return this.myDelegate.navigableKeySet();
    }

    @Override
    public Map.Entry<K, V> pollFirstEntry() {
        return this.myDelegate.pollFirstEntry();
    }

    @Override
    public Map.Entry<K, V> pollLastEntry() {
        return this.myDelegate.pollLastEntry();
    }

    @Override
    public V put(K key, V value) {
        return (V)((Comparable)this.myDelegate.put(key, value));
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        this.myDelegate.putAll(m);
    }

    @Override
    public V putIfAbsent(K key, V value) {
        return (V)((Comparable)this.myDelegate.putIfAbsent(key, value));
    }

    @Override
    public V remove(Object key) {
        return (V)((Comparable)this.myDelegate.remove(key));
    }

    @Override
    public boolean remove(Object key, Object value) {
        return this.myDelegate.remove(key, value);
    }

    @Override
    public V replace(K key, V value) {
        return (V)((Comparable)this.myDelegate.replace(key, value));
    }

    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        return this.myDelegate.replace(key, oldValue, newValue);
    }

    @Override
    public void replaceAll(BiFunction<? super K, ? super V, ? extends V> function) {
        this.myDelegate.replaceAll(function);
    }

    @Override
    public void setColour(ColourData colour) {
        this.myColour = colour;
    }

    @Override
    public void setName(String name) {
        this.myName = name;
    }

    @Override
    public int size() {
        return this.myDelegate.size();
    }

    @Override
    public NavigableMap<K, V> subMap(K fromKey, boolean fromInclusive, K toKey, boolean toInclusive) {
        return this.myDelegate.subMap(fromKey, fromInclusive, toKey, toInclusive);
    }

    @Override
    public SortedMap<K, V> subMap(K fromKey, K toKey) {
        return this.myDelegate.subMap(fromKey, toKey);
    }

    @Override
    public SortedMap<K, V> tailMap(K fromKey) {
        return this.myDelegate.tailMap(fromKey);
    }

    @Override
    public NavigableMap<K, V> tailMap(K fromKey, boolean inclusive) {
        return this.myDelegate.tailMap(fromKey, inclusive);
    }

    public String toString() {
        StringBuilder retVal = this.toStringFirstPart();
        this.appendLastPartToString(retVal);
        return retVal.toString();
    }

    @Override
    public Collection<V> values() {
        return this.myDelegate.values();
    }

    final void appendLastPartToString(StringBuilder builder) {
        if (this.myColour != null) {
            builder.append(TypeUtils.toHexString(this.myColour.getRGB()));
            builder.append('\u00a0');
        }
        if (this.size() <= 30) {
            builder.append(this.myDelegate.toString());
        } else {
            builder.append("First:");
            builder.append(this.firstKey());
            builder.append("=");
            builder.append(this.firstValue());
            builder.append('\u00a0');
            builder.append("Last:");
            builder.append(this.lastKey());
            builder.append("=");
            builder.append(this.lastValue());
            builder.append('\u00a0');
            builder.append("Size:");
            builder.append(this.size());
        }
    }

    final StringBuilder toStringFirstPart() {
        StringBuilder retVal = new StringBuilder();
        if (this.myName != null) {
            retVal.append(this.myName);
            retVal.append('\u00a0');
        }
        return retVal;
    }
}

