/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.type;

import java.time.DateTimeException;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalAdjuster;
import java.time.temporal.TemporalField;
import java.time.temporal.TemporalUnit;
import java.time.temporal.UnsupportedTemporalTypeException;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import org.ojalgo.ProgrammingError;
import org.ojalgo.RecoverableCondition;
import org.ojalgo.structure.Structure1D;
import org.ojalgo.type.CalendarDateDuration;
import org.ojalgo.type.CalendarDateUnit;
import org.ojalgo.type.StandardType;

public final class CalendarDate
implements Temporal,
Comparable<CalendarDate> {
    static final long MILLIS_PER_SECOND = 1000L;
    static final int NANOS_PER_MILLIS = 1000000;
    static final int NANOS_PER_SECOND = 1000000000;
    static final long SECONDS_PER_DAY = 86400L;
    public final long millis;

    public static CalendarDate from(TemporalAccessor temporal) {
        ProgrammingError.throwIfNull((Object)temporal, (Object)"temporal");
        if (temporal instanceof CalendarDate) {
            return (CalendarDate)temporal;
        }
        if (temporal instanceof Instant) {
            return new CalendarDate(((Instant)temporal).toEpochMilli());
        }
        try {
            long tmpSeconds = temporal.getLong(ChronoField.INSTANT_SECONDS);
            int tmpMillisOfSecond = temporal.get(ChronoField.MILLI_OF_SECOND);
            return new CalendarDate(tmpSeconds * 1000L + (long)tmpMillisOfSecond);
        }
        catch (DateTimeException ex) {
            throw new DateTimeException("Unable to obtain CalendarDate from TemporalAccessor: " + temporal + " of type " + temporal.getClass().getName(), ex);
        }
    }

    public static CalendarDate make(Calendar calendar, Resolution resolution) {
        return new CalendarDate(resolution.adjustInto(calendar.getTimeInMillis()));
    }

    public static CalendarDate make(Resolution resolution) {
        return new CalendarDate(resolution.adjustInto(System.currentTimeMillis()));
    }

    public static CalendarDate make(Date date, Resolution resolution) {
        return new CalendarDate(resolution.adjustInto(date.getTime()));
    }

    public static CalendarDate make(long timeInMIllis, Resolution resolution) {
        return new CalendarDate(resolution.adjustInto(timeInMIllis));
    }

    public static CalendarDate now() {
        return new CalendarDate();
    }

    public static Calendar toCalendar(Instant instant) {
        GregorianCalendar retVal = new GregorianCalendar();
        retVal.setTimeInMillis(instant.toEpochMilli());
        return retVal;
    }

    public static Calendar toCalendar(Instant instant, Locale locale) {
        GregorianCalendar retVal = new GregorianCalendar(locale);
        retVal.setTimeInMillis(instant.toEpochMilli());
        return retVal;
    }

    public static Calendar toCalendar(Instant instant, TimeZone zone) {
        GregorianCalendar retVal = new GregorianCalendar(zone);
        retVal.setTimeInMillis(instant.toEpochMilli());
        return retVal;
    }

    public static Calendar toCalendar(Instant instant, TimeZone zone, Locale locale) {
        GregorianCalendar retVal = new GregorianCalendar(zone, locale);
        retVal.setTimeInMillis(instant.toEpochMilli());
        return retVal;
    }

    public static Date toDate(Instant instant) {
        return new Date(instant.toEpochMilli());
    }

    public static LocalDate toLocalDate(Calendar calendar) {
        int year = calendar.get(1);
        int month = 1 + calendar.get(2);
        int day = calendar.get(5);
        return LocalDate.of(year, month, day);
    }

    public static LocalDate toLocalDate(Instant instant, ZoneId zone) {
        return CalendarDate.toLocalDateTime(instant, zone).toLocalDate();
    }

    public static LocalDateTime toLocalDateTime(Instant instant, ZoneId zone) {
        return LocalDateTime.ofInstant(instant, zone);
    }

    public static LocalTime toLocalTime(Instant instant, ZoneId zone) {
        return CalendarDate.toLocalDateTime(instant, zone).toLocalTime();
    }

    public static OffsetDateTime toOffsetDateTime(Instant instant, ZoneId zone) {
        return OffsetDateTime.ofInstant(instant, zone);
    }

    public static OffsetDateTime toOffsetDateTime(Instant instant, ZoneId zone, Instant zoneToOffsetConversionInstant) {
        return OffsetDateTime.ofInstant(instant, zone).withOffsetSameInstant(OffsetDateTime.ofInstant(zoneToOffsetConversionInstant, zone).getOffset());
    }

    public static OffsetDateTime toOffsetDateTime(Instant instant, ZoneOffset offset) {
        return OffsetDateTime.ofInstant(instant, ZoneId.systemDefault()).withOffsetSameInstant(offset);
    }

    public static ZonedDateTime toZonedDateTime(Instant instant, ZoneId zone) {
        return ZonedDateTime.ofInstant(instant, zone);
    }

    public static CalendarDate valueOf(Instant instant) {
        return new CalendarDate(instant.toEpochMilli());
    }

    public static CalendarDate valueOf(OffsetDateTime offsetDateTime) {
        return new CalendarDate(offsetDateTime.toEpochSecond() * 1000L);
    }

    public static CalendarDate valueOf(ZonedDateTime zonedDateTime) {
        return new CalendarDate(zonedDateTime.toEpochSecond() * 1000L);
    }

    static long millis(TemporalAccessor temporal) {
        if (temporal instanceof CalendarDate) {
            return ((CalendarDate)temporal).millis;
        }
        if (temporal instanceof Instant) {
            return ((Instant)temporal).toEpochMilli();
        }
        try {
            long tmpSeconds = temporal.getLong(ChronoField.INSTANT_SECONDS);
            int tmpMillisOfSecond = temporal.get(ChronoField.MILLI_OF_SECOND);
            return tmpSeconds * 1000L + (long)tmpMillisOfSecond;
        }
        catch (DateTimeException ex) {
            throw new DateTimeException("No millis!");
        }
    }

    public CalendarDate() {
        this.millis = System.currentTimeMillis();
    }

    public CalendarDate(Calendar calendar) {
        this.millis = calendar.getTimeInMillis();
    }

    public CalendarDate(Date date) {
        this.millis = date.getTime();
    }

    public CalendarDate(long timeInMillis) {
        this.millis = timeInMillis;
    }

    public CalendarDate(String sqlString) throws RecoverableCondition {
        boolean tmpTimePart;
        boolean tmpDatePart = sqlString.indexOf(45) >= 0;
        boolean bl = tmpTimePart = sqlString.indexOf(58) >= 0;
        if (tmpDatePart && tmpTimePart) {
            this.millis = ((Date)StandardType.SQL_DATETIME.parse(sqlString)).getTime();
        } else if (tmpDatePart && !tmpTimePart) {
            this.millis = ((Date)StandardType.SQL_DATE.parse(sqlString)).getTime();
        } else if (!tmpDatePart && tmpTimePart) {
            this.millis = ((Date)StandardType.SQL_TIME.parse(sqlString)).getTime();
        } else {
            this.millis = Long.MIN_VALUE;
            throw RecoverableCondition.newFailedToParseString(sqlString, CalendarDate.class);
        }
    }

    public Calendar adjustInto(Calendar temporal) {
        GregorianCalendar retVal = new GregorianCalendar();
        retVal.setTimeInMillis(this.millis);
        return retVal;
    }

    public Date adjustInto(Date temporal) {
        return new Date(this.millis);
    }

    public <T extends Temporal> T adjustInto(T temporal) {
        if (temporal instanceof CalendarDate) {
            return (T)this;
        }
        long seconds = this.millis / 1000L;
        long nanos = this.millis % 1000L * 1000000L;
        return (T)temporal.with(ChronoField.INSTANT_SECONDS, seconds).with(ChronoField.NANO_OF_SECOND, nanos);
    }

    @Override
    public int compareTo(CalendarDate ref) {
        return Long.signum(this.millis - ref.millis);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof CalendarDate)) {
            return false;
        }
        CalendarDate other = (CalendarDate)obj;
        return this.millis == other.millis;
    }

    public CalendarDate filter(CalendarDateUnit resolution) {
        if (resolution.isCalendarUnit()) {
            return resolution.adjustInto(this);
        }
        return new CalendarDate(resolution.adjustInto(this.millis));
    }

    @Override
    public long getLong(TemporalField field) {
        if (field instanceof ChronoField) {
            if (field == ChronoField.INSTANT_SECONDS) {
                return this.millis / 1000L;
            }
            throw new UnsupportedTemporalTypeException("Unsupported field: " + field);
        }
        return field.getFrom(this);
    }

    public int hashCode() {
        return (int)(this.millis ^ this.millis >>> 32);
    }

    @Override
    public boolean isSupported(TemporalField field) {
        if (field instanceof ChronoField) {
            return field == ChronoField.INSTANT_SECONDS || field == ChronoField.MILLI_OF_SECOND;
        }
        return field.isSupportedBy(this);
    }

    @Override
    public boolean isSupported(TemporalUnit unit) {
        if (unit instanceof CalendarDateUnit) {
            return true;
        }
        if (unit instanceof ChronoUnit) {
            return unit.isTimeBased() || unit == ChronoUnit.DAYS;
        }
        if (unit != null) {
            return unit.isSupportedBy(this);
        }
        return false;
    }

    @Override
    public Temporal plus(long amountToAdd, TemporalUnit unit) {
        if (unit instanceof CalendarDateUnit) {
            return this.step((int)amountToAdd, (CalendarDateUnit)unit);
        }
        if (unit instanceof ChronoUnit) {
            return this.toInstant().plus(amountToAdd, unit);
        }
        return unit.addTo(this, amountToAdd);
    }

    public CalendarDate step(CalendarDateDuration aStepDuration) {
        return this.step((int)aStepDuration.measure, aStepDuration.unit);
    }

    public CalendarDate step(CalendarDateUnit aStepUnit) {
        return this.step(1, aStepUnit);
    }

    public CalendarDate step(int aStepCount, CalendarDateUnit aStepUnit) {
        return new CalendarDate(this.millis + (long)aStepCount * aStepUnit.toDurationInMillis());
    }

    public Calendar toCalendar() {
        GregorianCalendar retVal = new GregorianCalendar();
        retVal.setTimeInMillis(this.millis);
        return retVal;
    }

    public Calendar toCalendar(Locale locale) {
        GregorianCalendar retVal = new GregorianCalendar(locale);
        retVal.setTimeInMillis(this.millis);
        return retVal;
    }

    public Calendar toCalendar(TimeZone zone) {
        GregorianCalendar retVal = new GregorianCalendar(zone);
        retVal.setTimeInMillis(this.millis);
        return retVal;
    }

    public Calendar toCalendar(TimeZone zone, Locale locale) {
        GregorianCalendar retVal = new GregorianCalendar(zone, locale);
        retVal.setTimeInMillis(this.millis);
        return retVal;
    }

    public Date toDate() {
        return new Date(this.millis);
    }

    public Instant toInstant() {
        return Instant.ofEpochMilli(this.millis);
    }

    public LocalDate toLocalDate(ZoneOffset offset) {
        long tmpSeconds = Math.floorDiv(this.millis, 1000L);
        long tmpLocalSeconds = tmpSeconds + (long)offset.getTotalSeconds();
        long tmpLocalDay = Math.floorDiv(tmpLocalSeconds, 86400L);
        return LocalDate.ofEpochDay(tmpLocalDay);
    }

    public LocalDateTime toLocalDateTime(ZoneOffset offset) {
        long tmpSeconds = Math.floorDiv(this.millis, 1000L);
        int tmpNanos = (int)Math.floorMod(this.millis, 1000L);
        return LocalDateTime.ofEpochSecond(tmpSeconds, tmpNanos, offset);
    }

    public LocalTime toLocalTime(ZoneOffset offset) {
        long tmpSeconds = Math.floorDiv(this.millis, 1000L);
        int tmpNanos = (int)Math.floorMod(this.millis, 1000L);
        long tmpLocalSeconds = tmpSeconds + (long)offset.getTotalSeconds();
        int tmpSecondOfDay = (int)Math.floorMod(tmpLocalSeconds, 86400L);
        int tmpNanoOfDay = tmpSecondOfDay * 1000000000 + tmpNanos;
        return LocalTime.ofNanoOfDay(tmpNanoOfDay);
    }

    public OffsetDateTime toOffsetDateTime(ZoneOffset offset) {
        return OffsetDateTime.of(this.toLocalDateTime(offset), offset);
    }

    public String toString() {
        return StandardType.SQL_DATETIME.format(this.toDate());
    }

    public ZonedDateTime toZonedDateTime(ZoneOffset offset) {
        return ZonedDateTime.of(this.toLocalDateTime(offset), offset);
    }

    @Override
    public long until(Temporal endExclusive, TemporalUnit unit) {
        if (unit instanceof CalendarDateUnit) {
            return ((CalendarDateUnit)unit).count(this.millis, CalendarDate.millis(endExclusive));
        }
        if (unit instanceof ChronoUnit) {
            return this.toInstant().until(endExclusive, unit);
        }
        return unit.between(this, endExclusive);
    }

    @Override
    public CalendarDate with(TemporalAdjuster adjuster) {
        return (CalendarDate)Temporal.super.with(adjuster);
    }

    @Override
    public CalendarDate with(TemporalField field, long newValue) {
        if (field instanceof ChronoField) {
            if (field == ChronoField.INSTANT_SECONDS) {
                long tmpMillisOfSecond = this.millis % 1000L;
                return new CalendarDate(newValue * 1000L + tmpMillisOfSecond);
            }
            if (field == ChronoField.MILLI_OF_SECOND) {
                long tmpSeconds = this.millis / 1000L;
                return new CalendarDate(tmpSeconds * 1000L + newValue);
            }
            throw new UnsupportedTemporalTypeException("Unsupported field: " + field);
        }
        return field.adjustInto(this, newValue);
    }

    public static interface Resolution
    extends TemporalAdjuster,
    Structure1D.IndexMapper<CalendarDate> {
        default public long addTo(long epochMilli) {
            return epochMilli + this.toDurationInMillis();
        }

        default public long adjustInto(long epochMilli) {
            long duration = this.toDurationInMillis();
            long half = duration / 2L;
            return epochMilli / duration * duration + half;
        }

        public long toDurationInMillis();

        default public long toDurationInNanos() {
            return this.toDurationInMillis() * 1000000L;
        }

        @Override
        default public long toIndex(CalendarDate key) {
            return this.adjustInto(key.millis);
        }

        @Override
        default public CalendarDate toKey(long index) {
            return new CalendarDate(index);
        }

        default public CalendarDate adjustInto(CalendarDate temporal) {
            return new CalendarDate(this.adjustInto(temporal.millis));
        }
    }
}

