/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.type;

public final class IntCount {
    private static final boolean BOOLEAN_FALSE = false;
    private static final boolean BOOLEAN_TRUE = true;
    private static final int INT_ONE = 1;
    private static final int INT_TWO = 2;
    private static final int INT_ZERO = 0;
    public final int count;
    public final boolean modified;

    public IntCount(int aCount) {
        this(aCount, false);
    }

    private IntCount() {
        this(0, false);
    }

    private IntCount(int aCount, boolean aModified) {
        this.count = aCount;
        this.modified = aModified;
    }

    public IntCount decrement() {
        return new IntCount(this.count - 1, true);
    }

    public IntCount duplicate() {
        return new IntCount(this.count * 2, true);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof IntCount)) {
            return false;
        }
        IntCount other = (IntCount)obj;
        if (this.count != other.count) {
            return false;
        }
        return this.modified == other.modified;
    }

    public IntCount halve() {
        return new IntCount(this.count / 2, true);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.count;
        return 31 * result + (this.modified ? 1231 : 1237);
    }

    public IntCount increment() {
        return new IntCount(this.count + 1, true);
    }

    public String toString() {
        return Integer.toString(this.count);
    }
}

