/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.math.interpolate;

import org.meteoinfo.math.interpolate.RectInterpolator;
import org.meteoinfo.ndarray.Array;
import org.meteoinfo.ndarray.Index;
import org.meteoinfo.ndarray.math.ArrayUtil;

public class RectNearestInterpolator
extends RectInterpolator {
    public RectNearestInterpolator(Array xa, Array ya, Array va) {
        super(xa, ya, va);
    }

    @Override
    double cellValue(Index dindex, double x, double y) {
        double y2;
        int[] xyIdx = ArrayUtil.gridIndex((Array)this.xa, (Array)this.ya, (double)x, (double)y);
        if (xyIdx == null) {
            return Double.NaN;
        }
        int i1 = xyIdx[0];
        int j1 = xyIdx[1];
        int i2 = i1 + 1;
        int j2 = j1 + 1;
        double x1 = this.xa.getDouble(j1);
        double x2 = this.xa.getDouble(j2);
        double y1 = this.ya.getDouble(i1);
        int ii = y - y1 < (y2 = this.ya.getDouble(i2)) - y ? i1 : i2;
        int jj = x - x1 < x2 - x ? j1 : j2;
        Index index = this.va.getIndex();
        int n = index.getRank();
        for (int i = 0; i < n - 2; ++i) {
            index.setDim(i, dindex.getCurrentCounter()[i]);
        }
        index.setDim(n - 2, ii);
        index.setDim(n - 1, jj);
        double v = this.va.getDouble(index);
        return v;
    }

    @Override
    double interpolate(double x, double y) {
        double y2;
        int[] xyIdx = ArrayUtil.gridIndex((Array)this.xa, (Array)this.ya, (double)x, (double)y);
        if (xyIdx == null) {
            return Double.NaN;
        }
        int i1 = xyIdx[0];
        int j1 = xyIdx[1];
        int i2 = i1 + 1;
        int j2 = j1 + 1;
        double x1 = this.xa.getDouble(j1);
        double x2 = this.xa.getDouble(j2);
        double y1 = this.ya.getDouble(i1);
        int ii = y - y1 < (y2 = this.ya.getDouble(i2)) - y ? i1 : i2;
        int jj = x - x1 < x2 - x ? j1 : j2;
        Index index = this.va.getIndex();
        index.setDim(0, ii);
        index.setDim(1, jj);
        return this.va.getDouble(index);
    }
}

