/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.math.linalg;

import java.nio.DoubleBuffer;
import java.util.ArrayList;
import java.util.logging.Logger;
import org.apache.commons.math4.legacy.core.Pair;
import org.apache.commons.math4.legacy.fitting.leastsquares.LeastSquaresBuilder;
import org.apache.commons.math4.legacy.fitting.leastsquares.LeastSquaresOptimizer;
import org.apache.commons.math4.legacy.fitting.leastsquares.LeastSquaresProblem;
import org.apache.commons.math4.legacy.fitting.leastsquares.LevenbergMarquardtOptimizer;
import org.apache.commons.math4.legacy.fitting.leastsquares.MultivariateJacobianFunction;
import org.apache.commons.math4.legacy.linear.Array2DRowRealMatrix;
import org.apache.commons.math4.legacy.linear.ArrayRealVector;
import org.apache.commons.math4.legacy.linear.DecompositionSolver;
import org.apache.commons.math4.legacy.linear.RealMatrix;
import org.apache.commons.math4.legacy.linear.RealVector;
import org.apache.commons.math4.legacy.linear.SingularValueDecomposition;
import org.meteoinfo.math.blas.LinearAlgebra;
import org.meteoinfo.math.blas.SVDJob;
import org.meteoinfo.math.blas.UPLO;
import org.meteoinfo.math.matrix.Matrix;
import org.meteoinfo.math.matrix.MatrixUtil;
import org.meteoinfo.ndarray.Array;
import org.meteoinfo.ndarray.DataType;
import org.meteoinfo.ndarray.Index;
import org.meteoinfo.ndarray.InvalidRangeException;
import org.meteoinfo.ndarray.Range;
import org.meteoinfo.ndarray.math.ArrayMath;
import org.meteoinfo.ndarray.math.ArrayUtil;

public class LinalgUtil {
    static Logger logger = Logger.getLogger("LinalgUtil class");

    public static Array cross(Array aa, Array ba) {
        DataType dataType = ArrayMath.commonType((DataType)aa.getDataType(), (DataType)ba.getDataType());
        Array r = Array.factory((DataType)dataType, (int[])aa.getShape());
        double[] a = (double[])aa.get1DJavaArray(Double.TYPE);
        double[] b = (double[])ba.get1DJavaArray(Double.TYPE);
        r.setObject(0, (Object)(a[1] * b[2] - a[2] * b[1]));
        r.setObject(1, (Object)(a[2] * b[0] - a[0] * b[2]));
        r.setObject(2, (Object)(a[0] * b[1] - a[1] * b[0]));
        return r;
    }

    private static Array cross(Array aa, Array ba, DataType dataType) {
        Array r = Array.factory((DataType)dataType, (int[])aa.getShape());
        double[] a = (double[])aa.get1DJavaArray(Double.TYPE);
        double[] b = (double[])ba.get1DJavaArray(Double.TYPE);
        r.setObject(0, (Object)(a[1] * b[2] - a[2] * b[1]));
        r.setObject(1, (Object)(a[2] * b[0] - a[0] * b[2]));
        r.setObject(2, (Object)(a[0] * b[1] - a[1] * b[0]));
        return r;
    }

    public static Array cross(Array a, Array b, int axis) throws InvalidRangeException {
        a = a.copyIfView();
        b = b.copyIfView();
        DataType dataType = ArrayMath.commonType((DataType)a.getDataType(), (DataType)b.getDataType());
        int[] shape = a.getShape();
        Array r = Array.factory((DataType)dataType, (int[])shape);
        int n = 1;
        if (axis == -1) {
            axis = shape.length - 1;
        }
        for (int i = 0; i < shape.length; ++i) {
            if (i == axis) continue;
            n += n * shape[i];
        }
        Index indexR = r.getIndex();
        Index index = a.getIndex();
        int i = 0;
        while ((long)i < r.getSize()) {
            int[] current = indexR.getCurrentCounter();
            if (current[axis] == 0) {
                ArrayList<Range> ranges = new ArrayList<Range>();
                for (int j = 0; j < shape.length; ++j) {
                    if (j == axis) {
                        ranges.add(new Range(0, shape[j] - 1, 1));
                        continue;
                    }
                    ranges.add(new Range(current[j], current[j], 1));
                }
                Array rr = LinalgUtil.cross(a.section(ranges), b.section(ranges), dataType);
                index.set(current);
                r.setObject(index, rr.getObject(0));
                index.setDim(axis, 1);
                r.setObject(index, rr.getObject(1));
                index.setDim(axis, 2);
                r.setObject(index, rr.getObject(2));
            }
            indexR.incr();
            ++i;
        }
        return r;
    }

    public static double cross2D(Array a, Array b) {
        a = a.copyIfView();
        b = b.copyIfView();
        double r = a.getDouble(0) * b.getDouble(1) - a.getDouble(1) * b.getDouble(0);
        return r;
    }

    public static Array dot(Array a, Array b) {
        Matrix ma = MatrixUtil.arrayToMatrix(a);
        Matrix mb = MatrixUtil.arrayToMatrix(b);
        Matrix mr = ma.mm(mb);
        return MatrixUtil.matrixToArray(mr);
    }

    public static Array solve(Array a, Array b) {
        Array r;
        Matrix ma = MatrixUtil.arrayToMatrix(a);
        Matrix.LU lu = ma.lu();
        if (b.getRank() == 1) {
            double[] bb = (double[])ArrayUtil.copyToNDJavaArray_Double((Array)b);
            double[] x = lu.solve(bb);
            r = Array.factory((DataType)DataType.DOUBLE, (int[])b.getShape(), (Object)x);
        } else {
            Matrix mb = MatrixUtil.arrayToMatrix(b);
            lu.solve(mb);
            r = MatrixUtil.matrixToArray(mb);
        }
        return r;
    }

    public static Array cholesky(Array a) {
        return LinalgUtil.cholesky(a, true);
    }

    public static Array cholesky(Array a, boolean lower) {
        UPLO uplo = lower ? UPLO.LOWER : UPLO.UPPER;
        Matrix ma = MatrixUtil.arrayToMatrix(a);
        ma.uplo(uplo);
        Matrix.Cholesky cholesky = ma.cholesky();
        return MatrixUtil.matrixToArray(cholesky.lu, uplo);
    }

    public static Array[] lu(Array a) {
        Matrix ma = new Matrix((double[][])ArrayUtil.copyToNDJavaArray_Double((Array)a));
        Matrix.LU lu = ma.lu();
        Array La = MatrixUtil.matrixToArray(lu.lu, UPLO.LOWER, 1.0);
        Array Ua = MatrixUtil.matrixToArray(lu.lu, UPLO.UPPER);
        int m = lu.ipiv.length;
        Matrix P = new Matrix(m, m);
        for (int i = 0; i < m; ++i) {
            P.set(i, i, 1.0);
        }
        for (int i = 0; i < m; ++i) {
            for (int j = 0; j < m; ++j) {
                double temp = P.get(i, j);
                P.set(i, j, P.get(lu.ipiv[i] - 1, j));
                P.set(lu.ipiv[i] - 1, j, temp);
            }
        }
        P = P.transpose();
        Array Pa = MatrixUtil.matrixToArray(P);
        return new Array[]{Pa, La, Ua};
    }

    public static Array[] qr(Array a) {
        Matrix ma = new Matrix((double[][])ArrayUtil.copyToNDJavaArray_Double((Array)a));
        Matrix.QR qr = ma.qr();
        Array Qa = MatrixUtil.matrixToArray(qr.Q());
        Array Ra = MatrixUtil.matrixToArray(qr.R());
        return new Array[]{Qa, Ra};
    }

    public static Array[] svd(Array a, boolean fullMatrices) {
        int info;
        Matrix VT;
        Matrix U;
        Matrix ma = MatrixUtil.arrayToMatrix(a);
        int m = ma.nrows();
        int n = ma.ncols();
        int k = Math.min(m, n);
        double[] s = new double[k];
        Matrix W = ma;
        if (fullMatrices) {
            U = new Matrix(m, m);
            VT = new Matrix(n, n);
            info = LinearAlgebra.engine.gesdd(W.layout(), SVDJob.ALL, m, n, W.getA(), W.ld(), DoubleBuffer.wrap(s), U.getA(), U.ld(), VT.getA(), VT.ld());
            if (info != 0) {
                logger.severe(String.format("LAPACK GESDD error code: {%s}", info));
                throw new ArithmeticException("LAPACK GESDD error code: " + info);
            }
        } else {
            U = new Matrix(m, k);
            VT = new Matrix(k, n);
            info = LinearAlgebra.engine.gesdd(W.layout(), SVDJob.COMPACT, m, n, W.getA(), W.ld(), DoubleBuffer.wrap(s), U.getA(), U.ld(), VT.getA(), VT.ld());
            if (info != 0) {
                logger.severe(String.format("LAPACK GESDD error code: {%s}", info));
                throw new ArithmeticException("LAPACK GESDD error code: " + info);
            }
        }
        Array Ua = MatrixUtil.matrixToArray(U);
        Array Va = MatrixUtil.matrixToArray(VT);
        Array Sa = Array.factory((DataType)DataType.DOUBLE, (int[])new int[]{s.length}, (Object)s);
        return new Array[]{Ua, Sa, Va};
    }

    public static Array[] eigen(Array a) {
        Array Wa;
        Matrix ma = MatrixUtil.arrayToMatrix(a);
        boolean isSymmetric = MatrixUtil.isSymmetric(ma);
        if (isSymmetric) {
            ma.uplo(UPLO.LOWER);
        }
        Matrix.EVD evd = ma.eigen(false, true, false);
        if (evd.wi == null) {
            Wa = Array.factory((DataType)DataType.DOUBLE, (int[])new int[]{evd.wr.length}, (Object)evd.wr);
        } else {
            boolean isComplex = false;
            for (int i = 0; i < evd.wi.length; ++i) {
                if (evd.wi[i] == 0.0) continue;
                isComplex = true;
                break;
            }
            Wa = isComplex ? MatrixUtil.toArray(evd.wr, evd.wi) : Array.factory((DataType)DataType.DOUBLE, (int[])new int[]{evd.wr.length}, (Object)evd.wr);
        }
        Array Va = MatrixUtil.matrixToArray(evd.Vr);
        return new Array[]{Wa, Va};
    }

    public static Array inv(Array a) {
        Matrix ma = MatrixUtil.arrayToMatrix(a);
        Matrix r = ma.inverse();
        return r == null ? null : MatrixUtil.matrixToArray(r);
    }

    public static Array pinv(Array a) {
        double[][] aa = (double[][])ArrayUtil.copyToNDJavaArray_Double((Array)a);
        Array2DRowRealMatrix matrix = new Array2DRowRealMatrix(aa, false);
        SingularValueDecomposition svd = new SingularValueDecomposition((RealMatrix)matrix);
        DecompositionSolver solver = svd.getSolver();
        RealMatrix pinv = solver.getInverse();
        int n = pinv.getColumnDimension();
        int m = pinv.getRowDimension();
        Array r = Array.factory((DataType)DataType.DOUBLE, (int[])new int[]{m, n});
        for (int i = 0; i < m; ++i) {
            for (int j = 0; j < n; ++j) {
                r.setDouble(i * n + j, pinv.getEntry(i, j));
            }
        }
        return r;
    }

    public static double det(Array a) {
        Matrix ma = MatrixUtil.arrayToMatrix(a);
        Matrix.LU lu = ma.lu();
        return lu.det();
    }

    public static double[] sLogDet(Array a) {
        int n;
        Matrix ma = MatrixUtil.arrayToMatrix(a);
        Matrix.LU lu = ma.lu();
        int m = lu.lu.nrows();
        if (m != (n = lu.lu.ncols())) {
            throw new IllegalArgumentException(String.format("The matrix is not square: %d x %d", m, n));
        }
        double d = 0.0;
        for (int j = 0; j < n; ++j) {
            d += Math.log(Math.abs(lu.lu.get(j, j)));
        }
        int changeSign = 0;
        for (int j = 0; j < n; ++j) {
            if (j + 1 == lu.ipiv[j]) continue;
            ++changeSign;
        }
        int sign = changeSign % 2 > 0 ? -1 : 1;
        return new double[]{sign, d};
    }

    public static Array lstsq(Array a, Array b) {
        final double[][] aa = (double[][])ArrayUtil.copyToNDJavaArray_Double((Array)a);
        final double[] bb = (double[])ArrayUtil.copyToNDJavaArray_Double((Array)b);
        MultivariateJacobianFunction function = new MultivariateJacobianFunction(){

            public Pair<RealVector, RealMatrix> value(RealVector point) {
                ArrayRealVector value = new ArrayRealVector(bb.length);
                Array2DRowRealMatrix jacobian = new Array2DRowRealMatrix(aa, false);
                for (int i = 0; i < bb.length; ++i) {
                }
                return new Pair((Object)value, (Object)jacobian);
            }
        };
        LeastSquaresProblem problem = new LeastSquaresBuilder().model(function).target(bb).lazyEvaluation(false).maxEvaluations(1000).maxIterations(1000).build();
        LeastSquaresOptimizer.Optimum optimum = new LevenbergMarquardtOptimizer().optimize(problem);
        RealVector r = optimum.getPoint();
        int n = r.getDimension();
        Array x = Array.factory((DataType)DataType.DOUBLE, (int[])new int[]{n});
        for (int i = 0; i < n; ++i) {
            x.setDouble(i, r.getEntry(i));
        }
        return x;
    }

    public static void getCofactor(double[][] mat, double[][] temp, int p, int q, int n) {
        int i = 0;
        int j = 0;
        for (int row = 0; row < n; ++row) {
            for (int col = 0; col < n; ++col) {
                if (row == p || col == q) continue;
                temp[i][j++] = mat[row][col];
                if (j != n - 1) continue;
                j = 0;
                ++i;
            }
        }
    }

    public static double determinantOfMatrix(double[][] mat, int n, int N) {
        int D = 0;
        if (n == 1) {
            return mat[0][0];
        }
        double[][] temp = new double[N][N];
        int sign = 1;
        for (int f = 0; f < n; ++f) {
            LinalgUtil.getCofactor(mat, temp, 0, f, n);
            D = (int)((double)D + (double)sign * mat[0][f] * LinalgUtil.determinantOfMatrix(temp, n - 1, N));
            sign = -sign;
        }
        return D;
    }

    public static double determinantOfMatrix(Array mat) {
        int n = mat.getShape()[0];
        double[][] a = (double[][])ArrayUtil.copyToNDJavaArray_Double((Array)mat);
        return LinalgUtil.determinantOfMatrix(a, n, n);
    }
}

