/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.math.matrix;

import java.io.IOException;
import java.io.LineNumberReader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Scanner;
import org.meteoinfo.math.blas.Transpose;
import org.meteoinfo.math.blas.UPLO;
import org.meteoinfo.math.matrix.IMatrix;
import org.meteoinfo.math.matrix.Matrix;
import org.meteoinfo.math.matrix.SparseMatrix;
import org.meteoinfo.math.matrix.SymmMatrix;
import org.meteoinfo.math.util.SparseArray;
import org.meteoinfo.math.util.Strings;

public abstract class DMatrix
extends IMatrix<double[]> {
    public abstract DMatrix set(int var1, int var2, double var3);

    public DMatrix update(int i, int j, double x) {
        return this.set(i, j, x);
    }

    public abstract double get(int var1, int var2);

    public double apply(int i, int j) {
        return this.get(i, j);
    }

    @Override
    String str(int i, int j) {
        return Strings.format(this.get(i, j), true);
    }

    public double[] diag() {
        int n = Math.min(this.nrows(), this.ncols());
        double[] d = new double[n];
        for (int i = 0; i < n; ++i) {
            d[i] = this.get(i, i);
        }
        return d;
    }

    public double trace() {
        int n = Math.min(this.nrows(), this.ncols());
        double t = 0.0;
        for (int i = 0; i < n; ++i) {
            t += this.get(i, i);
        }
        return t;
    }

    public abstract void mv(Transpose var1, double var2, double[] var4, double var5, double[] var7);

    @Override
    public double[] mv(double[] x) {
        double[] y = new double[this.nrows()];
        this.mv(Transpose.NO_TRANSPOSE, 1.0, x, 0.0, y);
        return y;
    }

    @Override
    public void mv(double[] x, double[] y) {
        this.mv(Transpose.NO_TRANSPOSE, 1.0, x, 0.0, y);
    }

    public void mv(double alpha, double[] x, double beta, double[] y) {
        this.mv(Transpose.NO_TRANSPOSE, alpha, x, beta, y);
    }

    @Override
    public double[] tv(double[] x) {
        double[] y = new double[this.ncols()];
        this.mv(Transpose.TRANSPOSE, 1.0, x, 0.0, y);
        return y;
    }

    @Override
    public void tv(double[] x, double[] y) {
        this.mv(Transpose.TRANSPOSE, 1.0, x, 0.0, y);
    }

    public void tv(double alpha, double[] x, double beta, double[] y) {
        this.mv(Transpose.TRANSPOSE, alpha, x, beta, y);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static DMatrix market(Path path) throws IOException, ParseException {
        try (LineNumberReader reader = new LineNumberReader(Files.newBufferedReader(path));
             Scanner scanner = new Scanner(reader);){
            int i;
            ArrayList<SparseArray> rows;
            int[] colSize;
            int nz;
            int ncol;
            int nrow;
            String line;
            boolean skew;
            boolean symmetric;
            block48: {
                block47: {
                    block45: {
                        Matrix matrix;
                        int ncol2;
                        int nrow2;
                        block43: {
                            block46: {
                                block44: {
                                    String format;
                                    block42: {
                                        String header = scanner.next();
                                        if (!header.equals("%%MatrixMarket")) {
                                            throw new ParseException("Invalid Matrix Market file header", reader.getLineNumber());
                                        }
                                        String object = scanner.next();
                                        if (!object.equals("matrix")) {
                                            throw new UnsupportedOperationException("The object is not a matrix file: " + object);
                                        }
                                        format = scanner.next();
                                        String field = scanner.next();
                                        if (field.equals("complex")) throw new UnsupportedOperationException("No support of complex or pattern matrix");
                                        if (field.equals("pattern")) {
                                            throw new UnsupportedOperationException("No support of complex or pattern matrix");
                                        }
                                        String symmetry = scanner.nextLine().trim();
                                        if (symmetry.equals("Hermitian")) {
                                            throw new UnsupportedOperationException("No support of Hermitian matrix");
                                        }
                                        symmetric = symmetry.equals("symmetric");
                                        skew = symmetry.equals("skew-symmetric");
                                        line = scanner.nextLine();
                                        while (line.startsWith("%")) {
                                            line = scanner.nextLine();
                                        }
                                        if (!format.equals("array")) break block42;
                                        Scanner s = new Scanner(line);
                                        nrow2 = s.nextInt();
                                        ncol2 = s.nextInt();
                                        matrix = new Matrix(nrow2, ncol2);
                                        break block43;
                                    }
                                    if (!format.equals("coordinate")) throw new ParseException("Invalid Matrix Market format: " + format, 0);
                                    Scanner s = new Scanner(line);
                                    nrow = s.nextInt();
                                    ncol = s.nextInt();
                                    nz = s.nextInt();
                                    if (!symmetric || nz != nrow * (nrow + 1) / 2) break block44;
                                    if (nrow != ncol) {
                                        throw new IllegalStateException(String.format("Symmetric matrix is not square: %d != %d", nrow, ncol));
                                    }
                                    break block45;
                                }
                                if (!skew || nz != nrow * (nrow + 1) / 2) break block46;
                                if (nrow != ncol) {
                                    throw new IllegalStateException(String.format("Skew-symmetric matrix is not square: %d != %d", nrow, ncol));
                                }
                                break block47;
                            }
                            colSize = new int[ncol];
                            rows = new ArrayList<SparseArray>();
                            for (int i2 = 0; i2 < nrow; ++i2) {
                                rows.add(new SparseArray());
                            }
                            break block48;
                        }
                        for (int j = 0; j < ncol2; ++j) {
                            for (int i3 = 0; i3 < nrow2; ++i3) {
                                double x = scanner.nextDouble();
                                matrix.set(i3, j, x);
                            }
                        }
                        if (symmetric) {
                            matrix.uplo(UPLO.LOWER);
                        }
                        Matrix j = matrix;
                        return j;
                    }
                    SymmMatrix matrix = new SymmMatrix(UPLO.LOWER, nrow);
                    int k2 = 0;
                    while (true) {
                        if (k2 >= nz) {
                            SymmMatrix k2 = matrix;
                            return k2;
                        }
                        String[] tokens = scanner.nextLine().trim().split("\\s+");
                        if (tokens.length != 3) {
                            throw new ParseException("Invalid data line: " + line, reader.getLineNumber());
                        }
                        int i4 = Integer.parseInt(tokens[0]) - 1;
                        int j = Integer.parseInt(tokens[1]) - 1;
                        double x = Double.parseDouble(tokens[2]);
                        matrix.set(i4, j, x);
                        ++k2;
                    }
                }
                Matrix matrix = new Matrix(nrow, ncol);
                int k3 = 0;
                while (true) {
                    if (k3 >= nz) {
                        Matrix k3 = matrix;
                        return k3;
                    }
                    String[] tokens = scanner.nextLine().trim().split("\\s+");
                    if (tokens.length != 3) {
                        throw new ParseException("Invalid data line: " + line, reader.getLineNumber());
                    }
                    int i5 = Integer.parseInt(tokens[0]) - 1;
                    int j = Integer.parseInt(tokens[1]) - 1;
                    double x = Double.parseDouble(tokens[2]);
                    matrix.set(i5, j, x);
                    matrix.set(j, i5, -x);
                    ++k3;
                }
            }
            for (int k = 0; k < nz; ++k) {
                String[] tokens = scanner.nextLine().trim().split("\\s+");
                if (tokens.length != 3) {
                    throw new ParseException("Invalid data line: " + line, reader.getLineNumber());
                }
                i = Integer.parseInt(tokens[0]) - 1;
                int j = Integer.parseInt(tokens[1]) - 1;
                double x = Double.parseDouble(tokens[2]);
                SparseArray row = (SparseArray)rows.get(i);
                row.set(j, x);
                int n = j;
                colSize[n] = colSize[n] + 1;
                if (symmetric) {
                    row = (SparseArray)rows.get(j);
                    row.set(i, x);
                    int n2 = i;
                    colSize[n2] = colSize[n2] + 1;
                    continue;
                }
                if (!skew) continue;
                row = (SparseArray)rows.get(j);
                row.set(i, -x);
                int n3 = i;
                colSize[n3] = colSize[n3] + 1;
            }
            int[] pos = new int[ncol];
            int[] colIndex = new int[ncol + 1];
            for (i = 0; i < ncol; ++i) {
                colIndex[i + 1] = colIndex[i] + colSize[i];
            }
            if (symmetric || skew) {
                nz *= 2;
            }
            int[] rowIndex = new int[nz];
            double[] x = new double[nz];
            for (int i6 = 0; i6 < nrow; ++i6) {
                for (SparseArray.Entry e : (SparseArray)rows.get(i6)) {
                    int j = e.i;
                    int k = colIndex[j] + pos[j];
                    rowIndex[k] = i6;
                    x[k] = e.x;
                    int n = j;
                    pos[n] = pos[n] + 1;
                }
            }
            SparseMatrix sparseMatrix = new SparseMatrix(nrow, ncol, x, rowIndex, colIndex);
            return sparseMatrix;
        }
    }

    DMatrix square() {
        final DMatrix A = this;
        return new DMatrix(){
            private final int m;
            private final int n;
            private final double[] Ax;
            {
                this.m = Math.max(A.nrows(), A.ncols());
                this.n = Math.min(A.nrows(), A.ncols());
                this.Ax = new double[this.m + this.n];
            }

            @Override
            public int nrows() {
                return this.n;
            }

            @Override
            public int ncols() {
                return this.n;
            }

            @Override
            public long size() {
                return this.m + this.n;
            }

            @Override
            public void mv(double[] work, int inputOffset, int outputOffset) {
                System.arraycopy(work, inputOffset, this.Ax, 0, this.n);
                if (A.nrows() >= A.ncols()) {
                    A.mv(this.Ax, 0, this.n);
                    A.tv(this.Ax, this.n, 0);
                } else {
                    A.tv(this.Ax, 0, this.n);
                    A.mv(this.Ax, this.n, 0);
                }
                System.arraycopy(this.Ax, 0, work, outputOffset, this.n);
            }

            @Override
            public void tv(double[] work, int inputOffset, int outputOffset) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void mv(Transpose trans, double alpha, double[] x, double beta, double[] y) {
                throw new UnsupportedOperationException();
            }

            @Override
            public double get(int i, int j) {
                throw new UnsupportedOperationException();
            }

            @Override
            public DMatrix set(int i, int j, double x) {
                throw new UnsupportedOperationException();
            }
        };
    }
}

