/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.data;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.JOptionPane;
import org.meteoinfo.common.util.GlobalUtil;
import org.meteoinfo.data.TableData;
import org.meteoinfo.ndarray.DataType;
import org.meteoinfo.projection.KnownCoordinateSystems;
import org.meteoinfo.projection.ProjectionInfo;

public class StationTableData
extends TableData {
    private ProjectionInfo projInfo;
    private int stIdx;
    private int lonIdx;
    private int latIdx;

    public StationTableData() {
        this.projInfo = KnownCoordinateSystems.geographic.world.WGS1984;
        this.stIdx = 0;
        this.lonIdx = 1;
        this.latIdx = 2;
    }

    public ProjectionInfo getProjectionInfo() {
        return this.projInfo;
    }

    public void setProjectionInfo(ProjectionInfo value) {
        this.projInfo = value;
    }

    public int getStationIndex() {
        return this.stIdx;
    }

    public void setStationIndex(int value) {
        this.stIdx = value;
    }

    public int getLonIndex() {
        return this.lonIdx;
    }

    public void setLonIndex(int value) {
        this.latIdx = value;
    }

    public int getLatIndex() {
        return this.latIdx;
    }

    public void setLatIndex(int value) {
        this.lonIdx = value;
    }

    public void readASCIIFile(String fileName, int lonIdx, int latIdx) throws FileNotFoundException, IOException, Exception {
        this.readASCIIFile(fileName, 0, lonIdx, latIdx);
    }

    public void readASCIIFile(String fileName, int stIdx, int lonIdx, int latIdx) throws FileNotFoundException, IOException, Exception {
        String separator;
        this.lonIdx = lonIdx;
        this.latIdx = latIdx;
        BufferedReader sr = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(fileName), "utf-8"));
        String title = sr.readLine().trim();
        String[] titleArray = GlobalUtil.split((String)title, (String)(separator = GlobalUtil.getDelimiter((String)title)));
        if (titleArray.length < 2) {
            JOptionPane.showMessageDialog(null, "File Format Error!");
            sr.close();
        } else {
            ArrayList<Integer> dataIdxs = new ArrayList<Integer>();
            for (int i = 0; i < titleArray.length; ++i) {
                String fieldName = titleArray[i];
                if (i == lonIdx || i == latIdx) {
                    this.addColumn(fieldName, DataType.FLOAT);
                } else {
                    this.addColumn(fieldName, DataType.STRING);
                }
                dataIdxs.add(i);
            }
            int rn = 0;
            String line = sr.readLine();
            while (line != null) {
                if ((line = line.trim()).isEmpty()) continue;
                String[] dataArray = GlobalUtil.split((String)line, (String)separator);
                this.addRow();
                int cn = 0;
                Iterator iterator = dataIdxs.iterator();
                while (iterator.hasNext()) {
                    int idx = (Integer)iterator.next();
                    if (idx == lonIdx || idx == latIdx) {
                        this.setValue(rn, cn, Float.valueOf(Float.parseFloat(dataArray[idx])));
                    } else {
                        this.setValue(rn, cn, dataArray[idx]);
                    }
                    ++cn;
                }
                ++rn;
                line = sr.readLine();
            }
            sr.close();
        }
    }

    @Override
    public Object clone() {
        StationTableData std = new StationTableData();
        std = (StationTableData)((Object)super.clone());
        std.missingValue = this.missingValue;
        std.projInfo = this.projInfo;
        std.stIdx = this.stIdx;
        std.lonIdx = this.lonIdx;
        std.latIdx = this.latIdx;
        return std;
    }
}

