/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.data;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.ParseException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.JOptionPane;
import org.meteoinfo.common.util.GlobalUtil;
import org.meteoinfo.data.TableData;
import org.meteoinfo.data.analysis.Statistics;
import org.meteoinfo.ndarray.DataType;
import org.meteoinfo.table.DataColumn;
import org.meteoinfo.table.DataRow;
import org.meteoinfo.table.DataTable;

public class TimeTableData
extends TableData {
    private String timeColName;
    private List<LocalDateTime> times;

    public TimeTableData() {
        DataColumn col = new DataColumn("Time", DataType.DATE);
        this.addColumn(col);
        this.times = new ArrayList<LocalDateTime>();
    }

    public TimeTableData(DataTable dataTable, String timeColName) {
        super(dataTable);
        this.timeColName = timeColName;
        this.times = this.getColumnData(timeColName).getData();
    }

    @Override
    public String getTimeColName() {
        return this.timeColName;
    }

    public void setTimeColName(String value) {
        this.timeColName = value;
    }

    public void readASCIIFile(String fileName, int timeColIdx, String formatStr, List<DataColumn> dataColumns) throws FileNotFoundException, IOException, Exception {
        this.addColumn("Time", DataType.DATE);
        BufferedReader sr = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(fileName), "utf-8"));
        String title = sr.readLine().trim();
        String separator = GlobalUtil.getDelimiter((String)title);
        String[] titleArray = GlobalUtil.split((String)title, (String)separator);
        if (titleArray.length < 2) {
            JOptionPane.showMessageDialog(null, "File Format Error!");
            sr.close();
        } else {
            for (DataColumn col : dataColumns) {
                this.addColumn(col);
            }
            DateTimeFormatter format = DateTimeFormatter.ofPattern(formatStr);
            ArrayList<Integer> dataIdxs = new ArrayList<Integer>();
            for (int i = 0; i < titleArray.length; ++i) {
                String fieldName = titleArray[i];
                if (i == timeColIdx) {
                    ((DataColumn)this.getColumns().get(0)).setColumnName(fieldName);
                    continue;
                }
                for (DataColumn col : dataColumns) {
                    if (col.getDataType() == DataType.DATE || !fieldName.equals(col.getColumnName())) continue;
                    dataIdxs.add(i);
                }
            }
            int rn = 0;
            String line = sr.readLine();
            while (line != null) {
                if ((line = line.trim()).isEmpty()) continue;
                String[] dataArray = GlobalUtil.split((String)line, (String)separator);
                this.addRow();
                this.setValue(rn, 0, format.parse(dataArray[timeColIdx]));
                int cn = 1;
                Iterator iterator = dataIdxs.iterator();
                while (iterator.hasNext()) {
                    int idx = (Integer)iterator.next();
                    this.setValue(rn, cn, dataArray[idx]);
                    ++cn;
                }
                ++rn;
                line = sr.readLine();
            }
            sr.close();
        }
    }

    public void readASCIIFile(String fileName, int timeColIdx, String formatStr) throws FileNotFoundException, IOException, Exception {
        this.addColumn("Time", DataType.DATE);
        BufferedReader sr = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(fileName), "utf-8"));
        String title = sr.readLine().trim();
        String separator = GlobalUtil.getDelimiter((String)title);
        String[] titleArray = GlobalUtil.split((String)title, (String)separator);
        if (titleArray.length < 2) {
            JOptionPane.showMessageDialog(null, "File Format Error!");
            sr.close();
        } else {
            DateTimeFormatter format = DateTimeFormatter.ofPattern(formatStr);
            ArrayList<Integer> dataIdxs = new ArrayList<Integer>();
            for (int i = 0; i < titleArray.length; ++i) {
                String fieldName = titleArray[i];
                if (i == timeColIdx) {
                    ((DataColumn)this.getColumns().get(0)).setColumnName(fieldName);
                    continue;
                }
                this.addColumn(fieldName, DataType.STRING);
                dataIdxs.add(i);
            }
            int rn = 0;
            String line = sr.readLine();
            while (line != null) {
                if ((line = line.trim()).isEmpty()) continue;
                String[] dataArray = GlobalUtil.split((String)line, (String)separator);
                this.addRow();
                this.setValue(rn, 0, format.parse(dataArray[timeColIdx]));
                int cn = 1;
                Iterator iterator = dataIdxs.iterator();
                while (iterator.hasNext()) {
                    int idx = (Integer)iterator.next();
                    if (dataArray.length > idx) {
                        this.setValue(rn, cn, dataArray[idx]);
                    } else {
                        this.setValue(rn, cn, "");
                    }
                    ++cn;
                }
                ++rn;
                line = sr.readLine();
            }
            sr.close();
        }
    }

    public int getTimeIndex_Ex(LocalDateTime t) {
        return this.times.indexOf(t);
    }

    public int getTimeIndex(LocalDateTime t) {
        if (t.isBefore(this.times.get(0))) {
            return 0;
        }
        if (t.isAfter(this.times.get(this.times.size() - 1))) {
            return this.times.size() - 1;
        }
        int idx = -1;
        for (int i = 0; i < this.times.size(); ++i) {
            if (t.isAfter(this.times.get(i))) continue;
            idx = i;
            break;
        }
        return idx;
    }

    public List<Integer> getTimeIndex(List<LocalDateTime> ts) {
        ArrayList<Integer> ii = new ArrayList<Integer>();
        for (LocalDateTime t : ts) {
            int i = this.times.indexOf(t);
            if (i < 0) continue;
            ii.add(i);
        }
        return ii;
    }

    public List<Integer> getTimeIndex(LocalDateTime st, LocalDateTime et, int step) {
        int sidx = this.getTimeIndex(st);
        int eidx = this.getTimeIndex(et);
        ArrayList<Integer> ii = new ArrayList<Integer>();
        for (int i = sidx; i < eidx; i += step) {
            ii.add(i);
        }
        return ii;
    }

    public List<Integer> getYears() {
        ArrayList<Integer> years = new ArrayList<Integer>();
        for (DataRow row : this.getRows()) {
            LocalDateTime ldt = (LocalDateTime)row.getValue(this.timeColName);
            int year = ldt.getYear();
            if (years.contains(year)) continue;
            years.add(year);
        }
        return years;
    }

    public List<String> getYearMonths() {
        ArrayList<String> yms = new ArrayList<String>();
        DateTimeFormatter format = DateTimeFormatter.ofPattern("yyyyMM");
        for (DataRow row : this.getRows()) {
            String ym;
            LocalDateTime date = (LocalDateTime)row.getValue(this.timeColName);
            if (date == null || yms.contains(ym = format.format(date))) continue;
            yms.add(ym);
        }
        return yms;
    }

    public List<LocalDateTime> getDates_Day() {
        ArrayList<String> days = new ArrayList<String>();
        ArrayList<LocalDateTime> dates = new ArrayList<LocalDateTime>();
        DateTimeFormatter format = DateTimeFormatter.ofPattern("yyyyMMdd");
        for (DataRow row : this.getRows()) {
            String day;
            LocalDateTime date = (LocalDateTime)row.getValue(this.timeColName);
            if (date == null || days.contains(day = format.format(date))) continue;
            days.add(day);
            dates.add(date);
        }
        return dates;
    }

    public List<LocalDateTime> getDates_Hour() {
        ArrayList<String> hours = new ArrayList<String>();
        ArrayList<LocalDateTime> dates = new ArrayList<LocalDateTime>();
        DateTimeFormatter format = DateTimeFormatter.ofPattern("yyyyMMddHH");
        for (DataRow row : this.getRows()) {
            String hour;
            LocalDateTime date = (LocalDateTime)row.getValue(this.timeColName);
            if (date == null || hours.contains(hour = format.format(date))) continue;
            hours.add(hour);
            dates.add(date);
        }
        return dates;
    }

    public List<DataRow> getDataByYear(int year) {
        ArrayList<DataRow> rows = new ArrayList<DataRow>();
        for (DataRow row : this.getRows()) {
            LocalDateTime ldt = (LocalDateTime)row.getValue(this.timeColName);
            if (ldt.getYear() != year) continue;
            rows.add(row);
        }
        return rows;
    }

    public List<DataRow> getDataBySeason(String season) {
        List<Integer> months = this.getMonthsBySeason(season);
        ArrayList<DataRow> rows = new ArrayList<DataRow>();
        for (DataRow row : this.getRows()) {
            LocalDateTime ldt = (LocalDateTime)row.getValue(this.timeColName);
            int month = ldt.getMonthValue();
            if (!months.contains(month)) continue;
            rows.add(row);
        }
        return rows;
    }

    private List<Integer> getMonthsBySeason(String season) {
        ArrayList<Integer> months = new ArrayList<Integer>();
        if (season.equalsIgnoreCase("spring")) {
            months.add(3);
            months.add(4);
            months.add(5);
        } else if (season.equalsIgnoreCase("summer")) {
            months.add(6);
            months.add(7);
            months.add(8);
        } else if (season.equalsIgnoreCase("autumn")) {
            months.add(9);
            months.add(10);
            months.add(11);
        } else if (season.equalsIgnoreCase("winter")) {
            months.add(12);
            months.add(1);
            months.add(2);
        }
        return months;
    }

    public List<DataRow> getDataByYearMonth(String yearMonth) {
        int year = Integer.parseInt(yearMonth.substring(0, 4));
        int month = Integer.parseInt(yearMonth.substring(4));
        return this.getDataByYearMonth(year, month);
    }

    public List<DataRow> getDataByYearMonth(int year, int month) {
        ArrayList<DataRow> rows = new ArrayList<DataRow>();
        for (DataRow row : this.getRows()) {
            LocalDateTime ldt = (LocalDateTime)row.getValue(this.timeColName);
            if (ldt.getYear() != year || ldt.getMonthValue() != month) continue;
            rows.add(row);
        }
        return rows;
    }

    public List<DataRow> getDataByDate(LocalDateTime date, List<DataRow> drs) {
        ArrayList<DataRow> rows = new ArrayList<DataRow>();
        DateTimeFormatter format = DateTimeFormatter.ofPattern("yyyyMMdd");
        for (DataRow row : drs) {
            LocalDateTime bdate = (LocalDateTime)row.getValue(this.timeColName);
            if (!format.format(bdate).equals(format.format(date))) continue;
            rows.add(row);
        }
        return rows;
    }

    public List<DataRow> getDataByDate_Hour(LocalDateTime date, List<DataRow> drs) {
        ArrayList<DataRow> rows = new ArrayList<DataRow>();
        DateTimeFormatter format = DateTimeFormatter.ofPattern("yyyyMMddHH");
        for (DataRow row : drs) {
            LocalDateTime bdate = (LocalDateTime)row.getValue(this.timeColName);
            if (!format.format(bdate).equals(format.format(date))) continue;
            rows.add(row);
        }
        return rows;
    }

    public List<DataRow> getDataByDate(int year, int month, int day) {
        ArrayList<DataRow> rows = new ArrayList<DataRow>();
        for (DataRow row : this.getRows()) {
            LocalDateTime ldt = (LocalDateTime)row.getValue(this.timeColName);
            if (ldt.getYear() != year || ldt.getMonthValue() != month || ldt.getDayOfMonth() != day) continue;
            rows.add(row);
        }
        return rows;
    }

    public List<DataRow> getDataByDate(int year, int month, int day, int hour) {
        ArrayList<DataRow> rows = new ArrayList<DataRow>();
        for (DataRow row : this.getRows()) {
            LocalDateTime ldt = (LocalDateTime)row.getValue(this.timeColName);
            if (ldt.getYear() != year || ldt.getMonthValue() != month || ldt.getDayOfMonth() != day || ldt.getHour() != hour) continue;
            rows.add(row);
        }
        return rows;
    }

    public List<DataRow> getDataByMonth(int month) {
        ArrayList<DataRow> rows = new ArrayList<DataRow>();
        for (DataRow row : this.getRows()) {
            LocalDateTime ldt = (LocalDateTime)row.getValue(this.timeColName);
            if (ldt.getMonthValue() != month) continue;
            rows.add(row);
        }
        return rows;
    }

    public List<DataRow> getDataByDayOfWeek(int dow) {
        if (++dow == 8) {
            dow = 1;
        }
        ArrayList<DataRow> rows = new ArrayList<DataRow>();
        for (DataRow row : this.getRows()) {
            LocalDateTime ldt = (LocalDateTime)row.getValue(this.timeColName);
            if (ldt.getDayOfWeek().getValue() != dow) continue;
            rows.add(row);
        }
        return rows;
    }

    public List<DataRow> getDataByHour(int hour) {
        ArrayList<DataRow> rows = new ArrayList<DataRow>();
        for (DataRow row : this.getRows()) {
            LocalDateTime ldt = (LocalDateTime)row.getValue(this.timeColName);
            if (ldt.getHour() != hour) continue;
            rows.add(row);
        }
        return rows;
    }

    public DataTable ave_Year(List<DataColumn> cols) throws Exception {
        DataTable rTable = new DataTable();
        rTable.addColumn("Year", DataType.INT);
        for (DataColumn col : cols) {
            rTable.addColumn(col.getColumnName(), DataType.DOUBLE);
        }
        List<Integer> years = this.getYears();
        for (int year : years) {
            DataRow nRow = rTable.addRow();
            nRow.setValue(0, (Object)year);
            List<DataRow> rows = this.getDataByYear(year);
            for (DataColumn col : cols) {
                List<Double> values = this.getValidColumnValues(rows, col);
                nRow.setValue(col.getColumnName(), (Object)Statistics.mean(values));
            }
        }
        return rTable;
    }

    public DataTable ave_Year(List<DataColumn> cols, int year) throws Exception {
        DataTable rTable = new DataTable();
        rTable.addColumn("Year", DataType.INT);
        for (DataColumn col : cols) {
            rTable.addColumn(col.getColumnName(), DataType.DOUBLE);
        }
        DataRow nRow = rTable.addRow();
        nRow.setValue(0, (Object)year);
        List<DataRow> rows = this.getDataByYear(year);
        for (DataColumn col : cols) {
            List<Double> values = this.getValidColumnValues(rows, col);
            nRow.setValue(col.getColumnName(), (Object)Statistics.mean(values));
        }
        return rTable;
    }

    public DataTable sum_Year(List<DataColumn> cols) throws Exception {
        DataTable rTable = new DataTable();
        rTable.addColumn("Year", DataType.INT);
        for (DataColumn col : cols) {
            rTable.addColumn(col.getColumnName(), DataType.DOUBLE);
        }
        List<Integer> years = this.getYears();
        for (int year : years) {
            DataRow nRow = rTable.addRow();
            nRow.setValue(0, (Object)year);
            List<DataRow> rows = this.getDataByYear(year);
            for (DataColumn col : cols) {
                List<Double> values = this.getValidColumnValues(rows, col);
                nRow.setValue(col.getColumnName(), (Object)Statistics.sum(values));
            }
        }
        return rTable;
    }

    public DataTable ave_YearMonth(List<DataColumn> cols, int month) throws Exception {
        DataTable rTable = new DataTable();
        rTable.addColumn("Year", DataType.INT);
        for (DataColumn col : cols) {
            rTable.addColumn(col.getColumnName(), DataType.DOUBLE);
        }
        List<Integer> years = this.getYears();
        for (int year : years) {
            DataRow nRow = rTable.addRow();
            nRow.setValue(0, (Object)year);
            List<DataRow> rows = this.getDataByYearMonth(year, month);
            for (DataColumn col : cols) {
                List<Double> values = this.getValidColumnValues(rows, col);
                nRow.setValue(col.getColumnName(), (Object)Statistics.mean(values));
            }
        }
        return rTable;
    }

    public DataTable sum_YearMonth(List<DataColumn> cols, int month) throws Exception {
        DataTable rTable = new DataTable();
        rTable.addColumn("Year", DataType.INT);
        for (DataColumn col : cols) {
            rTable.addColumn(col.getColumnName(), DataType.DOUBLE);
        }
        List<Integer> years = this.getYears();
        for (int year : years) {
            DataRow nRow = rTable.addRow();
            nRow.setValue(0, (Object)year);
            List<DataRow> rows = this.getDataByYearMonth(year, month);
            for (DataColumn col : cols) {
                List<Double> values = this.getValidColumnValues(rows, col);
                nRow.setValue(col.getColumnName(), (Object)Statistics.sum(values));
            }
        }
        return rTable;
    }

    public DataTable ave_Month(List<DataColumn> cols) throws Exception {
        DataTable rTable = new DataTable();
        rTable.addColumn("YearMonth", DataType.STRING);
        for (DataColumn col : cols) {
            rTable.addColumn(col.getColumnName(), DataType.DOUBLE);
        }
        List<String> yms = this.getYearMonths();
        for (String ym : yms) {
            DataRow nRow = rTable.addRow();
            nRow.setValue(0, (Object)ym);
            List<DataRow> rows = this.getDataByYearMonth(ym);
            for (DataColumn col : cols) {
                List<Double> values = this.getValidColumnValues(rows, col);
                nRow.setValue(col.getColumnName(), (Object)Statistics.mean(values));
            }
        }
        return rTable;
    }

    public DataTable sum_Month(List<DataColumn> cols) throws Exception {
        DataTable rTable = new DataTable();
        rTable.addColumn("YearMonth", DataType.STRING);
        for (DataColumn col : cols) {
            rTable.addColumn(col.getColumnName(), DataType.DOUBLE);
        }
        List<String> yms = this.getYearMonths();
        for (String ym : yms) {
            DataRow nRow = rTable.addRow();
            nRow.setValue(0, (Object)ym);
            List<DataRow> rows = this.getDataByYearMonth(ym);
            for (DataColumn col : cols) {
                List<Double> values = this.getValidColumnValues(rows, col);
                nRow.setValue(col.getColumnName(), (Object)Statistics.sum(values));
            }
        }
        return rTable;
    }

    public DataTable ave_Day(List<DataColumn> cols) throws Exception {
        DataTable rTable = new DataTable();
        rTable.addColumn(new DataColumn("Date", DataType.DATE, "yyyyMMdd"));
        for (DataColumn col : cols) {
            rTable.addColumn(col.getColumnName(), DataType.DOUBLE);
        }
        List<LocalDateTime> days = this.getDates_Day();
        ArrayList<DataRow> drs = new ArrayList<DataRow>((Collection<DataRow>)this.getRows());
        for (LocalDateTime day : days) {
            DataRow nRow = rTable.addRow();
            nRow.setValue(0, (Object)day);
            List<DataRow> rows = this.getDataByDate(day, drs);
            drs.removeAll(rows);
            for (DataColumn col : cols) {
                List<Double> values = this.getValidColumnValues(rows, col);
                nRow.setValue(col.getColumnName(), (Object)Statistics.mean(values));
            }
        }
        return rTable;
    }

    public DataTable sum_Day(List<DataColumn> cols) throws Exception {
        DataTable rTable = new DataTable();
        rTable.addColumn(new DataColumn("Date", DataType.DATE, "yyyyMMdd"));
        for (DataColumn col : cols) {
            rTable.addColumn(col.getColumnName(), DataType.DOUBLE);
        }
        List<LocalDateTime> days = this.getDates_Day();
        ArrayList<DataRow> drs = new ArrayList<DataRow>((Collection<DataRow>)this.getRows());
        for (LocalDateTime day : days) {
            DataRow nRow = rTable.addRow();
            nRow.setValue(0, (Object)day);
            List<DataRow> rows = this.getDataByDate(day, drs);
            drs.removeAll(rows);
            for (DataColumn col : cols) {
                List<Double> values = this.getValidColumnValues(rows, col);
                nRow.setValue(col.getColumnName(), (Object)Statistics.sum(values));
            }
        }
        return rTable;
    }

    public DataTable ave_Hour(List<DataColumn> cols) throws Exception {
        DataTable rTable = new DataTable();
        rTable.addColumn(new DataColumn("Date", DataType.DATE, "yyyyMMddHH"));
        for (DataColumn col : cols) {
            rTable.addColumn(col.getColumnName(), DataType.DOUBLE);
        }
        List<LocalDateTime> hours = this.getDates_Hour();
        ArrayList<DataRow> drs = new ArrayList<DataRow>((Collection<DataRow>)this.getRows());
        for (LocalDateTime hour : hours) {
            DataRow nRow = rTable.addRow();
            nRow.setValue(0, (Object)hour);
            List<DataRow> rows = this.getDataByDate_Hour(hour, drs);
            drs.removeAll(rows);
            for (DataColumn col : cols) {
                List<Double> values = this.getValidColumnValues(rows, col);
                nRow.setValue(col.getColumnName(), (Object)Statistics.mean(values));
            }
        }
        return rTable;
    }

    public DataTable sum_Hour(List<DataColumn> cols) throws Exception {
        DataTable rTable = new DataTable();
        rTable.addColumn(new DataColumn("Date", DataType.DATE, "yyyyMMddHH"));
        for (DataColumn col : cols) {
            rTable.addColumn(col.getColumnName(), DataType.DOUBLE);
        }
        List<LocalDateTime> hours = this.getDates_Hour();
        ArrayList<DataRow> drs = new ArrayList<DataRow>((Collection<DataRow>)this.getRows());
        for (LocalDateTime hour : hours) {
            DataRow nRow = rTable.addRow();
            nRow.setValue(0, (Object)hour);
            List<DataRow> rows = this.getDataByDate_Hour(hour, drs);
            drs.removeAll(rows);
            for (DataColumn col : cols) {
                List<Double> values = this.getValidColumnValues(rows, col);
                nRow.setValue(col.getColumnName(), (Object)Statistics.sum(values));
            }
        }
        return rTable;
    }

    public DataTable ave_MonthOfYear(List<DataColumn> cols) throws Exception {
        int i;
        DataTable rTable = new DataTable();
        rTable.addColumn("Month", DataType.STRING);
        for (DataColumn col : cols) {
            rTable.addColumn(col.getColumnName(), DataType.DOUBLE);
        }
        List<String> monthNames = Arrays.asList("Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec");
        ArrayList<Integer> months = new ArrayList<Integer>();
        for (i = 1; i < 13; ++i) {
            months.add(i);
        }
        i = 0;
        Iterator iterator = months.iterator();
        while (iterator.hasNext()) {
            int month = (Integer)iterator.next();
            DataRow nRow = rTable.addRow();
            nRow.setValue(0, (Object)monthNames.get(i));
            List<DataRow> rows = this.getDataByMonth(month);
            for (DataColumn col : cols) {
                List<Double> values = this.getValidColumnValues(rows, col);
                nRow.setValue(col.getColumnName(), (Object)Statistics.mean(values));
            }
            ++i;
        }
        return rTable;
    }

    public DataTable sum_MonthOfYear(List<DataColumn> cols) throws Exception {
        int i;
        DataTable rTable = new DataTable();
        rTable.addColumn("Month", DataType.STRING);
        for (DataColumn col : cols) {
            rTable.addColumn(col.getColumnName(), DataType.DOUBLE);
        }
        List<String> monthNames = Arrays.asList("Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec");
        ArrayList<Integer> months = new ArrayList<Integer>();
        for (i = 1; i < 13; ++i) {
            months.add(i);
        }
        i = 0;
        Iterator iterator = months.iterator();
        while (iterator.hasNext()) {
            int month = (Integer)iterator.next();
            DataRow nRow = rTable.addRow();
            nRow.setValue(0, (Object)monthNames.get(i));
            List<DataRow> rows = this.getDataByMonth(month);
            for (DataColumn col : cols) {
                List<Double> values = this.getValidColumnValues(rows, col);
                nRow.setValue(col.getColumnName(), (Object)Statistics.sum(values));
            }
            ++i;
        }
        return rTable;
    }

    public DataTable ave_SeasonOfYear(List<DataColumn> cols) throws Exception {
        DataTable rTable = new DataTable();
        rTable.addColumn("Season", DataType.STRING);
        for (DataColumn col : cols) {
            rTable.addColumn(col.getColumnName(), DataType.DOUBLE);
        }
        List<String> seasons = Arrays.asList("Spring", "Summer", "Autumn", "Winter");
        for (String season : seasons) {
            DataRow nRow = rTable.addRow();
            nRow.setValue(0, (Object)season);
            List<DataRow> rows = this.getDataBySeason(season);
            for (DataColumn col : cols) {
                List<Double> values = this.getValidColumnValues(rows, col);
                nRow.setValue(col.getColumnName(), (Object)Statistics.mean(values));
            }
        }
        return rTable;
    }

    public DataTable sum_SeasonOfYear(List<DataColumn> cols) throws Exception {
        DataTable rTable = new DataTable();
        rTable.addColumn("Season", DataType.STRING);
        for (DataColumn col : cols) {
            rTable.addColumn(col.getColumnName(), DataType.DOUBLE);
        }
        List<String> seasons = Arrays.asList("Spring", "Summer", "Autumn", "Winter");
        for (String season : seasons) {
            DataRow nRow = rTable.addRow();
            nRow.setValue(0, (Object)season);
            List<DataRow> rows = this.getDataBySeason(season);
            for (DataColumn col : cols) {
                List<Double> values = this.getValidColumnValues(rows, col);
                nRow.setValue(col.getColumnName(), (Object)Statistics.mean(values));
            }
        }
        return rTable;
    }

    public DataTable ave_DayOfWeek(List<DataColumn> cols) throws Exception {
        int i;
        DataTable rTable = new DataTable();
        rTable.addColumn("Day", DataType.STRING);
        for (DataColumn col : cols) {
            rTable.addColumn(col.getColumnName(), DataType.STRING);
        }
        List<String> dowNames = Arrays.asList("Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday");
        ArrayList<Integer> dows = new ArrayList<Integer>();
        dows.add(7);
        for (i = 1; i < 7; ++i) {
            dows.add(i);
        }
        i = 0;
        Iterator iterator = dows.iterator();
        while (iterator.hasNext()) {
            int dow = (Integer)iterator.next();
            DataRow nRow = rTable.addRow();
            nRow.setValue(0, (Object)dowNames.get(i));
            List<DataRow> rows = this.getDataByDayOfWeek(dow);
            for (DataColumn col : cols) {
                List<Double> values = this.getValidColumnValues(rows, col);
                nRow.setValue(col.getColumnName(), (Object)Statistics.mean(values));
            }
            ++i;
        }
        return rTable;
    }

    public DataTable sum_DayOfWeek(List<DataColumn> cols) throws Exception {
        int i;
        DataTable rTable = new DataTable();
        rTable.addColumn("Day", DataType.STRING);
        for (DataColumn col : cols) {
            rTable.addColumn(col.getColumnName(), DataType.DOUBLE);
        }
        List<String> dowNames = Arrays.asList("Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday");
        ArrayList<Integer> dows = new ArrayList<Integer>();
        dows.add(7);
        for (i = 1; i < 7; ++i) {
            dows.add(i);
        }
        i = 0;
        Iterator iterator = dows.iterator();
        while (iterator.hasNext()) {
            int dow = (Integer)iterator.next();
            DataRow nRow = rTable.addRow();
            nRow.setValue(0, (Object)dowNames.get(i));
            List<DataRow> rows = this.getDataByDayOfWeek(dow);
            for (DataColumn col : cols) {
                List<Double> values = this.getValidColumnValues(rows, col);
                nRow.setValue(col.getColumnName(), (Object)Statistics.sum(values));
            }
            ++i;
        }
        return rTable;
    }

    public DataTable ave_HourOfDay(List<DataColumn> cols) throws Exception {
        DataTable rTable = new DataTable();
        rTable.addColumn("Hour", DataType.INT);
        for (DataColumn col : cols) {
            rTable.addColumn(col.getColumnName(), DataType.DOUBLE);
        }
        ArrayList<Integer> hours = new ArrayList<Integer>();
        for (int i = 0; i < 24; ++i) {
            hours.add(i);
        }
        Iterator iterator = hours.iterator();
        while (iterator.hasNext()) {
            int hour = (Integer)iterator.next();
            DataRow nRow = rTable.addRow();
            nRow.setValue(0, (Object)hour);
            List<DataRow> rows = this.getDataByHour(hour);
            for (DataColumn col : cols) {
                List<Double> values = this.getValidColumnValues(rows, col);
                nRow.setValue(col.getColumnName(), (Object)Statistics.mean(values));
            }
        }
        return rTable;
    }

    public DataTable sum_HourOfDay(List<DataColumn> cols) throws Exception {
        DataTable rTable = new DataTable();
        rTable.addColumn("Hour", DataType.INT);
        for (DataColumn col : cols) {
            rTable.addColumn(col.getColumnName(), DataType.DOUBLE);
        }
        ArrayList<Integer> hours = new ArrayList<Integer>();
        for (int i = 0; i < 24; ++i) {
            hours.add(i);
        }
        Iterator iterator = hours.iterator();
        while (iterator.hasNext()) {
            int hour = (Integer)iterator.next();
            DataRow nRow = rTable.addRow();
            nRow.setValue(0, (Object)hour);
            List<DataRow> rows = this.getDataByHour(hour);
            for (DataColumn col : cols) {
                List<Double> values = this.getValidColumnValues(rows, col);
                nRow.setValue(col.getColumnName(), (Object)Statistics.sum(values));
            }
        }
        return rTable;
    }

    public static List<LocalDateTime> getDateList(LocalDateTime stdate, LocalDateTime enddate, String tdtype, int timeDelt) throws FileNotFoundException, IOException, ParseException {
        ArrayList<LocalDateTime> dates = new ArrayList<LocalDateTime>();
        block14: while (stdate.isBefore(enddate)) {
            dates.add(stdate);
            switch (tdtype.toUpperCase()) {
                case "YEAR": {
                    stdate = stdate.plusYears(timeDelt);
                    continue block14;
                }
                case "MONTH": {
                    stdate = stdate.plusMonths(timeDelt);
                    continue block14;
                }
                case "DAY": {
                    stdate = stdate.plusDays(timeDelt);
                    continue block14;
                }
                case "HOUR": {
                    stdate = stdate.plusHours(timeDelt);
                    continue block14;
                }
                case "MINUTE": {
                    stdate = stdate.plusMinutes(timeDelt);
                    continue block14;
                }
            }
            stdate = stdate.plusSeconds(timeDelt);
        }
        dates.add(enddate);
        return dates;
    }

    public TimeTableData timeOrder(LocalDateTime stdate, LocalDateTime enddate, String tdtype, int timeDelt) throws IOException, FileNotFoundException, ParseException, Exception {
        List<LocalDateTime> dateList = TimeTableData.getDateList(stdate, enddate, tdtype, timeDelt);
        int lineNum = this.getRowCount();
        int colNum = this.getColumnCount();
        DataTable outData = new DataTable();
        for (DataColumn col : this.getDataColumns()) {
            outData.addColumn((DataColumn)col.clone());
        }
        for (int i = 0; i < dateList.size(); ++i) {
            outData.addRow();
            ++i;
        }
        for (int i = 0; i < lineNum; ++i) {
            LocalDateTime date = (LocalDateTime)this.getValue(i, this.timeColName);
            int idx = dateList.indexOf(date);
            if (idx < 0) continue;
            for (int j = 0; j < colNum; ++j) {
                outData.setValue(idx, j, this.getValue(i, j));
            }
        }
        TimeTableData r = new TimeTableData(outData, this.timeColName);
        return r;
    }
}

