/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.data.mathparser;

import java.util.Arrays;
import org.meteoinfo.data.DataMath;
import org.meteoinfo.data.mathparser.ExpressionBase;

public class FunctionExpression
extends ExpressionBase {
    private String _function;
    private static final String[] mathFunctions = new String[]{"abs", "acos", "asin", "atan", "cos", "exp", "log", "log10", "sin", "sqrt", "tan"};

    public FunctionExpression(String function) {
        this(function, true);
    }

    @Override
    public int getArgumentCount() {
        return 1;
    }

    protected FunctionExpression(String function, boolean validate) {
        function = function.toLowerCase();
        if (validate && !FunctionExpression.isFunction(function)) {
            throw new IllegalArgumentException("Invalid function name");
        }
        this._function = function;
    }

    public static boolean isFunction(String function) {
        int idx = Arrays.binarySearch(mathFunctions, function);
        return idx >= 0;
    }

    @Override
    public Object evaluate(Object[] numbers) {
        super.validate(numbers);
        if (this._function.equals("abs")) {
            return DataMath.abs(numbers[0]);
        }
        if (this._function.equals("acos")) {
            return DataMath.acos(numbers[0]);
        }
        if (this._function.equals("asin")) {
            return DataMath.asin(numbers[0]);
        }
        if (this._function.equals("atan")) {
            return DataMath.atan(numbers[0]);
        }
        if (this._function.equals("cos")) {
            return DataMath.cos(numbers[0]);
        }
        if (this._function.equals("exp")) {
            return DataMath.exp(numbers[0]);
        }
        if (this._function.equals("log")) {
            return DataMath.log(numbers[0]);
        }
        if (this._function.equals("log10")) {
            return DataMath.log10(numbers[0]);
        }
        if (this._function.equals("sin")) {
            return DataMath.sin(numbers[0]);
        }
        if (this._function.equals("sqrt")) {
            return DataMath.sqrt(numbers[0]);
        }
        if (this._function.equals("tan")) {
            return DataMath.tan(numbers[0]);
        }
        return null;
    }

    public String toString() {
        return this._function;
    }

    public static String[] getFunctionNames() {
        return mathFunctions;
    }
}

