/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.data.meteodata.radar;

import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.ByteOrder;
import org.meteoinfo.common.DataConvert;

public class CutConfig {
    public static int length = 256;
    public int processMode;
    public int waveForm;
    public float PRF1;
    public float PRF2;
    public int deAliasingMode;
    public float azimuth;
    public float elevation;
    public float startAngle;
    public float endAngle;
    public float angularResolution;
    public float scanSpeed;
    public int logResolution;
    public int dopplerResolution;
    public int maximumRange1;
    public int maximumRange2;
    public int startRange;
    public int sample1;
    public int sample2;
    public int phaseMode;
    public float atmosphericLoss;
    public float nyquistSpeed;
    public long momentsMask;
    public long momentsSizeMask;
    public int miscFilterMask;
    public float SQIThreshold;
    public float SIGThreshold;
    public float CSRThreshold;
    public float LOGThreshold;
    public float CPAThreshold;
    public float PMIThreshold;
    public float DPLOGThreshold;
    public byte[] thresholdsReserved;
    public int dBTMask;
    public int dBZMask;
    public int velocityMask;
    public int spectrumWidthMask;
    public int DPMask;
    public byte[] maskReserved;
    public byte[] reserved;
    public int direction;
    public short groundClutterClassifierType;
    public short groundClutterFilterType;
    public short groundClutterNotchWidth;
    public short groundClutterFilterWindow;
    public byte[] reserved2;

    public CutConfig(RandomAccessFile raf) throws IOException {
        byte[] bytes = new byte[4];
        raf.read(bytes);
        this.processMode = DataConvert.bytes2Int((byte[])bytes, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
        raf.read(bytes);
        this.waveForm = DataConvert.bytes2Int((byte[])bytes, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
        raf.read(bytes);
        this.PRF1 = DataConvert.bytes2Float((byte[])bytes, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
        raf.read(bytes);
        this.PRF2 = DataConvert.bytes2Float((byte[])bytes, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
        raf.read(bytes);
        this.deAliasingMode = DataConvert.bytes2Int((byte[])bytes, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
        raf.read(bytes);
        this.azimuth = DataConvert.bytes2Float((byte[])bytes, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
        raf.read(bytes);
        this.elevation = DataConvert.bytes2Float((byte[])bytes, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
        raf.read(bytes);
        this.startAngle = DataConvert.bytes2Float((byte[])bytes, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
        raf.read(bytes);
        this.endAngle = DataConvert.bytes2Float((byte[])bytes, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
        raf.read(bytes);
        this.angularResolution = DataConvert.bytes2Float((byte[])bytes, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
        raf.read(bytes);
        this.scanSpeed = DataConvert.bytes2Float((byte[])bytes, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
        raf.read(bytes);
        this.logResolution = DataConvert.bytes2Int((byte[])bytes, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
        raf.read(bytes);
        this.dopplerResolution = DataConvert.bytes2Int((byte[])bytes, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
        raf.read(bytes);
        this.maximumRange1 = DataConvert.bytes2Int((byte[])bytes, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
        raf.read(bytes);
        this.maximumRange2 = DataConvert.bytes2Int((byte[])bytes, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
        raf.read(bytes);
        this.startRange = DataConvert.bytes2Int((byte[])bytes, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
        raf.read(bytes);
        this.sample1 = DataConvert.bytes2Int((byte[])bytes, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
        raf.read(bytes);
        this.sample2 = DataConvert.bytes2Int((byte[])bytes, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
        raf.read(bytes);
        this.phaseMode = DataConvert.bytes2Int((byte[])bytes, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
        raf.read(bytes);
        this.atmosphericLoss = DataConvert.bytes2Float((byte[])bytes, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
        raf.read(bytes);
        this.nyquistSpeed = DataConvert.bytes2Float((byte[])bytes, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
        bytes = new byte[8];
        raf.read(bytes);
        this.momentsMask = DataConvert.bytes2Long((byte[])bytes, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
        raf.read(bytes);
        this.momentsSizeMask = DataConvert.bytes2Long((byte[])bytes, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
        bytes = new byte[4];
        raf.read(bytes);
        this.miscFilterMask = DataConvert.bytes2Int((byte[])bytes, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
        raf.read(bytes);
        this.SQIThreshold = DataConvert.bytes2Float((byte[])bytes, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
        raf.read(bytes);
        this.SIGThreshold = DataConvert.bytes2Float((byte[])bytes, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
        raf.read(bytes);
        this.CSRThreshold = DataConvert.bytes2Float((byte[])bytes, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
        raf.read(bytes);
        this.LOGThreshold = DataConvert.bytes2Float((byte[])bytes, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
        raf.read(bytes);
        this.CPAThreshold = DataConvert.bytes2Float((byte[])bytes, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
        raf.read(bytes);
        this.PMIThreshold = DataConvert.bytes2Float((byte[])bytes, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
        raf.read(bytes);
        this.DPLOGThreshold = DataConvert.bytes2Float((byte[])bytes, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
        this.thresholdsReserved = new byte[4];
        raf.read(this.thresholdsReserved);
        raf.read(bytes);
        this.dBTMask = DataConvert.bytes2Int((byte[])bytes, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
        raf.read(bytes);
        this.dBZMask = DataConvert.bytes2Int((byte[])bytes, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
        raf.read(bytes);
        this.velocityMask = DataConvert.bytes2Int((byte[])bytes, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
        raf.read(bytes);
        this.spectrumWidthMask = DataConvert.bytes2Int((byte[])bytes, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
        raf.read(bytes);
        this.DPMask = DataConvert.bytes2Int((byte[])bytes, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
        this.maskReserved = new byte[12];
        raf.read(this.maskReserved);
        this.reserved = new byte[4];
        raf.read(this.reserved);
        raf.read(bytes);
        this.direction = DataConvert.bytes2Int((byte[])bytes, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
        bytes = new byte[2];
        raf.read(bytes);
        this.groundClutterClassifierType = DataConvert.bytes2Short((byte[])bytes, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
        raf.read(bytes);
        this.groundClutterFilterType = DataConvert.bytes2Short((byte[])bytes, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
        raf.read(bytes);
        this.groundClutterNotchWidth = DataConvert.bytes2Short((byte[])bytes, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
        raf.read(bytes);
        this.groundClutterFilterWindow = DataConvert.bytes2Short((byte[])bytes, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
        this.reserved2 = new byte[72];
        raf.read(this.reserved2);
    }

    public CutConfig(InputStream raf) throws IOException {
        byte[] bytes = new byte[4];
        raf.read(bytes);
        this.processMode = DataConvert.bytes2Int((byte[])bytes, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
        raf.read(bytes);
        this.waveForm = DataConvert.bytes2Int((byte[])bytes, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
        raf.read(bytes);
        this.PRF1 = DataConvert.bytes2Float((byte[])bytes, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
        raf.read(bytes);
        this.PRF2 = DataConvert.bytes2Float((byte[])bytes, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
        raf.read(bytes);
        this.deAliasingMode = DataConvert.bytes2Int((byte[])bytes, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
        raf.read(bytes);
        this.azimuth = DataConvert.bytes2Float((byte[])bytes, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
        raf.read(bytes);
        this.elevation = DataConvert.bytes2Float((byte[])bytes, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
        raf.read(bytes);
        this.startAngle = DataConvert.bytes2Float((byte[])bytes, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
        raf.read(bytes);
        this.endAngle = DataConvert.bytes2Float((byte[])bytes, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
        raf.read(bytes);
        this.angularResolution = DataConvert.bytes2Float((byte[])bytes, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
        raf.read(bytes);
        this.scanSpeed = DataConvert.bytes2Float((byte[])bytes, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
        raf.read(bytes);
        this.logResolution = DataConvert.bytes2Int((byte[])bytes, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
        raf.read(bytes);
        this.dopplerResolution = DataConvert.bytes2Int((byte[])bytes, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
        raf.read(bytes);
        this.maximumRange1 = DataConvert.bytes2Int((byte[])bytes, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
        raf.read(bytes);
        this.maximumRange2 = DataConvert.bytes2Int((byte[])bytes, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
        raf.read(bytes);
        this.startRange = DataConvert.bytes2Int((byte[])bytes, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
        raf.read(bytes);
        this.sample1 = DataConvert.bytes2Int((byte[])bytes, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
        raf.read(bytes);
        this.sample2 = DataConvert.bytes2Int((byte[])bytes, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
        raf.read(bytes);
        this.phaseMode = DataConvert.bytes2Int((byte[])bytes, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
        raf.read(bytes);
        this.atmosphericLoss = DataConvert.bytes2Float((byte[])bytes, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
        raf.read(bytes);
        this.nyquistSpeed = DataConvert.bytes2Float((byte[])bytes, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
        bytes = new byte[8];
        raf.read(bytes);
        this.momentsMask = DataConvert.bytes2Long((byte[])bytes, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
        raf.read(bytes);
        this.momentsSizeMask = DataConvert.bytes2Long((byte[])bytes, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
        bytes = new byte[4];
        raf.read(bytes);
        this.miscFilterMask = DataConvert.bytes2Int((byte[])bytes, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
        raf.read(bytes);
        this.SQIThreshold = DataConvert.bytes2Float((byte[])bytes, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
        raf.read(bytes);
        this.SIGThreshold = DataConvert.bytes2Float((byte[])bytes, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
        raf.read(bytes);
        this.CSRThreshold = DataConvert.bytes2Float((byte[])bytes, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
        raf.read(bytes);
        this.LOGThreshold = DataConvert.bytes2Float((byte[])bytes, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
        raf.read(bytes);
        this.CPAThreshold = DataConvert.bytes2Float((byte[])bytes, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
        raf.read(bytes);
        this.PMIThreshold = DataConvert.bytes2Float((byte[])bytes, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
        raf.read(bytes);
        this.DPLOGThreshold = DataConvert.bytes2Float((byte[])bytes, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
        this.thresholdsReserved = new byte[4];
        raf.read(this.thresholdsReserved);
        raf.read(bytes);
        this.dBTMask = DataConvert.bytes2Int((byte[])bytes, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
        raf.read(bytes);
        this.dBZMask = DataConvert.bytes2Int((byte[])bytes, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
        raf.read(bytes);
        this.velocityMask = DataConvert.bytes2Int((byte[])bytes, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
        raf.read(bytes);
        this.spectrumWidthMask = DataConvert.bytes2Int((byte[])bytes, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
        raf.read(bytes);
        this.DPMask = DataConvert.bytes2Int((byte[])bytes, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
        this.maskReserved = new byte[12];
        raf.read(this.maskReserved);
        this.reserved = new byte[4];
        raf.read(this.reserved);
        raf.read(bytes);
        this.direction = DataConvert.bytes2Int((byte[])bytes, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
        bytes = new byte[2];
        raf.read(bytes);
        this.groundClutterClassifierType = DataConvert.bytes2Short((byte[])bytes, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
        raf.read(bytes);
        this.groundClutterFilterType = DataConvert.bytes2Short((byte[])bytes, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
        raf.read(bytes);
        this.groundClutterNotchWidth = DataConvert.bytes2Short((byte[])bytes, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
        raf.read(bytes);
        this.groundClutterFilterWindow = DataConvert.bytes2Short((byte[])bytes, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
        this.reserved2 = new byte[72];
        raf.read(this.reserved2);
    }
}

