/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.data.meteodata.radar;

import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.meteoinfo.data.dimarray.Dimension;
import org.meteoinfo.data.meteodata.Attribute;
import org.meteoinfo.data.meteodata.radar.BaseRadarDataInfo;
import org.meteoinfo.data.meteodata.radar.IRadarDataInfo;
import org.meteoinfo.data.meteodata.radar.RadarDataType;
import org.meteoinfo.data.meteodata.radar.RadialRecord;
import org.meteoinfo.ndarray.math.ArrayUtil;

public class SCRadarDataInfo
extends BaseRadarDataInfo
implements IRadarDataInfo {
    @Override
    public boolean isValidFile(RandomAccessFile raf) {
        return false;
    }

    void setScaleOffset(RadialRecord record, float maxV) {
        switch (record.product) {
            case "dBZ": 
            case "dBT": {
                record.scale = 0.5f;
                record.offset = -32.0f;
                break;
            }
            case "V": {
                record.scale = maxV / 127.5f;
                record.offset = -128.0f * maxV / 127.5f;
                break;
            }
            case "W": {
                record.scale = maxV / 256.0f;
                record.offset = 0.0f;
            }
        }
    }

    @Override
    void readDataInfo(InputStream is) {
        try {
            byte[] bytes = new byte[RadarHeader.length];
            is.read(bytes);
            RadarHeader radarHeader = new RadarHeader(bytes);
            ArrayList<String> products = new ArrayList<String>(Arrays.asList("dBZ", "V", "dBT", "W"));
            float maxV = radarHeader.layerParams.get(0).getMaxV();
            for (String product : products) {
                RadialRecord record = new RadialRecord(product);
                record.setBinLength(1);
                this.setScaleOffset(record, maxV);
                this.recordMap.put(product, record);
            }
            int gateNum = 998;
            byte[] rhBytes = new byte[RadialHeader.length];
            for (int iSweep = 0; iSweep < radarHeader.nSweeps; ++iSweep) {
                LayerParam layerParam = radarHeader.layerParams.get(iSweep);
                maxV = (float)layerParam.maxV / 100.0f;
                for (int iRadial = 0; iRadial < layerParam.recordNumber; ++iRadial) {
                    is.read(rhBytes);
                    RadialHeader radialHeader = new RadialHeader(rhBytes);
                    bytes = new byte[gateNum * 4];
                    is.read(bytes);
                    int i = 0;
                    for (String product : products) {
                        RadialRecord record = (RadialRecord)this.recordMap.get(product);
                        if (iRadial == 0) {
                            record.fixedElevation.add(Float.valueOf(layerParam.getSweepAngle()));
                            record.elevation.add(new ArrayList());
                            record.azimuth.add(new ArrayList());
                            record.azimuthMinIndex.add(0);
                            record.disResolution.add(Float.valueOf((float)layerParam.binWidth / 10.0f));
                            record.distance.add(ArrayUtil.arrayRange1((Number)0, (int)gateNum, (Number)(layerParam.binWidth / 10)));
                            record.newScanData();
                        }
                        record.elevation.get(record.elevation.size() - 1).add(Float.valueOf(radialHeader.getElevation()));
                        record.addAzimuth(radialHeader.getAzimuth());
                        byte[] data = new byte[gateNum];
                        for (int j = 0; j < 998; ++j) {
                            data[j] = bytes[4 * j + i];
                        }
                        record.addDataBytes(data);
                        ++i;
                    }
                }
            }
            is.close();
            this.addAttribute(new Attribute("Country", radarHeader.country));
            this.addAttribute(new Attribute("Province", radarHeader.province));
            this.addAttribute(new Attribute("StationName", radarHeader.station));
            this.addAttribute(new Attribute("StationLongitude", Float.valueOf(radarHeader.getLongitude())));
            this.addAttribute(new Attribute("StationLatitude", Float.valueOf(radarHeader.getLatitude())));
            this.addAttribute(new Attribute("AntennaHeight", Float.valueOf(radarHeader.getHeight())));
            this.addAttribute(new Attribute("featureType", "RADIAL"));
            this.addAttribute(new Attribute("DataType", "Radial"));
            this.addAttribute(new Attribute("RadarDataType", "SC"));
            RadialRecord refRadialRecord = (RadialRecord)this.recordMap.get("dBZ");
            this.radialDim = new Dimension();
            this.radialDim.setName("radial");
            this.radialDim.setLength(refRadialRecord.getMaxRadials());
            this.addDimension(this.radialDim);
            this.scanDim = new Dimension();
            this.scanDim.setName("scan");
            this.scanDim.setLength(refRadialRecord.getScanNumber());
            this.addDimension(this.scanDim);
            this.gateRDim = new Dimension();
            this.gateRDim.setName("gateR");
            this.gateRDim.setLength(refRadialRecord.getGateNumber(0));
            this.addDimension(this.gateRDim);
            this.makeRefVariables(refRadialRecord);
            RadialRecord velRadialRecord = (RadialRecord)this.recordMap.get("V");
            this.gateVDim = new Dimension();
            this.gateVDim.setName("gateV");
            this.gateVDim.setLength(velRadialRecord.getGateNumber(0));
            this.addDimension(this.gateVDim);
            this.makeVelVariables(velRadialRecord);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public RadarDataType getRadarDataType() {
        return RadarDataType.SC;
    }

    static class RadialHeader {
        public static int length = 8;
        public short startAzimuth;
        public short startElevation;
        public short endAzimuth;
        public short endElevation;

        public RadialHeader(byte[] inBytes) throws IOException {
            ByteBuffer byteBuffer = ByteBuffer.wrap(inBytes);
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            this.startAzimuth = byteBuffer.getShort();
            this.startElevation = byteBuffer.getShort();
            this.endAzimuth = byteBuffer.getShort();
            this.endElevation = byteBuffer.getShort();
        }

        public float getAzimuth() {
            return (float)this.startAzimuth * 360.0f / 65536.0f;
        }

        public float getElevation() {
            return (float)this.startElevation * 120.0f / 65536.0f;
        }
    }

    static class RadarHeader {
        public static int length = 1024;
        public String country;
        public String province;
        public String station;
        public String stationID;
        public String radarType;
        public String longitudeStr;
        public String latitudeStr;
        public int longitude;
        public int latitude;
        public int height;
        public short maxAngle;
        public short opAngle;
        public short mangFreq;
        public int antennaG;
        public short beamH;
        public short beamL;
        public byte polarizations;
        public byte sideLobe;
        public int power;
        public int waveLength;
        public short logA;
        public short lineA;
        public short AGCP;
        public byte clutterT;
        public byte velocityP;
        public byte filderP;
        public byte noiseT;
        public byte SQIT;
        public byte intensityC;
        public byte intensityR;
        public byte sType;
        public short sYear;
        public byte sMonth;
        public byte sDay;
        public byte sHour;
        public byte sMinute;
        public byte sSecond;
        public byte timeP;
        public int sMillisecond;
        public byte calibration;
        public byte intensityI;
        public byte velocityP1;
        public List<LayerParam> layerParams;
        public short RHIA;
        public short RHIL;
        public short RHIH;
        public short eYear;
        public byte eMonth;
        public byte eDay;
        public byte eHour;
        public byte eMinute;
        public byte eSecond;
        public byte eTenth;
        public int nSweeps;

        public RadarHeader(byte[] inBytes) throws UnsupportedEncodingException {
            ByteBuffer byteBuffer = ByteBuffer.wrap(inBytes);
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            byte[] bytes = new byte[30];
            byteBuffer.get(bytes);
            String charsetName = "GB2312";
            this.country = new String(bytes, charsetName);
            bytes = new byte[20];
            byteBuffer.get(bytes);
            this.province = new String(bytes, charsetName);
            bytes = new byte[40];
            byteBuffer.get(bytes);
            this.station = new String(bytes, charsetName);
            bytes = new byte[10];
            byteBuffer.get(bytes);
            this.stationID = new String(bytes, charsetName);
            bytes = new byte[20];
            byteBuffer.get(bytes);
            this.radarType = new String(bytes, charsetName);
            bytes = new byte[16];
            byteBuffer.get(bytes);
            this.longitudeStr = new String(bytes, charsetName);
            bytes = new byte[16];
            byteBuffer.get(bytes);
            this.latitudeStr = new String(bytes, charsetName);
            this.longitude = byteBuffer.getInt();
            this.latitude = byteBuffer.getInt();
            this.height = byteBuffer.getInt();
            this.maxAngle = byteBuffer.getShort();
            this.opAngle = byteBuffer.getShort();
            this.mangFreq = byteBuffer.getShort();
            this.antennaG = byteBuffer.getInt();
            this.beamH = byteBuffer.getShort();
            this.beamL = byteBuffer.getShort();
            this.polarizations = byteBuffer.get();
            this.sideLobe = byteBuffer.get();
            this.power = byteBuffer.getInt();
            this.waveLength = byteBuffer.getInt();
            this.logA = byteBuffer.getShort();
            this.lineA = byteBuffer.getShort();
            this.AGCP = byteBuffer.getShort();
            this.clutterT = byteBuffer.get();
            this.velocityP = byteBuffer.get();
            this.filderP = byteBuffer.get();
            this.noiseT = byteBuffer.get();
            this.SQIT = byteBuffer.get();
            this.intensityC = byteBuffer.get();
            this.intensityR = byteBuffer.get();
            this.sType = byteBuffer.get();
            this.nSweeps = this.sType - 100;
            this.sYear = byteBuffer.getShort();
            this.sMonth = byteBuffer.get();
            this.sDay = byteBuffer.get();
            this.sHour = byteBuffer.get();
            this.sMinute = byteBuffer.get();
            this.sSecond = byteBuffer.get();
            this.timeP = byteBuffer.get();
            this.sMillisecond = byteBuffer.getInt();
            this.calibration = byteBuffer.get();
            this.intensityI = byteBuffer.get();
            this.velocityP1 = byteBuffer.get();
            this.layerParams = new ArrayList<LayerParam>();
            for (int i = 0; i < this.nSweeps; ++i) {
                this.layerParams.add(new LayerParam(byteBuffer));
            }
            this.RHIA = byteBuffer.getShort();
            this.RHIL = byteBuffer.getShort();
            this.RHIH = byteBuffer.getShort();
            this.eYear = byteBuffer.getShort();
            this.eMonth = byteBuffer.get();
            this.eDay = byteBuffer.get();
            this.eHour = byteBuffer.get();
            this.eMinute = byteBuffer.get();
            this.eSecond = byteBuffer.get();
            this.eTenth = byteBuffer.get();
        }

        public float getLongitude() {
            return (float)this.longitude / 100.0f;
        }

        public float getLatitude() {
            return (float)this.latitude / 100.0f;
        }

        public float getHeight() {
            return (float)this.height / 1000.0f;
        }
    }

    static class LayerParam {
        public byte ambiguousP;
        public short aRotate;
        public short prf1;
        public short prf2;
        public short sPulseW;
        public short maxV;
        public short maxL;
        public short binWidth;
        public short binNumber;
        public short recordNumber;
        public short swAngles;

        public LayerParam(ByteBuffer byteBuffer) {
            this.ambiguousP = byteBuffer.get();
            this.aRotate = byteBuffer.getShort();
            this.prf1 = byteBuffer.getShort();
            this.prf2 = byteBuffer.getShort();
            this.sPulseW = byteBuffer.getShort();
            this.maxV = byteBuffer.getShort();
            this.maxL = byteBuffer.getShort();
            this.binWidth = byteBuffer.getShort();
            this.binNumber = byteBuffer.getShort();
            this.recordNumber = byteBuffer.getShort();
            this.swAngles = byteBuffer.getShort();
        }

        public float getMaxV() {
            return (float)this.maxV / 100.0f;
        }

        public int getBinWidth() {
            return this.binWidth / 10;
        }

        public float getSweepAngle() {
            return (float)this.swAngles / 100.0f;
        }
    }
}

