/*
 * Decompiled with CFR 0.152.
 */
package us.hebi.matlab.mat.format;

import java.io.IOException;
import us.hebi.matlab.mat.format.Compat;
import us.hebi.matlab.mat.format.Mat5Serializable;
import us.hebi.matlab.mat.format.Mat5WriteUtil;
import us.hebi.matlab.mat.format.NumberStore;
import us.hebi.matlab.mat.format.UniversalNumberStore;
import us.hebi.matlab.mat.types.AbstractSparse;
import us.hebi.matlab.mat.types.MatlabType;
import us.hebi.matlab.mat.types.Sink;
import us.hebi.matlab.mat.types.Sparse;
import us.hebi.matlab.mat.util.Casts;
import us.hebi.matlab.mat.util.Preconditions;

class MatSparseCSC
extends AbstractSparse
implements Sparse,
Mat5Serializable,
Mat5Serializable.Mat5Attributes {
    private final NumberStore columnIndices;
    private final NumberStore rowIndices;
    private final NumberStore real;
    private final NumberStore imaginary;
    private final boolean logical;
    private final boolean complex;
    final int nzMax;

    MatSparseCSC(int[] dims, boolean logical, int nzMax, NumberStore real, NumberStore imaginary, NumberStore rowIndices, NumberStore columnIndices) {
        super(dims);
        if (columnIndices.getNumElements() != this.getNumCols() + 1) {
            throw new IllegalArgumentException("Expected (numCols + 1) column indices");
        }
        if (rowIndices.getNumElements() != nzMax) {
            throw new IllegalArgumentException("Expected nzMax row indices");
        }
        if (real.getNumElements() > nzMax) {
            throw new IllegalArgumentException("Expected data with fewer than " + nzMax + " elements");
        }
        this.real = Preconditions.checkNotNull(real);
        this.imaginary = imaginary;
        this.nzMax = nzMax;
        this.complex = imaginary != null;
        this.logical = logical;
        this.columnIndices = columnIndices;
        this.rowIndices = rowIndices;
    }

    @Override
    public boolean isLogical() {
        return this.logical;
    }

    @Override
    public boolean isComplex() {
        return this.complex;
    }

    @Override
    public double getDouble(int index) {
        return this.orLogical(index < 0 ? this.getDefaultValue() : this.real.getDouble(index));
    }

    @Override
    public void setDouble(int index, double value) {
        throw new IllegalStateException("This sparse matrix can't be modified.");
    }

    @Override
    public double getImaginaryDouble(int index) {
        if (!this.complex) {
            return 0.0;
        }
        return this.orLogical(index < 0 ? this.getDefaultValue() : this.imaginary.getDouble(index));
    }

    @Override
    public void setImaginaryDouble(int index, double value) {
        throw new IllegalStateException("This sparse matrix can't be modified.");
    }

    @Override
    protected int getColumnMajorIndex(int row, int col) {
        int fromIndex = Casts.sint32(this.columnIndices.getLong(col));
        int toIndex = Casts.sint32(this.columnIndices.getLong(col + 1));
        return this.searchRowBinary(fromIndex, toIndex, row);
    }

    protected int searchRowLinear(int fromIndex, int toIndex, int row) {
        for (int i = fromIndex; i < toIndex; ++i) {
            if (this.rowIndices.getLong(i) != (long)row) continue;
            return i;
        }
        return -1;
    }

    protected int searchRowBinary(int fromIndex, int toIndex, int row) {
        int low = fromIndex;
        int high = toIndex - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            int midVal = Casts.sint32(this.rowIndices.getLong(mid));
            if (midVal < row) {
                low = mid + 1;
                continue;
            }
            if (midVal > row) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -1;
    }

    @Override
    public int getNzMax() {
        return this.nzMax;
    }

    @Override
    public int getNumNonZero() {
        return this.real.getNumElements();
    }

    @Override
    public void forEach(Sparse.SparseConsumer action) {
        int i0 = (int)this.columnIndices.getLong(0);
        for (int col = 0; col < this.getNumCols(); ++col) {
            int i1 = (int)this.columnIndices.getLong(col + 1);
            for (int i = i0; i < i1; ++i) {
                int row = (int)this.rowIndices.getLong(i);
                double imag = this.complex ? this.imaginary.getDouble(i) : 0.0;
                action.accept(row, col, this.real.getDouble(i), imag);
            }
            i0 = i1;
        }
    }

    @Override
    public void close() throws IOException {
        this.rowIndices.close();
        this.columnIndices.close();
        this.real.close();
        if (this.complex) {
            this.imaginary.close();
        }
    }

    @Override
    public int getMat5Size(String name) {
        return 8 + Mat5WriteUtil.computeArrayHeaderSize(name, this) + this.rowIndices.getMat5Size() + this.columnIndices.getMat5Size() + this.real.getMat5Size() + (this.complex ? this.imaginary.getMat5Size() : 0);
    }

    @Override
    public void writeMat5(String name, boolean isGlobal, Sink sink) throws IOException {
        Mat5WriteUtil.writeMatrixTag(name, this, sink);
        Mat5WriteUtil.writeArrayHeader(name, isGlobal, this, sink);
        this.rowIndices.writeMat5(sink);
        this.columnIndices.writeMat5(sink);
        this.real.writeMat5(sink);
        if (this.complex) {
            this.imaginary.writeMat5(sink);
        }
    }

    @Override
    protected int subHashCode() {
        return Compat.hash(this.nzMax, this.logical, this.complex, UniversalNumberStore.hashCodeForType(this.imaginary, this.logical, MatlabType.Double), UniversalNumberStore.hashCodeForType(this.real, this.logical, MatlabType.Double), UniversalNumberStore.hashCodeForType(this.rowIndices, this.logical, MatlabType.Int64), UniversalNumberStore.hashCodeForType(this.columnIndices, this.logical, MatlabType.Int64));
    }

    @Override
    protected boolean subEqualsGuaranteedSameClass(Object otherGuaranteedSameClass) {
        MatSparseCSC other = (MatSparseCSC)otherGuaranteedSameClass;
        return other.nzMax == this.nzMax && other.logical == this.logical && other.complex == this.complex && UniversalNumberStore.equalForType(other.imaginary, this.imaginary, this.logical, MatlabType.Double) && UniversalNumberStore.equalForType(other.real, this.real, this.logical, MatlabType.Double) && UniversalNumberStore.equalForType(other.rowIndices, this.rowIndices, this.logical, MatlabType.Int64) && UniversalNumberStore.equalForType(other.columnIndices, this.columnIndices, this.logical, MatlabType.Int64);
    }
}

