/*
 * Decompiled with CFR 0.152.
 */
package us.hebi.matlab.mat.types;

import us.hebi.matlab.mat.types.AbstractArray;
import us.hebi.matlab.mat.types.Char;
import us.hebi.matlab.mat.types.MatlabType;

public abstract class AbstractCharBase
extends AbstractArray
implements Char {
    protected final StringBuilder builder = new StringBuilder();

    protected AbstractCharBase(int[] dims) {
        super(dims);
    }

    @Override
    public abstract CharSequence asCharSequence();

    @Override
    public abstract char getChar(int var1);

    @Override
    public abstract void setChar(int var1, char var2);

    @Override
    public MatlabType getType() {
        return MatlabType.Character;
    }

    @Override
    public String getString() {
        if (this.getNumRows() != 1) {
            throw new IllegalStateException("Char is not a single row char string");
        }
        return this.getRow(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getRow(int row) {
        this.checkNumDimensions(2);
        int numCols = this.getNumCols();
        StringBuilder stringBuilder = this.builder;
        synchronized (stringBuilder) {
            char c;
            this.builder.ensureCapacity(numCols);
            this.builder.setLength(0);
            for (int col = 0; col < numCols && (c = this.getChar(row, col)) != '\u0000'; ++col) {
                this.builder.append(c);
            }
            return this.builder.toString();
        }
    }

    @Override
    public char getChar(int row, int col) {
        return this.getChar(this.getColumnMajorIndex(row, col));
    }

    @Override
    public char getChar(int[] indices) {
        return this.getChar(this.getColumnMajorIndex(indices));
    }

    @Override
    public void setChar(int row, int col, char value) {
        this.setChar(this.getColumnMajorIndex(row, col), value);
    }

    @Override
    public void setChar(int[] indices, char value) {
        this.setChar(this.getColumnMajorIndex(indices), value);
    }
}

