/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.ndarray.io.npy;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.function.BiConsumer;
import org.meteoinfo.ndarray.Array;
import org.meteoinfo.ndarray.io.npy.ArrayChannelReader;
import org.meteoinfo.ndarray.io.npy.NpyByteOrder;
import org.meteoinfo.ndarray.io.npy.NpyDataType;
import org.meteoinfo.ndarray.io.npy.NpyHeader;
import org.meteoinfo.ndarray.io.npy.NpyUtil;
import org.meteoinfo.ndarray.io.npy.dict.NpyHeaderDict;

public class Npy {
    public static Array load(String fileName) {
        File file = new File(fileName);
        return Npy.load(file);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static Array load(File file) {
        try (RandomAccessFile f = new RandomAccessFile(file, "r");){
            Array array;
            block13: {
                FileChannel channel = f.getChannel();
                try {
                    NpyHeader header = NpyHeader.read(channel);
                    array = ArrayChannelReader.read(channel, header);
                    if (channel == null) break block13;
                }
                catch (Throwable throwable) {
                    if (channel != null) {
                        try {
                            channel.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                channel.close();
            }
            return array;
        }
        catch (IOException e) {
            throw new RuntimeException("failed to read file: " + file, e);
        }
    }

    public static Array load(ReadableByteChannel channel) {
        try {
            NpyHeader header = NpyHeader.read(channel);
            return ArrayChannelReader.read(channel, header);
        }
        catch (IOException e) {
            throw new RuntimeException("failed to read NPY array from channel", e);
        }
    }

    public static void use(File file, BiConsumer<RandomAccessFile, NpyHeader> fn) {
        try (RandomAccessFile raf = new RandomAccessFile(file, "r");
             FileChannel channel = raf.getChannel();){
            NpyHeader header = NpyHeader.read(channel);
            fn.accept(raf, header);
        }
        catch (IOException e) {
            throw new RuntimeException("failed to use NPY file: " + file, e);
        }
    }

    static NpyHeaderDict shape1d(NpyHeaderDict dict, int n) {
        return NpyHeaderDict.of(dict.dataType()).withTypeSize(dict.typeSize()).withByteOrder(dict.byteOrder()).withFortranOrder(dict.hasFortranOrder()).withShape(new int[]{n}).create();
    }

    public static void save(String fileName, Array array) {
        File file = new File(fileName);
        Npy.save(file, array);
    }

    public static void save(File file, Array array) {
        try (RandomAccessFile f = new RandomAccessFile(file, "rw");
             FileChannel channel = f.getChannel();){
            Npy.save(channel, array);
        }
        catch (IOException e) {
            throw new RuntimeException("failed to write array to file " + file, e);
        }
    }

    public static void save(WritableByteChannel channel, Array array) {
        try {
            NpyDataType dataType = NpyUtil.toNpyDataType(array.getDataType());
            NpyHeaderDict dict = NpyHeaderDict.of(dataType).withShape(array.getShape()).withFortranOrder(false).withByteOrder(NpyByteOrder.LITTLE_ENDIAN).create();
            channel.write(ByteBuffer.wrap(dict.toNpyHeader()));
            ByteBuffer buffer = array.getDataAsByteBuffer(ByteOrder.LITTLE_ENDIAN);
            channel.write(buffer);
        }
        catch (IOException e) {
            throw new RuntimeException("failed to write NPY array to channel", e);
        }
    }

    public static void save(OutputStream outputStream, Array array) {
        WritableByteChannel channel = Channels.newChannel(outputStream);
        Npy.save(channel, array);
    }

    public static void write(File file, NpyHeaderDict dict, byte[] data) {
        try (RandomAccessFile f = new RandomAccessFile(file, "rw");
             FileChannel channel = f.getChannel();){
            Npy.write(channel, dict, data);
        }
        catch (IOException e) {
            throw new RuntimeException("failed to write npy data to file " + file, e);
        }
    }

    private static void write(WritableByteChannel channel, NpyHeaderDict dict, byte[] data) {
        try {
            byte[] header = dict.toNpyHeader();
            channel.write(ByteBuffer.wrap(header));
            channel.write(ByteBuffer.wrap(data));
        }
        catch (Exception e) {
            throw new RuntimeException("failed to write npy data", e);
        }
    }
}

