/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.ndarray.io.npy;

import java.util.EnumSet;
import org.meteoinfo.ndarray.io.npy.NpyByteOrder;

public enum NpyDataType {
    bool("?", 1, new String[]{"b1", "bool", "bool8", "bool_"}),
    f2("f2", 2, new String[]{"e", "float16", "half"}),
    f4("f4", 4, new String[]{"f", "float32", "single"}),
    f8("f8", 8, new String[]{"d", "double", "float", "float64", "float_", "g", "longdouble", "longfloat"}),
    i1("b", 1, new String[]{"byte", "i1", "int8"}),
    i2("i2", 2, new String[]{"h", "int16", "short"}),
    i4("i4", 4, new String[]{"i", "int", "int32", "int_", "intc", "l", "long"}),
    i8("i8", 8, new String[]{"int0", "int64", "intp", "longlong", "p", "q"}),
    u1("B", 1, new String[]{"u1", "ubyte", "uint8"}),
    u2("u2", 2, new String[]{"H", "uint16", "ushort"}),
    u4("u4", 4, new String[]{"I", "L", "uint", "uint32", "uintc"}),
    u8("u8", 8, new String[]{"P", "Q", "Uint64", "uint0", "uint64", "uintp", "ulonglong"}),
    S("S", 0, new String[]{"Bytes0", "a", "bytes", "bytes0", "bytes_", "string_"}),
    U("U", 0, new String[]{"Str0", "str", "str0", "str_", "unicode", "unicode_"});

    private final String symbol;
    private final int size;
    private final String[] synonyms;

    private NpyDataType(String symbol, int size, String[] synonyms) {
        this.symbol = symbol;
        this.size = size;
        this.synonyms = synonyms;
    }

    public String toString() {
        return this.symbol;
    }

    public String symbol() {
        return this.symbol;
    }

    public int size() {
        return this.size;
    }

    public static NpyDataType of(String dtype) {
        if (dtype == null || dtype.length() == 0) {
            return null;
        }
        char first = dtype.charAt(0);
        boolean hasOrderMark = first == '<' || first == '>' || first == '=' || first == '|';
        String symbol = hasOrderMark ? dtype.substring(1) : dtype;
        for (NpyDataType type : NpyDataType.values()) {
            if (symbol.equals(type.symbol())) {
                return type;
            }
            String[] stringArray = type.synonyms;
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String name = stringArray[i];
                if (!symbol.equals(name)) continue;
                return type;
            }
        }
        int digetPos = -1;
        for (int i = 0; i < symbol.length(); ++i) {
            char c = symbol.charAt(i);
            if (!Character.isDigit(c)) continue;
            digetPos = i;
            break;
        }
        if (digetPos == 0) {
            return null;
        }
        if (digetPos > 0) {
            symbol = symbol.substring(0, digetPos);
        }
        for (NpyDataType type : EnumSet.of(S, U)) {
            if (type.symbol.equals(symbol)) {
                return type;
            }
            for (String syn : type.synonyms) {
                if (!syn.equals(symbol)) continue;
                return type;
            }
        }
        return null;
    }

    public static NpyByteOrder byteOrderOf(String dtype) {
        if (dtype == null || dtype.length() == 0) {
            return NpyByteOrder.NOT_APPLICABLE;
        }
        switch (dtype.charAt(0)) {
            case '=': {
                return NpyByteOrder.HARDWARE_NATIVE;
            }
            case '>': {
                return NpyByteOrder.BIG_ENDIAN;
            }
            case '<': {
                return NpyByteOrder.LITTLE_ENDIAN;
            }
        }
        return NpyByteOrder.NOT_APPLICABLE;
    }
}

