/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.ndarray.io.npy;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.function.Consumer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.meteoinfo.ndarray.Array;
import org.meteoinfo.ndarray.io.npy.Npy;

public class Npz {
    public static ZipFile open(String fileName) {
        File file = new File(fileName);
        try {
            ZipFile zipFile = new ZipFile(file);
            return zipFile;
        }
        catch (IOException e) {
            throw new RuntimeException("failed to read zip file: " + fileName, e);
        }
    }

    public static List<String> entries(String fileName) {
        File file = new File(fileName);
        return Npz.entries(file);
    }

    public static List<String> entries(File npz) {
        List<String> list;
        ZipFile zip = new ZipFile(npz);
        try {
            list = Npz.entries(zip);
        }
        catch (Throwable throwable) {
            try {
                try {
                    zip.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException("failed to read zip file: " + npz, e);
            }
        }
        zip.close();
        return list;
    }

    public static List<String> entries(ZipFile npz) {
        ArrayList<String> entries = new ArrayList<String>();
        Enumeration<? extends ZipEntry> zipEntries = npz.entries();
        while (zipEntries.hasMoreElements()) {
            ZipEntry e = zipEntries.nextElement();
            if (e.isDirectory()) continue;
            entries.add(e.getName());
        }
        return entries;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static Array load(ZipFile npz, String entry) {
        ZipEntry e = npz.getEntry(entry);
        try (InputStream stream = npz.getInputStream(e);){
            Array array;
            block14: {
                ReadableByteChannel channel = Channels.newChannel(stream);
                try {
                    array = Npy.load(channel);
                    if (channel == null) break block14;
                }
                catch (Throwable throwable) {
                    if (channel != null) {
                        try {
                            channel.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                channel.close();
            }
            return array;
        }
        catch (IOException ex) {
            throw new RuntimeException("failed to read entry " + entry, ex);
        }
    }

    public static void use(File npz, Consumer<ZipFile> fn) {
        try (ZipFile zip = new ZipFile(npz);){
            fn.accept(zip);
        }
        catch (IOException e) {
            throw new RuntimeException("failed to use NPZ file " + npz, e);
        }
    }

    public static void create(File file, Consumer<ZipOutputStream> fn) {
        try (FileOutputStream fileOut = new FileOutputStream(file);
             ZipOutputStream zipOut = new ZipOutputStream(fileOut);){
            fn.accept(zipOut);
        }
        catch (IOException e) {
            throw new RuntimeException("failed to create NPZ file: " + file, e);
        }
    }

    public static ZipOutputStream create(File file) {
        FileOutputStream fileOut = null;
        try {
            fileOut = new FileOutputStream(file);
            ZipOutputStream zipOut = new ZipOutputStream(fileOut);
            return zipOut;
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public static ZipOutputStream create(String fileName) {
        File file = new File(fileName);
        return Npz.create(file);
    }

    public static void write(ZipOutputStream npz, String entry, Array array) {
        ZipEntry e = new ZipEntry(entry);
        try {
            npz.putNextEntry(e);
            Npy.save(npz, array);
            npz.closeEntry();
        }
        catch (IOException ex) {
            throw new RuntimeException("failed to write NPZ entry: " + entry, ex);
        }
    }
}

