/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.ndarray.io.npy.dict;

import java.util.ArrayList;
import java.util.List;
import org.meteoinfo.ndarray.io.npy.dict.Lexer;
import org.meteoinfo.ndarray.io.npy.dict.PyDict;
import org.meteoinfo.ndarray.io.npy.dict.PyError;
import org.meteoinfo.ndarray.io.npy.dict.PyIdentifier;
import org.meteoinfo.ndarray.io.npy.dict.PyInt;
import org.meteoinfo.ndarray.io.npy.dict.PyString;
import org.meteoinfo.ndarray.io.npy.dict.PyTuple;
import org.meteoinfo.ndarray.io.npy.dict.PyValue;
import org.meteoinfo.ndarray.io.npy.dict.Token;
import org.meteoinfo.ndarray.io.npy.dict.TokenType;

class Parser {
    private final List<Token> tokens;
    private int pos = -1;

    private Parser(List<Token> tokens) {
        this.tokens = tokens;
    }

    static PyValue parse(String text) {
        if (text == null) {
            return PyError.of("empty input");
        }
        List<Token> tokens = Lexer.lex(text);
        if (tokens.isEmpty()) {
            return PyError.of("empty input");
        }
        for (Token token : tokens) {
            if (token.type != TokenType.ERROR) continue;
            return PyError.of("syntax error: " + token.value + "; at " + token.position);
        }
        Parser parser = new Parser(tokens);
        PyValue value = parser.parseNext();
        if (value.isError()) {
            return value;
        }
        Token next = parser.next();
        if (!next.isEof()) {
            return PyError.of("syntax error: expected EOF at " + next.position + " but found: " + next);
        }
        return value;
    }

    private PyValue parseNext() {
        Token token = this.peek();
        switch (token.type) {
            case IDENTIFIER: {
                this.moveNext();
                return new PyIdentifier(token.value);
            }
            case INTEGER: {
                this.moveNext();
                try {
                    long value = Long.parseLong(token.value);
                    return new PyInt(value);
                }
                catch (NumberFormatException e) {
                    return PyError.of("failed to parse integer: '" + token.value + "' at:" + token.position);
                }
            }
            case STRING: {
                this.moveNext();
                return new PyString(token.value);
            }
            case TUPLE_START: {
                return this.parseTuple();
            }
            case DICT_START: {
                return this.parseDict();
            }
        }
        return PyError.of("syntax error: unexpected token '" + token.value + "' at " + token.position);
    }

    private PyValue parseTuple() {
        Token start = this.next();
        if (start.type != TokenType.TUPLE_START) {
            return PyError.of("syntax error: expected tuple start at " + start.position);
        }
        ArrayList<PyValue> values = new ArrayList<PyValue>();
        boolean head = true;
        while (true) {
            Token next;
            if ((next = this.peek()).isEof()) {
                return PyError.of("syntax error: unexpected end of tuple");
            }
            if (next.type == TokenType.TUPLE_END) break;
            if (!head) {
                if (next.type != TokenType.COMMA) {
                    return PyError.of("syntax error: unexpected token: " + next);
                }
                head = true;
                this.moveNext();
                continue;
            }
            PyValue value = this.parseNext();
            if (value.isError()) {
                return value;
            }
            values.add(value);
            head = false;
        }
        this.moveNext();
        return new PyTuple(values);
    }

    private PyValue parseDict() {
        Token start = this.next();
        if (start.type != TokenType.DICT_START) {
            return PyError.of("syntax error: expected dict start at " + start.position);
        }
        PyDict dict = new PyDict();
        boolean head = true;
        while (true) {
            Token next = this.next();
            if (next.type == TokenType.DICT_END) break;
            if (!head) {
                if (next.type != TokenType.COMMA) {
                    return PyError.of("syntax error: unexpected token: " + next);
                }
                head = true;
                continue;
            }
            if (next.type != TokenType.STRING) {
                return PyError.of("syntax error: only string keys are allowed but found: " + next);
            }
            String key = next.value;
            Token colon = this.next();
            if (colon.type != TokenType.COLON) {
                return PyError.of("syntax error: expected colon but found: " + next);
            }
            PyValue value = this.parseNext();
            if (value.isError()) {
                return value;
            }
            dict.put(key, value);
            head = false;
        }
        return dict;
    }

    private Token peek() {
        int nextPos = this.pos + 1;
        return nextPos < this.tokens.size() ? this.tokens.get(nextPos) : Token.eof(-1);
    }

    private Token next() {
        Token peeked = this.peek();
        if (peeked.type != TokenType.EOF) {
            ++this.pos;
        }
        return peeked;
    }

    private void moveNext() {
        ++this.pos;
    }
}

