/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.chart.graphic.pipe;

import java.util.ArrayList;
import org.joml.Vector3f;
import org.meteoinfo.chart.graphic.pipe.Pipe;
import org.meteoinfo.chart.jogl.Transform;
import org.meteoinfo.geometry.shape.PointZ;
import org.meteoinfo.geometry.shape.PolylineZShape;

public class PipeShape
extends PolylineZShape {
    private float radius = 0.05f;
    private int steps = 48;
    private Pipe pipe;
    private Transform transform;

    public PipeShape(PolylineZShape shape) {
        this.setPoints(shape.getPoints());
    }

    public PipeShape(PolylineZShape shape, float radius, int steps) {
        this.setPoints(shape.getPoints());
        this.radius = radius;
        this.steps = steps;
        this.generatePipe();
    }

    public Pipe getPipe() {
        return this.pipe;
    }

    public float getRadius() {
        return this.radius;
    }

    public int getSteps() {
        return this.steps;
    }

    public int getVertexCount() {
        return this.getPointNum() * (this.steps + 1);
    }

    void generatePipe() {
        ArrayList<Vector3f> path = new ArrayList<Vector3f>();
        for (PointZ p : this.getPoints()) {
            path.add(new Vector3f((float)p.X, (float)p.Y, (float)p.Z));
        }
        this.pipe = new Pipe(path, this.radius, this.steps);
    }

    public void transform(Transform transform) {
        if (this.transform != null && this.transform.equals(transform)) {
            return;
        }
        this.transform = (Transform)transform.clone();
        ArrayList<Vector3f> path = new ArrayList<Vector3f>();
        for (PointZ p : this.getPoints()) {
            path.add(new Vector3f(transform.transform_x((float)p.X), transform.transform_y((float)p.Y), transform.transform_z((float)p.Z)));
        }
        this.pipe = new Pipe(path, this.radius, this.steps);
    }
}

