/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.chart.jogl;

import com.jogamp.opengl.GL2;
import java.awt.geom.Rectangle2D;
import java.util.List;
import java.util.Objects;
import org.joml.Vector3f;
import org.meteoinfo.chart.ChartText;
import org.meteoinfo.chart.geo.MapGridLine3D;
import org.meteoinfo.chart.graphic.GraphicProjectionUtil;
import org.meteoinfo.chart.jogl.GLPlot;
import org.meteoinfo.common.Extent;
import org.meteoinfo.common.GridLabel;
import org.meteoinfo.common.PointD;
import org.meteoinfo.common.XAlign;
import org.meteoinfo.common.YAlign;
import org.meteoinfo.geometry.graphic.Graphic;
import org.meteoinfo.geometry.graphic.GraphicCollection3D;
import org.meteoinfo.projection.ProjectionInfo;

public class MapGLPlot
extends GLPlot {
    private ProjectionInfo projInfo;

    public MapGLPlot() {
        this(ProjectionInfo.LONG_LAT);
    }

    public MapGLPlot(ProjectionInfo projInfo) {
        this.gridLine = new MapGridLine3D();
        this.projInfo = projInfo;
        this.updateExtent();
    }

    @Override
    public ProjectionInfo getProjInfo() {
        return this.projInfo;
    }

    @Override
    public void setProjInfo(ProjectionInfo value) {
        this.projInfo = value;
        if (!this.projInfo.isLonLat()) {
            ((MapGridLine3D)this.gridLine).setProjInfo(this.projInfo);
        }
    }

    @Override
    public void addGraphic(Graphic graphic, ProjectionInfo proj) {
        if (proj.equals(this.projInfo)) {
            super.addGraphic(graphic);
        } else {
            Graphic nGraphic = GraphicProjectionUtil.projectClipGraphic(graphic, proj, this.projInfo);
            if (nGraphic instanceof GraphicCollection3D) {
                ((GraphicCollection3D)nGraphic).setUsingLight(((GraphicCollection3D)graphic).isUsingLight());
            }
            super.addGraphic(nGraphic);
        }
    }

    @Override
    public void addGraphic(int index, Graphic graphic, ProjectionInfo proj) {
        if (proj.equals(this.projInfo)) {
            super.addGraphic(index, graphic);
        } else {
            Graphic nGraphic = GraphicProjectionUtil.projectClipGraphic(graphic, proj, this.projInfo);
            super.addGraphic(index, nGraphic);
        }
    }

    @Override
    public void setDrawExtent(Extent value) {
        super.setDrawExtent(value);
        if (!this.projInfo.isLonLat()) {
            ((MapGridLine3D)this.gridLine).setExtent(value);
        }
    }

    @Override
    protected void updateExtent() {
        super.updateExtent();
        if (!this.projInfo.isLonLat()) {
            ((MapGridLine3D)this.gridLine).setExtent((Extent)this.drawExtent);
        }
    }

    @Override
    protected void drawXYGridLine(GL2 gl) {
        if (this.projInfo.isLonLat()) {
            super.drawXYGridLine(gl);
        } else {
            MapGridLine3D mapGridLine = (MapGridLine3D)this.gridLine;
            if (mapGridLine.isDrawXLine() && mapGridLine.getLongitudeLines() != null) {
                this.drawGraphics(gl, (Graphic)mapGridLine.getLongitudeLines());
            }
            if (mapGridLine.isDrawYLine() && mapGridLine.getLatitudeLines() != null) {
                this.drawGraphics(gl, (Graphic)mapGridLine.getLatitudeLines());
            }
            if (this.lighting.isStarted()) {
                this.lighting.stop(gl);
            }
        }
    }

    @Override
    protected void drawAxis(GL2 gl) {
        if (this.projInfo.isLonLat()) {
            super.drawAxis(gl);
        } else {
            Rectangle2D rect;
            float x;
            float strWidth;
            YAlign yAlign;
            XAlign xAlign;
            float axisLen;
            float[] rgba;
            float y;
            float xMin = (float)this.axesExtent.minX;
            float xMax = (float)this.axesExtent.maxX;
            float yMin = (float)this.axesExtent.minY;
            float yMax = (float)this.axesExtent.maxY;
            float zMin = (float)this.axesExtent.minZ;
            float zMax = (float)this.axesExtent.maxZ;
            gl.glDepthFunc(519);
            Vector3f center = this.transform.getCenter();
            MapGridLine3D mapGridLine = (MapGridLine3D)this.gridLine;
            if (this.displayXY) {
                y = this.angleY >= 90.0f && this.angleY < 270.0f ? yMax : yMin;
                rgba = this.xAxis.getLineColor().getRGBComponents(null);
                gl.glColor4f(rgba[0], rgba[1], rgba[2], rgba[3]);
                gl.glLineWidth(this.xAxis.getLineWidth() * this.dpiScale);
                gl.glBegin(1);
                gl.glVertex3f(xMin, y, zMin);
                gl.glVertex3f(xMax, y, zMin);
                gl.glEnd();
                float f = this.xAxis.getTickLength();
                Objects.requireNonNull(this);
                float tickLen = f * 0.01f * this.transform.getYLength() / 2.0f;
                axisLen = this.toScreenLength(xMin, y, zMin, xMax, y, zMin);
                float y1 = y > center.y ? y + tickLen : y - tickLen;
                xAlign = this.angleY < 90.0f || this.angleY >= 180.0f && this.angleY < 270.0f ? XAlign.LEFT : XAlign.RIGHT;
                yAlign = this.angleX > -120.0f ? YAlign.TOP : YAlign.BOTTOM;
                strWidth = 0.0f;
                float strHeight = 0.0f;
                List<GridLabel> lonLabels = mapGridLine.getLongitudeLabels();
                for (int i = 0; i < lonLabels.size(); ++i) {
                    GridLabel gridLabel = lonLabels.get(i);
                    PointD point = gridLabel.getCoord();
                    x = (float)point.X;
                    if ((double)x < this.axesExtent.minX || (double)x > this.axesExtent.maxX) continue;
                    rgba = this.xAxis.getLineColor().getRGBComponents(null);
                    gl.glColor4f(rgba[0], rgba[1], rgba[2], rgba[3]);
                    gl.glLineWidth(this.xAxis.getLineWidth() * this.dpiScale);
                    gl.glBegin(1);
                    gl.glVertex3f(x, y, zMin);
                    gl.glVertex3f(x, y1, zMin);
                    gl.glEnd();
                    rect = this.drawString(gl, gridLabel.getLabString(), this.xAxis.getTickLabelFont(), this.xAxis.getTickLabelColor(), x, y1, zMin, xAlign, yAlign);
                    if ((double)strWidth < rect.getWidth()) {
                        strWidth = (float)rect.getWidth();
                    }
                    if (!((double)strHeight < rect.getHeight())) continue;
                    strHeight = (float)rect.getHeight();
                }
                ChartText label = this.xAxis.getLabel();
                if (label != null) {
                    this.updateTextRender(label.getFont());
                    float angle = this.toScreenAngle(xMin, y, zMin, xMax, y, zMin);
                    angle = y < center.y ? 270.0f - angle : 90.0f - angle;
                    float yShift = Math.min(-(strWidth += this.tickSpace), -strWidth);
                    if (this.angleX <= -120.0f) {
                        yShift = -yShift;
                    }
                    float x1 = (xMin + xMax) / 2.0f;
                    this.drawString(gl, label, x1, y1, zMin, XAlign.CENTER, yAlign, angle, 0.0f, yShift);
                }
                x = this.angleY >= 180.0f && this.angleY < 360.0f ? xMax : xMin;
                rgba = this.yAxis.getLineColor().getRGBComponents(null);
                gl.glColor4f(rgba[0], rgba[1], rgba[2], rgba[3]);
                gl.glLineWidth(this.yAxis.getLineWidth() * this.dpiScale);
                gl.glBegin(1);
                gl.glVertex3f(x, yMin, zMin);
                gl.glVertex3f(x, yMax, zMin);
                gl.glEnd();
                axisLen = this.toScreenLength(x, yMin, zMin, x, yMax, zMin);
                float f2 = this.yAxis.getTickLength();
                Objects.requireNonNull(this);
                tickLen = f2 * 0.01f * this.transform.getXLength() / 2.0f;
                float x1 = x > center.x ? x + tickLen : x - tickLen;
                xAlign = this.angleY < 90.0f || this.angleY >= 180.0f && this.angleY < 270.0f ? XAlign.RIGHT : XAlign.LEFT;
                yAlign = this.angleX > -120.0f ? YAlign.TOP : YAlign.BOTTOM;
                strWidth = 0.0f;
                strHeight = 0.0f;
                List<GridLabel> latLabels = mapGridLine.getLatitudeLabels();
                for (int i = 0; i < latLabels.size(); ++i) {
                    GridLabel gridLabel = latLabels.get(i);
                    PointD point = gridLabel.getCoord();
                    y = (float)point.Y;
                    if ((double)y < this.axesExtent.minY || (double)y > this.axesExtent.maxY) continue;
                    rgba = this.yAxis.getLineColor().getRGBComponents(null);
                    gl.glColor4f(rgba[0], rgba[1], rgba[2], rgba[3]);
                    gl.glLineWidth(this.yAxis.getLineWidth() * this.dpiScale);
                    gl.glBegin(1);
                    gl.glVertex3f(x, y, zMin);
                    gl.glVertex3f(x1, y, zMin);
                    gl.glEnd();
                    rect = this.drawString(gl, gridLabel.getLabString(), this.yAxis.getTickLabelFont(), this.yAxis.getTickLabelColor(), x1, y, zMin, xAlign, yAlign);
                    if ((double)strWidth < rect.getWidth()) {
                        strWidth = (float)rect.getWidth();
                    }
                    if (!((double)strHeight < rect.getHeight())) continue;
                    strHeight = (float)rect.getHeight();
                }
                label = this.yAxis.getLabel();
                if (label != null) {
                    this.updateTextRender(label.getFont());
                    float angle = this.toScreenAngle(x, yMin, zMin, x, yMax, zMin);
                    angle = x > center.x ? 270.0f - angle : 90.0f - angle;
                    float yShift = Math.min(-(strWidth += this.tickSpace), -strWidth);
                    if (this.angleX <= -120.0f) {
                        yShift = -yShift;
                    }
                    y1 = (yMin + yMax) / 2.0f;
                    this.drawString(gl, label, x1, y1, zMin, XAlign.CENTER, yAlign, angle, 0.0f, yShift);
                }
            }
            if (this.displayZ) {
                ChartText label;
                if (this.angleY < 90.0f) {
                    x = xMin;
                    y = yMax;
                } else if (this.angleY < 180.0f) {
                    x = xMax;
                    y = yMax;
                } else if (this.angleY < 270.0f) {
                    x = xMax;
                    y = yMin;
                } else {
                    x = xMin;
                    y = yMin;
                }
                rgba = this.zAxis.getLineColor().getRGBComponents(null);
                gl.glColor4f(rgba[0], rgba[1], rgba[2], rgba[3]);
                gl.glLineWidth(this.zAxis.getLineWidth() * this.dpiScale);
                gl.glBegin(1);
                gl.glVertex3f(x, y, zMin);
                gl.glVertex3f(x, y, zMax);
                gl.glEnd();
                this.zAxis.updateTickLabels();
                List<ChartText> tlabs = this.zAxis.getTickLabels();
                axisLen = this.toScreenLength(x, y, zMin, x, y, zMax);
                int skip = this.getLabelGap(this.zAxis.getTickLabelFont(), tlabs, axisLen);
                float x1 = x;
                float y1 = y;
                float f = this.zAxis.getTickLength();
                Objects.requireNonNull(this);
                float tickLen = f * 0.01f * this.transform.getYLength() / 2.0f;
                if (x < center.x) {
                    if (y > center.y) {
                        y1 += tickLen;
                    } else {
                        x1 -= tickLen;
                    }
                } else if (y > center.y) {
                    x1 += tickLen;
                } else {
                    y1 -= tickLen;
                }
                xAlign = XAlign.RIGHT;
                yAlign = YAlign.CENTER;
                strWidth = 0.0f;
                for (int i = 0; i < this.zAxis.getTickValues().length; i += skip) {
                    float v = (float)this.zAxis.getTickValues()[i];
                    if ((double)v < this.axesExtent.minZ || (double)v > this.axesExtent.maxZ) continue;
                    if (i == tlabs.size()) break;
                    rgba = this.zAxis.getLineColor().getRGBComponents(null);
                    gl.glColor4f(rgba[0], rgba[1], rgba[2], rgba[3]);
                    gl.glLineWidth(this.zAxis.getLineWidth() * this.dpiScale);
                    gl.glBegin(1);
                    gl.glVertex3f(x, y, v);
                    gl.glVertex3f(x1, y1, v);
                    gl.glEnd();
                    rect = this.drawString(gl, tlabs.get(i), x1, y1, v, xAlign, yAlign, -this.tickSpace, 0.0f);
                    if (!((double)strWidth < rect.getWidth())) continue;
                    strWidth = (float)rect.getWidth();
                }
                if ((label = this.zAxis.getLabel()) != null) {
                    float yShift = strWidth + this.tickSpace * 3.0f;
                    float z1 = (zMax + zMin) * 0.5f;
                    this.drawString(gl, label, x1, y1, z1, XAlign.CENTER, YAlign.BOTTOM, 90.0f, 0.0f, yShift);
                }
            }
            gl.glDepthFunc(515);
        }
    }
}

