/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.chart.jogl.mc;

import java.util.ArrayList;
import org.meteoinfo.chart.jogl.mc.CallbackMC;
import org.meteoinfo.chart.jogl.mc.TablesMC;
import org.meteoinfo.ndarray.Array;

public class MarchingCubes {
    static float[] lerp(float[] vec1, float[] vec2, float alpha) {
        return new float[]{vec1[0] + (vec2[0] - vec1[0]) * alpha, vec1[1] + (vec2[1] - vec1[1]) * alpha, vec1[2] + (vec2[2] - vec1[2]) * alpha};
    }

    static void marchingCubesChar(char[] values, int[] volDim, int volZFull, float[] voxDim, char isoLevel, int offset, CallbackMC callback) {
        ArrayList<float[]> vertices = new ArrayList<float[]>();
        float[][] vertList = new float[12][3];
        float maxX = voxDim[0] * (float)(volDim[0] - 1);
        float maxY = voxDim[1] * (float)(volDim[1] - 1);
        float maxZ = voxDim[2] * (float)(volZFull - 1);
        float maxAxisVal = Math.max(maxX, Math.max(maxY, maxZ));
        for (int z = 0; z < volDim[2] - 1; ++z) {
            for (int y = 0; y < volDim[1] - 1; ++y) {
                for (int x = 0; x < volDim[0] - 1; ++x) {
                    int bits;
                    int p = x + volDim[0] * y + volDim[0] * volDim[1] * (z + offset);
                    int px = p + 1;
                    int py = p + volDim[0];
                    int pxy = py + 1;
                    int pz = p + volDim[0] * volDim[1];
                    int pxz = px + volDim[0] * volDim[1];
                    int pyz = py + volDim[0] * volDim[1];
                    int pxyz = pxy + volDim[0] * volDim[1];
                    float[] position = new float[]{(float)x * voxDim[0], (float)y * voxDim[1], (float)(z + offset) * voxDim[2]};
                    char value0 = values[p];
                    char value1 = values[px];
                    char value2 = values[py];
                    char value3 = values[pxy];
                    char value4 = values[pz];
                    char value5 = values[pxz];
                    char value6 = values[pyz];
                    char value7 = values[pxyz];
                    int cubeindex = 0;
                    if (value0 > isoLevel) {
                        cubeindex |= 1;
                    }
                    if (value1 > isoLevel) {
                        cubeindex |= 2;
                    }
                    if (value2 > isoLevel) {
                        cubeindex |= 8;
                    }
                    if (value3 > isoLevel) {
                        cubeindex |= 4;
                    }
                    if (value4 > isoLevel) {
                        cubeindex |= 0x10;
                    }
                    if (value5 > isoLevel) {
                        cubeindex |= 0x20;
                    }
                    if (value6 > isoLevel) {
                        cubeindex |= 0x80;
                    }
                    if (value7 > isoLevel) {
                        cubeindex |= 0x40;
                    }
                    if ((bits = TablesMC.MC_EDGE_TABLE[cubeindex]) == 0) continue;
                    float mu = 0.5f;
                    if ((bits & 1) != 0) {
                        mu = (isoLevel - value0) / (value1 - value0);
                        vertList[0] = MarchingCubes.lerp(position, new float[]{position[0] + voxDim[0], position[1], position[2]}, mu);
                    }
                    if ((bits & 2) != 0) {
                        mu = (isoLevel - value1) / (value3 - value1);
                        vertList[1] = MarchingCubes.lerp(new float[]{position[0] + voxDim[0], position[1], position[2]}, new float[]{position[0] + voxDim[0], position[1] + voxDim[1], position[2]}, mu);
                    }
                    if ((bits & 4) != 0) {
                        mu = (isoLevel - value2) / (value3 - value2);
                        vertList[2] = MarchingCubes.lerp(new float[]{position[0], position[1] + voxDim[1], position[2]}, new float[]{position[0] + voxDim[0], position[1] + voxDim[1], position[2]}, mu);
                    }
                    if ((bits & 8) != 0) {
                        mu = (isoLevel - value0) / (value2 - value0);
                        vertList[3] = MarchingCubes.lerp(position, new float[]{position[0], position[1] + voxDim[1], position[2]}, mu);
                    }
                    if ((bits & 0x10) != 0) {
                        mu = (isoLevel - value4) / (value5 - value4);
                        vertList[4] = MarchingCubes.lerp(new float[]{position[0], position[1], position[2] + voxDim[2]}, new float[]{position[0] + voxDim[0], position[1], position[2] + voxDim[2]}, mu);
                    }
                    if ((bits & 0x20) != 0) {
                        mu = (isoLevel - value5) / (value7 - value5);
                        vertList[5] = MarchingCubes.lerp(new float[]{position[0] + voxDim[0], position[1], position[2] + voxDim[2]}, new float[]{position[0] + voxDim[0], position[1] + voxDim[1], position[2] + voxDim[2]}, mu);
                    }
                    if ((bits & 0x40) != 0) {
                        mu = (isoLevel - value6) / (value7 - value6);
                        vertList[6] = MarchingCubes.lerp(new float[]{position[0], position[1] + voxDim[1], position[2] + voxDim[2]}, new float[]{position[0] + voxDim[0], position[1] + voxDim[1], position[2] + voxDim[2]}, mu);
                    }
                    if ((bits & 0x80) != 0) {
                        mu = (isoLevel - value4) / (value6 - value4);
                        vertList[7] = MarchingCubes.lerp(new float[]{position[0], position[1], position[2] + voxDim[2]}, new float[]{position[0], position[1] + voxDim[1], position[2] + voxDim[2]}, mu);
                    }
                    if ((bits & 0x100) != 0) {
                        mu = (isoLevel - value0) / (value4 - value0);
                        vertList[8] = MarchingCubes.lerp(position, new float[]{position[0], position[1], position[2] + voxDim[2]}, mu);
                    }
                    if ((bits & 0x200) != 0) {
                        mu = (isoLevel - value1) / (value5 - value1);
                        vertList[9] = MarchingCubes.lerp(new float[]{position[0] + voxDim[0], position[1], position[2]}, new float[]{position[0] + voxDim[0], position[1], position[2] + voxDim[2]}, mu);
                    }
                    if ((bits & 0x400) != 0) {
                        mu = (isoLevel - value3) / (value7 - value3);
                        vertList[10] = MarchingCubes.lerp(new float[]{position[0] + voxDim[0], position[1] + voxDim[1], position[2]}, new float[]{position[0] + voxDim[0], position[1] + voxDim[1], position[2] + voxDim[2]}, mu);
                    }
                    if ((bits & 0x800) != 0) {
                        mu = (isoLevel - value2) / (value6 - value2);
                        vertList[11] = MarchingCubes.lerp(new float[]{position[0], position[1] + voxDim[1], position[2]}, new float[]{position[0], position[1] + voxDim[1], position[2] + voxDim[2]}, mu);
                    }
                    int i = 0;
                    cubeindex <<= 4;
                    while (TablesMC.MC_TRI_TABLE[cubeindex + i] != -1) {
                        int index1 = TablesMC.MC_TRI_TABLE[cubeindex + i];
                        int index2 = TablesMC.MC_TRI_TABLE[cubeindex + i + 1];
                        int index3 = TablesMC.MC_TRI_TABLE[cubeindex + i + 2];
                        vertices.add(new float[]{vertList[index3][0] / maxAxisVal - 0.5f, vertList[index3][1] / maxAxisVal - 0.5f, vertList[index3][2] / maxAxisVal - 0.5f});
                        vertices.add(new float[]{vertList[index2][0] / maxAxisVal - 0.5f, vertList[index2][1] / maxAxisVal - 0.5f, vertList[index2][2] / maxAxisVal - 0.5f});
                        vertices.add(new float[]{vertList[index1][0] / maxAxisVal - 0.5f, vertList[index1][1] / maxAxisVal - 0.5f, vertList[index1][2] / maxAxisVal - 0.5f});
                        i += 3;
                    }
                }
            }
        }
        callback.setVertices(vertices);
        callback.run();
    }

    static void marchingCubesShort(short[] values, int[] volDim, int volZFull, float[] voxDim, short isoLevel, int offset, CallbackMC callback) {
        ArrayList<float[]> vertices = new ArrayList<float[]>();
        float[][] vertList = new float[12][3];
        float maxX = voxDim[0] * (float)(volDim[0] - 1);
        float maxY = voxDim[1] * (float)(volDim[1] - 1);
        float maxZ = voxDim[2] * (float)(volZFull - 1);
        float maxAxisVal = Math.max(maxX, Math.max(maxY, maxZ));
        for (int z = 0; z < volDim[2] - 1; ++z) {
            for (int y = 0; y < volDim[1] - 1; ++y) {
                for (int x = 0; x < volDim[0] - 1; ++x) {
                    int bits;
                    int p = x + volDim[0] * y + volDim[0] * volDim[1] * (z + offset);
                    int px = p + 1;
                    int py = p + volDim[0];
                    int pxy = py + 1;
                    int pz = p + volDim[0] * volDim[1];
                    int pxz = px + volDim[0] * volDim[1];
                    int pyz = py + volDim[0] * volDim[1];
                    int pxyz = pxy + volDim[0] * volDim[1];
                    float[] position = new float[]{(float)x * voxDim[0], (float)y * voxDim[1], (float)(z + offset) * voxDim[2]};
                    short value0 = values[p];
                    short value1 = values[px];
                    short value2 = values[py];
                    short value3 = values[pxy];
                    short value4 = values[pz];
                    short value5 = values[pxz];
                    short value6 = values[pyz];
                    short value7 = values[pxyz];
                    int cubeindex = 0;
                    if (value0 > isoLevel) {
                        cubeindex |= 1;
                    }
                    if (value1 > isoLevel) {
                        cubeindex |= 2;
                    }
                    if (value2 > isoLevel) {
                        cubeindex |= 8;
                    }
                    if (value3 > isoLevel) {
                        cubeindex |= 4;
                    }
                    if (value4 > isoLevel) {
                        cubeindex |= 0x10;
                    }
                    if (value5 > isoLevel) {
                        cubeindex |= 0x20;
                    }
                    if (value6 > isoLevel) {
                        cubeindex |= 0x80;
                    }
                    if (value7 > isoLevel) {
                        cubeindex |= 0x40;
                    }
                    if ((bits = TablesMC.MC_EDGE_TABLE[cubeindex]) == 0) continue;
                    float mu = 0.5f;
                    if ((bits & 1) != 0) {
                        mu = (isoLevel - value0) / (value1 - value0);
                        vertList[0] = MarchingCubes.lerp(position, new float[]{position[0] + voxDim[0], position[1], position[2]}, mu);
                    }
                    if ((bits & 2) != 0) {
                        mu = (isoLevel - value1) / (value3 - value1);
                        vertList[1] = MarchingCubes.lerp(new float[]{position[0] + voxDim[0], position[1], position[2]}, new float[]{position[0] + voxDim[0], position[1] + voxDim[1], position[2]}, mu);
                    }
                    if ((bits & 4) != 0) {
                        mu = (isoLevel - value2) / (value3 - value2);
                        vertList[2] = MarchingCubes.lerp(new float[]{position[0], position[1] + voxDim[1], position[2]}, new float[]{position[0] + voxDim[0], position[1] + voxDim[1], position[2]}, mu);
                    }
                    if ((bits & 8) != 0) {
                        mu = (isoLevel - value0) / (value2 - value0);
                        vertList[3] = MarchingCubes.lerp(position, new float[]{position[0], position[1] + voxDim[1], position[2]}, mu);
                    }
                    if ((bits & 0x10) != 0) {
                        mu = (isoLevel - value4) / (value5 - value4);
                        vertList[4] = MarchingCubes.lerp(new float[]{position[0], position[1], position[2] + voxDim[2]}, new float[]{position[0] + voxDim[0], position[1], position[2] + voxDim[2]}, mu);
                    }
                    if ((bits & 0x20) != 0) {
                        mu = (isoLevel - value5) / (value7 - value5);
                        vertList[5] = MarchingCubes.lerp(new float[]{position[0] + voxDim[0], position[1], position[2] + voxDim[2]}, new float[]{position[0] + voxDim[0], position[1] + voxDim[1], position[2] + voxDim[2]}, mu);
                    }
                    if ((bits & 0x40) != 0) {
                        mu = (isoLevel - value6) / (value7 - value6);
                        vertList[6] = MarchingCubes.lerp(new float[]{position[0], position[1] + voxDim[1], position[2] + voxDim[2]}, new float[]{position[0] + voxDim[0], position[1] + voxDim[1], position[2] + voxDim[2]}, mu);
                    }
                    if ((bits & 0x80) != 0) {
                        mu = (isoLevel - value4) / (value6 - value4);
                        vertList[7] = MarchingCubes.lerp(new float[]{position[0], position[1], position[2] + voxDim[2]}, new float[]{position[0], position[1] + voxDim[1], position[2] + voxDim[2]}, mu);
                    }
                    if ((bits & 0x100) != 0) {
                        mu = (isoLevel - value0) / (value4 - value0);
                        vertList[8] = MarchingCubes.lerp(position, new float[]{position[0], position[1], position[2] + voxDim[2]}, mu);
                    }
                    if ((bits & 0x200) != 0) {
                        mu = (isoLevel - value1) / (value5 - value1);
                        vertList[9] = MarchingCubes.lerp(new float[]{position[0] + voxDim[0], position[1], position[2]}, new float[]{position[0] + voxDim[0], position[1], position[2] + voxDim[2]}, mu);
                    }
                    if ((bits & 0x400) != 0) {
                        mu = (isoLevel - value3) / (value7 - value3);
                        vertList[10] = MarchingCubes.lerp(new float[]{position[0] + voxDim[0], position[1] + voxDim[1], position[2]}, new float[]{position[0] + voxDim[0], position[1] + voxDim[1], position[2] + voxDim[2]}, mu);
                    }
                    if ((bits & 0x800) != 0) {
                        mu = (isoLevel - value2) / (value6 - value2);
                        vertList[11] = MarchingCubes.lerp(new float[]{position[0], position[1] + voxDim[1], position[2]}, new float[]{position[0], position[1] + voxDim[1], position[2] + voxDim[2]}, mu);
                    }
                    int i = 0;
                    cubeindex <<= 4;
                    while (TablesMC.MC_TRI_TABLE[cubeindex + i] != -1) {
                        int index1 = TablesMC.MC_TRI_TABLE[cubeindex + i];
                        int index2 = TablesMC.MC_TRI_TABLE[cubeindex + i + 1];
                        int index3 = TablesMC.MC_TRI_TABLE[cubeindex + i + 2];
                        vertices.add(new float[]{vertList[index3][0] / maxAxisVal - 0.5f, vertList[index3][1] / maxAxisVal - 0.5f, vertList[index3][2] / maxAxisVal - 0.5f});
                        vertices.add(new float[]{vertList[index2][0] / maxAxisVal - 0.5f, vertList[index2][1] / maxAxisVal - 0.5f, vertList[index2][2] / maxAxisVal - 0.5f});
                        vertices.add(new float[]{vertList[index1][0] / maxAxisVal - 0.5f, vertList[index1][1] / maxAxisVal - 0.5f, vertList[index1][2] / maxAxisVal - 0.5f});
                        i += 3;
                    }
                }
            }
        }
        callback.setVertices(vertices);
        callback.run();
    }

    static void marchingCubesInt(int[] values, int[] volDim, int volZFull, float[] voxDim, int isoLevel, int offset, CallbackMC callback) {
        ArrayList<float[]> vertices = new ArrayList<float[]>();
        float[][] vertList = new float[12][3];
        float maxX = voxDim[0] * (float)(volDim[0] - 1);
        float maxY = voxDim[1] * (float)(volDim[1] - 1);
        float maxZ = voxDim[2] * (float)(volZFull - 1);
        float maxAxisVal = Math.max(maxX, Math.max(maxY, maxZ));
        for (int z = 0; z < volDim[2] - 1; ++z) {
            for (int y = 0; y < volDim[1] - 1; ++y) {
                for (int x = 0; x < volDim[0] - 1; ++x) {
                    int bits;
                    int p = x + volDim[0] * y + volDim[0] * volDim[1] * (z + offset);
                    int px = p + 1;
                    int py = p + volDim[0];
                    int pxy = py + 1;
                    int pz = p + volDim[0] * volDim[1];
                    int pxz = px + volDim[0] * volDim[1];
                    int pyz = py + volDim[0] * volDim[1];
                    int pxyz = pxy + volDim[0] * volDim[1];
                    float[] position = new float[]{(float)x * voxDim[0], (float)y * voxDim[1], (float)(z + offset) * voxDim[2]};
                    int value0 = values[p];
                    int value1 = values[px];
                    int value2 = values[py];
                    int value3 = values[pxy];
                    int value4 = values[pz];
                    int value5 = values[pxz];
                    int value6 = values[pyz];
                    int value7 = values[pxyz];
                    int cubeindex = 0;
                    if (value0 > isoLevel) {
                        cubeindex |= 1;
                    }
                    if (value1 > isoLevel) {
                        cubeindex |= 2;
                    }
                    if (value2 > isoLevel) {
                        cubeindex |= 8;
                    }
                    if (value3 > isoLevel) {
                        cubeindex |= 4;
                    }
                    if (value4 > isoLevel) {
                        cubeindex |= 0x10;
                    }
                    if (value5 > isoLevel) {
                        cubeindex |= 0x20;
                    }
                    if (value6 > isoLevel) {
                        cubeindex |= 0x80;
                    }
                    if (value7 > isoLevel) {
                        cubeindex |= 0x40;
                    }
                    if ((bits = TablesMC.MC_EDGE_TABLE[cubeindex]) == 0) continue;
                    float mu = 0.5f;
                    if ((bits & 1) != 0) {
                        mu = (isoLevel - value0) / (value1 - value0);
                        vertList[0] = MarchingCubes.lerp(position, new float[]{position[0] + voxDim[0], position[1], position[2]}, mu);
                    }
                    if ((bits & 2) != 0) {
                        mu = (isoLevel - value1) / (value3 - value1);
                        vertList[1] = MarchingCubes.lerp(new float[]{position[0] + voxDim[0], position[1], position[2]}, new float[]{position[0] + voxDim[0], position[1] + voxDim[1], position[2]}, mu);
                    }
                    if ((bits & 4) != 0) {
                        mu = (isoLevel - value2) / (value3 - value2);
                        vertList[2] = MarchingCubes.lerp(new float[]{position[0], position[1] + voxDim[1], position[2]}, new float[]{position[0] + voxDim[0], position[1] + voxDim[1], position[2]}, mu);
                    }
                    if ((bits & 8) != 0) {
                        mu = (isoLevel - value0) / (value2 - value0);
                        vertList[3] = MarchingCubes.lerp(position, new float[]{position[0], position[1] + voxDim[1], position[2]}, mu);
                    }
                    if ((bits & 0x10) != 0) {
                        mu = (isoLevel - value4) / (value5 - value4);
                        vertList[4] = MarchingCubes.lerp(new float[]{position[0], position[1], position[2] + voxDim[2]}, new float[]{position[0] + voxDim[0], position[1], position[2] + voxDim[2]}, mu);
                    }
                    if ((bits & 0x20) != 0) {
                        mu = (isoLevel - value5) / (value7 - value5);
                        vertList[5] = MarchingCubes.lerp(new float[]{position[0] + voxDim[0], position[1], position[2] + voxDim[2]}, new float[]{position[0] + voxDim[0], position[1] + voxDim[1], position[2] + voxDim[2]}, mu);
                    }
                    if ((bits & 0x40) != 0) {
                        mu = (isoLevel - value6) / (value7 - value6);
                        vertList[6] = MarchingCubes.lerp(new float[]{position[0], position[1] + voxDim[1], position[2] + voxDim[2]}, new float[]{position[0] + voxDim[0], position[1] + voxDim[1], position[2] + voxDim[2]}, mu);
                    }
                    if ((bits & 0x80) != 0) {
                        mu = (isoLevel - value4) / (value6 - value4);
                        vertList[7] = MarchingCubes.lerp(new float[]{position[0], position[1], position[2] + voxDim[2]}, new float[]{position[0], position[1] + voxDim[1], position[2] + voxDim[2]}, mu);
                    }
                    if ((bits & 0x100) != 0) {
                        mu = (isoLevel - value0) / (value4 - value0);
                        vertList[8] = MarchingCubes.lerp(position, new float[]{position[0], position[1], position[2] + voxDim[2]}, mu);
                    }
                    if ((bits & 0x200) != 0) {
                        mu = (isoLevel - value1) / (value5 - value1);
                        vertList[9] = MarchingCubes.lerp(new float[]{position[0] + voxDim[0], position[1], position[2]}, new float[]{position[0] + voxDim[0], position[1], position[2] + voxDim[2]}, mu);
                    }
                    if ((bits & 0x400) != 0) {
                        mu = (isoLevel - value3) / (value7 - value3);
                        vertList[10] = MarchingCubes.lerp(new float[]{position[0] + voxDim[0], position[1] + voxDim[1], position[2]}, new float[]{position[0] + voxDim[0], position[1] + voxDim[1], position[2] + voxDim[2]}, mu);
                    }
                    if ((bits & 0x800) != 0) {
                        mu = (isoLevel - value2) / (value6 - value2);
                        vertList[11] = MarchingCubes.lerp(new float[]{position[0], position[1] + voxDim[1], position[2]}, new float[]{position[0], position[1] + voxDim[1], position[2] + voxDim[2]}, mu);
                    }
                    int i = 0;
                    cubeindex <<= 4;
                    while (TablesMC.MC_TRI_TABLE[cubeindex + i] != -1) {
                        int index1 = TablesMC.MC_TRI_TABLE[cubeindex + i];
                        int index2 = TablesMC.MC_TRI_TABLE[cubeindex + i + 1];
                        int index3 = TablesMC.MC_TRI_TABLE[cubeindex + i + 2];
                        vertices.add(new float[]{vertList[index3][0] / maxAxisVal - 0.5f, vertList[index3][1] / maxAxisVal - 0.5f, vertList[index3][2] / maxAxisVal - 0.5f});
                        vertices.add(new float[]{vertList[index2][0] / maxAxisVal - 0.5f, vertList[index2][1] / maxAxisVal - 0.5f, vertList[index2][2] / maxAxisVal - 0.5f});
                        vertices.add(new float[]{vertList[index1][0] / maxAxisVal - 0.5f, vertList[index1][1] / maxAxisVal - 0.5f, vertList[index1][2] / maxAxisVal - 0.5f});
                        i += 3;
                    }
                }
            }
        }
        callback.setVertices(vertices);
        callback.run();
    }

    static void marchingCubesFloat(float[] values, int[] volDim, int volZFull, float[] voxDim, float isoLevel, int offset, CallbackMC callback) {
        ArrayList<float[]> vertices = new ArrayList<float[]>();
        float[][] vertList = new float[12][3];
        float maxX = voxDim[0] * (float)(volDim[0] - 1);
        float maxY = voxDim[1] * (float)(volDim[1] - 1);
        float maxZ = voxDim[2] * (float)(volZFull - 1);
        float maxAxisVal = Math.max(maxX, Math.max(maxY, maxZ));
        for (int z = 0; z < volDim[2] - 1; ++z) {
            for (int y = 0; y < volDim[1] - 1; ++y) {
                for (int x = 0; x < volDim[0] - 1; ++x) {
                    int bits;
                    int p = x + volDim[0] * y + volDim[0] * volDim[1] * (z + offset);
                    int px = p + 1;
                    int py = p + volDim[0];
                    int pxy = py + 1;
                    int pz = p + volDim[0] * volDim[1];
                    int pxz = px + volDim[0] * volDim[1];
                    int pyz = py + volDim[0] * volDim[1];
                    int pxyz = pxy + volDim[0] * volDim[1];
                    float[] position = new float[]{(float)x * voxDim[0], (float)y * voxDim[1], (float)(z + offset) * voxDim[2]};
                    float value0 = values[p];
                    float value1 = values[px];
                    float value2 = values[py];
                    float value3 = values[pxy];
                    float value4 = values[pz];
                    float value5 = values[pxz];
                    float value6 = values[pyz];
                    float value7 = values[pxyz];
                    int cubeindex = 0;
                    if (value0 > isoLevel) {
                        cubeindex |= 1;
                    }
                    if (value1 > isoLevel) {
                        cubeindex |= 2;
                    }
                    if (value2 > isoLevel) {
                        cubeindex |= 8;
                    }
                    if (value3 > isoLevel) {
                        cubeindex |= 4;
                    }
                    if (value4 > isoLevel) {
                        cubeindex |= 0x10;
                    }
                    if (value5 > isoLevel) {
                        cubeindex |= 0x20;
                    }
                    if (value6 > isoLevel) {
                        cubeindex |= 0x80;
                    }
                    if (value7 > isoLevel) {
                        cubeindex |= 0x40;
                    }
                    if ((bits = TablesMC.MC_EDGE_TABLE[cubeindex]) == 0) continue;
                    float mu = 0.5f;
                    if ((bits & 1) != 0) {
                        mu = (isoLevel - value0) / (value1 - value0);
                        vertList[0] = MarchingCubes.lerp(position, new float[]{position[0] + voxDim[0], position[1], position[2]}, mu);
                    }
                    if ((bits & 2) != 0) {
                        mu = (isoLevel - value1) / (value3 - value1);
                        vertList[1] = MarchingCubes.lerp(new float[]{position[0] + voxDim[0], position[1], position[2]}, new float[]{position[0] + voxDim[0], position[1] + voxDim[1], position[2]}, mu);
                    }
                    if ((bits & 4) != 0) {
                        mu = (isoLevel - value2) / (value3 - value2);
                        vertList[2] = MarchingCubes.lerp(new float[]{position[0], position[1] + voxDim[1], position[2]}, new float[]{position[0] + voxDim[0], position[1] + voxDim[1], position[2]}, mu);
                    }
                    if ((bits & 8) != 0) {
                        mu = (isoLevel - value0) / (value2 - value0);
                        vertList[3] = MarchingCubes.lerp(position, new float[]{position[0], position[1] + voxDim[1], position[2]}, mu);
                    }
                    if ((bits & 0x10) != 0) {
                        mu = (isoLevel - value4) / (value5 - value4);
                        vertList[4] = MarchingCubes.lerp(new float[]{position[0], position[1], position[2] + voxDim[2]}, new float[]{position[0] + voxDim[0], position[1], position[2] + voxDim[2]}, mu);
                    }
                    if ((bits & 0x20) != 0) {
                        mu = (isoLevel - value5) / (value7 - value5);
                        vertList[5] = MarchingCubes.lerp(new float[]{position[0] + voxDim[0], position[1], position[2] + voxDim[2]}, new float[]{position[0] + voxDim[0], position[1] + voxDim[1], position[2] + voxDim[2]}, mu);
                    }
                    if ((bits & 0x40) != 0) {
                        mu = (isoLevel - value6) / (value7 - value6);
                        vertList[6] = MarchingCubes.lerp(new float[]{position[0], position[1] + voxDim[1], position[2] + voxDim[2]}, new float[]{position[0] + voxDim[0], position[1] + voxDim[1], position[2] + voxDim[2]}, mu);
                    }
                    if ((bits & 0x80) != 0) {
                        mu = (isoLevel - value4) / (value6 - value4);
                        vertList[7] = MarchingCubes.lerp(new float[]{position[0], position[1], position[2] + voxDim[2]}, new float[]{position[0], position[1] + voxDim[1], position[2] + voxDim[2]}, mu);
                    }
                    if ((bits & 0x100) != 0) {
                        mu = (isoLevel - value0) / (value4 - value0);
                        vertList[8] = MarchingCubes.lerp(position, new float[]{position[0], position[1], position[2] + voxDim[2]}, mu);
                    }
                    if ((bits & 0x200) != 0) {
                        mu = (isoLevel - value1) / (value5 - value1);
                        vertList[9] = MarchingCubes.lerp(new float[]{position[0] + voxDim[0], position[1], position[2]}, new float[]{position[0] + voxDim[0], position[1], position[2] + voxDim[2]}, mu);
                    }
                    if ((bits & 0x400) != 0) {
                        mu = (isoLevel - value3) / (value7 - value3);
                        vertList[10] = MarchingCubes.lerp(new float[]{position[0] + voxDim[0], position[1] + voxDim[1], position[2]}, new float[]{position[0] + voxDim[0], position[1] + voxDim[1], position[2] + voxDim[2]}, mu);
                    }
                    if ((bits & 0x800) != 0) {
                        mu = (isoLevel - value2) / (value6 - value2);
                        vertList[11] = MarchingCubes.lerp(new float[]{position[0], position[1] + voxDim[1], position[2]}, new float[]{position[0], position[1] + voxDim[1], position[2] + voxDim[2]}, mu);
                    }
                    int i = 0;
                    cubeindex <<= 4;
                    while (TablesMC.MC_TRI_TABLE[cubeindex + i] != -1) {
                        int index1 = TablesMC.MC_TRI_TABLE[cubeindex + i];
                        int index2 = TablesMC.MC_TRI_TABLE[cubeindex + i + 1];
                        int index3 = TablesMC.MC_TRI_TABLE[cubeindex + i + 2];
                        vertices.add(new float[]{vertList[index3][0] / maxAxisVal - 0.5f, vertList[index3][1] / maxAxisVal - 0.5f, vertList[index3][2] / maxAxisVal - 0.5f});
                        vertices.add(new float[]{vertList[index2][0] / maxAxisVal - 0.5f, vertList[index2][1] / maxAxisVal - 0.5f, vertList[index2][2] / maxAxisVal - 0.5f});
                        vertices.add(new float[]{vertList[index1][0] / maxAxisVal - 0.5f, vertList[index1][1] / maxAxisVal - 0.5f, vertList[index1][2] / maxAxisVal - 0.5f});
                        i += 3;
                    }
                }
            }
        }
        callback.setVertices(vertices);
        callback.run();
    }

    static void marchingCubesDouble(double[] values, int[] volDim, int volZFull, float[] voxDim, double isoLevel, int offset, CallbackMC callback) {
        ArrayList<float[]> vertices = new ArrayList<float[]>();
        float[][] vertList = new float[12][3];
        float maxX = voxDim[0] * (float)(volDim[0] - 1);
        float maxY = voxDim[1] * (float)(volDim[1] - 1);
        float maxZ = voxDim[2] * (float)(volZFull - 1);
        float maxAxisVal = Math.max(maxX, Math.max(maxY, maxZ));
        for (int z = 0; z < volDim[2] - 1; ++z) {
            for (int y = 0; y < volDim[1] - 1; ++y) {
                for (int x = 0; x < volDim[0] - 1; ++x) {
                    int bits;
                    int p = x + volDim[0] * y + volDim[0] * volDim[1] * (z + offset);
                    int px = p + 1;
                    int py = p + volDim[0];
                    int pxy = py + 1;
                    int pz = p + volDim[0] * volDim[1];
                    int pxz = px + volDim[0] * volDim[1];
                    int pyz = py + volDim[0] * volDim[1];
                    int pxyz = pxy + volDim[0] * volDim[1];
                    float[] position = new float[]{(float)x * voxDim[0], (float)y * voxDim[1], (float)(z + offset) * voxDim[2]};
                    double value0 = values[p];
                    double value1 = values[px];
                    double value2 = values[py];
                    double value3 = values[pxy];
                    double value4 = values[pz];
                    double value5 = values[pxz];
                    double value6 = values[pyz];
                    double value7 = values[pxyz];
                    int cubeindex = 0;
                    if (value0 > isoLevel) {
                        cubeindex |= 1;
                    }
                    if (value1 > isoLevel) {
                        cubeindex |= 2;
                    }
                    if (value2 > isoLevel) {
                        cubeindex |= 8;
                    }
                    if (value3 > isoLevel) {
                        cubeindex |= 4;
                    }
                    if (value4 > isoLevel) {
                        cubeindex |= 0x10;
                    }
                    if (value5 > isoLevel) {
                        cubeindex |= 0x20;
                    }
                    if (value6 > isoLevel) {
                        cubeindex |= 0x80;
                    }
                    if (value7 > isoLevel) {
                        cubeindex |= 0x40;
                    }
                    if ((bits = TablesMC.MC_EDGE_TABLE[cubeindex]) == 0) continue;
                    float mu = 0.5f;
                    if ((bits & 1) != 0) {
                        mu = (float)((isoLevel - value0) / (value1 - value0));
                        vertList[0] = MarchingCubes.lerp(position, new float[]{position[0] + voxDim[0], position[1], position[2]}, mu);
                    }
                    if ((bits & 2) != 0) {
                        mu = (float)((isoLevel - value1) / (value3 - value1));
                        vertList[1] = MarchingCubes.lerp(new float[]{position[0] + voxDim[0], position[1], position[2]}, new float[]{position[0] + voxDim[0], position[1] + voxDim[1], position[2]}, mu);
                    }
                    if ((bits & 4) != 0) {
                        mu = (float)((isoLevel - value2) / (value3 - value2));
                        vertList[2] = MarchingCubes.lerp(new float[]{position[0], position[1] + voxDim[1], position[2]}, new float[]{position[0] + voxDim[0], position[1] + voxDim[1], position[2]}, mu);
                    }
                    if ((bits & 8) != 0) {
                        mu = (float)((isoLevel - value0) / (value2 - value0));
                        vertList[3] = MarchingCubes.lerp(position, new float[]{position[0], position[1] + voxDim[1], position[2]}, mu);
                    }
                    if ((bits & 0x10) != 0) {
                        mu = (float)((isoLevel - value4) / (value5 - value4));
                        vertList[4] = MarchingCubes.lerp(new float[]{position[0], position[1], position[2] + voxDim[2]}, new float[]{position[0] + voxDim[0], position[1], position[2] + voxDim[2]}, mu);
                    }
                    if ((bits & 0x20) != 0) {
                        mu = (float)((isoLevel - value5) / (value7 - value5));
                        vertList[5] = MarchingCubes.lerp(new float[]{position[0] + voxDim[0], position[1], position[2] + voxDim[2]}, new float[]{position[0] + voxDim[0], position[1] + voxDim[1], position[2] + voxDim[2]}, mu);
                    }
                    if ((bits & 0x40) != 0) {
                        mu = (float)((isoLevel - value6) / (value7 - value6));
                        vertList[6] = MarchingCubes.lerp(new float[]{position[0], position[1] + voxDim[1], position[2] + voxDim[2]}, new float[]{position[0] + voxDim[0], position[1] + voxDim[1], position[2] + voxDim[2]}, mu);
                    }
                    if ((bits & 0x80) != 0) {
                        mu = (float)((isoLevel - value4) / (value6 - value4));
                        vertList[7] = MarchingCubes.lerp(new float[]{position[0], position[1], position[2] + voxDim[2]}, new float[]{position[0], position[1] + voxDim[1], position[2] + voxDim[2]}, mu);
                    }
                    if ((bits & 0x100) != 0) {
                        mu = (float)((isoLevel - value0) / (value4 - value0));
                        vertList[8] = MarchingCubes.lerp(position, new float[]{position[0], position[1], position[2] + voxDim[2]}, mu);
                    }
                    if ((bits & 0x200) != 0) {
                        mu = (float)((isoLevel - value1) / (value5 - value1));
                        vertList[9] = MarchingCubes.lerp(new float[]{position[0] + voxDim[0], position[1], position[2]}, new float[]{position[0] + voxDim[0], position[1], position[2] + voxDim[2]}, mu);
                    }
                    if ((bits & 0x400) != 0) {
                        mu = (float)((isoLevel - value3) / (value7 - value3));
                        vertList[10] = MarchingCubes.lerp(new float[]{position[0] + voxDim[0], position[1] + voxDim[1], position[2]}, new float[]{position[0] + voxDim[0], position[1] + voxDim[1], position[2] + voxDim[2]}, mu);
                    }
                    if ((bits & 0x800) != 0) {
                        mu = (float)((isoLevel - value2) / (value6 - value2));
                        vertList[11] = MarchingCubes.lerp(new float[]{position[0], position[1] + voxDim[1], position[2]}, new float[]{position[0], position[1] + voxDim[1], position[2] + voxDim[2]}, mu);
                    }
                    int i = 0;
                    cubeindex <<= 4;
                    while (TablesMC.MC_TRI_TABLE[cubeindex + i] != -1) {
                        int index1 = TablesMC.MC_TRI_TABLE[cubeindex + i];
                        int index2 = TablesMC.MC_TRI_TABLE[cubeindex + i + 1];
                        int index3 = TablesMC.MC_TRI_TABLE[cubeindex + i + 2];
                        vertices.add(new float[]{vertList[index3][0] / maxAxisVal - 0.5f, vertList[index3][1] / maxAxisVal - 0.5f, vertList[index3][2] / maxAxisVal - 0.5f});
                        vertices.add(new float[]{vertList[index2][0] / maxAxisVal - 0.5f, vertList[index2][1] / maxAxisVal - 0.5f, vertList[index2][2] / maxAxisVal - 0.5f});
                        vertices.add(new float[]{vertList[index1][0] / maxAxisVal - 0.5f, vertList[index1][1] / maxAxisVal - 0.5f, vertList[index1][2] / maxAxisVal - 0.5f});
                        i += 3;
                    }
                }
            }
        }
        callback.setVertices(vertices);
        callback.run();
    }

    public static ArrayList<float[]> marchingCubes(Array values, Array xc, Array yc, Array zc, float isoLevel) {
        ArrayList<float[]> vertices = new ArrayList<float[]>();
        float[][] vertList = new float[12][3];
        int[] shape = values.getShape();
        int[] volDim = new int[]{shape[2], shape[1], shape[0]};
        for (int z = 0; z < volDim[2] - 1; ++z) {
            float zz = zc.getFloat(z);
            for (int y = 0; y < volDim[1] - 1; ++y) {
                float yy = yc.getFloat(y);
                for (int x = 0; x < volDim[0] - 1; ++x) {
                    int bits;
                    float xx = xc.getFloat(x);
                    int p = x + volDim[0] * y + volDim[0] * volDim[1] * z;
                    int px = p + 1;
                    int py = p + volDim[0];
                    int pxy = py + 1;
                    int pz = p + volDim[0] * volDim[1];
                    int pxz = px + volDim[0] * volDim[1];
                    int pyz = py + volDim[0] * volDim[1];
                    int pxyz = pxy + volDim[0] * volDim[1];
                    float value0 = values.getFloat(p);
                    float value1 = values.getFloat(px);
                    float value2 = values.getFloat(py);
                    float value3 = values.getFloat(pxy);
                    float value4 = values.getFloat(pz);
                    float value5 = values.getFloat(pxz);
                    float value6 = values.getFloat(pyz);
                    float value7 = values.getFloat(pxyz);
                    int cubeindex = 0;
                    if (value0 > isoLevel) {
                        cubeindex |= 1;
                    }
                    if (value1 > isoLevel) {
                        cubeindex |= 2;
                    }
                    if (value2 > isoLevel) {
                        cubeindex |= 8;
                    }
                    if (value3 > isoLevel) {
                        cubeindex |= 4;
                    }
                    if (value4 > isoLevel) {
                        cubeindex |= 0x10;
                    }
                    if (value5 > isoLevel) {
                        cubeindex |= 0x20;
                    }
                    if (value6 > isoLevel) {
                        cubeindex |= 0x80;
                    }
                    if (value7 > isoLevel) {
                        cubeindex |= 0x40;
                    }
                    if ((bits = TablesMC.MC_EDGE_TABLE[cubeindex]) == 0) continue;
                    float mu = 0.5f;
                    if ((bits & 1) != 0) {
                        mu = (isoLevel - value0) / (value1 - value0);
                        vertList[0] = MarchingCubes.lerp(new float[]{xx, yy, zz}, new float[]{xc.getFloat(x + 1), yy, zz}, mu);
                    }
                    if ((bits & 2) != 0) {
                        mu = (isoLevel - value1) / (value3 - value1);
                        vertList[1] = MarchingCubes.lerp(new float[]{xc.getFloat(x + 1), yy, zz}, new float[]{xc.getFloat(x + 1), yc.getFloat(y + 1), zz}, mu);
                    }
                    if ((bits & 4) != 0) {
                        mu = (isoLevel - value2) / (value3 - value2);
                        vertList[2] = MarchingCubes.lerp(new float[]{xx, yc.getFloat(y + 1), zz}, new float[]{xc.getFloat(x + 1), yc.getFloat(y + 1), zz}, mu);
                    }
                    if ((bits & 8) != 0) {
                        mu = (isoLevel - value0) / (value2 - value0);
                        vertList[3] = MarchingCubes.lerp(new float[]{xx, yy, zz}, new float[]{xx, yc.getFloat(y + 1), zz}, mu);
                    }
                    if ((bits & 0x10) != 0) {
                        mu = (isoLevel - value4) / (value5 - value4);
                        vertList[4] = MarchingCubes.lerp(new float[]{xx, yy, zc.getFloat(z + 1)}, new float[]{xc.getFloat(x + 1), yy, zc.getFloat(z + 1)}, mu);
                    }
                    if ((bits & 0x20) != 0) {
                        mu = (isoLevel - value5) / (value7 - value5);
                        vertList[5] = MarchingCubes.lerp(new float[]{xc.getFloat(x + 1), yy, zc.getFloat(z + 1)}, new float[]{xc.getFloat(x + 1), yc.getFloat(y + 1), zc.getFloat(z + 1)}, mu);
                    }
                    if ((bits & 0x40) != 0) {
                        mu = (isoLevel - value6) / (value7 - value6);
                        vertList[6] = MarchingCubes.lerp(new float[]{xx, yc.getFloat(y + 1), zc.getFloat(z + 1)}, new float[]{xc.getFloat(x + 1), yc.getFloat(y + 1), zc.getFloat(z + 1)}, mu);
                    }
                    if ((bits & 0x80) != 0) {
                        mu = (isoLevel - value4) / (value6 - value4);
                        vertList[7] = MarchingCubes.lerp(new float[]{xx, yy, zc.getFloat(z + 1)}, new float[]{xx, yc.getFloat(y + 1), zc.getFloat(z + 1)}, mu);
                    }
                    if ((bits & 0x100) != 0) {
                        mu = (isoLevel - value0) / (value4 - value0);
                        vertList[8] = MarchingCubes.lerp(new float[]{xx, yy, zz}, new float[]{xx, yy, zc.getFloat(z + 1)}, mu);
                    }
                    if ((bits & 0x200) != 0) {
                        mu = (isoLevel - value1) / (value5 - value1);
                        vertList[9] = MarchingCubes.lerp(new float[]{xc.getFloat(x + 1), yy, zz}, new float[]{xc.getFloat(x + 1), yy, zc.getFloat(z + 1)}, mu);
                    }
                    if ((bits & 0x400) != 0) {
                        mu = (isoLevel - value3) / (value7 - value3);
                        vertList[10] = MarchingCubes.lerp(new float[]{xc.getFloat(x + 1), yc.getFloat(y + 1), zz}, new float[]{xc.getFloat(x + 1), yc.getFloat(y + 1), zc.getFloat(z + 1)}, mu);
                    }
                    if ((bits & 0x800) != 0) {
                        mu = (isoLevel - value2) / (value6 - value2);
                        vertList[11] = MarchingCubes.lerp(new float[]{xx, yc.getFloat(y + 1), zz}, new float[]{xx, yc.getFloat(y + 1), zc.getFloat(z + 1)}, mu);
                    }
                    int i = 0;
                    cubeindex <<= 4;
                    while (TablesMC.MC_TRI_TABLE[cubeindex + i] != -1) {
                        int index1 = TablesMC.MC_TRI_TABLE[cubeindex + i];
                        int index2 = TablesMC.MC_TRI_TABLE[cubeindex + i + 1];
                        int index3 = TablesMC.MC_TRI_TABLE[cubeindex + i + 2];
                        vertices.add(new float[]{vertList[index3][0], vertList[index3][1], vertList[index3][2]});
                        vertices.add(new float[]{vertList[index2][0], vertList[index2][1], vertList[index2][2]});
                        vertices.add(new float[]{vertList[index1][0], vertList[index1][1], vertList[index1][2]});
                        i += 3;
                    }
                }
            }
        }
        return vertices;
    }

    public static void marchingCubes(Array values, Array xc, Array yc, Array zc, float isoLevel, int len, int offset, CallbackMC callback) {
        ArrayList<float[]> vertices = new ArrayList<float[]>();
        float[][] vertList = new float[12][3];
        int[] shape = values.getShape();
        int[] volDim = new int[]{shape[2], shape[1], len};
        for (int z = offset; z < volDim[2] - 1 + offset; ++z) {
            float zz = zc.getFloat(z);
            for (int y = 0; y < volDim[1] - 1; ++y) {
                float yy = yc.getFloat(y);
                for (int x = 0; x < volDim[0] - 1; ++x) {
                    int bits;
                    float xx = xc.getFloat(x);
                    int p = x + volDim[0] * y + volDim[0] * volDim[1] * z;
                    int px = p + 1;
                    int py = p + volDim[0];
                    int pxy = py + 1;
                    int pz = p + volDim[0] * volDim[1];
                    int pxz = px + volDim[0] * volDim[1];
                    int pyz = py + volDim[0] * volDim[1];
                    int pxyz = pxy + volDim[0] * volDim[1];
                    float value0 = values.getFloat(p);
                    float value1 = values.getFloat(px);
                    float value2 = values.getFloat(py);
                    float value3 = values.getFloat(pxy);
                    float value4 = values.getFloat(pz);
                    float value5 = values.getFloat(pxz);
                    float value6 = values.getFloat(pyz);
                    float value7 = values.getFloat(pxyz);
                    int cubeindex = 0;
                    if (value0 > isoLevel) {
                        cubeindex |= 1;
                    }
                    if (value1 > isoLevel) {
                        cubeindex |= 2;
                    }
                    if (value2 > isoLevel) {
                        cubeindex |= 8;
                    }
                    if (value3 > isoLevel) {
                        cubeindex |= 4;
                    }
                    if (value4 > isoLevel) {
                        cubeindex |= 0x10;
                    }
                    if (value5 > isoLevel) {
                        cubeindex |= 0x20;
                    }
                    if (value6 > isoLevel) {
                        cubeindex |= 0x80;
                    }
                    if (value7 > isoLevel) {
                        cubeindex |= 0x40;
                    }
                    if ((bits = TablesMC.MC_EDGE_TABLE[cubeindex]) == 0) continue;
                    float mu = 0.5f;
                    if ((bits & 1) != 0) {
                        mu = (isoLevel - value0) / (value1 - value0);
                        vertList[0] = MarchingCubes.lerp(new float[]{xx, yy, zz}, new float[]{xc.getFloat(x + 1), yy, zz}, mu);
                    }
                    if ((bits & 2) != 0) {
                        mu = (isoLevel - value1) / (value3 - value1);
                        vertList[1] = MarchingCubes.lerp(new float[]{xc.getFloat(x + 1), yy, zz}, new float[]{xc.getFloat(x + 1), yc.getFloat(y + 1), zz}, mu);
                    }
                    if ((bits & 4) != 0) {
                        mu = (isoLevel - value2) / (value3 - value2);
                        vertList[2] = MarchingCubes.lerp(new float[]{xx, yc.getFloat(y + 1), zz}, new float[]{xc.getFloat(x + 1), yc.getFloat(y + 1), zz}, mu);
                    }
                    if ((bits & 8) != 0) {
                        mu = (isoLevel - value0) / (value2 - value0);
                        vertList[3] = MarchingCubes.lerp(new float[]{xx, yy, zz}, new float[]{xx, yc.getFloat(y + 1), zz}, mu);
                    }
                    if ((bits & 0x10) != 0) {
                        mu = (isoLevel - value4) / (value5 - value4);
                        vertList[4] = MarchingCubes.lerp(new float[]{xx, yy, zc.getFloat(z + 1)}, new float[]{xc.getFloat(x + 1), yy, zc.getFloat(z + 1)}, mu);
                    }
                    if ((bits & 0x20) != 0) {
                        mu = (isoLevel - value5) / (value7 - value5);
                        vertList[5] = MarchingCubes.lerp(new float[]{xc.getFloat(x + 1), yy, zc.getFloat(z + 1)}, new float[]{xc.getFloat(x + 1), yc.getFloat(y + 1), zc.getFloat(z + 1)}, mu);
                    }
                    if ((bits & 0x40) != 0) {
                        mu = (isoLevel - value6) / (value7 - value6);
                        vertList[6] = MarchingCubes.lerp(new float[]{xx, yc.getFloat(y + 1), zc.getFloat(z + 1)}, new float[]{xc.getFloat(x + 1), yc.getFloat(y + 1), zc.getFloat(z + 1)}, mu);
                    }
                    if ((bits & 0x80) != 0) {
                        mu = (isoLevel - value4) / (value6 - value4);
                        vertList[7] = MarchingCubes.lerp(new float[]{xx, yy, zc.getFloat(z + 1)}, new float[]{xx, yc.getFloat(y + 1), zc.getFloat(z + 1)}, mu);
                    }
                    if ((bits & 0x100) != 0) {
                        mu = (isoLevel - value0) / (value4 - value0);
                        vertList[8] = MarchingCubes.lerp(new float[]{xx, yy, zz}, new float[]{xx, yy, zc.getFloat(z + 1)}, mu);
                    }
                    if ((bits & 0x200) != 0) {
                        mu = (isoLevel - value1) / (value5 - value1);
                        vertList[9] = MarchingCubes.lerp(new float[]{xc.getFloat(x + 1), yy, zz}, new float[]{xc.getFloat(x + 1), yy, zc.getFloat(z + 1)}, mu);
                    }
                    if ((bits & 0x400) != 0) {
                        mu = (isoLevel - value3) / (value7 - value3);
                        vertList[10] = MarchingCubes.lerp(new float[]{xc.getFloat(x + 1), yc.getFloat(y + 1), zz}, new float[]{xc.getFloat(x + 1), yc.getFloat(y + 1), zc.getFloat(z + 1)}, mu);
                    }
                    if ((bits & 0x800) != 0) {
                        mu = (isoLevel - value2) / (value6 - value2);
                        vertList[11] = MarchingCubes.lerp(new float[]{xx, yc.getFloat(y + 1), zz}, new float[]{xx, yc.getFloat(y + 1), zc.getFloat(z + 1)}, mu);
                    }
                    int i = 0;
                    cubeindex <<= 4;
                    while (TablesMC.MC_TRI_TABLE[cubeindex + i] != -1) {
                        int index1 = TablesMC.MC_TRI_TABLE[cubeindex + i];
                        int index2 = TablesMC.MC_TRI_TABLE[cubeindex + i + 1];
                        int index3 = TablesMC.MC_TRI_TABLE[cubeindex + i + 2];
                        vertices.add(new float[]{vertList[index3][0], vertList[index3][1], vertList[index3][2]});
                        vertices.add(new float[]{vertList[index2][0], vertList[index2][1], vertList[index2][2]});
                        vertices.add(new float[]{vertList[index1][0], vertList[index1][1], vertList[index1][2]});
                        i += 3;
                    }
                }
            }
        }
        callback.setVertices(vertices);
        callback.run();
    }
}

