/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.chart.plot;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import org.meteoinfo.chart.ChartLegend;
import org.meteoinfo.chart.Location;
import org.meteoinfo.chart.axis.TimeAxis;
import org.meteoinfo.chart.plot.AbstractPlot2D;
import org.meteoinfo.chart.plot.ChartPlotMethod;
import org.meteoinfo.chart.plot.PlotOrientation;
import org.meteoinfo.chart.plot.PlotType;
import org.meteoinfo.chart.plot.SeriesLegend;
import org.meteoinfo.common.Extent;
import org.meteoinfo.common.MIMath;
import org.meteoinfo.common.PointF;
import org.meteoinfo.common.colors.ColorUtil;
import org.meteoinfo.data.Dataset;
import org.meteoinfo.data.XYDataset;
import org.meteoinfo.data.XYErrorSeriesData;
import org.meteoinfo.data.XYListDataset;
import org.meteoinfo.data.XYSeriesData;
import org.meteoinfo.data.XYYSeriesData;
import org.meteoinfo.geometry.legend.ColorBreak;
import org.meteoinfo.geometry.legend.LegendScheme;
import org.meteoinfo.geometry.legend.PointBreak;
import org.meteoinfo.geometry.legend.PolygonBreak;
import org.meteoinfo.geometry.legend.PolylineBreak;
import org.meteoinfo.geometry.shape.ShapeTypes;
import org.meteoinfo.render.java2d.Draw;

public class XY1DPlot
extends AbstractPlot2D {
    private XYListDataset dataset = new XYListDataset();
    private ChartPlotMethod chartPlotMethod = ChartPlotMethod.LINE;
    private List<SeriesLegend> seriesLegends = new ArrayList<SeriesLegend>();
    private boolean useBreak2D = false;
    private float barWidth = 0.8f;
    private boolean autoBarWidth = true;

    public XY1DPlot() {
    }

    public XY1DPlot(XYDataset dateset) {
        this();
        this.setDataset((Dataset)dateset);
    }

    public XY1DPlot(PlotOrientation orientation, XYDataset dateset) {
        this();
        this.setPlotOrientation(orientation);
        this.setDataset((Dataset)dateset);
    }

    public XY1DPlot(boolean isTime, XYDataset dateset) {
        this();
        if (isTime) {
            this.setXAxis(new TimeAxis("X", true));
            this.getAxis(Location.TOP).setDrawTickLabel(false);
        }
        this.setDataset((Dataset)dateset);
    }

    public XY1DPlot(boolean isTime, ChartPlotMethod cpMethod, XYDataset dateset) {
        this();
        if (isTime) {
            this.setXAxis(new TimeAxis("X", true));
            this.getAxis(Location.TOP).setDrawTickLabel(false);
        }
        this.setChartPlotMethod(cpMethod);
        this.setDataset((Dataset)dateset);
    }

    public XY1DPlot(boolean isTime, PlotOrientation orientation, XYDataset dateset) {
        this();
        if (isTime) {
            this.setXAxis(new TimeAxis("X", true));
            this.getAxis(Location.TOP).setDrawTickLabel(false);
        }
        this.setPlotOrientation(orientation);
        this.setDataset((Dataset)dateset);
    }

    public XYDataset getDataset() {
        return this.dataset;
    }

    @Override
    public void setDataset(Dataset value) {
        this.dataset = (XYListDataset)value;
        Extent extent = this.getAutoExtent();
        this.setDrawExtent(extent);
        this.setExtent(extent);
        this.updateSeriesLegend();
    }

    private void updateSeriesLegend() {
        int si = this.seriesLegends.size();
        if (si > this.dataset.getSeriesCount()) {
            si = 0;
        }
        block5: for (int i = si; i < this.dataset.getSeriesCount(); ++i) {
            Color color = ColorUtil.getCommonColor((int)i);
            switch (this.chartPlotMethod) {
                case LINE: 
                case LINE_POINT: {
                    PolylineBreak plb = new PolylineBreak();
                    if (this.chartPlotMethod == ChartPlotMethod.LINE) {
                        plb.setDrawSymbol(false);
                    } else {
                        plb.setDrawSymbol(true);
                        plb.setSymbolColor(color);
                        plb.setSymbolFillColor(color);
                    }
                    plb.setColor(color);
                    plb.setCaption(this.dataset.getSeriesKey(i));
                    this.seriesLegends.add(new SeriesLegend((ColorBreak)plb));
                    continue block5;
                }
                case POINT: {
                    PointBreak pb = new PointBreak();
                    pb.setColor(color);
                    pb.setCaption(this.dataset.getSeriesKey(i));
                    this.seriesLegends.add(new SeriesLegend((ColorBreak)pb));
                    continue block5;
                }
                case BAR: {
                    PolygonBreak pgb = new PolygonBreak();
                    pgb.setColor(color);
                    pgb.setCaption(this.dataset.getSeriesKey(i));
                    this.seriesLegends.add(new SeriesLegend((ColorBreak)pgb));
                }
            }
        }
    }

    public ChartPlotMethod getChartPlotMethod() {
        return this.chartPlotMethod;
    }

    public void setChartPlotMethod(ChartPlotMethod value) {
        this.chartPlotMethod = value;
        if (this.dataset != null) {
            this.updateSeriesLegend();
        }
    }

    @Override
    public PlotType getPlotType() {
        return PlotType.XY;
    }

    public List<SeriesLegend> getLegendBreaks() {
        return this.seriesLegends;
    }

    public boolean isUseBreak2D() {
        return this.useBreak2D;
    }

    public void setUseBeak2D(boolean value) {
        this.useBreak2D = value;
    }

    public float getBarWidth() {
        return this.barWidth;
    }

    public void setBarWidth(float value) {
        this.barWidth = value;
    }

    public boolean isAutoBarWidth() {
        return this.autoBarWidth;
    }

    public void setAutoBarWidth(boolean value) {
        this.autoBarWidth = value;
    }

    public void addSeries(String seriesKey, double[] xvs, double[] yvs) {
        this.dataset.addSeries(seriesKey, xvs, yvs);
        PolylineBreak plb = new PolylineBreak();
        plb.setColor(ColorUtil.getCommonColor((int)this.dataset.getSeriesCount()));
        plb.setCaption(seriesKey);
        this.seriesLegends.add(new SeriesLegend((ColorBreak)plb));
        Extent extent = this.getAutoExtent();
        this.setDrawExtent(extent);
    }

    public void removeLastSeries() {
        XYListDataset ds = this.dataset;
        ds.removeSeries(this.dataset.getSeriesCount() - 1);
        this.seriesLegends.remove(this.seriesLegends.size() - 1);
        Extent extent = this.getAutoExtent();
        this.setDrawExtent(extent);
    }

    private PointF[] getScreenPoints(double[] xdata, double[] ydata, List<Integer> mvIdx, Rectangle2D area) {
        int len = xdata.length;
        PointF[] points = new PointF[len];
        if (this.getPlotOrientation() == PlotOrientation.VERTICAL) {
            for (int j = 0; j < len; ++j) {
                double[] xy = this.projToScreen(xdata[j], ydata[j], area);
                points[j] = new PointF((float)xy[0], (float)xy[1]);
            }
        } else {
            for (int j = 0; j < len; ++j) {
                double[] xy = this.projToScreen(ydata[j], xdata[j], area);
                points[j] = new PointF((float)xy[0], (float)xy[1]);
            }
        }
        return points;
    }

    /*
     * Could not resolve type clashes
     */
    @Override
    void drawGraph(Graphics2D g, Rectangle2D area) {
        AffineTransform oldMatrix = g.getTransform();
        Rectangle oldRegion = g.getClipBounds();
        g.setClip(area);
        g.translate(area.getX(), area.getY());
        if (this.background != null) {
            g.setColor(this.getBackground());
            g.fill(new Rectangle2D.Double(0.0, 0.0, area.getWidth(), area.getHeight()));
        }
        double[] xy = this.projToScreen(0.0, 0.0, area);
        float y0 = (float)xy[1];
        boolean drawBaseline = false;
        for (int i = 0; i < this.dataset.getSeriesCount(); ++i) {
            PointF p;
            int j;
            XYSeriesData sdata = this.dataset.getSeriesData(i);
            int len = sdata.dataLength();
            List mvIdx = sdata.getMissingValueIndex();
            PointF[] points = this.getScreenPoints(sdata.getXdata(), sdata.getYdata(), mvIdx, area);
            SeriesLegend slegend = this.seriesLegends.get(i);
            if (slegend.isLine()) {
                if (mvIdx.isEmpty()) {
                    Draw.drawPolyline((PointF[])points, (PolylineBreak)((PolylineBreak)slegend.getLegendBreak()), (Graphics2D)g);
                } else {
                    Draw.drawPolyline((PointF[])points, (PolylineBreak)((PolylineBreak)slegend.getLegendBreak()), (Graphics2D)g, (List)mvIdx);
                }
            } else if (slegend.isPoint()) {
                if (slegend.isMutiple()) {
                    for (int j2 = 0; j2 < len; ++j2) {
                        if (mvIdx.contains(j2)) continue;
                        Draw.drawPoint((PointF)points[j2], (PointBreak)((PointBreak)slegend.getLegendBreak(j2)), (Graphics2D)g);
                    }
                } else {
                    for (int j3 = 0; j3 < len; ++j3) {
                        if (mvIdx.contains(j3)) continue;
                        Draw.drawPoint((PointF)points[j3], (PointBreak)((PointBreak)slegend.getLegendBreak()), (Graphics2D)g);
                    }
                }
            } else if (slegend.isPolygon()) {
                switch (slegend.getPlotMethod()) {
                    case BAR: {
                        if (sdata instanceof XYErrorSeriesData) {
                            double x;
                            double error;
                            double elen;
                            PointF p2;
                            PolygonBreak pgb;
                            drawBaseline = true;
                            XYErrorSeriesData esdata = (XYErrorSeriesData)sdata;
                            double[] bottom = esdata.getBottom();
                            float[] yBottoms = null;
                            if (bottom != null) {
                                yBottoms = new float[bottom.length];
                                for (int j4 = 0; j4 < bottom.length; ++j4) {
                                    xy = this.projToScreen(esdata.getBottom(j4), esdata.getBottom(j4), area);
                                    yBottoms[j4] = (float)xy[1];
                                }
                            }
                            float width = this.barWidth;
                            if (this.autoBarWidth) {
                                width = points.length > 1 ? (float)((double)(points[1].X - points[0].X) * 0.5) / (float)this.dataset.getSeriesCount() : (float)(area.getWidth() / 10.0) / (float)this.dataset.getSeriesCount();
                                for (j = 0; j < len; ++j) {
                                    if (mvIdx.contains(j)) continue;
                                    pgb = (PolygonBreak)slegend.getLegendBreak(j);
                                    float height = Math.abs(points[j].Y - y0);
                                    float yBottom = y0;
                                    if (yBottoms != null) {
                                        yBottom = j < yBottoms.length ? yBottoms[j] : yBottoms[0];
                                    }
                                    float yb = yBottom;
                                    if (points[j].Y >= y0) {
                                        yb += height;
                                    }
                                    Draw.drawBar((PointF)new PointF(points[j].X - width * (float)this.dataset.getSeriesCount() / 2.0f + (float)i * width, yb), (float)width, (float)height, (PolygonBreak)pgb, (Graphics2D)g, (boolean)false, (int)5);
                                    if (esdata.getYerror() == null) continue;
                                    p2 = (PointF)points[j].clone();
                                    p2.Y -= y0 - yBottom;
                                    elen = 6.0;
                                    error = esdata.getYerror(j);
                                    error = this.projYLength(error, area);
                                    x = p2.X - width * (float)this.dataset.getSeriesCount() / 2.0f + (float)i * width + width / 2.0f;
                                    g.setColor(slegend.getErrorColor());
                                    g.draw(new Line2D.Double(x, (double)p2.Y - error, x, (double)p2.Y + error));
                                    g.draw(new Line2D.Double(x - elen * 0.5, (double)p2.Y - error, x + elen * 0.5, (double)p2.Y - error));
                                    g.draw(new Line2D.Double(x - elen * 0.5, (double)p2.Y + error, x + elen * 0.5, (double)p2.Y + error));
                                }
                            } else {
                                width = (float)this.projXLength(width, area);
                                for (j = 0; j < len; ++j) {
                                    if (mvIdx.contains(j)) continue;
                                    pgb = (PolygonBreak)slegend.getLegendBreak(j);
                                    float height = Math.abs(points[j].Y - y0);
                                    float yBottom = y0;
                                    if (yBottoms != null) {
                                        yBottom = j < yBottoms.length ? yBottoms[j] : yBottoms[0];
                                    }
                                    float yb = yBottom;
                                    if (points[j].Y >= y0) {
                                        yb += height;
                                    }
                                    Draw.drawBar((PointF)new PointF(points[j].X, yb), (float)width, (float)height, (PolygonBreak)pgb, (Graphics2D)g, (boolean)false, (int)5);
                                    if (esdata.getYerror() == null) continue;
                                    p2 = (PointF)points[j].clone();
                                    p2.Y -= y0 - yBottom;
                                    elen = 6.0;
                                    error = esdata.getYerror(j);
                                    error = this.projYLength(error, area);
                                    x = p2.X + width / 2.0f;
                                    g.setColor(slegend.getErrorColor());
                                    g.draw(new Line2D.Double(x, (double)p2.Y - error, x, (double)p2.Y + error));
                                    g.draw(new Line2D.Double(x - elen * 0.5, (double)p2.Y - error, x + elen * 0.5, (double)p2.Y - error));
                                    g.draw(new Line2D.Double(x - elen * 0.5, (double)p2.Y + error, x + elen * 0.5, (double)p2.Y + error));
                                }
                            }
                        } else {
                            int j5;
                            drawBaseline = true;
                            float width = this.barWidth;
                            if (this.autoBarWidth) {
                                width = points.length > 1 ? (float)((double)(points[1].X - points[0].X) * 0.5) / (float)this.dataset.getSeriesCount() : (float)(area.getWidth() / 10.0) / (float)this.dataset.getSeriesCount();
                                for (j5 = 0; j5 < len; ++j5) {
                                    if (mvIdx.contains(j5)) continue;
                                    PolygonBreak pgb = (PolygonBreak)slegend.getLegendBreak(j5);
                                    float height = Math.abs(points[j5].Y - y0);
                                    float yb = y0;
                                    if (points[j5].Y >= y0) {
                                        yb += height;
                                    }
                                    Draw.drawBar((PointF)new PointF(points[j5].X - width * (float)this.dataset.getSeriesCount() / 2.0f + (float)i * width, yb), (float)width, (float)height, (PolygonBreak)pgb, (Graphics2D)g, (boolean)false, (int)5);
                                }
                            } else {
                                width = (float)this.projXLength(width, area);
                                for (j5 = 0; j5 < len; ++j5) {
                                    if (mvIdx.contains(j5)) continue;
                                    PolygonBreak pgb = (PolygonBreak)slegend.getLegendBreak(j5);
                                    float height = Math.abs(points[j5].Y - y0);
                                    float yb = y0;
                                    if (points[j5].Y >= y0) {
                                        yb += height;
                                    }
                                    Draw.drawBar((PointF)new PointF(points[j5].X, yb), (float)width, (float)height, (PolygonBreak)pgb, (Graphics2D)g, (boolean)false, (int)5);
                                }
                            }
                        }
                        break;
                    }
                    case FILL: {
                        XYYSeriesData xyydata = (XYYSeriesData)sdata;
                        PointF[] y2Points = this.getScreenPoints(xyydata.getXdata(), xyydata.getY2data(), mvIdx, area);
                        if (xyydata.getWhere() == null) {
                            PointF[] npoints = new PointF[len * 2];
                            for (int j6 = 0; j6 < len; ++j6) {
                                npoints[j6] = points[len - j6 - 1];
                                npoints[j6 + len] = y2Points[j6];
                            }
                            Draw.drawPolygon((PointF[])npoints, (PolygonBreak)((PolygonBreak)slegend.getLegendBreak()), (Graphics2D)g);
                            break;
                        }
                        boolean ob = false;
                        ArrayList idxs = new ArrayList();
                        ArrayList<Integer> idx = new ArrayList<Integer>();
                        for (int j7 = 0; j7 < len; ++j7) {
                            if (((Boolean)xyydata.getWhere().get(j7)).booleanValue()) {
                                if (!ob) {
                                    idx = new ArrayList();
                                }
                                idx.add(j7);
                            } else if (ob) {
                                idxs.add(idx);
                            }
                            ob = (Boolean)xyydata.getWhere().get(j7);
                        }
                        for (List index : idxs) {
                            int nn = index.size();
                            if (nn < 2) continue;
                            PointF[] npoints = new PointF[nn * 2];
                            for (int j8 = 0; j8 < nn; ++j8) {
                                int ii = (Integer)index.get(j8);
                                int ii2 = (Integer)index.get(nn - j8 - 1);
                                npoints[j8] = points[ii];
                                npoints[j8 + index.size()] = y2Points[ii2];
                            }
                            Draw.drawPolygon((PointF[])npoints, (PolygonBreak)((PolygonBreak)slegend.getLegendBreak()), (Graphics2D)g);
                        }
                        break;
                    }
                }
            }
            if (drawBaseline) {
                g.setColor(Color.black);
                g.draw(new Line2D.Double(0.0, y0, area.getWidth(), y0));
            }
            if (!(sdata instanceof XYErrorSeriesData)) continue;
            XYErrorSeriesData esdata = (XYErrorSeriesData)sdata;
            g.setColor(slegend.getLegendBreak().getColor());
            double elen = 6.0;
            if (esdata.getYerror() != null && slegend.getPlotMethod() != ChartPlotMethod.BAR) {
                for (j = 0; j < len; ++j) {
                    if (mvIdx.contains(j)) continue;
                    p = points[j];
                    double error = esdata.getYerror(j);
                    error = this.projYLength(error, area);
                    g.draw(new Line2D.Double(p.X, (double)p.Y - error, p.X, (double)p.Y + error));
                    g.draw(new Line2D.Double((double)p.X - elen * 0.5, (double)p.Y - error, (double)p.X + elen * 0.5, (double)p.Y - error));
                    g.draw(new Line2D.Double((double)p.X - elen * 0.5, (double)p.Y + error, (double)p.X + elen * 0.5, (double)p.Y + error));
                }
            }
            if (esdata.getXerror() == null) continue;
            for (j = 0; j < len; ++j) {
                if (mvIdx.contains(j)) continue;
                p = points[j];
                double error = esdata.getXerror(j);
                error = this.projXLength(error, area);
                g.draw(new Line2D.Double((double)p.X - error, p.Y, (double)p.X + error, p.Y));
                g.draw(new Line2D.Double((double)p.X - error, (double)p.Y - elen * 0.5, (double)p.X - error, (double)p.Y + elen * 0.5));
                g.draw(new Line2D.Double((double)p.X + error, (double)p.Y - elen * 0.5, (double)p.X + error, (double)p.Y + elen * 0.5));
            }
        }
        g.setTransform(oldMatrix);
        g.setClip(oldRegion);
    }

    public PointBreak getItemPointBreak(int seriesIdx, int itemIdx) {
        return (PointBreak)this.seriesLegends.get(seriesIdx).getLegendBreak(itemIdx);
    }

    public void setItemPointBreak(int seriesIdx, int itemIdx, PointBreak pb) {
        this.seriesLegends.get(seriesIdx).setLegendBreak(itemIdx, (ColorBreak)pb);
    }

    public ColorBreak getLegendBreak(int seriesIdx) {
        return this.seriesLegends.get(seriesIdx).getLegendBreak();
    }

    public void setLegendBreak(int seriesIdx, ColorBreak cb) {
        this.seriesLegends.get(seriesIdx).setLegendBreak(cb);
    }

    public void setLegendBreak(int seriesIdx, SeriesLegend sLegend) {
        this.seriesLegends.set(seriesIdx, sLegend);
    }

    private double getBarXInterval(int idx) {
        double[] xvalues = this.dataset.getXValues(idx);
        if (xvalues.length == 1) {
            if (xvalues[0] == 0.0) {
                return 1.0;
            }
            return xvalues[0] / 10.0;
        }
        return xvalues[1] - xvalues[0];
    }

    private int getBarIndex() {
        int idx = -1;
        for (int i = 0; i < this.seriesLegends.size(); ++i) {
            if (this.seriesLegends.get(i).getPlotMethod() != ChartPlotMethod.BAR) continue;
            idx = i;
            break;
        }
        return idx;
    }

    @Override
    public Extent getAutoExtent() {
        double[] xValues;
        int barIdx;
        Extent extent = this.dataset.getDataExtent();
        if (extent.minX == extent.maxX) {
            extent.minX -= Math.abs(extent.minX);
            extent.maxX += Math.abs(extent.minX);
        }
        if (extent.minY == extent.maxY) {
            extent.minY -= Math.abs(extent.minY);
            extent.maxY += Math.abs(extent.maxY);
        }
        if ((barIdx = this.getBarIndex()) >= 0) {
            double dx = this.getBarXInterval(barIdx);
            extent.minX -= dx;
            extent.maxX += dx;
        }
        if (this.getXAxis() instanceof TimeAxis) {
            xValues = (double[])MIMath.getIntervalValues((double)extent.minX, (double)extent.maxX, (boolean)false).get(0);
            xValues[0] = extent.minX;
            xValues[xValues.length - 1] = extent.maxX;
        } else {
            xValues = (double[])MIMath.getIntervalValues((double)extent.minX, (double)extent.maxX, (boolean)true).get(0);
        }
        double[] yValues = (double[])MIMath.getIntervalValues((double)extent.minY, (double)extent.maxY, (boolean)true).get(0);
        if (this.getPlotOrientation() == PlotOrientation.VERTICAL) {
            return new Extent(xValues[0], xValues[xValues.length - 1], yValues[0], yValues[yValues.length - 1]);
        }
        return new Extent(yValues[0], yValues[yValues.length - 1], xValues[0], xValues[xValues.length - 1]);
    }

    @Override
    public void setAutoExtent() {
        Extent extent = this.getAutoExtent();
        this.setDrawExtent(extent);
    }

    public LegendScheme getLegendScheme() {
        ShapeTypes stype = ShapeTypes.POLYLINE;
        LegendScheme ls = new LegendScheme(stype);
        for (SeriesLegend slegend : this.seriesLegends) {
            ls.getLegendBreaks().add(slegend.getLegendBreak());
        }
        return ls;
    }

    @Override
    public void updateLegendScheme() {
        if (this.getLegend() == null) {
            this.setLegend(new ChartLegend(this.getLegendScheme()));
        } else {
            this.getLegend().setLegendScheme(this.getLegendScheme());
        }
    }
}

